require_relative '../../globalized'
include Globalized

describe "Story#JRNL-1306: [Notification_Settings_Email_Removal_Warning_Modal_spec.rb]", :regression => true do

  startTime = Time.new
  puts "Start Time: " + startTime.inspect

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")
    #Put pause to allow app to POST setting preferences because all was cleared from mongo
  end

  after(:all) do
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")
    #quitDriver()
  end

  it "Login and Add an Email address from Notification Settings page and then create a reminder with In-App and Email delivery methods" do
    @main.clickNavMenu
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyReminders']").click
    waitForPageToFinishLoading
    !5.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")

    @reminders.clickSubGroup("preventive-services")
    !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    #Set an email from Notification Settings page
    @common.navigateToNotificationSettingAndSetOrRemoveEmail("lian.gould@agilex.com")

    #Return to PS and click on Cervical Cancer Screening
    @screening.returnToPSAndEditAPS("Cervical Cancer Screening")

    #Select On from Notification Preference
    @screening.selectNotificationStatus("On")

    #Check the Email option
    #@screening.clickNotificationDeliveryCheckBox("Email")

    #Provide values to Next Due Dateq2
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    setDate(tomorrow, "date-control[label='Next Due Date'] input")
    #Check one checkbox under Notify Me
    @screening.clickNotificationDeliveryCheckBox("On the date")
    waitForPageToFinishLoading
    @driver.find_element(:css, "input[name='serviceName']").send_keys "Test Service Name"
    waitForPageToFinishLoading
    #Click Save
    @screening.clickSaveButton()
    waitForPageToFinishLoading
    !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    !5.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@screening.getTableViewHeader()).to eq("Status")
  end

  it " Navigate back to Notification Settings and remove the email then save. Verify that a modal dialog pops up and all its Title, Body Contents and Button names meet the requirement" do
    #Remove the email from Notification Settings page
    @common.navigateToNotificationSettingAndSetOrRemoveEmail("")
    !5.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
    expect(getTextForElement(:css, ".modal-body p p:nth-of-type(1)")).to eq("An email address is required for VA Health email notifications. If you do not provide an email address any future email notifications will be cancelled.")
    expect(getTextForElement(:css, ".modal-body p p:nth-of-type(2)")).to eq("If you wish to continue saving, click SAVE, otherwise, select CANCEL to update your Notification Settings.")
    #Verify that Save and Cancel buttons are present
    expect(@modal.isSaveButtonPresent()).to eq(true)
    expect(@modal.isCancelButtonPresent()).to eq(true)
    #Verify the button texts
    expect(@modal.getConfirmButtonText()).to eq("Save")
    expect(@modal.getCancelButtonText()).to eq("Cancel")

    #Click Cancel
    @modal.clickCancelButton()
    !5.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
    #Verify that the email address persist
    expect(@notifications_reminders.getEmailAddressFromNotificationSettingScreen()).to eq("lian.gould@agilex.com")

    #Attempt to remove again
    @landing.setEmailAddress("")
    @modal.clickSaveButton()
    !5.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
    expect(@modal.getTopLayerModalConfirmationHeading()).to eq("Warning")
    waitForPageToFinishLoading
    #Click Save
    #@modal.clickSaveButton()
    @driver.find_element(:css, "button[data-ng-click='modalContent.ok();']").click
    waitForPageToFinishLoading
    !5.times{ break if (@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
  end

  it "Verify that after removing the email, the email notification delivery method is removed from the notification reminders" do
    #Return to PS and click on Cervical Cancer Screening
    @screening.returnToPSAndEditAPS("Cervical Cancer Screening")

    #Verify that the Email notification delivery method is unchecked
    expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(false)
    #Verify the Email checkbox is disabled
    expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(true)
    #Verify that the text is displayed when email is not available and this box is disabled
    expect(@screening.getEmailFromNotification()).to eq("Email address has not been saved")

    @screening.clickCancelButton()
    !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
  end

  it "Verify that warning pops up when there are no active notifications " do

    #Remove notification collection
    removeCollection("reminders", "remindersdb")

    #Set an email from Notification Settings page
    @common.navigateToNotificationSettingAndSetOrRemoveEmail("lian.gould@agilex.com")

    #Remove the email from Notification Settings page
    @common.navigateToNotificationSettingAndSetOrRemoveEmail("")
    !5.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
    expect(getTextForElement(:css, ".modal-body p p:nth-of-type(1)")).to eq("An email address is required for VA Health email notifications. If you do not provide an email address any future email notifications will be cancelled.")
    expect(getTextForElement(:css, ".modal-body p p:nth-of-type(2)")).to eq("If you wish to continue saving, click SAVE, otherwise, select CANCEL to update your Notification Settings.")
    #Verify that Save and Cancel buttons are present
    expect(@modal.isSaveButtonPresent()).to eq(true)
    expect(@modal.isCancelButtonPresent()).to eq(true)
    #Verify the button texts

    expect(@modal.getConfirmButtonText()).to eq("Save")
    expect(@modal.getCancelButtonText()).to eq("Cancel")

    #Click Cancel
    @modal.clickCancelButton()
    !5.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
    #Verify that the email address persist
    expect(@notifications_reminders.getEmailAddressFromNotificationSettingScreen()).to eq("lian.gould@agilex.com")

    #Attempt to remove again
    @landing.setEmailAddress("")
    @modal.clickSaveButton()
    !5.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
    expect(@modal.getTopLayerModalConfirmationHeading()).to eq("Warning")
    #Click Save
    #@modal.clickSaveButton()
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[data-ng-click='modalContent.ok();']").click
    waitForPageToFinishLoading
    !5.times{ break if (@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
  end
end













































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized

describe "Story#JRNL-1306: [Notification_Settings_Email_Removal_Warning_Modal_spec.rb]", :regression => true do

  startTime = Time.new
  puts "Start Time: " + startTime.inspect

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")

    @common.loginEndsOnLandingPage("zztest.patient14", "patient14, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient14, zztest")
    #Put pause to allow app to POST setting preferences because all was cleared from mongo
  end

  after(:all) do
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")
    quitDriver()
  end

  it "Login and Add an Email address from Notification Settings page and then create a reminder with In-App and Email delivery methods" do
    @main.clickNavMenu

    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")

    @reminders.clickSubGroup("preventive-services")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    !45.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@screening.getTableViewHeader()).to eq("Status")

    #Set an email from Notification Settings page
    @common.navigateToNotificationSettingAndSetOrRemoveEmail("lian.gould@agilex.com")

    #Return to PS and click on Cervical Cancer Screening
    @screening.returnToPSAndEditAPS("Cervical Cancer Screening")

    #Select On from Notification Preference
    @screening.selectNotificationStatus("On")

    #Check the Email option
    @screening.clickNotificationDeliveryCheckBox("Email")

    #Provide values to Next Due Date
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    setDate(tomorrow, "date-control[label='Next Due Date'] input")
    #Check one checkbox under Notify Me
    @screening.clickNotificationDeliveryCheckBox("On the date")
    #Click Save
    @screening.clickSaveButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    !45.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@screening.getTableViewHeader()).to eq("Status")
  end

  it " Navigate back to Notification Settings and remove the email then save. Verify that a modal dialog pops up and all its Title, Body Contents and Button names meet the requirement" do
    #Remove the email from Notification Settings page
    @common.navigateToNotificationSettingAndSetOrRemoveEmail("")
    !45.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
    expect(getTextForElement(:css, ".modal-body p p:nth-of-type(1)")).to eq("An email address is required for VA Health email notifications. If you do not provide an email address any future email notifications will be cancelled.")
    expect(getTextForElement(:css, ".modal-body p p:nth-of-type(2)")).to eq("If you wish to continue saving, click SAVE, otherwise, select CANCEL to update your Notification Settings.")
    #Verify that Save and Cancel buttons are present
    expect(@modal.isSaveButtonPresent()).to eq(true)
    expect(@modal.isCancelButtonPresent()).to eq(true)
    #Verify the button texts
    expect(@modal.getConfirmButtonText()).to eq("Save")
    expect(@modal.getCancelButtonText()).to eq("Cancel")

    #Click Cancel
    @modal.clickCancelButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
    #Verify that the email address persist
    expect(@notifications_reminders.getEmailAddressFromNotificationSettingScreen()).to eq("lian.gould@agilex.com")

    #Attempt to remove again
    @landing.setEmailAddress("")
    @modal.clickSaveButton()
    !45.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
    expect(@modal.getTopLayerModalConfirmationHeading()).to eq("Warning")
    #Click Save
    @modal.clickSaveButton()
    !30.times{ break if (@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
  end

  it "Verify that after removing the email, the email notification delivery method is removed from the notification reminders" do
    #Return to PS and click on Cervical Cancer Screening
    @screening.returnToPSAndEditAPS("Cervical Cancer Screening")

    #Verify that the Email notification delivery method is unchecked
    expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(false)
    #Verify the Email checkbox is disabled
    expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(true)
    #Verify that the text is displayed when email is not available and this box is disabled
    expect(@screening.getEmailFromNotification()).to eq("Email address has not been saved")

    @screening.clickCancelButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
  end

  it "Verify that warning pops up when there are no active notifications " do

    #Remove notification collection
    removeCollection("reminders", "remindersdb")

    #Set an email from Notification Settings page
    @common.navigateToNotificationSettingAndSetOrRemoveEmail("lian.gould@agilex.com")

    #Remove the email from Notification Settings page
    @common.navigateToNotificationSettingAndSetOrRemoveEmail("")
    !45.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
    expect(getTextForElement(:css, ".modal-body p p:nth-of-type(1)")).to eq("An email address is required for VA Health email notifications. If you do not provide an email address any future email notifications will be cancelled.")
    expect(getTextForElement(:css, ".modal-body p p:nth-of-type(2)")).to eq("If you wish to continue saving, click SAVE, otherwise, select CANCEL to update your Notification Settings.")
    #Verify that Save and Cancel buttons are present
    expect(@modal.isSaveButtonPresent()).to eq(true)
    expect(@modal.isCancelButtonPresent()).to eq(true)
    #Verify the button texts

    expect(@modal.getConfirmButtonText()).to eq("Save")
    expect(@modal.getCancelButtonText()).to eq("Cancel")

    #Click Cancel
    @modal.clickCancelButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Notification Settings"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Notification Settings")
    #Verify that the email address persist
    expect(@notifications_reminders.getEmailAddressFromNotificationSettingScreen()).to eq("lian.gould@agilex.com")

    #Attempt to remove again
    @landing.setEmailAddress("")
    @modal.clickSaveButton()
    !45.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
    expect(@modal.getTopLayerModalConfirmationHeading()).to eq("Warning")
    #Click Save
    @modal.clickSaveButton()
    !30.times{ break if (@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
  end

end
=end