require_relative '../../globalized'
include Globalized

describe "[Story #MVAH-28: Summary][Story #JRNL-2516: PDF][Story#JRNL-2462: Reflection changes]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("promptedresponses", "healthinventorydb")
    removeCollection("assessments", "healthinventorydb")

    initializeAllObjects

    @accordion = ["Working the body",
                  "Recharge",
                  "Food and Drink",
                  "Personal Development",
                  "Family, Friends, and Co-Workers",
                  "Spirit and Soul",
                  "Surroundings",
                  "Power of the Mind"  ]

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyStory']").click
    waitForPageToFinishLoading
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  # after(:all) do
  #   quitDriver()
  # end

  it "AC #JRNL-3279|TC #JRNL-2769: Under the label text 'Personal Values' the user is presnted with the most recent entries ", :broken => true do
    stageData()

    @my_story.clickSummary
    !5.times{ break if (@summary.getWhatReallyMatterQuestionText== "What REALLY matters to you in your life?");sleep 1 }
    expect(@summary.getPrimaryHeader).to eq("Summary")
    expect(@summary.getPersonalValuesHeading).to eq("Personal Values")

    #Personal values is the first section in the summary
    expect(@summary.isPersonalValuesFirstSection(1)).to eq(true)

    #Question Label
    expect(@summary.getWhatReallyMatterQuestionText).to eq("What REALLY matters to you in your life?")
    expect(@summary.getSenseOfJoyQuestionText).to eq("What brings you a sense of joy and happiness?")

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    #Responses
    expect(@summary.getWhatReallyMatterAnswer).to eq("Family, health, and Friends")
    expect(@summary.getSenseOfJoyAnswer).to eq("Music, Kids")
    #last updated date
    expect(@summary.getLastUpdatedDateForWhatReallyMatter).to eq("Last updated: " + today.to_s)
    expect(@summary.getLastUpdatedDateForSenseOfJoy).to eq("Last updated: " + today.to_s)

  end

  it "AC #JRNL-3280|TC #JRNL-2769:  Under the label text 'Assessment' the user is presented graphs", :broken => true do
    #Well-being graph is displayed under a sub-section labeled "Well-being"
    expect(@summary.isGraphDisplayed?("Well-being")).to eq(true)
    #Self care graph is displayed under a sub-section labeled “Eight Areas of Self Care”
    expect(@summary.isGraphDisplayed?("Eight Areas of Self Care")).to eq(true)
    #Professional care graph is displayed under a sub-section labeled “Professional Care”
    expect(@summary.isGraphDisplayed?("Professional Care")).to eq(true)
    #Each graph has the informational text “A text description of the information on this page is available in the table view.” listed centered above the graph
    expect(@summary.getTableViewDescriptionInfoText).to eq("A text description of the information on this page is available in the table view.")
    #Each graph has the informational text “Note: update dates are available in the table view.” listed left-justified below the graph
    expect(@summary.getNoteInfoText("Well-being")).to eq("Note: update dates are available in the table view.")
    expect(@summary.getNoteInfoText("Eight Areas of Self Care")).to eq("Note: update dates are available in the table view.")
    expect(@summary.getNoteInfoText("Professional Care")).to eq("Note: update dates are available in the table view.")

    #Well-being graph: The three well-being labels (“Physical”, “Mental/Emotional” and “Day-to-day”)
    expect(@summary.isXAxisLabelsValid("Well-being", ["Physical", "Mental/Emotional", "Day-to-day"])).to eq(true)

    expect(@summary.isXAxisLabelsValid("Eight Areas of Self Care", ["Working the body", "Recharge", "Food and Drink", "Personal Development", "Family, Friends, and Co-Workers", "Spirit and Soul", "Surroundings", "Power of the Mind"])).to eq(true)
    expect(@summary.isXAxisLabelsValid("Professional Care", ["Prevention", "Clinical Care"])).to eq(true)

    #The vertical axis includes the following labels:
    expect(@summary.getYAxisLabel("Well-being")).to eq("Rating (1=miserable, 5=great)")
    expect(@summary.getYAxisLabel("Eight Areas of Self Care")).to eq("Rating (1=low, 5=high)")
    expect(@summary.getYAxisLabel("Professional Care")).to eq("Rating (1=not at all, 5=very much)")
    #The self-care graph includes a legend that depicts the difference in current and future values
    expect(@summary.getSelfCareGraphLegend()).to eq("CurrentFuture")

    #On the professional care graph, if the value associated with the question "Are you working with a healthcare professional to treat any clinical conditions?" no, the following text is displayed below the professional care graph and informational text related to the update dates: "I am not working with a healthcare professional"
    expect(@summary.isNotWorkingWithProfTextDisplayed?()).to eq(false)


    @my_story.clickAssessment
    !5.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickProfessionalCare
    !5.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }
    @my_story.selectWorkingWithProfessional("No")

    !5.times{ break if (@modal.getConfirmationHeading() == "Alert"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Alert")
    expect(@modal.getConfirmationMessage()).to eq("Based on your response, the follow-on question does not apply and will be removed.")

    @modal.clickOKFromInfoModal()
    !5.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }

    @my_story.clickSaveChangesBtn

    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.clickSummary
    !5.times{ break if (@summary.getWhatReallyMatterQuestionText== "What REALLY matters to you in your life?");sleep 1 }
    expect(@summary.getPrimaryHeader).to eq("Summary")
    expect(@summary.getPersonalValuesHeading).to eq("Personal Values")
    expect(@summary.isNotWorkingWithProfTextDisplayed?()).to eq(true)

    #On phone form factors and smaller, users receive a message that “Graph view available in desktop view only.”
    expect(@summary.isPhoneViewGraphMessageDisplayed?).to eq(false)
    windowSize = getWindowSize()
    resizeWindowTo(400, 727)
    expect(@summary.isPhoneViewGraphMessageDisplayed?).to eq(true)

    resizeWindowTo(windowSize.width, windowSize.height)

  end

  it "AC #JRNL-3282|TC #JRNL-2769:  Each graph has a corresponding table view that is available using a single table/graph toggle button that displays either the table or the graph across for all three graphs", :broken => true do
    expect(@summary.getTableGraphButtonText).to eq("Table")

    @summary.clickTableButton
    !5.times{ break if (@summary.isGraphButtonDisplayed? == true);sleep 1 }
    expect(@summary.isGraphButtonDisplayed?).to eq(true)
    expect(@summary.getTableGraphButtonText).to eq("Graph")
    expect(@summary.getFocusedElementText).to eq("Assessment")

    expect(@summary.isGraphDisplayed?("Well-being")).to eq(false)
    expect(@summary.isGraphDisplayed?("Eight Areas of Self Care")).to eq(false)
    expect(@summary.isGraphDisplayed?("Professional Care")).to eq(false)

    expect(@summary.isTableDisplayed?("Well-being")).to eq(true)
    expect(@summary.isTableDisplayed?("Eight Areas of Self Care")).to eq(true)
    expect(@summary.isTableDisplayed?("Professional Care")).to eq(true)

    @summary.clickGraphButton
    !5.times{ break if (@summary.isTableButtonDisplayed? == true);sleep 1 }
    expect(@summary.isTableButtonDisplayed?).to eq(true)
    expect(@summary.getTableGraphButtonText).to eq("Table")
    expect(@summary.getFocusedElementText).to eq("Assessment")

    expect(@summary.isTableDisplayed?("Well-being")).to eq(false)
    expect(@summary.isTableDisplayed?("Eight Areas of Self Care")).to eq(false)
    expect(@summary.isTableDisplayed?("Professional Care")).to eq(false)

  end


  it "AC #JRNL-3281|TC #JRNL-2769: Under the label text 'Assessment', when the table view is selected, tables are displayed", :broken => true do
    @summary.clickTableButton
    !5.times{ break if (@summary.isGraphButtonDisplayed? == true);sleep 1 }
    expect(@summary.isGraphButtonDisplayed?).to eq(true)
    #Well-being table is displayed under a sub-section labeled “Well-being”, listing:
    expect(@summary.verifyTableHeader("Well-being", ["Well-being Area", "Last Updated", "Value"])).to eq(true)
    expect(@summary.getTableCellValue("Well-being", 1, 1)).to eq("Physical")
    expect(@summary.getTableCellValue("Well-being", 2, 1)).to eq("Mental/Emotional")
    expect(@summary.getTableCellValue("Well-being", 3, 1)).to eq("Day-to-day")

    expect(isDateFormatValid?(@summary.getTableCellValue("Well-being", 1, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Well-being", 2, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Well-being", 3, 2), "%m/%d/%Y")).to eq(true)

    expect(@summary.getTableCellValue("Well-being", 1, 3)).to eq("2")
    expect(@summary.getTableCellValue("Well-being", 2, 3)).to eq("4")
    expect(@summary.getTableCellValue("Well-being", 3, 3)).to eq("1")

    #Self-care table is displayed under a sub-section labeled “Eight Areas of Self Care”, listing:
    expect(@summary.verifyTableHeader("Eight Areas of Self Care", ["Self Care Area", "Last Updated", "Current", "Future"])).to eq(true)

    expect(@summary.getTableCellValue("Eight Areas of Self Care", 1, 1)).to eq("Working the body")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 2, 1)).to eq("Recharge")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 3, 1)).to eq("Food and Drink")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 4, 1)).to eq("Personal Development")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 5, 1)).to eq("Family, Friends, and Co-Workers")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 6, 1)).to eq("Spirit and Soul")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 7, 1)).to eq("Surroundings")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 8, 1)).to eq("Power of the Mind")

    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 1, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 2, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 3, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 4, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 5, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 6, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 7, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 8, 2), "%m/%d/%Y")).to eq(true)

    expect(@summary.getTableCellValue("Eight Areas of Self Care", 1, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 2, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 3, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 4, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 5, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 6, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 7, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 8, 3)).to eq("2")

    expect(@summary.getTableCellValue("Eight Areas of Self Care", 1, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 2, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 3, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 4, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 5, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 6, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 7, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 8, 4)).to eq("4")

  #Professional care table is displayed under a sub-section labeled “Professional Care", listing:
    expect(@summary.verifyTableHeader("Professional Care", ["Professional Care Area", "Last Updated", "Value"])).to eq(true)

    expect(@summary.getTableCellValue("Professional Care", 1, 1)).to eq("Prevention")
    expect(@summary.getTableCellValue("Professional Care", 2, 1)).to eq("Working with Professional (Yes/No)")
    expect(@summary.getTableCellValue("Professional Care", 3, 1)).to eq("Clinical Care")

    expect(isDateFormatValid?(@summary.getTableCellValue("Professional Care", 1, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Professional Care", 2, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Professional Care", 3, 2), "%m/%d/%Y")).to eq(true)

    expect(@summary.getTableCellValue("Professional Care", 1, 3)).to eq("2")
    expect(@summary.getTableCellValue("Professional Care", 2, 3)).to eq("No")
    expect(@summary.getTableCellValue("Professional Care", 3, 3)).to eq("")


  end

  it "AC #JRNL-3283|TC #JRNL-2769  AC#JRNL-1935|TC #JRNL-1819: Under the label text 'Reflections', the user is presented the most recent entries", :broken => true do
    @summary.clickGraphButton
    !5.times{ break if (@summary.isTableButtonDisplayed? == true);sleep 1 }
    expect(@summary.isTableButtonDisplayed?).to eq(true)
    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    expect(@summary.getReflectionsHeading).to eq("Reflections")
    expect(@summary.getReflectionNowThatQuestionLabel).to eq("Now that you have thought about all of these areas, what is your vision of your best possible health?")
    expect(@summary.getReflectionNowThatAnswer).to eq('I am going to exercise every other day.')
    expect(@summary.getUpdatedDateForReflectionNowThatQuestion).to eq("Last updated: " + today.to_s)

  end

  it "AC #JRNL-3303|TC #JRNL-2769: Each table includes informational text about the scale for that table above the table", :broken => true do
    @summary.clickTableButton
    !5.times{ break if (@summary.isGraphButtonDisplayed? == true);sleep 1 }

    expect(@summary.getScaleInfoText("Well-being")).to eq("1 = Miserable, 5 = Great")
    expect(@summary.getScaleInfoText("Eight Areas of Self Care")).to eq("1 = Low, 5 = High")
    expect(@summary.getScaleInfoText("Professional Care")).to eq("1 = Not at all, 5 = Very Much")
  end

  it "AC #JRNL-2721|TC #JRNL-2769: On a phone form factor and smaller, a card-based view replaces the table-based view", :broken => true do
    windowSize = getWindowSize()
    resizeWindowTo(400, 727)

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    expect(@summary.getLastUpdatedValueForWellBeingPhoneView).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Well-being", 1)).to eq("Physical:\n2")
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Well-being", 2)).to eq("Mental:\n4")
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Well-being", 3)).to eq("Day-to-day:\n1")

    expect(@summary.getSelfCareArea("Working the body")).to eq("Self Care Area: Working the body")
    expect(@summary.getCellTextForSelfCarePhoneView("Working the body", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Working the body", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Working the body", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Recharge")).to eq("Self Care Area: Recharge")
    expect(@summary.getCellTextForSelfCarePhoneView("Recharge", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Recharge", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Recharge", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Food and Drink")).to eq("Self Care Area: Food and Drink")
    expect(@summary.getCellTextForSelfCarePhoneView("Food and Drink", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Food and Drink", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Food and Drink", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Personal Development")).to eq("Self Care Area: Personal Development")
    expect(@summary.getCellTextForSelfCarePhoneView("Personal Development", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Personal Development", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Personal Development", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Family, Friends, and Co-Workers")).to eq("Self Care Area: Family, Friends, and Co-Workers")
    expect(@summary.getCellTextForSelfCarePhoneView("Family, Friends, and Co-Workers", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Family, Friends, and Co-Workers", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Family, Friends, and Co-Workers", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Spirit and Soul")).to eq("Self Care Area: Spirit and Soul")
    expect(@summary.getCellTextForSelfCarePhoneView("Spirit and Soul", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Spirit and Soul", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Spirit and Soul", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Surroundings")).to eq("Self Care Area: Surroundings")
    expect(@summary.getCellTextForSelfCarePhoneView("Surroundings", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Surroundings", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Surroundings", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Power of the Mind")).to eq("Self Care Area: Power of the Mind")
    expect(@summary.getCellTextForSelfCarePhoneView("Power of the Mind", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Power of the Mind", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Power of the Mind", 3)).to eq("Future:\n4")


    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Professional Care", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Professional Care", 2)).to eq("Prevention:\n2")
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Professional Care", 3)).to eq("Working with a healthcare professional (Y/N):\nNo")
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Professional Care", 4)).to eq("Clinical Care:")

    resizeWindowTo(windowSize.width, windowSize.height)
  end


  it "AC #JRNL-3284|TC #JRNL-2769: Any null responses display as blank", :broken => true do
    stageNullData()

    @my_story.clickSummary
    !5.times{ break if (@summary.getSenseOfJoyAnswer== "" and @summary.getReflectionNowThatAnswer == "");sleep 1 }
    expect(@summary.getPrimaryHeader).to eq("Summary")

    expect(@summary.getWhatReallyMatterAnswer).to eq("")
    expect(@summary.getSenseOfJoyAnswer).to eq("")

    expect(@summary.getReflectionNowThatAnswer).to eq("")

    @summary.clickTableButton
    !5.times{ break if (@summary.isGraphButtonDisplayed? == true);sleep 1 }
    expect(@summary.isGraphButtonDisplayed?).to eq(true)

    expect(@summary.getTableCellValue("Well-being", 1, 3)).to eq("")
    expect(@summary.getTableCellValue("Well-being", 2, 3)).to eq("")
    expect(@summary.getTableCellValue("Well-being", 3, 3)).to eq("")

    expect(@summary.getTableCellValue("Eight Areas of Self Care", 1, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 2, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 3, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 4, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 5, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 6, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 7, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 8, 3)).to eq("")

    expect(@summary.getTableCellValue("Professional Care", 1, 3)).to eq("")
    expect(@summary.getTableCellValue("Professional Care", 2, 3)).to eq("")
    expect(@summary.getTableCellValue("Professional Care", 3, 3)).to eq("")

  end


  it "AC #JRNL-3295|TC #JRNL-1963: The 'PDF' button is available in the title bar of the summary screen, right justified", :broken => true do
    expect(@summary.isPDFButtonDisplayed?).to eq(true)
  end

  it "AC #JRNL-3296|TC #JRNL-1963:  The PDF opens in a new tab to reveal the report", :broken => true do
    @summary.clickPDFButton
    switchWindowToWindowHandleLast()

    !5.times{ break if (getPageTitle() == "pdf"); sleep 1 }
    expect(@summary.getPageTitle).to eq("pdf")
    expect(@summary.verifyEmbeddedPDF()).to eq(true)

    closeBrowser()
    switchWindowToWindowHandleFirst()
  end


  def stageData()
    @my_story.clickPersonalValues
    !5.times{ break if (@my_story.getWhatReallyQuestionLabelInPersonalValues == "What REALLY matters to you in your life?");sleep 1 }

    #stage data
    @my_story.setWhatReallyQuestionInPersonalValues("Family, health, and Friends")
    @my_story.setSenseOfJoyQuestionInPersonalValues("Music, Kids")
    @my_story.clickSaveChangesBtn

    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.clickAssessment
    !5.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickWellBeing()
    !5.times{ break if (@my_story.getWellBeingInfoText == "On the following scales from 1-5, with 1 being miserable and 5 being great, select where you feel you are on the scale."); sleep 1 }

    @my_story.selectMentalWellBeing(4)
    @my_story.selectPhysicalWellBeing(2)
    @my_story.selectDayToDayLife(1)

    @my_story.clickSaveChangesBtn
    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

    for i in 0..7
      @my_story.clickAccordionByHeading(@accordion[i])
      !5.times{ break if (@my_story.getRateWhereYouAreLabelByHeading(@accordion[i]) == "Rate where you are (1 (low) to 5 (high))"); sleep 1 }
      @my_story.selectRateWhereYouAreByHeading(@accordion[i], "2")
      @my_story.selectWhereYouLikedToBeByHeading(@accordion[i], "4")
      !5.times{ break if (@my_story.isSaveChangesDisabled == false); sleep 1 }

      @my_story.clickSaveChangesBtn
      today = getDateNthDaysAgo(0,"%m/%d/%Y")

      !5.times{ break if (@my_story.getLastUpdatedDateByHeading(@accordion[i]) == "Last updated: " + today.to_s); sleep 1 }
      @my_story.collapseAccordionByHeading(@accordion[i])

    end

    @my_story.clickProfessionalCare
    !5.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }

    expect(@my_story.getPreventionForProCareValue).to eq("")
    @my_story.selectPreventionForProfCare("2")
    @my_story.selectWorkingWithProfessional("Yes")
    @my_story.clickSaveChangesBtn
    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

    @my_story.clickReflections
    !5.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }

    @my_story.setNowThatQuestionInReflectionValue("I am going to exercise every other day.")
    @my_story.clickSaveChangesBtn
    !5.times{ break if (@modal.getConfirmationHeading() == "Set a goal?"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Set a goal?")
    expect(@modal.getConfirmationMessage()).to eq("Would you like to set a goal based on your responses?")
    @modal.clickNoButton
    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }


    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

  end

  def stageNullData()
    @my_story.clickPersonalValues
    !5.times{ break if (@my_story.getWhatReallyQuestionLabelInPersonalValues == "What REALLY matters to you in your life?");sleep 1 }

    #stage data
    @my_story.setWhatReallyQuestionInPersonalValues("")
    @my_story.setSenseOfJoyQuestionInPersonalValues("")
    @my_story.clickSaveChangesBtn

    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.clickAssessment
    !5.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickWellBeing()
    !5.times{ break if (@my_story.getWellBeingInfoText == "On the following scales from 1-5, with 1 being miserable and 5 being great, select where you feel you are on the scale."); sleep 1 }

    @my_story.selectMentalWellBeing("")
    @my_story.selectPhysicalWellBeing("")
    @my_story.selectDayToDayLife("")

    @my_story.clickSaveChangesBtn
    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

    for i in 0..7
      @my_story.clickAccordionByHeading(@accordion[i])
      !5.times{ break if (@my_story.getRateWhereYouAreLabelByHeading(@accordion[i]) == "Rate where you are (1 (low) to 5 (high))"); sleep 1 }
      @my_story.selectRateWhereYouAreByHeading(@accordion[i], "Select")
      @my_story.selectWhereYouLikedToBeByHeading(@accordion[i], "Select")
      !5.times{ break if (@my_story.isSaveChangesDisabled == false); sleep 1 }

      @my_story.clickSaveChangesBtn
      today = getDateNthDaysAgo(0,"%m/%d/%Y")

      !5.times{ break if (@my_story.getLastUpdatedDateByHeading(@accordion[i]) == "Last updated: " + today.to_s); sleep 1 }
      @my_story.collapseAccordionByHeading(@accordion[i])

    end

    @my_story.clickProfessionalCare
    !5.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }

    @my_story.selectPreventionForProfCare("")
    @my_story.selectWorkingWithProfessional("")
    @my_story.clickSaveChangesBtn
    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

    @my_story.clickReflections
    !5.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }

    @my_story.setNowThatQuestionInReflectionValue("")

    @my_story.clickSaveChangesBtn
    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

  end
end













































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized

describe "[Story #MVAH-28: Summary][Story #JRNL-2516: PDF][Story#JRNL-2462: Reflection changes]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("promptedresponses", "healthinventorydb")
    removeCollection("assessments", "healthinventorydb")

    initializeAllObjects

    @accordion = ["Working the body",
                  "Recharge",
                  "Food and Drink",
                  "Personal Development",
                  "Family, Friends, and Co-Workers",
                  "Spirit and Soul",
                  "Surroundings",
                  "Power of the Mind"  ]

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory
    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3279|TC #JRNL-2769: Under the label text 'Personal Values' the user is presnted with the most recent entries ", :broken => true do
    stageData()

    @my_story.clickSummary
    !45.times{ break if (@summary.getWhatReallyMatterQuestionText== "What REALLY matters to you in your life?");sleep 1 }
    expect(@summary.getPrimaryHeader).to eq("Summary")
    expect(@summary.getPersonalValuesHeading).to eq("Personal Values")

    #Personal values is the first section in the summary
    expect(@summary.isPersonalValuesFirstSection(1)).to eq(true)

    #Question Label
    expect(@summary.getWhatReallyMatterQuestionText).to eq("What REALLY matters to you in your life?")
    expect(@summary.getSenseOfJoyQuestionText).to eq("What brings you a sense of joy and happiness?")

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    #Responses
    expect(@summary.getWhatReallyMatterAnswer).to eq("Family, health, and Friends")
    expect(@summary.getSenseOfJoyAnswer).to eq("Music, Kids")
    #last updated date
    expect(@summary.getLastUpdatedDateForWhatReallyMatter).to eq("Last updated: " + today.to_s)
    expect(@summary.getLastUpdatedDateForSenseOfJoy).to eq("Last updated: " + today.to_s)

  end

  it "AC #JRNL-3280|TC #JRNL-2769:  Under the label text 'Assessment' the user is presented graphs", :broken => true do
    #Well-being graph is displayed under a sub-section labeled "Well-being"
    expect(@summary.isGraphDisplayed?("Well-being")).to eq(true)
    #Self care graph is displayed under a sub-section labeled “Eight Areas of Self Care”
    expect(@summary.isGraphDisplayed?("Eight Areas of Self Care")).to eq(true)
    #Professional care graph is displayed under a sub-section labeled “Professional Care”
    expect(@summary.isGraphDisplayed?("Professional Care")).to eq(true)
    #Each graph has the informational text “A text description of the information on this page is available in the table view.” listed centered above the graph
    expect(@summary.getTableViewDescriptionInfoText).to eq("A text description of the information on this page is available in the table view.")
    #Each graph has the informational text “Note: update dates are available in the table view.” listed left-justified below the graph
    expect(@summary.getNoteInfoText("Well-being")).to eq("Note: update dates are available in the table view.")
    expect(@summary.getNoteInfoText("Eight Areas of Self Care")).to eq("Note: update dates are available in the table view.")
    expect(@summary.getNoteInfoText("Professional Care")).to eq("Note: update dates are available in the table view.")

    #Well-being graph: The three well-being labels (“Physical”, “Mental/Emotional” and “Day-to-day”)
    expect(@summary.isXAxisLabelsValid("Well-being", ["Physical", "Mental/Emotional", "Day-to-day"])).to eq(true)

    expect(@summary.isXAxisLabelsValid("Eight Areas of Self Care", ["Working the body", "Recharge", "Food and Drink", "Personal Development", "Family, Friends, and Co-Workers", "Spirit and Soul", "Surroundings", "Power of the Mind"])).to eq(true)
    expect(@summary.isXAxisLabelsValid("Professional Care", ["Prevention", "Clinical Care"])).to eq(true)

    #The vertical axis includes the following labels:
    expect(@summary.getYAxisLabel("Well-being")).to eq("Rating (1=miserable, 5=great)")
    expect(@summary.getYAxisLabel("Eight Areas of Self Care")).to eq("Rating (1=low, 5=high)")
    expect(@summary.getYAxisLabel("Professional Care")).to eq("Rating (1=not at all, 5=very much)")
    #The self-care graph includes a legend that depicts the difference in current and future values
    expect(@summary.getSelfCareGraphLegend()).to eq("CurrentFuture")

    #On the professional care graph, if the value associated with the question "Are you working with a healthcare professional to treat any clinical conditions?" no, the following text is displayed below the professional care graph and informational text related to the update dates: "I am not working with a healthcare professional"
    expect(@summary.isNotWorkingWithProfTextDisplayed?()).to eq(false)


    @my_story.clickAssessment
    !45.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickProfessionalCare
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }
    @my_story.selectWorkingWithProfessional("No")

    !45.times{ break if (@modal.getConfirmationHeading() == "Alert"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Alert")
    expect(@modal.getConfirmationMessage()).to eq("Based on your response, the follow-on question does not apply and will be removed.")

    @modal.clickOKFromInfoModal()
    !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }

    @my_story.clickSaveChangesBtn

    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.clickSummary
    !45.times{ break if (@summary.getWhatReallyMatterQuestionText== "What REALLY matters to you in your life?");sleep 1 }
    expect(@summary.getPrimaryHeader).to eq("Summary")
    expect(@summary.getPersonalValuesHeading).to eq("Personal Values")
    expect(@summary.isNotWorkingWithProfTextDisplayed?()).to eq(true)

    #On phone form factors and smaller, users receive a message that “Graph view available in desktop view only.”
    expect(@summary.isPhoneViewGraphMessageDisplayed?).to eq(false)
    windowSize = getWindowSize()
    resizeWindowTo(400, 727)
    expect(@summary.isPhoneViewGraphMessageDisplayed?).to eq(true)

    resizeWindowTo(windowSize.width, windowSize.height)

  end

  it "AC #JRNL-3282|TC #JRNL-2769:  Each graph has a corresponding table view that is available using a single table/graph toggle button that displays either the table or the graph across for all three graphs", :broken => true do
    expect(@summary.getTableGraphButtonText).to eq("Table")

    @summary.clickTableButton
    !45.times{ break if (@summary.isGraphButtonDisplayed? == true);sleep 1 }
    expect(@summary.isGraphButtonDisplayed?).to eq(true)
    expect(@summary.getTableGraphButtonText).to eq("Graph")
    expect(@summary.getFocusedElementText).to eq("Assessment")

    expect(@summary.isGraphDisplayed?("Well-being")).to eq(false)
    expect(@summary.isGraphDisplayed?("Eight Areas of Self Care")).to eq(false)
    expect(@summary.isGraphDisplayed?("Professional Care")).to eq(false)

    expect(@summary.isTableDisplayed?("Well-being")).to eq(true)
    expect(@summary.isTableDisplayed?("Eight Areas of Self Care")).to eq(true)
    expect(@summary.isTableDisplayed?("Professional Care")).to eq(true)

    @summary.clickGraphButton
    !45.times{ break if (@summary.isTableButtonDisplayed? == true);sleep 1 }
    expect(@summary.isTableButtonDisplayed?).to eq(true)
    expect(@summary.getTableGraphButtonText).to eq("Table")
    expect(@summary.getFocusedElementText).to eq("Assessment")

    expect(@summary.isTableDisplayed?("Well-being")).to eq(false)
    expect(@summary.isTableDisplayed?("Eight Areas of Self Care")).to eq(false)
    expect(@summary.isTableDisplayed?("Professional Care")).to eq(false)

  end


  it "AC #JRNL-3281|TC #JRNL-2769: Under the label text 'Assessment', when the table view is selected, tables are displayed", :broken => true do
    @summary.clickTableButton
    !45.times{ break if (@summary.isGraphButtonDisplayed? == true);sleep 1 }
    expect(@summary.isGraphButtonDisplayed?).to eq(true)
    #Well-being table is displayed under a sub-section labeled “Well-being”, listing:
    expect(@summary.verifyTableHeader("Well-being", ["Well-being Area", "Last Updated", "Value"])).to eq(true)
    expect(@summary.getTableCellValue("Well-being", 1, 1)).to eq("Physical")
    expect(@summary.getTableCellValue("Well-being", 2, 1)).to eq("Mental/Emotional")
    expect(@summary.getTableCellValue("Well-being", 3, 1)).to eq("Day-to-day")

    expect(isDateFormatValid?(@summary.getTableCellValue("Well-being", 1, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Well-being", 2, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Well-being", 3, 2), "%m/%d/%Y")).to eq(true)

    expect(@summary.getTableCellValue("Well-being", 1, 3)).to eq("2")
    expect(@summary.getTableCellValue("Well-being", 2, 3)).to eq("4")
    expect(@summary.getTableCellValue("Well-being", 3, 3)).to eq("1")

    #Self-care table is displayed under a sub-section labeled “Eight Areas of Self Care”, listing:
    expect(@summary.verifyTableHeader("Eight Areas of Self Care", ["Self Care Area", "Last Updated", "Current", "Future"])).to eq(true)

    expect(@summary.getTableCellValue("Eight Areas of Self Care", 1, 1)).to eq("Working the body")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 2, 1)).to eq("Recharge")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 3, 1)).to eq("Food and Drink")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 4, 1)).to eq("Personal Development")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 5, 1)).to eq("Family, Friends, and Co-Workers")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 6, 1)).to eq("Spirit and Soul")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 7, 1)).to eq("Surroundings")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 8, 1)).to eq("Power of the Mind")

    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 1, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 2, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 3, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 4, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 5, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 6, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 7, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Eight Areas of Self Care", 8, 2), "%m/%d/%Y")).to eq(true)

    expect(@summary.getTableCellValue("Eight Areas of Self Care", 1, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 2, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 3, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 4, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 5, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 6, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 7, 3)).to eq("2")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 8, 3)).to eq("2")

    expect(@summary.getTableCellValue("Eight Areas of Self Care", 1, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 2, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 3, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 4, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 5, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 6, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 7, 4)).to eq("4")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 8, 4)).to eq("4")

  #Professional care table is displayed under a sub-section labeled “Professional Care", listing:
    expect(@summary.verifyTableHeader("Professional Care", ["Professional Care Area", "Last Updated", "Value"])).to eq(true)

    expect(@summary.getTableCellValue("Professional Care", 1, 1)).to eq("Prevention")
    expect(@summary.getTableCellValue("Professional Care", 2, 1)).to eq("Working with Professional (Yes/No)")
    expect(@summary.getTableCellValue("Professional Care", 3, 1)).to eq("Clinical Care")

    expect(isDateFormatValid?(@summary.getTableCellValue("Professional Care", 1, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Professional Care", 2, 2), "%m/%d/%Y")).to eq(true)
    expect(isDateFormatValid?(@summary.getTableCellValue("Professional Care", 3, 2), "%m/%d/%Y")).to eq(true)

    expect(@summary.getTableCellValue("Professional Care", 1, 3)).to eq("2")
    expect(@summary.getTableCellValue("Professional Care", 2, 3)).to eq("No")
    expect(@summary.getTableCellValue("Professional Care", 3, 3)).to eq("")


  end

  it "AC #JRNL-3283|TC #JRNL-2769  AC#JRNL-1935|TC #JRNL-1819: Under the label text 'Reflections', the user is presented the most recent entries", :broken => true do
    @summary.clickGraphButton
    !45.times{ break if (@summary.isTableButtonDisplayed? == true);sleep 1 }
    expect(@summary.isTableButtonDisplayed?).to eq(true)
    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    expect(@summary.getReflectionsHeading).to eq("Reflections")
    expect(@summary.getReflectionNowThatQuestionLabel).to eq("Now that you have thought about all of these areas, what is your vision of your best possible health?")
    expect(@summary.getReflectionNowThatAnswer).to eq('I am going to exercise every other day.')
    expect(@summary.getUpdatedDateForReflectionNowThatQuestion).to eq("Last updated: " + today.to_s)

  end

  it "AC #JRNL-3303|TC #JRNL-2769: Each table includes informational text about the scale for that table above the table", :broken => true do
    @summary.clickTableButton
    !45.times{ break if (@summary.isGraphButtonDisplayed? == true);sleep 1 }

    expect(@summary.getScaleInfoText("Well-being")).to eq("1 = Miserable, 5 = Great")
    expect(@summary.getScaleInfoText("Eight Areas of Self Care")).to eq("1 = Low, 5 = High")
    expect(@summary.getScaleInfoText("Professional Care")).to eq("1 = Not at all, 5 = Very Much")
  end

  it "AC #JRNL-2721|TC #JRNL-2769: On a phone form factor and smaller, a card-based view replaces the table-based view", :broken => true do
    windowSize = getWindowSize()
    resizeWindowTo(400, 727)

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    expect(@summary.getLastUpdatedValueForWellBeingPhoneView).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Well-being", 1)).to eq("Physical:\n2")
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Well-being", 2)).to eq("Mental:\n4")
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Well-being", 3)).to eq("Day-to-day:\n1")

    expect(@summary.getSelfCareArea("Working the body")).to eq("Self Care Area: Working the body")
    expect(@summary.getCellTextForSelfCarePhoneView("Working the body", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Working the body", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Working the body", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Recharge")).to eq("Self Care Area: Recharge")
    expect(@summary.getCellTextForSelfCarePhoneView("Recharge", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Recharge", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Recharge", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Food and Drink")).to eq("Self Care Area: Food and Drink")
    expect(@summary.getCellTextForSelfCarePhoneView("Food and Drink", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Food and Drink", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Food and Drink", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Personal Development")).to eq("Self Care Area: Personal Development")
    expect(@summary.getCellTextForSelfCarePhoneView("Personal Development", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Personal Development", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Personal Development", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Family, Friends, and Co-Workers")).to eq("Self Care Area: Family, Friends, and Co-Workers")
    expect(@summary.getCellTextForSelfCarePhoneView("Family, Friends, and Co-Workers", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Family, Friends, and Co-Workers", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Family, Friends, and Co-Workers", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Spirit and Soul")).to eq("Self Care Area: Spirit and Soul")
    expect(@summary.getCellTextForSelfCarePhoneView("Spirit and Soul", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Spirit and Soul", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Spirit and Soul", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Surroundings")).to eq("Self Care Area: Surroundings")
    expect(@summary.getCellTextForSelfCarePhoneView("Surroundings", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Surroundings", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Surroundings", 3)).to eq("Future:\n4")

    expect(@summary.getSelfCareArea("Power of the Mind")).to eq("Self Care Area: Power of the Mind")
    expect(@summary.getCellTextForSelfCarePhoneView("Power of the Mind", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForSelfCarePhoneView("Power of the Mind", 2)).to eq("Current:\n2")
    expect(@summary.getCellTextForSelfCarePhoneView("Power of the Mind", 3)).to eq("Future:\n4")


    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Professional Care", 1)).to eq("Last updated:\n" + today.to_s)
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Professional Care", 2)).to eq("Prevention:\n2")
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Professional Care", 3)).to eq("Working with a healthcare professional (Y/N):\nNo")
    expect(@summary.getCellTextForWellBeingAndProfCarePhoneView("Professional Care", 4)).to eq("Clinical Care:")

    resizeWindowTo(windowSize.width, windowSize.height)
  end


  it "AC #JRNL-3284|TC #JRNL-2769: Any null responses display as blank", :broken => true do
    stageNullData()

    @my_story.clickSummary
    !45.times{ break if (@summary.getSenseOfJoyAnswer== "" and @summary.getReflectionNowThatAnswer == "");sleep 1 }
    expect(@summary.getPrimaryHeader).to eq("Summary")

    expect(@summary.getWhatReallyMatterAnswer).to eq("")
    expect(@summary.getSenseOfJoyAnswer).to eq("")

    expect(@summary.getReflectionNowThatAnswer).to eq("")

    @summary.clickTableButton
    !45.times{ break if (@summary.isGraphButtonDisplayed? == true);sleep 1 }
    expect(@summary.isGraphButtonDisplayed?).to eq(true)

    expect(@summary.getTableCellValue("Well-being", 1, 3)).to eq("")
    expect(@summary.getTableCellValue("Well-being", 2, 3)).to eq("")
    expect(@summary.getTableCellValue("Well-being", 3, 3)).to eq("")

    expect(@summary.getTableCellValue("Eight Areas of Self Care", 1, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 2, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 3, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 4, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 5, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 6, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 7, 3)).to eq("")
    expect(@summary.getTableCellValue("Eight Areas of Self Care", 8, 3)).to eq("")

    expect(@summary.getTableCellValue("Professional Care", 1, 3)).to eq("")
    expect(@summary.getTableCellValue("Professional Care", 2, 3)).to eq("")
    expect(@summary.getTableCellValue("Professional Care", 3, 3)).to eq("")

  end


  it "AC #JRNL-3295|TC #JRNL-1963: The 'PDF' button is available in the title bar of the summary screen, right justified", :broken => true do
    expect(@summary.isPDFButtonDisplayed?).to eq(true)
  end

  it "AC #JRNL-3296|TC #JRNL-1963:  The PDF opens in a new tab to reveal the report", :broken => true do
    @summary.clickPDFButton
    switchWindowToWindowHandleLast()

    !45.times{ break if (getPageTitle() == "pdf"); sleep 1 }
    expect(@summary.getPageTitle).to eq("pdf")
    expect(@summary.verifyEmbeddedPDF()).to eq(true)

    closeBrowser()
    switchWindowToWindowHandleFirst()
  end


  def stageData()
    @my_story.clickPersonalValues
    !45.times{ break if (@my_story.getWhatReallyQuestionLabelInPersonalValues == "What REALLY matters to you in your life?");sleep 1 }

    #stage data
    @my_story.setWhatReallyQuestionInPersonalValues("Family, health, and Friends")
    @my_story.setSenseOfJoyQuestionInPersonalValues("Music, Kids")
    @my_story.clickSaveChangesBtn

    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.clickAssessment
    !45.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickWellBeing()
    !45.times{ break if (@my_story.getWellBeingInfoText == "On the following scales from 1-5, with 1 being miserable and 5 being great, select where you feel you are on the scale."); sleep 1 }

    @my_story.selectMentalWellBeing(4)
    @my_story.selectPhysicalWellBeing(2)
    @my_story.selectDayToDayLife(1)

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

    for i in 0..7
      @my_story.clickAccordionByHeading(@accordion[i])
      !45.times{ break if (@my_story.getRateWhereYouAreLabelByHeading(@accordion[i]) == "Rate where you are (1 (low) to 5 (high))"); sleep 1 }
      @my_story.selectRateWhereYouAreByHeading(@accordion[i], "2")
      @my_story.selectWhereYouLikedToBeByHeading(@accordion[i], "4")
      !45.times{ break if (@my_story.isSaveChangesDisabled == false); sleep 1 }

      @my_story.clickSaveChangesBtn
      today = getDateNthDaysAgo(0,"%m/%d/%Y")

      !45.times{ break if (@my_story.getLastUpdatedDateByHeading(@accordion[i]) == "Last updated: " + today.to_s); sleep 1 }
      @my_story.collapseAccordionByHeading(@accordion[i])

    end

    @my_story.clickProfessionalCare
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }

    expect(@my_story.getPreventionForProCareValue).to eq("")
    @my_story.selectPreventionForProfCare("2")
    @my_story.selectWorkingWithProfessional("Yes")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

    @my_story.clickReflections
    !45.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }

    @my_story.setNowThatQuestionInReflectionValue("I am going to exercise every other day.")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@modal.getConfirmationHeading() == "Set a goal?"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Set a goal?")
    expect(@modal.getConfirmationMessage()).to eq("Would you like to set a goal based on your responses?")
    @modal.clickNoButton
    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }


    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

  end

  def stageNullData()
    @my_story.clickPersonalValues
    !45.times{ break if (@my_story.getWhatReallyQuestionLabelInPersonalValues == "What REALLY matters to you in your life?");sleep 1 }

    #stage data
    @my_story.setWhatReallyQuestionInPersonalValues("")
    @my_story.setSenseOfJoyQuestionInPersonalValues("")
    @my_story.clickSaveChangesBtn

    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.clickAssessment
    !45.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickWellBeing()
    !45.times{ break if (@my_story.getWellBeingInfoText == "On the following scales from 1-5, with 1 being miserable and 5 being great, select where you feel you are on the scale."); sleep 1 }

    @my_story.selectMentalWellBeing("")
    @my_story.selectPhysicalWellBeing("")
    @my_story.selectDayToDayLife("")

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

    for i in 0..7
      @my_story.clickAccordionByHeading(@accordion[i])
      !45.times{ break if (@my_story.getRateWhereYouAreLabelByHeading(@accordion[i]) == "Rate where you are (1 (low) to 5 (high))"); sleep 1 }
      @my_story.selectRateWhereYouAreByHeading(@accordion[i], "Select")
      @my_story.selectWhereYouLikedToBeByHeading(@accordion[i], "Select")
      !45.times{ break if (@my_story.isSaveChangesDisabled == false); sleep 1 }

      @my_story.clickSaveChangesBtn
      today = getDateNthDaysAgo(0,"%m/%d/%Y")

      !45.times{ break if (@my_story.getLastUpdatedDateByHeading(@accordion[i]) == "Last updated: " + today.to_s); sleep 1 }
      @my_story.collapseAccordionByHeading(@accordion[i])

    end

    @my_story.clickProfessionalCare
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }

    @my_story.selectPreventionForProfCare("")
    @my_story.selectWorkingWithProfessional("")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

    @my_story.clickReflections
    !45.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }

    @my_story.setNowThatQuestionInReflectionValue("")

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }

  end

end
=end