require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1940: Reflection (updated) - Story #JRNL-2462:  My Story and My Goals interaction]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("promptedresponses", "healthinventorydb")

    initializeAllObjects

    !5.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !5.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !5.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient05")

    !5.times{ break if (@main.getFooterText() == "Logged in as patient05, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isMyStoryButtonVisible).to eq(true)
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyStory']").click
    waitForPageToFinishLoading
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  # after(:all) do
  #   quitDriver()
  # end

  it "AC #JRNL-3234|TC#JRNL-3311  AC#JRNL-1938|TC#JRNL-1819:  Reflections - Save Action  AC#2351|TC #JRNL-1819: Set a goal modal disabled for null reflection answers", :broken => true do
    @my_story.clickReflections
    !5.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }

    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.setNowThatQuestionInReflectionValue("I am going to walk every day.")
    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.setNowThatQuestionInReflectionValue("")
    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.setNowThatQuestionInReflectionValue("I am going to exercise every other day.")
    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.clickSaveChangesBtn
    waitForPageToFinishLoading
    !5.times{ break if (@modal.getConfirmationHeading() == "Set a goal?"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Set a goal?")
    expect(@modal.getConfirmationMessage()).to eq("Would you like to set a goal based on your responses?")
    @modal.clickNoButton

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !5.times{ break if (@my_story.getNowThatLastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    expect(getFocusedElementText).to eq("Reflections")

    expect(@my_story.getNowThatLastUpdatedDate).to eq("Last updated: " + today.to_s)

    threeDaysAgo = (Time.now - 3.days)
    #updateReflectionsUpdatedDate(threeDaysAgo, "D123401")

    refreshBrowser
    !5.times{ break if (@my_story.getNowThatLastUpdatedDate == "Last updated: " + threeDaysAgo.strftime("%m/%d/%Y").to_s); sleep 1 }
    #expect(@my_story.getNowThatLastUpdatedDate).to eq("Last updated: " + threeDaysAgo.strftime("%m/%d/%Y").to_s)

    reflectionValue = "Dissanayake's phrase, making special is the value we give things: it is giving deeper meaning to something. According to Dissanayake, part of what sets humans apart from other mammals is their ability to make something special and to give it deeper meaning"
    reflectionValueStored = "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."
    @my_story.setNowThatQuestionInReflectionValue(reflectionValue)
    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.clickSaveChangesBtn
    !5.times{ break if (@modal.getConfirmationHeading() == "Set a goal?"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Set a goal?")
    expect(@modal.getConfirmationMessage()).to eq("Would you like to set a goal based on your responses?")
    @modal.clickYesButton

    !5.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    !5.times{ break if (@goal.getGoalReflectionText ==  reflectionValueStored); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")
    expect(@goal.getGoalReflectionText).to eq(reflectionValueStored)
    expect(@goal.isVisionLabelDisplayed).to eq(false)
    expect(@goal.getVisionLabel).to eq("")

    @my_story.clickReflections
    !5.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }

    !5.times{ break if (@my_story.getNowThatLastUpdatedDate== "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    expect(@my_story.getNowThatLastUpdatedDate).to eq("Last updated: " + today.to_s)

    @my_story.setNowThatQuestionInReflectionValue("")
    @my_story.clickSaveChangesBtn

    #AC JRNL-1816: set a goal modal disabled for null reflection answer
    #no confirmation modal displayed
    !5.times{ break if (@my_story.getNowThatLastUpdatedDate== "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
    waitForPageToFinishLoading
    @modal.clickYesButton
    waitForPageToFinishLoading
    @my_story.clickGoals
    waitForPageToFinishLoading

    !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
    expect(getPrimaryHeader).to eq("Goals")
    expect(@goal.isAddButtonVisible()).to eq(true)

    expect(@goal.clickAddButton)
    !5.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")
    expect(@goal.isVisionLabelDisplayed).to eq(false)
    expect(@goal.getGoalReflectionText).to eq("Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals.")

    @my_story.clickReflections
    !5.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }

    !5.times{ break if (@my_story.getNowThatLastUpdatedDate== "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.setNowThatQuestionInReflectionValue("Updated Now that question")
    @my_story.clickSaveChangesBtn
    waitForPageToFinishLoading
    @modal.clickNoButton
    waitForPageToFinishLoading
    !5.times{ break if (@my_story.getNowThatLastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    expect(getFocusedElementText).to eq("Reflections")
  end

  it "AC #JRNL-3235|TC#JRNL-3311: Prompt for Unsaved Changes", :broken => true do
    @my_story.setNowThatQuestionInReflectionValue("Testing prompt for Unsaved changes")
    waitForPageToFinishLoading
    @my_story.clickPersonalValues
    waitForPageToFinishLoading

    !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")

    @modal.clickReturnButton()
    !5.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }
    expect(@my_story.getNowThatQuestionInReflectionValue).to eq("Testing prompt for Unsaved changes")

    @my_story.clickAssessment
    !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")

    @modal.clickContinueButton

    !5.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickReflections
    !5.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }
  end

  it "AC#JRNL-1939|TC#JRNL-3311: Reflections - question update", :broken => true do
    expect(@my_story.getPrimaryHeader).to eq("Reflections")
    expect(@my_story.getNowThatQuestionInReflection).to eq("Now that you have thought about all of these areas, what is your vision of your best possible health?")

    text20 = "12345678901234567890"
    @my_story.setNowThatQuestionInReflectionValue(text20)
    expect(@my_story.getNowThatQuestionInReflectionValue.length).to eq(20)
    expect(@my_story.getNowThatQuestionInReflectionValue).to eq(text20)
    expect(@my_story.getCountDownTextForNowThat).to eq("235 characters left")

    text200 = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
    @my_story.setNowThatQuestionInReflectionValue(text200)
    expect(@my_story.getNowThatQuestionInReflectionValue.length).to eq(200)
    expect(@my_story.getNowThatQuestionInReflectionValue).to eq(text200)
    expect(@my_story.getCountDownTextForNowThat).to eq("55 characters left")

    text255 = "123451234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
    @my_story.setNowThatQuestionInReflectionValue(text255)
    expect(@my_story.getNowThatQuestionInReflectionValue.length).to eq(255)
    expect(@my_story.getNowThatQuestionInReflectionValue).to eq(text255)
    expect(@my_story.getCountDownTextForNowThat).to eq("0 characters left")

    text260 = text255 + "ABCDE"
    @my_story.setNowThatQuestionInReflectionValue(text260)
    expect(@my_story.getNowThatQuestionInReflectionValue.length).to eq(255)
    expect(@my_story.getNowThatQuestionInReflectionValue).to eq(text255)
    expect(@my_story.getCountDownTextForNowThat).to eq("0 characters left")

    @my_story.clickSaveChangesBtn
    waitForPageToFinishLoading
    !5.times{ break if (@modal.getConfirmationHeading() == "Set a goal?"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Set a goal?")
    expect(@modal.getConfirmationMessage()).to eq("Would you like to set a goal based on your responses?")
    @modal.clickNoButton
    waitForPageToFinishLoading
    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !5.times{ break if (@my_story.getNowThatLastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
  end
end



































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1940: Reflection (updated) - Story #JRNL-2462:  My Story and My Goals interaction]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("promptedresponses", "healthinventorydb")

    initializeAllObjects

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isMyStoryButtonVisible).to eq(true)

    @nav_menu.clickMyStory

    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3234|TC#JRNL-3311  AC#JRNL-1938|TC#JRNL-1819:  Reflections - Save Action  AC#2351|TC #JRNL-1819: Set a goal modal disabled for null reflection answers", :broken => true do
    @my_story.clickReflections
    !45.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }

    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.setNowThatQuestionInReflectionValue("I am going to walk every day.")
    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.setNowThatQuestionInReflectionValue("")
    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.setNowThatQuestionInReflectionValue("I am going to exercise every other day.")
    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@modal.getConfirmationHeading() == "Set a goal?"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Set a goal?")
    expect(@modal.getConfirmationMessage()).to eq("Would you like to set a goal based on your responses?")
    @modal.clickNoButton

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !45.times{ break if (@my_story.getNowThatLastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    expect(getFocusedElementText).to eq("Reflections")

    expect(@my_story.getNowThatLastUpdatedDate).to eq("Last updated: " + today.to_s)

    threeDaysAgo = (Time.now - 3.days)
    updateReflectionsUpdatedDate(threeDaysAgo, "D123401")

    refreshBrowser
    !45.times{ break if (@my_story.getNowThatLastUpdatedDate == "Last updated: " + threeDaysAgo.strftime("%m/%d/%Y").to_s); sleep 1 }
    expect(@my_story.getNowThatLastUpdatedDate).to eq("Last updated: " + threeDaysAgo.strftime("%m/%d/%Y").to_s)

    reflectionValue = "Dissanayake's phrase, making special is the value we give things: it is giving deeper meaning to something. According to Dissanayake, part of what sets humans apart from other mammals is their ability to make something special and to give it deeper meaning"
    reflectionValueStored = "Dissanayake's phrase, making special is the value we give things: it is giving deeper meaning to something. According to Dissanayake, part of what sets humans apart from other mammals is their ability to make something special and to give it deeper meanin"
    @my_story.setNowThatQuestionInReflectionValue(reflectionValue)
    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@modal.getConfirmationHeading() == "Set a goal?"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Set a goal?")
    expect(@modal.getConfirmationMessage()).to eq("Would you like to set a goal based on your responses?")
    @modal.clickYesButton

    !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    !45.times{ break if (@goal.getGoalReflectionText ==  reflectionValueStored); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")
    expect(@goal.getGoalReflectionText).to eq(reflectionValueStored)
    expect(@goal.isVisionLabelDisplayed).to eq(true)
    expect(@goal.getVisionLabel).to eq("Your Vision:")

    @my_story.clickReflections
    !45.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }

    !45.times{ break if (@my_story.getNowThatLastUpdatedDate== "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    expect(@my_story.getNowThatLastUpdatedDate).to eq("Last updated: " + today.to_s)

    @my_story.setNowThatQuestionInReflectionValue("")
    @my_story.clickSaveChangesBtn

    #AC JRNL-1816: set a goal modal disabled for null reflection answer
    #no confirmation modal displayed
    !45.times{ break if (@my_story.getNowThatLastUpdatedDate== "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.clickGoals

    !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
    expect(getPrimaryHeader).to eq("Goals")
    expect(@goal.isAddButtonVisible()).to eq(true)

    expect(@goal.clickAddButton)
    !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")
    expect(@goal.isVisionLabelDisplayed).to eq(false)
    expect(@goal.getGoalReflectionText).to eq("Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals.")

    @my_story.clickReflections
    !45.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }

    !45.times{ break if (@my_story.getNowThatLastUpdatedDate== "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.setNowThatQuestionInReflectionValue("Updated Now that question")
    @my_story.clickSaveChangesBtn
    @modal.clickNoButton

    !45.times{ break if (@my_story.getNowThatLastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    expect(getFocusedElementText).to eq("Reflections")


  end

  it "AC #JRNL-3235|TC#JRNL-3311: Prompt for Unsaved Changes", :broken => true do
    @my_story.setNowThatQuestionInReflectionValue("Testing prompt for Unsaved changes")
    @my_story.clickPersonalValues

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickReturnButton()
    !45.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }
    expect(@my_story.getNowThatQuestionInReflectionValue).to eq("Testing prompt for Unsaved changes")

    @my_story.clickAssessment
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickContinueButton

    !45.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickReflections
    !45.times{ break if (@my_story.getNowThatQuestionInReflection == "Now that you have thought about all of these areas, what is your vision of your best possible health?"); sleep 1 }

    expect(@my_story.getNowThatQuestionInReflectionValue).to eq("Updated Now that question")

  end

  it "AC#JRNL-1939|TC#JRNL-3311: Reflections - question update", :broken => true do

    expect(@my_story.getPrimaryHeader).to eq("Reflections")
    expect(@my_story.getNowThatQuestionInReflection).to eq("Now that you have thought about all of these areas, what is your vision of your best possible health?")

    text20 = "12345678901234567890"
    @my_story.setNowThatQuestionInReflectionValue(text20)
    expect(@my_story.getNowThatQuestionInReflectionValue.length).to eq(20)
    expect(@my_story.getNowThatQuestionInReflectionValue).to eq(text20)
    expect(@my_story.getCountDownTextForNowThat).to eq("235 characters left")

    text200 = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
    @my_story.setNowThatQuestionInReflectionValue(text200)
    expect(@my_story.getNowThatQuestionInReflectionValue.length).to eq(200)
    expect(@my_story.getNowThatQuestionInReflectionValue).to eq(text200)
    expect(@my_story.getCountDownTextForNowThat).to eq("55 characters left")

    text255 = "123451234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
    @my_story.setNowThatQuestionInReflectionValue(text255)
    expect(@my_story.getNowThatQuestionInReflectionValue.length).to eq(255)
    expect(@my_story.getNowThatQuestionInReflectionValue).to eq(text255)
    expect(@my_story.getCountDownTextForNowThat).to eq("0 characters left")

    text260 = text255 + "ABCDE"
    @my_story.setNowThatQuestionInReflectionValue(text260)
    expect(@my_story.getNowThatQuestionInReflectionValue.length).to eq(255)
    expect(@my_story.getNowThatQuestionInReflectionValue).to eq(text255)
    expect(@my_story.getCountDownTextForNowThat).to eq("0 characters left")

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@modal.getConfirmationHeading() == "Set a goal?"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Set a goal?")
    expect(@modal.getConfirmationMessage()).to eq("Would you like to set a goal based on your responses?")
    @modal.clickNoButton
    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !45.times{ break if (@my_story.getNowThatLastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

  end

end
=end