#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2518: Assessment – Professional Care Questions]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("assessments", "healthinventorydb")

    initializeAllObjects

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isMyStoryButtonVisible).to eq(true)

    @nav_menu.clickMyStory

    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3260: User is presented the professional care section as the last accordion (Prefessional Care) in the assessment section", :broken => true do
    @my_story.clickAssessment
    !45.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickProfessionalCare
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }

    expect(@my_story.getPreventionForProCareValue).to eq("")
    @my_story.selectPreventionForProfCare("2")
    @my_story.selectWorkingWithProfessional("Yes")

    expect(@my_story.getPreventionQuestionLabel).to eq("Prevention: On a scale of 1-5, select the number that best describes how up to date you are on your preventive care such as a flu shot, cholesterol check, cancer screening, and dental care.")
    expect(@my_story.getWorkingWithProfessionalQuestionLabel).to eq("Are you working with a healthcare professional to treat any clinical conditions?")
    expect(@my_story.getClinicalCareQuestionLabel).to eq("Clinical Care: If you are working with a healthcare professional, on a scale of 1-5, select the number that best describes how well you understand your health problems, the treatment plan, and your role in your health.")

  end

  it "AC #MVAH-75: When the accordion is expanded, informational text is shown for the prevention care question for the user to answer.  - AC #JRNL-3249: Upon saving using the “Save Changes” button, the page is refreshed - AC #JRNL-3251:After an initial submission users are presented their most recently submitted answers within each section  ", :broken => true do

    @my_story.selectPreventionForProfCare("1")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
    expect(@my_story.getPreventionForProCareValue).to eq("1")

    fiveDaysAgo = (Time.now - 5.days)
    updateProfessionalCareUpdatedDAte(fiveDaysAgo, "D123401")
    refreshBrowser
    !45.times{ break if (@my_story.getLastUpdatedDateForProfCare == "Last updated: " + fiveDaysAgo.strftime("%m/%d/%Y").to_s); sleep 1 }
    expect(@my_story.getLastUpdatedDateForProfCare).to eq("Last updated: " + fiveDaysAgo.strftime("%m/%d/%Y").to_s)

    @my_story.clickProfessionalCare
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }

    @my_story.selectPreventionForProfCare("")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
    expect(@my_story.getPreventionForProCareValue).to eq("")

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !45.times{ break if (@my_story.getLastUpdatedDateForProfCare == "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.getLastUpdatedDateForProfCare).to eq("Last updated: " + today.to_s)

    @my_story.selectPreventionForProfCare("2")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
    expect(@my_story.getPreventionForProCareValue).to eq("2")

    @my_story.selectPreventionForProfCare("3")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
    expect(@my_story.getPreventionForProCareValue).to eq("3")

    @my_story.selectPreventionForProfCare("4")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
    expect(@my_story.getPreventionForProCareValue).to eq("4")

    @my_story.selectPreventionForProfCare("5")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
    expect(@my_story.getPreventionForProCareValue).to eq("5")

    @my_story.selectPreventionForProfCare("")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
    expect(@my_story.getPreventionForProCareValue).to eq("")

  end

  it "AC #JRNL-3232: When the accordion is expanded, informational text is shown for the clinical care question for the user to answer. - AC #JRNL-3253: Once a user makes a change, the Save Changes button is enabled in the title bar", :broken => true do
    removeCollection("assessments", "healthinventorydb")
    refreshBrowser
    !45.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickProfessionalCare
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }

    expect(@my_story.getWorkingWithProfessionalValue).to eq("")
    @my_story.selectWorkingWithProfessional("Yes")
    !45.times{ break if (@my_story.getClinicalCareQuestionLabel == "Clinical Care: If you are working with a healthcare professional, on a scale of 1-5, select the number that best describes how well you understand your health problems, the treatment plan, and your role in your health."); sleep 1 }
    @my_story.selectClinicalCare("4")

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }

    expect(@my_story.getWorkingWithProfessionalValue).to eq("Yes")
    expect(@my_story.getClinicalCareValue).to eq("4")

    @my_story.selectClinicalCare("")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }

    expect(@my_story.getWorkingWithProfessionalValue).to eq("Yes")
    expect(@my_story.getClinicalCareValue).to eq("")
    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    expect(@my_story.getLastUpdatedDateForProfCare).to eq("Last updated: " + today.to_s)

    @my_story.selectClinicalCare("3")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }
    expect(@my_story.getClinicalCareValue).to eq("3")

    expect(@my_story.isClinicalCareQuestionPresent).to eq(true)
    @my_story.selectWorkingWithProfessional("No")

    !45.times{ break if (@modal.getConfirmationHeading() == "Alert"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Alert")
    expect(@modal.getConfirmationMessage()).to eq("Based on your response, the follow-on question does not apply and will be removed.")

    @modal.clickOKFromInfoModal()
    !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }

    expect(@my_story.isClinicalCareQuestionPresent).to eq(false)

    @my_story.selectWorkingWithProfessional("Yes")
    !45.times{ break if (@my_story.getClinicalCareQuestionLabel == "Clinical Care: If you are working with a healthcare professional, on a scale of 1-5, select the number that best describes how well you understand your health problems, the treatment plan, and your role in your health."); sleep 1 }
    expect(@my_story.getClinicalCareValue).to eq("")

  end

  it "AC #JRNL-3241: Prompt for Unsaved Changes", :broken => true do
    @my_story.selectPreventionForProfCare("4")
    @my_story.selectClinicalCare("2")

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }

    expect(@my_story.getPreventionForProCareValue).to eq("4")
    expect(@my_story.getClinicalCareValue).to eq("2")

    @my_story.selectPreventionForProfCare("2")
    @my_story.selectClinicalCare("5")

    @main.clickNavMenu
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    @nav_menu.navigate("PersonalTrackers")

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickReturnButton()
    !45.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }

    @main.clickNavMenu
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    @nav_menu.navigate("Assessments")

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickContinueButton
    !45.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }

    !45.times{ break if(getSecondaryHeader == "Assessment List"); sleep 1 }
    expect(getSecondaryHeader).to eq("Assessment List")

    @main.clickNavMenu
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory
    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

    @my_story.clickAssessment
    !45.times{ break if (@my_story.isAccordionCollapsed("Professional Care") == true); sleep 1 }
    expect(@my_story.isAccordionCollapsed("Professional Care")).to eq(true)

    @my_story.clickProfessionalCare()
    !45.times{ break if (@my_story.getWorkingWithProfessionalQuestionLabel == "Are you working with a healthcare professional to treat any clinical conditions?"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")
    expect(@my_story.getPreventionForProCareValue).to eq("4")
    expect(@my_story.getClinicalCareValue).to eq("2")

  end

  it "AC #JRNL-3244: Until a value is entered (in any section), the 'Save Changes' button is disabled, and the disabled status is conveyed by the screen reader", :broken => true do
    expect(@my_story.isSaveChangesDisabled).to eq(true)
  end

  it "AC #JRNL-3246: When the user makes a change to the state of any input (in any section), the Save Changes button becomes enabled on the right-hand of the title bar", :broken => true do
    @my_story.selectPreventionForProfCare("1")

    !45.times{ break if (@my_story.isSaveChangesDisabled == false); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(false)

  end

end
