require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2521: Personal Values]", :acceptance => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("promptedresponses", "healthinventorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isMyStoryButtonVisible).to eq(true)

    #@nav_menu.clickMyStory
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyStory']").click
    waitForPageToFinishLoading
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  # after(:all) do
  #   quitDriver()
  # end

  it "AC #JRNL-3166|TC #JRNL-3264: When the user selects Personal Values from the main pane, the system displays the Personal Values questions in the detail pane" do
    @my_story.clickPersonalValues
    !5.times{ break if (@my_story.getPrimaryHeader == "Personal Values"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Personal Values")
    !5.times{ break if(@my_story.getWhatReallyQuestionLabelInPersonalValues() == "What REALLY matters to you in your life?"); sleep 1 }
    expect(@my_story.getWhatReallyQuestionLabelInPersonalValues).to eq("What REALLY matters to you in your life?")
    expect(@my_story.getSenseOfJoyQuestionLabelInPersonalValues).to eq("What brings you a sense of joy and happiness?")
  end

  it "AC #JRNL-3168|TC #JRNL-3264:  Initial defaults are nulls and no guidance text is presented" do
    expect(@my_story.getWhatReallyQuestionInPersonalValues.length).to eq(0)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq("")
    expect(@my_story.isWhatReallyGuidanceTextPresent).to eq(false)

    expect(@my_story.getSenseOfJoyQuestionInPersonalValues.length).to eq(0)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq("")
    expect(@my_story.isSenseOfJoyGuidanceTextPresent).to eq(false)
  end

  it "AC #JRNL-3173|TC #JRNL-3264:After an initial submission users are presented their most recently submitted answers within each section " do
    @my_story.setWhatReallyQuestionInPersonalValues("Initial Submission")
    @my_story.setSenseOfJoyQuestionInPersonalValues("Music")

    @my_story.clickSaveChangesBtn()
    !5.times{ break if(@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled()).to eq(true)

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !5.times{ break if (@my_story.getWhatReallyLastUpdatedDate == "Last updated: "  + today.to_s); sleep 1 }
    expect(@my_story.getWhatReallyLastUpdatedDate).to eq("Last updated: "  + today.to_s)
    expect(@my_story.getSenseOfJoyLastUpatedDate).to eq("Last updated: " + today.to_s)
  end

  it "AC #JRNL-3169|TC #JRNL-3264:  Neither question is mandatory - AC #JRNL-3172: Upon saving using the 'Save Changes' button, the page is refreshed", :broken => true do
    twoDaysAgo = (Time.now - 2.days)

    #updatePersonalValuesUpdatedDate(twoDaysAgo, "D123401")

    refreshBrowser

    !5.times{ break if (@my_story.getWhatReallyLastUpdatedDate == "Last updated: "  +  twoDaysAgo.strftime("%m/%d/%Y").to_s); sleep 1 }
    #expect(@my_story.getWhatReallyLastUpdatedDate).to eq("Last updated: "  + twoDaysAgo.strftime("%m/%d/%Y").to_s)
    #expect(@my_story.getSenseOfJoyLastUpatedDate).to eq("Last updated: " + twoDaysAgo.strftime("%m/%d/%Y").to_s)

    @my_story.setWhatReallyQuestionInPersonalValues("There is no passion to be found in playing small in settling for a life that is less than what you are capable of living")
    @my_story.setSenseOfJoyQuestionInPersonalValues("Family, my work")

    @my_story.clickSaveChangesBtn
    !5.times{ break if(@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled()).to eq(true)

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !5.times{ break if (@my_story.getWhatReallyLastUpdatedDate == "Last updated: "  + today.to_s); sleep 1 }
    expect(@my_story.getWhatReallyLastUpdatedDate).to eq("Last updated: "  + today.to_s)
    expect(@my_story.getSenseOfJoyLastUpatedDate).to eq("Last updated: " + today.to_s)

    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq("Family, my work")
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq("There is no passion to be found in playing small in settling for a life that is less than what you are capable of living")

    @my_story.setWhatReallyQuestionInPersonalValues("")
    @my_story.setSenseOfJoyQuestionInPersonalValues("")

    @my_story.clickSaveChangesBtn
    !5.times{ break if (@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq("")
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq("")
  end

  it "AC #JRNL-3175|TC #JRNL-3264: Until changes are made from a previous answer, the 'Save Changes' button is disabled " do
    @my_story.setWhatReallyQuestionInPersonalValues("Updated What Really matter question")
    !5.times{ break if(@my_story.isSaveChangesDisabled == false); sleep 1}

    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.clickSaveChangesBtn
    !5.times{ break if (@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.setWhatReallyQuestionInPersonalValues("")

    @my_story.clickSaveChangesBtn
    !5.times{ break if (@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
  end

  it "AC #JRNL-3170|TC #JRNL-3264: Until text is entered, the 'Save Changes' button is disabled, and the disabled status is reflected in the voice over output" do
    expect(@my_story.isSaveChangesDisabled).to eq(true)
  end

  it "AC #JRNL-3171|TC #JRNL-3264: When the user makes a change to the state of any input, the 'Save Changes' button becomes enabled, located on the right-hand side of the title bar" do
    @my_story.setWhatReallyQuestionInPersonalValues("Testing testing")
    expect(@my_story.isSaveChangesDisabled).to eq(false)
  end

  it "AC #JRNL-3167|TC #JRNL-3264: User can save no more than 255 characters for each question " do
    text20 = "12345678901234567890"
    @my_story.setWhatReallyQuestionInPersonalValues(text20)
    expect(@my_story.getWhatReallyQuestionInPersonalValues.length).to eq(20)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq(text20)
    expect(@my_story.getCountDownTextForWhatReallyQuestionInPersonalValues).to eq("235 characters left")

    @my_story.setSenseOfJoyQuestionInPersonalValues(text20)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues.length).to eq(20)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq(text20)
    expect(@my_story.getCountDownTextForSenseOfJoyQuestionInPersonalValues).to eq("235 characters left")


    text200 = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
    @my_story.setWhatReallyQuestionInPersonalValues(text200)
    expect(@my_story.getWhatReallyQuestionInPersonalValues.length).to eq(200)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq(text200)
    expect(@my_story.getCountDownTextForWhatReallyQuestionInPersonalValues).to eq("55 characters left")

    @my_story.setSenseOfJoyQuestionInPersonalValues(text200)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues.length).to eq(200)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq(text200)
    expect(@my_story.getCountDownTextForSenseOfJoyQuestionInPersonalValues).to eq("55 characters left")

    text255 = "123451234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
    @my_story.setWhatReallyQuestionInPersonalValues(text255)
    expect(@my_story.getWhatReallyQuestionInPersonalValues.length).to eq(255)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq(text255)
    expect(@my_story.getCountDownTextForWhatReallyQuestionInPersonalValues).to eq("0 characters left")

    @my_story.setSenseOfJoyQuestionInPersonalValues(text255)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues.length).to eq(255)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq(text255)
    expect(@my_story.getCountDownTextForSenseOfJoyQuestionInPersonalValues).to eq("0 characters left")

    text260 = text255 + "ABCDE"
    @my_story.setWhatReallyQuestionInPersonalValues(text260)
    expect(@my_story.getWhatReallyQuestionInPersonalValues.length).to eq(255)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq(text255)
    expect(@my_story.getCountDownTextForWhatReallyQuestionInPersonalValues).to eq("0 characters left")

    @my_story.setSenseOfJoyQuestionInPersonalValues(text260)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues.length).to eq(255)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq(text255)
    expect(@my_story.getCountDownTextForSenseOfJoyQuestionInPersonalValues).to eq("0 characters left")
  end

  it "AC #MVAH|TC #JRNL-3264: When trying to navigate away from the section without having saved, users receive a prompt modal to 'Continue' or to 'Return'" do
    @my_story.setWhatReallyQuestionInPersonalValues("Testing 123")
    expect(@my_story.getWhatReallyQuestionInPersonalValues()).to eq("Testing 123")

    @my_story.clickSaveChangesBtn()
    waitForPageToFinishLoading()
    !5.times{ break if (@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled()).to eq(true)

    @my_story.setWhatReallyQuestionInPersonalValues("Testing Navigate away")
    expect(@my_story.getWhatReallyQuestionInPersonalValues()).to eq("Testing Navigate away")

    @my_story.clickAssessment()
    !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")

    @modal.clickReturnButton()
    !5.times{ break if (@modal.isConfirmationPopUpNotPresent()); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq("Testing Navigate away")

    @my_story.clickAssessment()
    !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")

    @modal.clickContinueButton()
    !5.times{ break if (@my_story.getPrimaryHeader() == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader()).to eq("Assessment")

    @my_story.clickPersonalValues()
    !5.times{ break if (@my_story.getPrimaryHeader() == "Personal Values"); sleep 1 }
    expect(@my_story.getPrimaryHeader()).to eq("Personal Values")

    waitForPageToFinishLoading()

    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq("")
  end

end









































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2521: Personal Values]", :acceptance => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("promptedresponses", "healthinventorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isMyStoryButtonVisible).to eq(true)

    @nav_menu.clickMyStory
    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3166|TC #JRNL-3264: When the user selects Personal Values from the main pane, the system displays the Personal Values questions in the detail pane" do
    @my_story.clickPersonalValues
    !45.times{ break if (@my_story.getPrimaryHeader == "Personal Values"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Personal Values")
    !30.times{ break if(@my_story.getWhatReallyQuestionLabelInPersonalValues() == "What REALLY matters to you in your life?"); sleep 1 }
    expect(@my_story.getWhatReallyQuestionLabelInPersonalValues).to eq("What REALLY matters to you in your life?")
    expect(@my_story.getSenseOfJoyQuestionLabelInPersonalValues).to eq("What brings you a sense of joy and happiness?")
  end

  it "AC #JRNL-3168|TC #JRNL-3264:  Initial defaults are nulls and no guidance text is presented" do
    expect(@my_story.getWhatReallyQuestionInPersonalValues.length).to eq(0)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq("")
    expect(@my_story.isWhatReallyGuidanceTextPresent).to eq(false)

    expect(@my_story.getSenseOfJoyQuestionInPersonalValues.length).to eq(0)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq("")
    expect(@my_story.isSenseOfJoyGuidanceTextPresent).to eq(false)
  end

  it "AC #JRNL-3173|TC #JRNL-3264:After an initial submission users are presented their most recently submitted answers within each section " do
    @my_story.setWhatReallyQuestionInPersonalValues("Initial Submission")
    @my_story.setSenseOfJoyQuestionInPersonalValues("Music")

    @my_story.clickSaveChangesBtn()
    !45.times{ break if(@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled()).to eq(true)

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !45.times{ break if (@my_story.getWhatReallyLastUpdatedDate == "Last updated: "  + today.to_s); sleep 1 }
    expect(@my_story.getWhatReallyLastUpdatedDate).to eq("Last updated: "  + today.to_s)
    expect(@my_story.getSenseOfJoyLastUpatedDate).to eq("Last updated: " + today.to_s)
  end

  it "AC #JRNL-3169|TC #JRNL-3264:  Neither question is mandatory - AC #JRNL-3172: Upon saving using the 'Save Changes' button, the page is refreshed", :broken => true do
    twoDaysAgo = (Time.now - 2.days)

    updatePersonalValuesUpdatedDate(twoDaysAgo, "D123401")

    refreshBrowser

    !45.times{ break if (@my_story.getWhatReallyLastUpdatedDate == "Last updated: "  +  twoDaysAgo.strftime("%m/%d/%Y").to_s); sleep 1 }
    expect(@my_story.getWhatReallyLastUpdatedDate).to eq("Last updated: "  + twoDaysAgo.strftime("%m/%d/%Y").to_s)
    expect(@my_story.getSenseOfJoyLastUpatedDate).to eq("Last updated: " + twoDaysAgo.strftime("%m/%d/%Y").to_s)

    @my_story.setWhatReallyQuestionInPersonalValues("There is no passion to be found in playing small in settling for a life that is less than what you are capable of living")
    @my_story.setSenseOfJoyQuestionInPersonalValues("Family, my work")

    @my_story.clickSaveChangesBtn
    !45.times{ break if(@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled()).to eq(true)

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !45.times{ break if (@my_story.getWhatReallyLastUpdatedDate == "Last updated: "  + today.to_s); sleep 1 }
    expect(@my_story.getWhatReallyLastUpdatedDate).to eq("Last updated: "  + today.to_s)
    expect(@my_story.getSenseOfJoyLastUpatedDate).to eq("Last updated: " + today.to_s)

    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq("Family, my work")
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq("There is no passion to be found in playing small in settling for a life that is less than what you are capable of living")

    @my_story.setWhatReallyQuestionInPersonalValues("")
    @my_story.setSenseOfJoyQuestionInPersonalValues("")

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq("")
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq("")
  end

  it "AC #JRNL-3175|TC #JRNL-3264: Until changes are made from a previous answer, the 'Save Changes' button is disabled " do
    @my_story.setWhatReallyQuestionInPersonalValues("Updated What Really matter question")
    !45.times{ break if(@my_story.isSaveChangesDisabled == false); sleep 1}




    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    @my_story.setWhatReallyQuestionInPersonalValues("")

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
  end

  it "AC #JRNL-3170|TC #JRNL-3264: Until text is entered, the 'Save Changes' button is disabled, and the disabled status is reflected in the voice over output" do
    expect(@my_story.isSaveChangesDisabled).to eq(true)
  end

  it "AC #JRNL-3171|TC #JRNL-3264: When the user makes a change to the state of any input, the 'Save Changes' button becomes enabled, located on the right-hand side of the title bar" do
    @my_story.setWhatReallyQuestionInPersonalValues("Testing testing")
    expect(@my_story.isSaveChangesDisabled).to eq(false)
  end

  it "AC #JRNL-3167|TC #JRNL-3264: User can save no more than 255 characters for each question " do
    text20 = "12345678901234567890"
    @my_story.setWhatReallyQuestionInPersonalValues(text20)
    expect(@my_story.getWhatReallyQuestionInPersonalValues.length).to eq(20)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq(text20)
    expect(@my_story.getCountDownTextForWhatReallyQuestionInPersonalValues).to eq("235 characters left")

    @my_story.setSenseOfJoyQuestionInPersonalValues(text20)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues.length).to eq(20)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq(text20)
    expect(@my_story.getCountDownTextForSenseOfJoyQuestionInPersonalValues).to eq("235 characters left")


    text200 = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
    @my_story.setWhatReallyQuestionInPersonalValues(text200)
    expect(@my_story.getWhatReallyQuestionInPersonalValues.length).to eq(200)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq(text200)
    expect(@my_story.getCountDownTextForWhatReallyQuestionInPersonalValues).to eq("55 characters left")

    @my_story.setSenseOfJoyQuestionInPersonalValues(text200)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues.length).to eq(200)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq(text200)
    expect(@my_story.getCountDownTextForSenseOfJoyQuestionInPersonalValues).to eq("55 characters left")

    text255 = "123451234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
    @my_story.setWhatReallyQuestionInPersonalValues(text255)
    expect(@my_story.getWhatReallyQuestionInPersonalValues.length).to eq(255)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq(text255)
    expect(@my_story.getCountDownTextForWhatReallyQuestionInPersonalValues).to eq("0 characters left")

    @my_story.setSenseOfJoyQuestionInPersonalValues(text255)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues.length).to eq(255)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq(text255)
    expect(@my_story.getCountDownTextForSenseOfJoyQuestionInPersonalValues).to eq("0 characters left")

    text260 = text255 + "ABCDE"
    @my_story.setWhatReallyQuestionInPersonalValues(text260)
    expect(@my_story.getWhatReallyQuestionInPersonalValues.length).to eq(255)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq(text255)
    expect(@my_story.getCountDownTextForWhatReallyQuestionInPersonalValues).to eq("0 characters left")

    @my_story.setSenseOfJoyQuestionInPersonalValues(text260)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues.length).to eq(255)
    expect(@my_story.getSenseOfJoyQuestionInPersonalValues).to eq(text255)
    expect(@my_story.getCountDownTextForSenseOfJoyQuestionInPersonalValues).to eq("0 characters left")
  end

  it "AC #MVAH|TC #JRNL-3264: When trying to navigate away from the section without having saved, users receive a prompt modal to 'Continue' or to 'Return'" do
    @my_story.setWhatReallyQuestionInPersonalValues("Testing 123")
    expect(@my_story.getWhatReallyQuestionInPersonalValues()).to eq("Testing 123")

    @my_story.clickSaveChangesBtn()
    waitForPageToFinishLoading()
    !45.times{ break if (@my_story.isSaveChangesDisabled()); sleep 1 }
    expect(@my_story.isSaveChangesDisabled()).to eq(true)

    @my_story.setWhatReallyQuestionInPersonalValues("Testing Navigate away")
    expect(@my_story.getWhatReallyQuestionInPersonalValues()).to eq("Testing Navigate away")

    @my_story.clickAssessment()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickReturnButton()
    !45.times{ break if (@modal.isConfirmationPopUpNotPresent()); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq("Testing Navigate away")

    @my_story.clickAssessment()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    @modal.clickContinueButton()
    !45.times{ break if (@my_story.getPrimaryHeader() == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader()).to eq("Assessment")

    @my_story.clickPersonalValues()
    !45.times{ break if (@my_story.getPrimaryHeader() == "Personal Values"); sleep 1 }
    expect(@my_story.getPrimaryHeader()).to eq("Personal Values")

    waitForPageToFinishLoading()

    expect(@my_story.getWhatReallyQuestionInPersonalValues).to eq("Testing 123")
  end

end
=end