require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2463:  Goal Notification/Reminder]", :acceptance => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("goals", "healthinventorydb")
    removeCollection("promptedresponses", "healthinventorydb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    resetCollection("notifications", "notificationsdb", "goal_notification")

    initializeAllObjects

    @expectedValidationSummaryHeader = "The following errors were found:"

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    navigateToGoal()

    expect(@goal.isAddButtonVisible()).to eq(true)
    expect(@goal.isAddButtonRightJustified).to eq(true)

    @goal.clickAddButton()
    !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")

    @goalName = "Goal with Notification set up"
    @goalStartDate = getDateNthDaysFromNow(0, "%m/%d/%Y")
    goalEndDate = getDateNthYeasFromNow(1,  "%m/%d/%Y")

    stepDueDate_1 = getDateNthDaysFromNow(10, "%m/%d/%Y")
    stepDueDate_2 = getDateNthDaysFromNow(50, "%m/%d/%Y")
    stepAndDueDateArr = ["Step 1;" + stepDueDate_1.to_s, "Step 2;" + stepDueDate_2.to_s]
    enterData(@goalName, @goalStartDate, goalEndDate, stepAndDueDateArr, "", "")

  end

  after(:all) do
    quitDriver()
  end

  context '#AC #JRNL-2810|TC#JRNL-1817: Goals - Notification Fields' do
    it ".A separator bar is shown above the word Notifications" do
      expect(@goal_notification.isSeparatorBarPresent).to eq(true)
    end

    it ".Notification label is shown, bell icon is shown to the left of the notifications label" do
      expect(@goal_notification.getNotificationLabel).to eq("Notification:")
      expect(@goal_notification.isNotificationIconPresent).to eq(true)
    end

    it ".Status options, shown below Notification label: (single select, radio button, values on/off, default to off) " do
      expect(@goal_notification.getNotificationStatusNthOptionText(1)).to eq("On")
      expect(@goal_notification.getNotificationStatusNthOptionValue(1)).to eq("On")
      expect(@goal_notification.isNotificationStatusOptionSelected("On")).to eq(false)
    end

    it ".If Status is off, Start Date, Notify Me, and Notification Delivery fields are all disabled and optional." do
      expect(@goal_notification.getNotificationStatusNthOptionText(2)).to eq("Off")
      expect(@goal_notification.getNotificationStatusNthOptionValue(2)).to eq("Off")
      expect(@goal_notification.isNotificationStatusOptionSelected("Off")).to eq(true)

      expect(@goal_notification.isNotificationStartDateFieldDisabled).to eq(true)
      expect(@goal_notification.isNotifyMeFieldDisabled).to eq(true)
      expect(@goal_notification.isNotificationDeliveryFieldDisabled("In-App")).to eq(true)
      expect(@goal_notification.isNotificationDeliveryFieldDisabled("Email")).to eq(true)

      expect(@goal_notification.isNotificationStartDateFieldRequired).to eq(false)
      expect(@goal_notification.isNotifyMeFieldRequired).to eq(false)
      expect(@goal_notification.isNotificationDeliveryMethodRequired).to eq(false)

    end

    it ".	If Status is on, Start Date, Notify Me, and Notification Delivery fields are all enabled and required." do
      @goal_notification.selectNotificationStatus("On")
      !45.times{ break if (@goal_notification.isNotificationStartDateFieldDisabled == false); sleep 1 }
      expect(@goal_notification.isNotificationStartDateFieldDisabled).to eq(false)
      expect(@goal_notification.isNotifyMeFieldDisabled).to eq(false)
      expect(@goal_notification.isNotificationDeliveryFieldDisabled("In-App")).to eq(false)
      expect(@goal_notification.isNotificationDeliveryFieldDisabled("Email")).to eq(true)

      expect(@goal_notification.isNotificationStartDateFieldRequired).to eq(true)
      expect(@goal_notification.isNotifyMeFieldRequired).to eq(true)
      expect(@goal_notification.isNotificationDeliveryMethodRequired).to eq(true)
    end

    it ".Start Date (date, date picker, format: MM/DD/YYYY, show format as guidance text)" do
      expect(@goal_notification.getNotificationStartDateGuidanceText).to eq("MM/DD/YYYY")

    end

    it ".Notify Me (required if enabled, single select, select list, values: Select, Daily, Weekly, Monthly)" do
      expect(@goal_notification.isNotifyMeFieldRequired).to eq(true)
      expect(@goal_notification.areAllTheseValuesAvailableInNotifyMeList("Select, Daily, Weekly, Monthly")).to eq(true)

    end

    it ".Notification Delivery (required if enabled, multi-select, check boxes, values: In-App, Email; In-App is checked by default when status is on),If preferred email is null, the Email check box is disabled.", :broken => true do
      expect(@goal_notification.isNotificationDeliveryMethodRequired).to eq(true)
      expect(@goal_notification.isInAppCheckboxChecked).to eq(true)
      @goal_notification.setNotificationDeliveryOption("In-App")
      @form.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "A Notification Delivery method is needed to save this record. Please select a method and save again.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Start Date field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Notify Me field is required.")).to eq(true)

      expect(@goal_notification.isNotificationDeliveryFieldDisabled("In-App")).to eq(false)
      expect(@goal_notification.isNotificationDeliveryFieldDisabled("Email")).to eq(true)
      expect(@goal_notification.getNotificationEmailAddress).to eq("Email address has not been saved")

      @goal_notification.selectNotificationStatus("Off")

      @form.clickSaveButton
      !45.times{ break if (@goal.findIndexWithGivenGoalName(@goalName) > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName(@goalName)
      expect(index > -1).to eq(true)

      sleep 3
      @common.navigateToNotificationSettingAndSetOrRemoveEmail("meera.cho@agilex.com")
      !45.times{ break if (@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      navigateToGoal()

      @goal.clickNthRow(index)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      @goal_notification.selectNotificationStatus("On")
      expect(@goal_notification.isNotificationDeliveryFieldDisabled("In-App")).to eq(false)
      expect(@goal_notification.isNotificationDeliveryFieldDisabled("Email")).to eq(false)
      expect(@goal_notification.getNotificationEmailAddress).to eq("meera.cho@agilex.com")

    end

    it "Guidance text: You may update your Preferred Email address in the Notification feature by selecting the <insert gear icon, alt text Notifications Settings> icon." do
      expect(@goal_notification.getEmailGuidanceText).to eq("You may update your Preferred Email address in the Notification feature by selecting the icon.")
    end

    it ".Standard Save and Cancel buttons shown on the Add/Edit Goal function to cover Saving and Canceling any notification." do
      expect(@form.isCancelButtonVisible).to eq(true)
      expect(@form.isSaveButtonVisible).to eq(true)
    end

  end

  context "#AC #JRNL-2930|TC #JRNL-1817: Remove pending notifications for complete goals. - update Status to Complete" do
    it ".If a user marks a goal as complete, all pending notifications are removed.", :broken => true do
      @goal_notification.selectNotificationStatus("On")
      @goal_notification.setNotificationStartDate(@goalStartDate)
      @goal_notification.selectNotifyMe("Daily")
      @goal_notification.setNotificationDeliveryOption("Email")

      @form.clickSaveButton
      !45.times{ break if (@goal.findIndexWithGivenGoalName(@goalName) > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName(@goalName)
      expect(index > -1).to eq(true)

      @goal.clickNthRow(index)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      #notification start date is disabled
      expect(isThisElementDisabled(:css, Goal_Notification::START_DATE)).to eq(true)
      @goal.selectStatus("Complete")
      @form.clickSaveButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      @modal.clickContinueButton

      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      filterByCompletedGoalAndVerifyNotificationOptionTurnedOff(@goalName)

    end

    it ".If a user marks a goal as complete, all pending notifications are removed.  - Complete all steps", :broken => true do
      @goal.selectStatus("Active")
      @date_filter.clickFilterBtn
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      name = "Goals - Complete all steps"
      goalStartDate = "10/01/2014"
      goalEndDate = "07/01/2015"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014"]
      addGoalAndAddNotification(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "", "Weekly")

      verifyDataEntriesInEditForGoalNotification(name,"Weekly")

      index = @goal.findIndexWithGivenGoalName(name)
      @goal.clickNthRow(index)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      @goal.checkNthStepComplete(1)
      @goal.checkNthStepComplete(2)

      @form.clickSaveButton
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      @modal.clickContinueButton

      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      filterByCompletedGoalAndVerifyNotificationOptionTurnedOff(name)

    end
  end

  context "#AC #JRNL-2811|TC #JRNL-1817: Goals - In app Notification format" do
    it ".In app Notification text", :broken => true do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
      expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

      @nav_menu.clickNotifications()
      !45.times{ break if (@notifications.getTitle() == "Notifications"); sleep 1 }
      expect(@notifications.getTitle()).to eq("Notifications")

      @nav_menu.clickAllNotifications()
      !45.times{ break if (getPrimaryHeader() == "All Notifications"); sleep 1 }
      expect(getPrimaryHeader()).to eq("All Notifications")

      yearAgo = getDateNthYearsAgo(1, '%m/%d/%Y')

      @date_filter.setFromDate(yearAgo)
      @date_filter.clickFilterBtn()
      waitForPageToFinishLoading()

      expect(getCount() >= 2).to eq(true)

      expectedNotification = ["Status", "Unread", "Notification", "Your Walk 10k Steps a day goal is due on 10/25/2014", "Source", "My VA Health - My Story", "Date", "10/21/2014 12:05 PM America/New_York"]
      actualNotification = getTextForRow(1).split(%(\n)).map(&:strip)

      for i in 0..actualNotification.length()
        expect(actualNotification[i]).to eq(expectedNotification[i])
      end

      expectedNotification = ["Status", "Unread", "Notification", "Your Eat 2 servings of vegetables a day goal is due on 10/25/2014", "Source", "My VA Health - My Story", "Date", "10/21/2014 12:04 PM America/New_York"]
      actualNotification = getTextForRow(2).split(%(\n)).map(&:strip)

      for i in 0..actualNotification.length()
        expect(actualNotification[i]).to eq(expectedNotification[i])
      end

      clickNthRow(1)
      waitForPageToFinishLoading()
      expect(@notifications.getPrimaryHeader).to eq("View Notification")

      expect(@notifications.getSourceInDetail).to eq("My VA Health - My Story")
      expect(@notifications.getDateAndTimeInDetail).to eq("10/21/2014 12:05 PM")
      expect(@notifications.getTimezoneInDetail).to eq("America/New_York")
      expect(@notifications.getTextInDetail).to eq("Your Walk 10k Steps a day goal is due on 10/25/2014")

    end

  end


  def enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)
    @goal.setGoalName(name)
    @goal.setGoalStartDate(goalStartDate)
    @goal.setGoalEndDate(goalEndDate)

    stepsCount = stepsAndDueDateArr.length
    for i in 0..(stepsCount - 1 )
      if(@goal.isNthStepPresent(i + 1) == false)
        @goal.clickAddStepButton
      end

      #puts "steps and due date array: " + stepsAndDueDateArr[i]

      stepsAndDate = stepsAndDueDateArr[i]
      data = stepsAndDate.split(";")
      step = data[0]
      date = data[1]

      @goal.setNthStep(i + 1, step)
      @goal.setNthStepDueDate(i + 1, date)
    end
    @goal.setDescription(description)
    @goal.setRewardAtCompletion(reward)
  end

  def navigateToGoal
    @main.clickNavMenu()
    !45.times { break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory
    !45.times { break if (getSecondaryHeader == "My Story"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Story")

    @my_story.clickGoals
    !45.times { break if (getPrimaryHeader == "Goals"); sleep 1 }
    expect(getPrimaryHeader).to eq("Goals")
  end

  def addGoalAndAddNotification(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward, notifyMe)
    @goal.clickAddButton()
    !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")

    @goal_notification.selectNotificationStatus("On")

    enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)
    startDate = @goalStartDate
    email = "Email"
    inApp = "In-App"
    enterNotification(startDate, notifyMe, email, inApp)

    @form.clickSaveButton
    !45.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
    expect(@goal.findIndexWithGivenGoalName(name) > -1).to eq(true)
  end

  def enterNotification(startDate, notifyMe, email, inApp)
    @goal_notification.setNotificationStartDate(startDate)
    @goal_notification.selectNotifyMe(notifyMe)
    if email != ""
      @goal_notification.setNotificationDeliveryOption(email)
    end
    if inApp != ""
      @goal_notification.setNotificationDeliveryOption(inApp)
    end
  end

  def filterByCompletedGoalAndVerifyNotificationOptionTurnedOff(name)
    @goal.selectStatus("Complete")
    @date_filter.clickFilterBtn

    !45.times { break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
    index = @goal.findIndexWithGivenGoalName(name)
    expect(index > -1).to eq(true)

    @goal.clickNthRow(index)
    !45.times { break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Edit Goal Entry")

    expect(@goal_notification.isNotificationStatusOptionSelected("Off")).to eq(true)
    expect(@goal_notification.isNotificationStatusOptionSelected("On")).to eq(false)

    @form.clickCancelButton
    !45.times { break if (getPrimaryHeader == "Goals"); sleep 1 }
    expect(getPrimaryHeader).to eq("Goals")
  end

  def verifyDataEntriesInEditForGoalNotification(goalName, notifyMe)
    index = @goal.findIndexWithGivenGoalName(goalName)
    @goal.clickNthRow(index)
    !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Edit Goal Entry")

    expect(@goal.getGoalName).to eq(goalName)

    expect(@goal_notification.getNotificationStartDate).to eq(@goalStartDate)
    expect(@goal_notification.getNotifyMe).to eq(notifyMe)

    expect(@goal_notification.isNotificationStatusOptionSelected("Off")).to eq(false)
    expect(@goal_notification.isNotificationStatusOptionSelected("On")).to eq(true)

    @form.clickCancelButton
    !45.times { break if (getPrimaryHeader == "Goals"); sleep 1 }
    expect(getPrimaryHeader).to eq("Goals")

  end

end
