#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2464:  Create Learn More About SMART Goals]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("goals", "healthinventorydb")
    removeCollection("promptedresponses", "healthinventorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyStory']").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader == "My Story"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Story")

    @my_story.clickGoals
    !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
    expect(getPrimaryHeader).to eq("Goals")
    expect(@goal.isAddButtonVisible()).to eq(true)

    @goal.clickAddButton
    !5.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")
    !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(@goal.getGoalReflectionText).to eq("Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals.")
  end

  # after(:all) do
  #   quitDriver()
  # end

  context "#AC JRNL-1951: Learn More Link On Goals" do
    it ".When a user views the Add or Edit Goal Detail screen, the system provides a link to a tutorial on SMART goals labeled Learn more about SMART Goals." do
      waitForPageToFinishLoading
      expect(isElementPresentAndVisible(:css, MyStory_Goal::SMART_GOAL)).to eq(true)
      expect(isElementPresentAndVisible(:css, MyStory_Goal::GRADUATION_CAP)).to eq(true)
      expect(getTextForElement(:css, MyStory_Goal::SMART_GOAL)).to eq("Learn more about SMART Goals")
      expect(@goal.getGraduationCapAltText).to eq("Graduation cap (icon)")
    end
  end

  context "#AC JRNL-1950: Screen 1 - Tutorial" do
    it ".When the user selects the Learn More link, the system displays the tutorial in a modal window using a Carousel control" do
      waitForPageToFinishLoading
      click(:css, MyStory_Goal::SMART_GOAL)
      !5.times{ break if (@carousel.getCarouselHeading == "Learn More about SMART Goals"); sleep 1 }
      expect(@carousel.getCarouselHeading).to eq("Learn More about SMART Goals")
      expect(@carousel.getSubHeading).to eq("Smart Goals")
      expect(@carousel.getPaginationAltText).to eq("Page 1 of 7")

      text = getTextForElement(:css, SMART_GOAL_CAROUSEL::CAROUSEL_BODY)
      expect(text.include?("SMART Goals are realistic goals you can reach.")).to eq(true)
      expect(text.include?("Small changes can have a big impact.")).to eq(true)
      expect(text.include?("Set goals in small steps that you can manage.")).to eq(true)
      expect(text.include?("For success, create Goals that keep you motivated.")).to eq(true)
    end
  end

  context "#AC-JRNL-1948, #AC JRNL-1947 #AC JRNL-1946, #JRNL-1945, #JRNL-1944 SMART GOAL Screen validation" do
    it ".Learn More about SMART Goals; Sub-header: body text; bottom section question" do
      main_heading = "Learn More about SMART Goals"
      sub_heading = "Specific Goals"
      paginationAltText = "Page 2 of 7"
      h5_subHeading = "Specific"
      bodyText = ["A Goal is Specific if it:", "Describes a certain action or behavior", "Is clear and to the point" ]
      questionLabel = "Which goal is most Specific?"
      radioOptionLabels = ["I will eat more fruits.", "I will jog three times a week for 30 minutes.", "I will cut down on cigarettes."]
      correctAnswer = 2
      ac_num = "JRNL-1948"
      incorrectAnswer = [1, 3]
      screen2 = [main_heading, sub_heading, paginationAltText, h5_subHeading, bodyText, questionLabel, radioOptionLabels, correctAnswer, ac_num, incorrectAnswer]

      sub_heading = "Measurable Goals"
      paginationAltText = "Page 3 of 7"
      h5_subHeading = "Measurable"
      bodyText = ["A Goal is Measurable if it:", "Can say it was reached or not", "Can measure progress toward achieving it" ]
      questionLabel = "Which goal is most Measurable?"
      radioOptionLabels = ["I will smoke fewer cigarettes.", "I will try to exercise more.", "I will eat 2 serving of vegetables a day."]
      correctAnswer = 3
      ac_num = "JRNL-1947"
      incorrectAnswer = [2, 1]
      screen3 = [main_heading, sub_heading, paginationAltText, h5_subHeading, bodyText, questionLabel, radioOptionLabels, correctAnswer, ac_num, incorrectAnswer]

      sub_heading = "Attainable Goals"
      paginationAltText = "Page 4 of 7"
      h5_subHeading = "Action-Oriented"
      bodyText = ["A Goal is Action-Oriented if it:", "It is something you will do", "It is a behavior, task, or activity" ]
      questionLabel = "Which goal is most Action-Oriented?"
      radioOptionLabels = ["I will think about cutting down on coffee.", "I will take the stairs to the twentieth floor at work.", "I want to lose 15 pounds."]
      correctAnswer = 3
      ac_num = "JRNL-1946"
      incorrectAnswer = [2, 1]
      screen4 = [main_heading, sub_heading, paginationAltText, h5_subHeading, bodyText, questionLabel, radioOptionLabels, correctAnswer, ac_num, incorrectAnswer]

      sub_heading = "Realistic Goals"
      paginationAltText = "Page 5 of 7"
      h5_subHeading = "Realistic"
      bodyText = ["Goal is Realistic if it:", "You want to do it", "You can do it" ]
      questionLabel = "Which goal is most Realistic?"
      radioOptionLabels = ["I will never eat anything unhealthy.", "I will be able to run a marathon in a month.", "I will quit smoking with my nicotine patches and the telephone quit line."]
      correctAnswer = 3
      ac_num = "JRNL-1945"
      incorrectAnswer = [1, 2]
      screen5 = [main_heading, sub_heading, paginationAltText, h5_subHeading, bodyText, questionLabel, radioOptionLabels, correctAnswer, ac_num, incorrectAnswer]

      sub_heading = "Time-Specific Goals"
      paginationAltText = "Page 6 of 7"
      h5_subHeading = "Time-Specific"
      bodyText = ["A Goal is Time-Specific if it:", "Sets a time for it to be done", "Says how often it will be done" ]
      questionLabel = "Which goal is most Time-Specific?"
      radioOptionLabels = ["I will eat three apples per week for a month.", "I will begin to drink more water during the day.", "I will exercise more often."]
      correctAnswer = 1
      ac_num = "JRNL-1944"
      incorrectAnswer = [2, 3]
      screen6 = [main_heading, sub_heading, paginationAltText, h5_subHeading, bodyText, questionLabel, radioOptionLabels, correctAnswer, ac_num, incorrectAnswer]

      all_screen = [screen2, screen3, screen4, screen5, screen6]

      waitForPageToFinishLoading
      for i in 0..4
        main_heading = all_screen[i][0]
        sub_heading = all_screen[i][1]
        paginationAltText = all_screen[i][2]
        h5_subHeading = all_screen[i][3]
        bodyText = all_screen[i][4]
        questionLabel = all_screen[i][5]
        radioOptionLabels = all_screen[i][6]
        correctAnswer = all_screen[i][7]
        ac_num = all_screen[i][8]

        incorrectAnswer1 = all_screen[i][9][0]
        incorrectAnswer2 = all_screen[i][9][1]

        puts "     #AC " + ac_num + " " + sub_heading
        click(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)
        !5.times{ break if (@carousel.getSubHeading == sub_heading); sleep 1 }
        expect(@carousel.getSubHeading).to eq(sub_heading)
        expect(@carousel.getCarouselHeading).to eq(main_heading)
        expect(@carousel.getPaginationAltText).to eq(paginationAltText)

        expect(@carousel.getH5SubHeading).to eq(h5_subHeading)
        text = getTextForElement(:css, SMART_GOAL_CAROUSEL::CAROUSEL_BODY)
        expect(text.include?(bodyText[0])).to eq(true)
        expect(text.include?(bodyText[1])).to eq(true)
        expect(text.include?(bodyText[2])).to eq(true)

        expect(@carousel.getQuestionLabel).to eq(questionLabel)
        expect(@carousel.verifyRadioOptionsLabels(radioOptionLabels)).to eq(true)

        puts "   #AC JRNL-1943: User answers questions - correct/incorrect"
        puts "     .if user chose an incorrect answer"

        @carousel.clickNthRadioButton(incorrectAnswer1)
        !5.times{ break if (isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_MSG)); sleep 1 }
        expect(isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_MSG)).to eq(true)
        expect(@carousel.getAlertMessage).to eq("That is not the SMARTest answer. Try again.")
        expect(getFocusedElementText()).to eq("That is not the SMARTest answer. Try again.")
        expect(@carousel.isNthIncorrectIconPresent(incorrectAnswer1)).to eq(true)
        expect(@carousel.getNthIconAltText(incorrectAnswer1)).to eq("Incorrect choice")
        expect(isThisElementDisabled(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)).to eq(true)

        @carousel.clickNthRadioButton(incorrectAnswer2)
        !5.times{ break if (isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_MSG)); sleep 1 }
        expect(isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_MSG)).to eq(true)
        expect(@carousel.getAlertMessage).to eq("That is not the SMARTest answer. Try again.")
        expect(getFocusedElementText()).to eq("That is not the SMARTest answer. Try again.")
        expect(@carousel.isNthIncorrectIconPresent(incorrectAnswer1)).to eq(false)
        expect(@carousel.isNthIncorrectIconPresent(incorrectAnswer2)).to eq(true)

        expect(@carousel.getNthIconAltText(incorrectAnswer2)).to eq("Incorrect choice")
        expect(isThisElementDisabled(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)).to eq(true)

        puts "     .if user chose a correct answer"
        @carousel.clickNthRadioButton(correctAnswer)
        !5.times{ break if (isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_SUCCESS_MSG)); sleep 1 }
        expect(isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_SUCCESS_MSG)).to eq(true)
        expect(@carousel.isNthCorrectIconPresent(correctAnswer)).to eq(true)
        expect(@carousel.isNthIncorrectIconPresent(incorrectAnswer2)).to eq(false)
        expect(@carousel.getNthIconAltText(correctAnswer)).to eq("Correct choice")
        expect(getFocusedElementText).to eq("Correct, you chose the best answer.")
        expect(getTextForElement(:css, SMART_GOAL_CAROUSEL::ALERT_SUCCESS_MSG)).to eq("Correct, you chose the best answer.")
        expect(isThisElementDisabled(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)).to eq(false)

        expect(@carousel.isNthRadioButtonDisabled(incorrectAnswer1)).to eq(true)
        expect(@carousel.isNthRadioButtonDisabled(incorrectAnswer2)).to eq(true)
      end
    end
  end

  context "#AC JRNL-1941 : Screen 7 - Congratulations" do

    it ".When the user answers the last question correctly (all questions must be answered in order), the system displays a congratulatory message on the last screen of the carousel: " do
      waitForPageToFinishLoading
      click(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)
      !5.times{ break if (@carousel.getSubHeading == "Congratulations"); sleep 1 }
      expect(@carousel.getSubHeading).to eq("Congratulations")
      expect(@carousel.getCarouselHeading).to eq("Learn More about SMART Goals")
      expect(@carousel.getPaginationAltText).to eq("Page 7 of 7")

      text = getTextForElement(:css, SMART_GOAL_CAROUSEL::CAROUSEL_BODY)
      expect(text.include?("Well done. By learning about SMART goals, you have taken an important step toward reaching what you desire.")).to eq(true)

      click(:css, SMART_GOAL_CAROUSEL::CAROUSEL_CLOSE_BUTTON)
      !5.times{ break if (isElementDisappeared(:css, SMART_GOAL_CAROUSEL::CAROUSEL_HEADING)); sleep 1 }
      expect(isElementDisappeared(:css, SMART_GOAL_CAROUSEL::CAROUSEL_HEADING)).to eq(true)
    end
  end

  context "#AC JRNL-1794: Learn More Carousel behavior " do

    it ".When a user opens a carousel control, the system displays the first page of the carousel page series with focus on the Page Header and the following screen components are displayed:" do
      waitForPageToFinishLoading
      click(:css, MyStory_Goal::SMART_GOAL)
      !5.times{ break if (@carousel.getCarouselHeading == "Learn More about SMART Goals"); sleep 1 }
      expect(@carousel.getCarouselHeading).to eq("Learn More about SMART Goals")
      expect(@carousel.getPaginationAltText).to eq("Page 1 of 7")
      expect(getFocusedElementText()).to eq("Learn More about SMART Goals")

      click(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)
      !5.times{ break if (@carousel.getSubHeading == "Specific Goals"); sleep 1 }
      expect(@carousel.getSubHeading).to eq("Specific Goals")

      #alt text for Left Arrow button
      expect(getTextForElement(:css, SMART_GOAL_CAROUSEL::CAROUSEL_LEFT_ARROW)).to eq("Previous Screen")
      expect(getTextForElement(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)).to eq("Next Screen")

      click(:css, SMART_GOAL_CAROUSEL::CAROUSEL_CLOSE_BUTTON)
      !5.times{ break if (isElementDisappeared(:css, SMART_GOAL_CAROUSEL::CAROUSEL_HEADING)); sleep 1 }
      expect(isElementDisappeared(:css, SMART_GOAL_CAROUSEL::CAROUSEL_HEADING)).to eq(true)
    end
  end
end



































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2464:  Create Learn More About SMART Goals]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("goals", "healthinventorydb")
    removeCollection("promptedresponses", "healthinventorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory
    !45.times{ break if (getSecondaryHeader == "My Story"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Story")

    @my_story.clickGoals
    !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
    expect(getPrimaryHeader).to eq("Goals")
    expect(@goal.isAddButtonVisible()).to eq(true)

    @goal.clickAddButton
    !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")
    !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(@goal.getGoalReflectionText).to eq("Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals.")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1951: Learn More Link On Goals" do

    it ".When a user views the Add or Edit Goal Detail screen, the system provides a link to a tutorial on SMART goals labeled Learn more about SMART Goals." do
      waitForPageToFinishLoading
      expect(isElementPresentAndVisible(:css, MyStory_Goal::SMART_GOAL)).to eq(true)
      expect(isElementPresentAndVisible(:css, MyStory_Goal::GRADUATION_CAP)).to eq(true)
      expect(getTextForElement(:css, MyStory_Goal::SMART_GOAL)).to eq("Learn more about SMART Goals")
      expect(@goal.getGraduationCapAltText).to eq("Graduation cap (icon)")
    end

  end

  context "#AC JRNL-1950: Screen 1 - Tutorial" do

    it ".When the user selects the Learn More link, the system displays the tutorial in a modal window using a Carousel control" do
      waitForPageToFinishLoading
      click(:css, MyStory_Goal::SMART_GOAL)
      !45.times{ break if (@carousel.getCarouselHeading == "Learn More about SMART Goals"); sleep 1 }
      expect(@carousel.getCarouselHeading).to eq("Learn More about SMART Goals")
      expect(@carousel.getSubHeading).to eq("Smart Goals")
      expect(@carousel.getPaginationAltText).to eq("Page 1 of 7")

      text = getTextForElement(:css, SMART_GOAL_CAROUSEL::CAROUSEL_BODY)
      expect(text.include?("SMART Goals are realistic goals you can reach.")).to eq(true)
      expect(text.include?("Small changes can have a big impact.")).to eq(true)
      expect(text.include?("Set goals in small steps that you can manage.")).to eq(true)
      expect(text.include?("For success, create Goals that keep you motivated.")).to eq(true)
    end

  end

  context "#AC-JRNL-1948, #AC JRNL-1947 #AC JRNL-1946, #JRNL-1945, #JRNL-1944 SMART GOAL Screen validation" do

    it ".Learn More about SMART Goals; Sub-header: body text; bottom section question" do
      main_heading = "Learn More about SMART Goals"
      sub_heading = "Specific Goals"
      paginationAltText = "Page 2 of 7"
      h5_subHeading = "Specific"
      bodyText = ["A Goal is Specific if it:", "Describes a certain action or behavior", "Is clear and to the point" ]
      questionLabel = "Which goal is most Specific?"
      radioOptionLabels = ["I will eat more fruits.", "I will jog three times a week for 30 minutes.", "I will cut down on cigarettes."]
      correctAnswer = 2
      ac_num = "JRNL-1948"
      incorrectAnswer = [1, 3]
      screen2 = [main_heading, sub_heading, paginationAltText, h5_subHeading, bodyText, questionLabel, radioOptionLabels, correctAnswer, ac_num, incorrectAnswer]

      sub_heading = "Measurable Goals"
      paginationAltText = "Page 3 of 7"
      h5_subHeading = "Measurable"
      bodyText = ["A Goal is Measurable if it:", "Can say it was reached or not", "Can measure progress toward achieving it" ]
      questionLabel = "Which goal is most Measurable?"
      radioOptionLabels = ["I will smoke fewer cigarettes.", "I will try to exercise more.", "I will eat 2 serving of vegetables a day."]
      correctAnswer = 3
      ac_num = "JRNL-1947"
      incorrectAnswer = [2, 1]
      screen3 = [main_heading, sub_heading, paginationAltText, h5_subHeading, bodyText, questionLabel, radioOptionLabels, correctAnswer, ac_num, incorrectAnswer]

      sub_heading = "Attainable Goals"
      paginationAltText = "Page 4 of 7"
      h5_subHeading = "Action-Oriented"
      bodyText = ["A Goal is Action-Oriented if it:", "It is something you will do", "It is a behavior, task, or activity" ]
      questionLabel = "Which goal is most Action-Oriented?"
      radioOptionLabels = ["I will think about cutting down on coffee.", "I will take the stairs to the twentieth floor at work.", "I want to lose 15 pounds."]
      correctAnswer = 3
      ac_num = "JRNL-1946"
      incorrectAnswer = [2, 1]
      screen4 = [main_heading, sub_heading, paginationAltText, h5_subHeading, bodyText, questionLabel, radioOptionLabels, correctAnswer, ac_num, incorrectAnswer]

      sub_heading = "Realistic Goals"
      paginationAltText = "Page 5 of 7"
      h5_subHeading = "Realistic"
      bodyText = ["Goal is Realistic if it:", "You want to do it", "You can do it" ]
      questionLabel = "Which goal is most Realistic?"
      radioOptionLabels = ["I will never eat anything unhealthy.", "I will be able to run a marathon in a month.", "I will quit smoking with my nicotine patches and the telephone quit line."]
      correctAnswer = 3
      ac_num = "JRNL-1945"
      incorrectAnswer = [1, 2]
      screen5 = [main_heading, sub_heading, paginationAltText, h5_subHeading, bodyText, questionLabel, radioOptionLabels, correctAnswer, ac_num, incorrectAnswer]

      sub_heading = "Time-Specific Goals"
      paginationAltText = "Page 6 of 7"
      h5_subHeading = "Time-Specific"
      bodyText = ["A Goal is Time-Specific if it:", "Sets a time for it to be done", "Says how often it will be done" ]
      questionLabel = "Which goal is most Time-Specific?"
      radioOptionLabels = ["I will eat three apples per week for a month.", "I will begin to drink more water during the day.", "I will exercise more often."]
      correctAnswer = 1
      ac_num = "JRNL-1944"
      incorrectAnswer = [2, 3]
      screen6 = [main_heading, sub_heading, paginationAltText, h5_subHeading, bodyText, questionLabel, radioOptionLabels, correctAnswer, ac_num, incorrectAnswer]

      all_screen = [screen2, screen3, screen4, screen5, screen6]

      waitForPageToFinishLoading
      for i in 0..4
        main_heading = all_screen[i][0]
        sub_heading = all_screen[i][1]
        paginationAltText = all_screen[i][2]
        h5_subHeading = all_screen[i][3]
        bodyText = all_screen[i][4]
        questionLabel = all_screen[i][5]
        radioOptionLabels = all_screen[i][6]
        correctAnswer = all_screen[i][7]
        ac_num = all_screen[i][8]

        incorrectAnswer1 = all_screen[i][9][0]
        incorrectAnswer2 = all_screen[i][9][1]

        puts "     #AC " + ac_num + " " + sub_heading
        click(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)
        !45.times{ break if (@carousel.getSubHeading == sub_heading); sleep 1 }
        expect(@carousel.getSubHeading).to eq(sub_heading)
        expect(@carousel.getCarouselHeading).to eq(main_heading)
        expect(@carousel.getPaginationAltText).to eq(paginationAltText)

        expect(@carousel.getH5SubHeading).to eq(h5_subHeading)
        text = getTextForElement(:css, SMART_GOAL_CAROUSEL::CAROUSEL_BODY)
        expect(text.include?(bodyText[0])).to eq(true)
        expect(text.include?(bodyText[1])).to eq(true)
        expect(text.include?(bodyText[2])).to eq(true)

        expect(@carousel.getQuestionLabel).to eq(questionLabel)
        expect(@carousel.verifyRadioOptionsLabels(radioOptionLabels)).to eq(true)

        puts "   #AC JRNL-1943: User answers questions - correct/incorrect"
        puts "     .if user chose an incorrect answer"

        @carousel.clickNthRadioButton(incorrectAnswer1)
        !45.times{ break if (isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_MSG)); sleep 1 }
        expect(isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_MSG)).to eq(true)
        expect(@carousel.getAlertMessage).to eq("That is not the SMARTest answer. Try again.")
        expect(getFocusedElementText()).to eq("That is not the SMARTest answer. Try again.")
        expect(@carousel.isNthIncorrectIconPresent(incorrectAnswer1)).to eq(true)
        expect(@carousel.getNthIconAltText(incorrectAnswer1)).to eq("Incorrect choice")
        expect(isThisElementDisabled(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)).to eq(true)

        @carousel.clickNthRadioButton(incorrectAnswer2)
        !45.times{ break if (isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_MSG)); sleep 1 }
        expect(isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_MSG)).to eq(true)
        expect(@carousel.getAlertMessage).to eq("That is not the SMARTest answer. Try again.")
        expect(getFocusedElementText()).to eq("That is not the SMARTest answer. Try again.")
        expect(@carousel.isNthIncorrectIconPresent(incorrectAnswer1)).to eq(false)
        expect(@carousel.isNthIncorrectIconPresent(incorrectAnswer2)).to eq(true)

        expect(@carousel.getNthIconAltText(incorrectAnswer2)).to eq("Incorrect choice")
        expect(isThisElementDisabled(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)).to eq(true)

        puts "     .if user chose a correct answer"
        @carousel.clickNthRadioButton(correctAnswer)
        !45.times{ break if (isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_SUCCESS_MSG)); sleep 1 }
        expect(isElementPresentAndVisible(:css, SMART_GOAL_CAROUSEL::ALERT_SUCCESS_MSG)).to eq(true)
        expect(@carousel.isNthCorrectIconPresent(correctAnswer)).to eq(true)
        expect(@carousel.isNthIncorrectIconPresent(incorrectAnswer2)).to eq(false)
        expect(@carousel.getNthIconAltText(correctAnswer)).to eq("Correct choice")
        expect(getFocusedElementText).to eq("Correct, you chose the best answer.")
        expect(getTextForElement(:css, SMART_GOAL_CAROUSEL::ALERT_SUCCESS_MSG)).to eq("Correct, you chose the best answer.")
        expect(isThisElementDisabled(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)).to eq(false)

        expect(@carousel.isNthRadioButtonDisabled(incorrectAnswer1)).to eq(true)
        expect(@carousel.isNthRadioButtonDisabled(incorrectAnswer2)).to eq(true)
      end

    end

  end

  context "#AC JRNL-1941 : Screen 7 - Congratulations" do

    it ".When the user answers the last question correctly (all questions must be answered in order), the system displays a congratulatory message on the last screen of the carousel: " do
      waitForPageToFinishLoading
      click(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)
      !45.times{ break if (@carousel.getSubHeading == "Congratulations"); sleep 1 }
      expect(@carousel.getSubHeading).to eq("Congratulations")
      expect(@carousel.getCarouselHeading).to eq("Learn More about SMART Goals")
      expect(@carousel.getPaginationAltText).to eq("Page 7 of 7")

      text = getTextForElement(:css, SMART_GOAL_CAROUSEL::CAROUSEL_BODY)
      expect(text.include?("Well done. By learning about SMART goals, you have taken an important step toward reaching what you desire.")).to eq(true)

      click(:css, SMART_GOAL_CAROUSEL::CAROUSEL_CLOSE_BUTTON)
      !45.times{ break if (isElementDisappeared(:css, SMART_GOAL_CAROUSEL::CAROUSEL_HEADING)); sleep 1 }
      expect(isElementDisappeared(:css, SMART_GOAL_CAROUSEL::CAROUSEL_HEADING)).to eq(true)
    end

  end

  context "#AC JRNL-1794: Learn More Carousel behavior " do

    it ".When a user opens a carousel control, the system displays the first page of the carousel page series with focus on the Page Header and the following screen components are displayed:" do
      waitForPageToFinishLoading
      click(:css, MyStory_Goal::SMART_GOAL)
      !45.times{ break if (@carousel.getCarouselHeading == "Learn More about SMART Goals"); sleep 1 }
      expect(@carousel.getCarouselHeading).to eq("Learn More about SMART Goals")
      expect(@carousel.getPaginationAltText).to eq("Page 1 of 7")
      expect(getFocusedElementText()).to eq("Learn More about SMART Goals")

      click(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)
      !45.times{ break if (@carousel.getSubHeading == "Specific Goals"); sleep 1 }
      expect(@carousel.getSubHeading).to eq("Specific Goals")

      #alt text for Left Arrow button
      expect(getTextForElement(:css, SMART_GOAL_CAROUSEL::CAROUSEL_LEFT_ARROW)).to eq("Previous Screen")
      expect(getTextForElement(:css, SMART_GOAL_CAROUSEL::CAROUSEL_RIGHT_ARROW)).to eq("Next Screen")

      click(:css, SMART_GOAL_CAROUSEL::CAROUSEL_CLOSE_BUTTON)
      !45.times{ break if (isElementDisappeared(:css, SMART_GOAL_CAROUSEL::CAROUSEL_HEADING)); sleep 1 }
      expect(isElementDisappeared(:css, SMART_GOAL_CAROUSEL::CAROUSEL_HEADING)).to eq(true)
    end
  end
end
=end