#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2523: My Story Learn content - Story #JRNL-2458: The My Story Tool]", :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    expect(@nav_menu.isMyStoryButtonVisible).to eq(true)
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyStory']").click
    waitForPageToFinishLoading
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  # after(:all) do
  #   quitDriver()
  # end

  it "AC #JRNL-3113|TC #JRNL-2755:  Under the label text 'Table of Contents' the user can access section anchors from a table of contents that is listed in the upper-left hand portion of the learn section" do
    @my_story.clickLearn()
    !5.times{ break if (@learn.getTableOfContentsLabel == "Table of Contents"); sleep 1 }
    expect(@learn.getTableOfContentsLabel).to eq("Table of Contents")
    expect(@learn.isTableOfContentsLinkVisible("Introduction")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Me")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Mindful Awareness")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("The Eight Areas of Self Care")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Working the Body")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Surroundings")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Personal Development")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Food and Drink")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Recharge")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Family, Friends, and Co-Workers")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Spirit and Soul")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Power of the Mind")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Professional Care")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Community")).to eq(true)
  end

  it "AC #JRNL-3122|TC #JRNL-2755:  When a user selects one of the anchors, they are taken to that portion of the learn content" do
    @learn.clickTableOfContents("The My Story Tool")
    !5.times{ break if (@learn.isContentDisplayedOnPage("The My Story Tool") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("The My Story Tool")).to eq(true)

    @learn.clickTableOfContents("Introduction")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Introduction") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Introduction")).to eq(true)

    @learn.clickTableOfContents("Me")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Me") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Me")).to eq(true)

    @learn.clickTableOfContents("Mindful Awareness")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Mindful Awareness") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Mindful Awareness")).to eq(true)

    @learn.clickTableOfContents("The Eight Areas of Self Care")
    !5.times{ break if (@learn.isContentDisplayedOnPage("The Eight Areas of Self Care") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("The Eight Areas of Self Care")).to eq(true)

    @learn.clickTableOfContents("Working the Body")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Working the Body") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Working the Body")).to eq(true)

    @learn.clickTableOfContents("Surroundings")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Surroundings") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Surroundings")).to eq(true)

    @learn.clickTableOfContents("Personal Development")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Personal Development") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Personal Development")).to eq(true)

    @learn.clickTableOfContents("Food and Drink")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Food and Drink") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Food and Drink")).to eq(true)

    @learn.clickTableOfContents("Recharge")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Recharge") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Recharge")).to eq(true)

    @learn.clickTableOfContents("Family, Friends, and Co-Workers")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Family, Friends, and Co-Workers") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Family, Friends, and Co-Workers")).to eq(true)

    @learn.clickTableOfContents("Spirit and Soul")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Spirit and Soul") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Spirit and Soul")).to eq(true)

    @learn.clickTableOfContents("Power of the Mind")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Power of the Mind") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Power of the Mind")).to eq(true)

    @learn.clickTableOfContents("Professional Care")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Professional Care") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Professional Care")).to eq(true)

    @learn.clickTableOfContents("Community")
    !5.times{ break if (@learn.isContentDisplayedOnPage("Community") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Community")).to eq(true)
  end

  it "AC #JRNL-3131|TC #JRNL-2755: User can review the 'Introduction' sub-sections of the PHI information from the attached PDF (label text 'Introduction') ", :broken => true do
   expect(@learn.getLearnHeadingText("Introduction")).to eq("Introduction")
   expect(@learn.getNthSubHeadingTextForIntroduction(1)).to eq("Whole Health And You As A Whole Person")
   expect(@learn.getNthSubHeadingTextForIntroduction(2)).to eq("The Components Of Proactive Health And Well-being")
   expect(@learn.getNthSubHeadingTextForIntroduction(3)).to eq("Discovering Why You Want Your Health And Developing Your Personal Health Goals")

   expect(@learn.isGraphOfComponentsOfProactiveHealthVisible).to eq(true)
   expect(@learn.getAltTextForGraphOfComponentsOfProactiveHealth).to eq("Graphic of The Components of Proactive Health and Well-being")
   expect(@learn.isGraphOfComponentsOfProactiveHealthMobileLinkVisible).to eq(false)

   expect(@learn.isGraphOfEquationForWholeHealthVisible).to eq(true)
   expect(@learn.getAltTextForGraphOfEquationForWholeHealth).to eq("Graphic of The Equation for Whole Health")
   expect(@learn.isGraphOfEquationForWholeHealthMobileLinkVisible).to eq(false)
   windowSize = getWindowSize()

   resizeWindowTo(400, 727)
   expect(@learn.isGraphOfComponentsOfProactiveHealthVisible).to eq(false)
   expect(@learn.isGraphOfComponentsOfProactiveHealthMobileLinkVisible).to eq(true)
   expect(@learn.isGraphOfEquationForWholeHealthVisible).to eq(false)
   expect(@learn.isGraphOfEquationForWholeHealthMobileLinkVisible).to eq(true)

   @learn.clickGraphOfComponentsOfProactiveHealthMobileLink
   switchWindowToWindowHandleLast()

   !5.times{ break if (getPageTitle.include?("The_Components_of_Proactive_Health_and_Well-being.pdf") == true); sleep 1 }
   expect(getPageTitle.include?("The_Components_of_Proactive_Health_and_Well-being.pdf")).to eq(true)

   closeBrowser()
   switchWindowToWindowHandleFirst()

   @learn.clickGraphOfEquationForWholeHealthMobileLink
   switchWindowToWindowHandleLast()

   !5.times{ break if (getPageTitle.include?("The_Equation_for_Whole_Health.pdf") == true); sleep 1 }
   expect(getPageTitle.include?("The_Equation_for_Whole_Health.pdf")).to eq(true)

   closeBrowser()
   switchWindowToWindowHandleFirst()

   expect(@learn.isAllBackToLinkVisibleAndClickable).to eq(true)
   @learn.clickNthBackToTopLink(2)
   expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)

   resizeWindowTo(windowSize.width, windowSize.height)
  end

  it "AC #JRNL-3140|TC #JRNL-2755: User can review the 'Me' information from the attached PDF under the Me section (label text 'Me') ", :broken => true do
    expect(@learn.getLearnHeadingText("Me")).to eq("Me")
    @learn.clickNthBackToTopLink(3)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)
  end

  it "AC #JRNL-3151|TC #JRNL-2755: User can review the 'Mindful Awareness' information from the attached PDF under the Mindful Awareness section (label text 'Mindful Awareness')", :broken => true do
    expect(@learn.getLearnHeadingText("Mindful Awareness")).to eq("Mindful Awareness")
    @learn.clickNthBackToTopLink(4)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)
  end

  it "AC #JRNL-3162|TC #JRNL-2755:  User can review the 'Eight Areas of Self Care' information under the Eight Areas of Self Care section (label text 'The Eight Areas of Self Care') in the attached PDF", :broken => true do
    expect(@learn.getLearnHeadingText("The Eight Areas of Self Care")).to eq("The Eight Areas Of Self Care")
    expect(@learn.getLearnHeadingText("Working Your Body")).to eq('Working Your Body "Energy and Flexibility"')
    expect(@learn.getLearnHeadingText("Surroundings")).to eq('Surroundings "Physical and Emotional"')
    expect(@learn.getLearnHeadingText("Personal Development")).to eq('Personal Development "Personal Life and Work Life"')
    expect(@learn.getLearnHeadingText("Food and Drink")).to eq('Food and Drink "Nourishing and Fueling"')
    expect(@learn.getLearnHeadingText("Recharge")).to eq('Recharge "Sleep and Refresh"')
    expect(@learn.getLearnHeadingText("Family, Friends, and Co-Workers")).to eq('Family, Friends, and Co-Workers "Relationships"')
    expect(@learn.getLearnHeadingText("Spirit and Soul")).to eq('Spirit and Soul "Growing and Connecting"')
    expect(@learn.getLearnHeadingText("Power of the Mind")).to eq('Power of the Mind "Strengthen and Listen"')
    @learn.clickNthBackToTopLink(5)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)
  end

  it "AC #JRNL-3164|TC #JRNL-2755:  User can review the 'Professional Care' information under the Professional Care section (label text 'Professional Care') in the attached PDF", :broken => true do
    expect(@learn.getLearnHeadingText("Professional Care")).to eq("Professional Care")
    @learn.clickNthBackToTopLink(6)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)
  end

  it "AC #JRNL-3165|TC #JRNL-2755: User can review the 'Community' information under the Community section (label text 'Community') in the attached PDF  ", :broken => true do
    expect(@learn.getLearnHeadingText("Community")).to eq("Community")
    @learn.clickNthBackToTopLink(7)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)
  end

  it "AC#JRNL-1927|TC #JRNL-2755:  The My Story Tool", :broken => true do
    expect(@learn.isTableOfContentsLinkVisible("The My Story Tool")).to eq(true)
    expect(@learn.getFirstTOCLink).to eq("The My Story Tool")
    expect(@learn.getFirstContentHeader).to eq("The My Story Tool")
    myStoryToolContent = "The My Story tool asks you to think about what really matters most to you in life. Knowing your life and health goals is important to your health care team. It is the first step in creating a plan that fits you. The tool asks you questions about your life including exercise, rest, diet, relationships, surroundings, spirituality, and personal development. It gives you a chance to consider where you are now in your life and where you’d like to be. Whether you want to be healthy enough to play with your children, travel, or run a marathon, the My Story tool helps you identify changes you want to make. You can talk with your health care team about achieving these goals."
    expect(@learn.getMyStoryToolContent).to eq(myStoryToolContent)
    @learn.clickNthBackToTopLink(1)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)
  end
end





































































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2523: My Story Learn content - Story #JRNL-2458: The My Story Tool]", :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isMyStoryButtonVisible).to eq(true)

    @nav_menu.clickMyStory

    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

  end

  after(:all) do
    quitDriver()
  end


  it "AC #JRNL-3113|TC #JRNL-2755:  Under the label text 'Table of Contents' the user can access section anchors from a table of contents that is listed in the upper-left hand portion of the learn section" do
    @my_story.clickLearn()
    !45.times{ break if (@learn.getTableOfContentsLabel == "Table of Contents"); sleep 1 }
    expect(@learn.getTableOfContentsLabel).to eq("Table of Contents")

    expect(@learn.isTableOfContentsLinkVisible("Introduction")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Me")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Mindful Awareness")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("The Eight Areas of Self Care")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Working the Body")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Surroundings")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Personal Development")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Food and Drink")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Recharge")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Family, Friends, and Co-Workers")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Spirit and Soul")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Power of the Mind")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Professional Care")).to eq(true)
    expect(@learn.isTableOfContentsLinkVisible("Community")).to eq(true)

  end

  it "AC #JRNL-3122|TC #JRNL-2755:  When a user selects one of the anchors, they are taken to that portion of the learn content" do
    @learn.clickTableOfContents("The My Story Tool")
    !45.times{ break if (@learn.isContentDisplayedOnPage("The My Story Tool") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("The My Story Tool")).to eq(true)

    @learn.clickTableOfContents("Introduction")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Introduction") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Introduction")).to eq(true)

    @learn.clickTableOfContents("Me")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Me") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Me")).to eq(true)

    @learn.clickTableOfContents("Mindful Awareness")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Mindful Awareness") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Mindful Awareness")).to eq(true)

    @learn.clickTableOfContents("The Eight Areas of Self Care")
    !45.times{ break if (@learn.isContentDisplayedOnPage("The Eight Areas of Self Care") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("The Eight Areas of Self Care")).to eq(true)

    @learn.clickTableOfContents("Working the Body")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Working the Body") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Working the Body")).to eq(true)

    @learn.clickTableOfContents("Surroundings")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Surroundings") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Surroundings")).to eq(true)

    @learn.clickTableOfContents("Personal Development")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Personal Development") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Personal Development")).to eq(true)

    @learn.clickTableOfContents("Food and Drink")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Food and Drink") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Food and Drink")).to eq(true)

    @learn.clickTableOfContents("Recharge")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Recharge") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Recharge")).to eq(true)

    @learn.clickTableOfContents("Family, Friends, and Co-Workers")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Family, Friends, and Co-Workers") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Family, Friends, and Co-Workers")).to eq(true)

    @learn.clickTableOfContents("Spirit and Soul")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Spirit and Soul") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Spirit and Soul")).to eq(true)

    @learn.clickTableOfContents("Power of the Mind")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Power of the Mind") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Power of the Mind")).to eq(true)

    @learn.clickTableOfContents("Professional Care")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Professional Care") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Professional Care")).to eq(true)

    @learn.clickTableOfContents("Community")
    !45.times{ break if (@learn.isContentDisplayedOnPage("Community") == true); sleep 1 }
    expect(@learn.isContentDisplayedOnPage("Community")).to eq(true)

  end

  it "AC #JRNL-3131|TC #JRNL-2755: User can review the 'Introduction' sub-sections of the PHI information from the attached PDF (label text 'Introduction') ", :broken => true do
   expect(@learn.getLearnHeadingText("Introduction")).to eq("Introduction")
   expect(@learn.getNthSubHeadingTextForIntroduction(1)).to eq("Whole Health And You As A Whole Person")
   expect(@learn.getNthSubHeadingTextForIntroduction(2)).to eq("The Components Of Proactive Health And Well-being")
   expect(@learn.getNthSubHeadingTextForIntroduction(3)).to eq("Discovering Why You Want Your Health And Developing Your Personal Health Goals")

   expect(@learn.isGraphOfComponentsOfProactiveHealthVisible).to eq(true)
   expect(@learn.getAltTextForGraphOfComponentsOfProactiveHealth).to eq("Graphic of The Components of Proactive Health and Well-being")
   expect(@learn.isGraphOfComponentsOfProactiveHealthMobileLinkVisible).to eq(false)

   expect(@learn.isGraphOfEquationForWholeHealthVisible).to eq(true)
   expect(@learn.getAltTextForGraphOfEquationForWholeHealth).to eq("Graphic of The Equation for Whole Health")
   expect(@learn.isGraphOfEquationForWholeHealthMobileLinkVisible).to eq(false)
   windowSize = getWindowSize()

   resizeWindowTo(400, 727)
   expect(@learn.isGraphOfComponentsOfProactiveHealthVisible).to eq(false)
   expect(@learn.isGraphOfComponentsOfProactiveHealthMobileLinkVisible).to eq(true)
   expect(@learn.isGraphOfEquationForWholeHealthVisible).to eq(false)
   expect(@learn.isGraphOfEquationForWholeHealthMobileLinkVisible).to eq(true)

   @learn.clickGraphOfComponentsOfProactiveHealthMobileLink
   switchWindowToWindowHandleLast()

   !45.times{ break if (getPageTitle.include?("The_Components_of_Proactive_Health_and_Well-being.pdf") == true); sleep 1 }
   expect(getPageTitle.include?("The_Components_of_Proactive_Health_and_Well-being.pdf")).to eq(true)

   closeBrowser()
   switchWindowToWindowHandleFirst()

   @learn.clickGraphOfEquationForWholeHealthMobileLink
   switchWindowToWindowHandleLast()

   !45.times{ break if (getPageTitle.include?("The_Equation_for_Whole_Health.pdf") == true); sleep 1 }
   expect(getPageTitle.include?("The_Equation_for_Whole_Health.pdf")).to eq(true)

   closeBrowser()
   switchWindowToWindowHandleFirst()

   expect(@learn.isAllBackToLinkVisibleAndClickable).to eq(true)
   @learn.clickNthBackToTopLink(2)
   expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)

   resizeWindowTo(windowSize.width, windowSize.height)

  end

  it "AC #JRNL-3140|TC #JRNL-2755: User can review the 'Me' information from the attached PDF under the Me section (label text 'Me') ", :broken => true do
    expect(@learn.getLearnHeadingText("Me")).to eq("Me")

    @learn.clickNthBackToTopLink(3)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)
  end

  it "AC #JRNL-3151|TC #JRNL-2755: User can review the 'Mindful Awareness' information from the attached PDF under the Mindful Awareness section (label text 'Mindful Awareness')", :broken => true do
    expect(@learn.getLearnHeadingText("Mindful Awareness")).to eq("Mindful Awareness")

    @learn.clickNthBackToTopLink(4)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)
  end

  it "AC #JRNL-3162|TC #JRNL-2755:  User can review the 'Eight Areas of Self Care' information under the Eight Areas of Self Care section (label text 'The Eight Areas of Self Care') in the attached PDF", :broken => true do
    expect(@learn.getLearnHeadingText("The Eight Areas of Self Care")).to eq("The Eight Areas Of Self Care")
    expect(@learn.getLearnHeadingText("Working Your Body")).to eq('Working Your Body "Energy and Flexibility"')
    expect(@learn.getLearnHeadingText("Surroundings")).to eq('Surroundings "Physical and Emotional"')
    expect(@learn.getLearnHeadingText("Personal Development")).to eq('Personal Development "Personal Life and Work Life"')
    expect(@learn.getLearnHeadingText("Food and Drink")).to eq('Food and Drink "Nourishing and Fueling"')
    expect(@learn.getLearnHeadingText("Recharge")).to eq('Recharge "Sleep and Refresh"')
    expect(@learn.getLearnHeadingText("Family, Friends, and Co-Workers")).to eq('Family, Friends, and Co-Workers "Relationships"')
    expect(@learn.getLearnHeadingText("Spirit and Soul")).to eq('Spirit and Soul "Growing and Connecting"')
    expect(@learn.getLearnHeadingText("Power of the Mind")).to eq('Power of the Mind "Strengthen and Listen"')

    @learn.clickNthBackToTopLink(5)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)
  end

  it "AC #JRNL-3164|TC #JRNL-2755:  User can review the 'Professional Care' information under the Professional Care section (label text 'Professional Care') in the attached PDF", :broken => true do
    expect(@learn.getLearnHeadingText("Professional Care")).to eq("Professional Care")

    @learn.clickNthBackToTopLink(6)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)
  end

  it "AC #JRNL-3165|TC #JRNL-2755: User can review the 'Community' information under the Community section (label text 'Community') in the attached PDF  ", :broken => true do
    expect(@learn.getLearnHeadingText("Community")).to eq("Community")

    @learn.clickNthBackToTopLink(7)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)
  end

  it "AC#JRNL-1927|TC #JRNL-2755:  The My Story Tool", :broken => true do
    expect(@learn.isTableOfContentsLinkVisible("The My Story Tool")).to eq(true)
    expect(@learn.getFirstTOCLink).to eq("The My Story Tool")
    expect(@learn.getFirstContentHeader).to eq("The My Story Tool")
    myStoryToolContent = "The My Story tool asks you to think about what really matters most to you in life. Knowing your life and health goals is important to your health care team. It is the first step in creating a plan that fits you. The tool asks you questions about your life including exercise, rest, diet, relationships, surroundings, spirituality, and personal development. It gives you a chance to consider where you are now in your life and where you’d like to be. Whether you want to be healthy enough to play with your children, travel, or run a marathon, the My Story tool helps you identify changes you want to make. You can talk with your health care team about achieving these goals."
    expect(@learn.getMyStoryToolContent).to eq(myStoryToolContent)

    @learn.clickNthBackToTopLink(1)
    expect(@learn.isContentDisplayedOnPage("Table of Contents")).to eq(true)

  end

end
=end