require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2470:  Goals - Filter and Table list View]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("goals", "healthinventorydb", "goals")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory()
    !45.times{ break if (@my_story.getSecondaryHeader() == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader()).to eq("My Story")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC #JRNL-2803|TC #JRNL-2936:  Add Goals Sub-Feature to My Story" do

    it ".Goals option" do
      expect(@my_story.getNthMyStoryFeatureName(1)).to eq("Summary")
      expect(@my_story.getNthMyStoryFeatureName(2)).to eq("Personal Values")
      expect(@my_story.getNthMyStoryFeatureName(3)).to eq("Assessment")
      expect(@my_story.getNthMyStoryFeatureName(4)).to eq("Reflections")
      expect(@my_story.getNthMyStoryFeatureName(5)).to eq("Goals")
      expect(@my_story.getNthMyStoryFeatureName(6)).to eq("Learn")

      @my_story.clickGoals()
      !45.times{ break if (@my_story.getPrimaryHeader() == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")
    end

  end

  context "#AC #JRNL-2801|TC #JRNL-2936: Goals Filter" do

    it ".Filter Feature" do
      @my_story.clickGoals()
      !45.times{ break if (@my_story.getPrimaryHeader() == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")
      expect(@date_filter.isFilterAccordionExpanded()).to eq(true)
      expect(@date_filter.getFilterAccordionAltText()).to eq("Collapse filter options")

      @date_filter.clickFilterAccordion()
      expect(@date_filter.getFilterAccordionAltText).to eq("Expand filter options")
    end

    it ".Filter Options (all are optional unless otherwise noted)", :broken => true do
      @date_filter.clickFilterAccordion()
      expect(@date_filter.getStartDateLabel()).to eq("* From Date:")
      expect(@date_filter.getEndDateLabel()).to eq("* To Date:")

      expect(@date_filter.isStartDateRequiredField()).to eq(true)
      expect(@date_filter.isEndDateRequiredField()).to eq(true)
      expect(@date_filter.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")
      expect(@date_filter.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")

      #default date:  1 yar from today
      oneYearAgo = getDateNthYearsAgo(1,"%m/%d/%Y")
      oneYearFuture = getDateNthYeasFromNow(1, "%m/%d/%Y")
      expect(@date_filter.getStartDate()).to eq(oneYearAgo)
      expect(@date_filter.getEndDate()).to eq(oneYearFuture)

      #d.  Input behavior: Constrain fields to match format; prevent invalid month or day entry
      @date_filter.setFromDate("06/32/2014")
      expect(@date_filter.getStartDate()).to eq("06/30")

      @date_filter.setEndDate("07/33/2014")
      expect(@date_filter.getEndDate()).to eq("07/30")

      today = getDateNthDaysAgo(0, "%m/%d/%Y")
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      @date_filter.setFromDate(tomorrow)
      @date_filter.setEndDate(today)

      @date_filter.clickFilterBtn()
      expectedValidationSummaryHeader = "The following errors were found:"
      !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
      #todo:  ask Jennifer
      expect(@error.isErrorMessageDisplayed("filterForm", "From Date must occur before To Date.")).to eq(true)
    end

    it ".Status", :broken => true do
      expect(@date_filter.isStatusChecked("Active")).to eq(true)
      expect(@date_filter.getStatusLabel()).to eq("Status:")
      expect(@date_filter.getFilterButtonLabel()).to eq("Filter")
    end

    it ".Filtered list", :broken => true do
      @goal.selectStatus("Active")
      @date_filter.setDateRangeAndFilter("02/02/2013", "04/01/2013")
      !45.times{ break if (@my_story.getPrimaryHeader() == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")
      !45.times{ break if (@goal.getNoResultsFoundMessage() == "No results were found with the current filters. Use the Add button above to create a new record."); sleep 1 }
      expect(@goal.getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")

      @date_filter.setDateRangeAndFilter("10/10/2013", "10/10/2015")
      !45.times{ break if (@my_story.getPrimaryHeader() == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")
      expect(@goal.isDateWithinFilteredDateRange?()).to eq(true)
      expect(@goal.isSortedByChronologicalOrder()).to eq(true)

      @date_filter.setDateRangeAndFilter("10/10/2014", "10/10/2016")
      !45.times{ break if (@my_story.getPrimaryHeader() == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")
      expect(@goal.isDateWithinFilteredDateRange?()).to eq(true)
      expect(@goal.isSortedByChronologicalOrder()).to eq(true)

      @goal.selectStatus("Inactive")
      @date_filter.setDateRangeAndFilter("10/10/2014", "10/10/2016")
      !45.times{ break if (@my_story.getPrimaryHeader() == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")
      expect(@goal.isDateWithinFilteredDateRange?()).to eq(true)
      expect(@goal.isSortedByChronologicalOrder()).to eq(true)

      @goal.selectStatus("Complete")
      @date_filter.setDateRangeAndFilter("10/10/2014", "10/23/2014")
      !45.times{ break if (@my_story.getPrimaryHeader() == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")
      expect(@goal.isDateWithinFilteredDateRange?()).to eq(true)
      expect(@goal.isSortedByChronologicalOrder()).to eq(true)
    end

  end

  context "#AC JRNL-2802|TC #JRNL-2936:  Goals - Table List view" do

    it ".Table List View", :broken => true do
      @goal.selectStatus("Active")
      @date_filter.setDateRangeAndFilter("10/10/2014", "10/23/2016")
      !45.times{ break if (@my_story.getPrimaryHeader() == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")
      expect(@goal.getNthProgress(2)).to eq("Progress")
      expect(@goal.getNthProgress(3)).to eq("Progress")

      #Sort order is tested Filter List section

      #Table header
      headerArr =  @goal.getTableHeaders()
      expect(headerArr[0].to_s).to eq("Goal")
      expect(headerArr[1].to_s).to eq("Progress")
      expect(headerArr[2].to_s).to eq("Goal End Date")
      expect(headerArr[3].to_s).to eq("Steps")

      expect(@goal.getTableTextbyRowCol(1, 1)).to eq("Goal  \nGoal 14")
      expect(@goal.getTableTextbyRowCol(2, 1)).to eq("Goal  \nGoal 2015")
      expect(@goal.getTableTextbyRowCol(3, 1)).to eq("Goal  \nGoal - 9")
      expect(@goal.getTableTextbyRowCol(4, 1)).to eq("Goal  \nGoal 5")

      expect(@goal.getNthProgress(1)).to eq("Progress  \n15%")
      expect(@goal.getNthProgress(4)).to eq("Progress  \n17%")
      expect(isDateFormatValid?(@goal.getNthGoalEndDate(1), "%m/%d/%Y" )).to eq(true)
      expect(isDateFormatValid?(@goal.getNthGoalEndDate(2), "%m/%d/%Y" )).to eq(true)

      expect(@goal.getTableTextbyRowCol(1, 4)).to eq("Steps  \nNone")
      expect(@goal.getTableTextbyRowCol(2, 4)).to eq("Steps  \nNone")
      expect(@goal.getTableTextbyRowCol(3, 4)).to eq("Steps  \n0/1 Complete\nNext Due: 07/09/2015")
      expect(@goal.getTableTextbyRowCol(4, 4)).to eq("Steps  \n0/2 Complete\nNext Due: 10/30/2014")

      @goal.selectStatus("Inactive")
      @date_filter.setDateRangeAndFilter("10/10/2014", "10/23/2016")
      !45.times{ break if (@my_story.getPrimaryHeader == "Goals"); sleep 1 }

      headerArr =  @goal.getTableHeaders()
      expect(headerArr[0].to_s).to eq("Goal")
      expect(headerArr[1].to_s).to eq("Progress")
      expect(headerArr[2].to_s).to eq("Goal End Date")
      expect(headerArr[3].to_s).to eq("Steps")

      expect(@goal.getNthProgress(1)).to eq("Progress  \n64%")
      expect(@goal.getNthProgress(2)).to eq("Progress  \n14%")

      expect(@goal.getTableTextbyRowCol(1, 4)).to eq("Steps  \n2/3 Complete\nNext Due: 12/21/2014")
      expect(@goal.getTableTextbyRowCol(2, 4)).to eq("Steps  \n2/4 Complete\nNext Due: 01/11/2015")
      expect(@goal.getTableTextbyRowCol(3, 4)).to eq("Steps  \nNone")

      @goal.selectStatus("Complete")
      @date_filter.setDateRangeAndFilter("10/10/2014", "10/23/2016")
      !45.times{ break if (@my_story.getPrimaryHeader == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")

      headerArr =  @goal.getTableHeaders()
      expect(headerArr[0].to_s).to eq("Goal")
      expect(headerArr[1].to_s).to eq("Date Completed")

      expect(@goal.getTableTextbyRowCol(1, 1)).to eq("Goal  \nGoal Test 3")
      expect(isDateFormatValid?(@goal.getNthGoalEndDate(1), "%m/%d/%Y" )).to eq(true)

      @goal.selectStatus("Active")
      @date_filter.setDateRangeAndFilter("10/10/2014", "10/23/2016")
      !45.times{ break if (@my_story.getPrimaryHeader == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")

      resizeWindowTo(400, 727)
      headerArr =  @goal.getTableHeaders()
      expect(headerArr[0].to_s).to eq("Goal")
      expect(headerArr[1].to_s).to eq("Progress")

      @goal.selectStatus("Inactive")
      @date_filter.setDateRangeAndFilter("10/10/2014", "10/23/2016")
      !45.times{ break if (@my_story.getPrimaryHeader == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")

      headerArr =  @goal.getTableHeaders()
      expect(headerArr[0].to_s).to eq("Goal")
      expect(headerArr[1].to_s).to eq("Progress")

      @goal.selectStatus("Complete")
      @date_filter.setDateRangeAndFilter("10/10/2014", "10/23/2016")
      !45.times{ break if (@my_story.getPrimaryHeader == "Goals"); sleep 1 }
      expect(@my_story.getPrimaryHeader()).to eq("Goals")

      headerArr =  @goal.getTableHeaders()
      expect(headerArr[0].to_s).to eq("Goal")
      expect(headerArr[1].to_s).to eq("Date Completed")
    end

  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible", :broken => true do
      expect(@date_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label", :broken => true do
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result", :broken => true do
      @date_filter.clickResetBtn()
      !30.times {
        break if (getFocusedElementText().include?("Goal") or
                  getFocusedElementText().include?("No results"));
        sleep 1
      }

      # DEFAULTS
      oneYearAgo = getDateNthYearsAgo(1,"%m/%d/%Y")
      oneYearFuture = getDateNthYeasFromNow(1, "%m/%d/%Y")

      expect(@date_filter.getStartDate()).to eq(oneYearAgo)
      expect(@date_filter.getEndDate()).to eq(oneYearFuture)
      expect(@date_filter.isStatusChecked("Active")).to eq(true)
    end

  end

end
