#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized


describe "[Story #JRNL-1838:  Indicate goal type and filter and list by type]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("goals", "healthinventorydb")

    initializeAllObjects

    @GOALS_SCREEN_SCRAPE = [
        "* Name of Goal:",
        "50 character maximum",
        "Type:",
        "Select",
        "Health",
        "Finance",
        "Work",
        "Leisure",
        "Relationships",
        "Other"
    ]

    @GOALS_SCREEN_FILTER_SCRAPE = [
        "Status:",
        "Active",
        "Inactive",
        "Complete",
        "Type:",
        "Select",
        "Health",
        "Finance",
        "Work",
        "Leisure",
        "Relationships",
        "Other"
    ]

    @tomorrow = getDateNthDaysFromNow(1,  "%m/%d/%Y")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @expectedValidationSummaryHeader = "The following errors were found:"

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory
    !45.times{ break if (getSecondaryHeader == "My Story"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Story")

  end

  after(:all) do
    quitDriver()
  end

  context "#AC #JRNL-1309|TC #JRNL-1298:  Add/Edit A goal" do
    it 'Type default value is select' do
       @my_story.clickGoals
       !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
       expect(getPrimaryHeader).to eq("Goals")
    end

    it 'The Type is under the status and the list order is verified', :broken => true do
        x = @my_story.getFilterFormContent().split("\n")
        x = x.slice(x.index("Status:")..x.index("Filter Reset")-1)
        @GOALS_SCREEN_FILTER_SCRAPE.each_with_index do |expectedScreenRow, i|
          expect(x[i]).to eq(expectedScreenRow)
        end

        @goal.clickAddButton
        !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }

       expect(@goal.getType).to eq('Select')
    end

    it "Type field contains relevant Values" do
      @goal.selectType("Health")
      expect(@goal.getType).to eq("Health")
      @goal.selectType("Finance")
      expect(@goal.getType).to eq("Finance")
      @goal.selectType("Work")
      expect(@goal.getType).to eq("Work")
      @goal.selectType("Leisure")
      expect(@goal.getType).to eq("Leisure")
      @goal.selectType("Relationships")
      expect(@goal.getType).to eq("Relationships")
      @goal.selectType("Other")
      expect(@goal.getType).to eq("Other")



    end

    it 'verify that Type is under name of goal and the values in the list are in order', :broken => true do
      x = @form.getFormContent().split("\n")
      x = x.slice(x.index("* Name of Goal:")..x.index("Description:")-1)

      @GOALS_SCREEN_SCRAPE.each_with_index do | expectedScreenRow, i |
        expect(x[i]).to eq(expectedScreenRow)
      end
    end

    it 'Enter all data and type values and save with the type field set', :broken => true do
      stepsAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014"]



      @goal.setGoalName("New Goal")
      @goal.setGoalStartDate("10/01/2014")
      @goal.setGoalEndDate("04/24/2015")
      @goal.selectType("Health")
      @goal.setRewardAtCompletion("Have a nice meal with family")

      @form.clickSaveButton
      !45.times{ break if (getPrimaryHeader() == "Goals"); sleep 1 }
      expect(getCount()).to eq(1)

      @goal.clickAddButton
      !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }

      @goal.setGoalName("Second Goal")
      @goal.setGoalStartDate("01/01/2015")
      @goal.setGoalEndDate("02/01/2015")
      @goal.selectType("Work")
      @goal.setRewardAtCompletion("Test reward")

      @form.clickSaveButton
      !45.times{ break if (getPrimaryHeader() == "Goals"); sleep 1 }
      expect(getCount()).to eq(2)
    end

    it 'Edit Record changing type from health to finance ', :broken => true do
      @goal.clickNthRow(2)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader() == "Edit Goal Entry")

      expect(@goal.getGoalName).to eq("New Goal")
      expect(@goal.isStatusOptionPresent).to eq(true)
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Active", "statusOption_0")).to eq(true)
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Inactive", "statusOption_1")).to eq(false)
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Complete", "statusOption_2")).to eq(false)
      expect(@goal.getGoalStartDate).to eq("10/01/2014")
      expect(@goal.getGoalEndDate).to eq("04/24/2015")
      expect(@goal.getType).to eq("Health")

      expect(@goal.getRewardAtCompletion).to eq("Have a nice meal with family")

      @goal.selectType("Finance")
      @form.clickSaveButton
      !45.times{ break if (getPrimaryHeader() == "Goals"); sleep 1 }
      expect(getCount()).to eq(2)

      @goal.clickNthRow(2)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Goal Entry")
      expect(@goal.getType).to eq("Finance")
    end
  end

  context "AC #JRNL-1308|TC #JRNL-1298: List and Filter Page View" do
      it "Table Headers", :broken => true do

        @form.clickCancelButton
        !45.times{ break if (getPrimaryHeader() == "Goals"); sleep 1 }
        expect(getCount()).to eq(2)
        expect(getTableHeaders()).to eq(["Goal", "Progress", "Goal End Date", "Steps", "Type"])
      end

      it "Phone view display", :broken => true do
        resizeWindowToPhone()
        expect(getTableHeaders()).to eq(["Goal", "Progress", "Goal End Date", "Steps"])
        resizeWindowToDefault()
      end

      it "filter by type", :broken => true do
        @goal.selectType("Work")
        @date_filter.clickFilterBtn()

        !5.times{ break if (getTextForRowColumn(1, 1) != nil); sleep 1 }

        !45.times{ break if (getPrimaryHeader() == "Goals"); sleep 1 }
        expect(getCount()).to eq(1)

        expect(getTextForRow(1).include?('Work')).to eq(true)

        @goal.selectType("Finance")
        @date_filter.clickFilterBtn()

        !5.times{ break if (getTextForRowColumn(1, 1) != nil); sleep 1 }

        !45.times{ break if (getPrimaryHeader() == "Goals"); sleep 1 }
        expect(getCount()).to eq(1)

        expect(getTextForRow(1).include?('Finance')).to eq(true)

        @goal.selectType("Select")
        @date_filter.clickFilterBtn()

        !5.times{ break if (getTextForRowColumn(1, 1) != nil); sleep 1 }

        !45.times{ break if (getPrimaryHeader() == "Goals"); sleep 1 }
        expect(getCount()).to eq(2)
      end
    end

end
