require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2469:  Goal - Edit/Delete]", :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("goals", "healthinventorydb")
    removeCollection("promptedresponses", "healthinventorydb")

    initializeAllObjects

    @tomorrow = getDateNthDaysFromNow(1,  "%m/%d/%Y")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @expectedValidationSummaryHeader = "The following errors were found:"

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyStory']").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader == "My Story"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Story")
  end

  # after(:all) do
  #   quitDriver()
  # end

    context "#AC #JRNL-2807|TC #JRNL-2919:  Goals - Edit Fields" do
    it ".All fields available in Add mode are shown and editable if status is Active or Inactive; Fields are shown as read only if status = Completed", :broken => true do
      waitForPageToFinishLoading
      @my_story.clickGoals
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      #scenario 1
      name = "New Goal with 10 Steps"
      goalStartDate = "10/01/2014"
      goalEndDate = "07/01/2015"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014", "Step4;11/01/2014", "Step 5;11/18/2014", "Step 6;12/29/2014", "Step 7;01/01/2015", "Step 8;03/26/2015", "Step9;05/03/2015", "Step 10;06/23/2015"]
      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "","Health")
      verifyDataEntriesInEditForActiveGoal(name, goalStartDate, goalEndDate, "", stepAndDueDateArr, "", "Health")

      @form.clickCancelButton
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      #scenario 2
      name = "Goal without Steps"
      goalStartDate = "10/01/2014"
      goalEndDate = "09/02/2015"
      stepAndDueDateArr = [" ; "]
      description = "Just do it"
      reward = ""
      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, description, reward, "Health")
      verifyDataEntriesInEditForActiveGoal(name, goalStartDate, goalEndDate, description, stepAndDueDateArr, reward, "Health")
      @form.clickCancelButton
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      #scenario 3
      name = "Goal with Reward at completion"
      goalStartDate = "10/23/2014"
      goalEndDate = "08/02/2015"
      stepAndDueDateArr = [" ; "]
      description = ""
      reward = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, description, reward, "Health")
      verifyDataEntriesInEditForActiveGoal(name, goalStartDate, goalEndDate, description, stepAndDueDateArr, reward, "Health")
      @form.clickCancelButton
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      #editable active/inactive mode
      index = @goal.findIndexWithGivenGoalName("New Goal with 10 Steps")
      @goal.clickNthRow(index)
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Active", "statusOption_0")).to eq(true)
      @goal.selectStatus("Inactive")
      name = "New Goal with 10 steps Edited"
      goalStartDate = "10/01/2014"
      goalEndDate = "04/24/2015"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014", "Step4;11/01/2014", "Step 5;11/18/2014", "Step 6;12/29/2014", "Step 7;01/01/2015", "Step 8;03/26/2015", "Step9;04/03/2015", "Step 10;04/05/2015"]
      description = "Added 10 steps"
      reward = "Have a nice meal with family"
      type="Health"

      enterData(name, goalStartDate, goalEndDate, stepAndDueDateArr, description, reward, type)
      @form.clickSaveButton
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      @goal.selectStatus("Inactive")
      @date_filter.clickFilterBtn
      !5.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName(name)
      expect(index > -1).to eq(true)

      @goal.clickNthRow(index)
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Inactive", "statusOption_1")).to eq(true)
      name = "New Goal with 10 steps Edited Again"
      goalStartDate = "10/02/2014"
      goalEndDate = "09/13/2015"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014", "Step4;11/01/2014", "Step 5;11/18/2014", "Step 6;12/29/2014", "Step 7;01/01/2015", "Step 8;03/26/2015", "Step9;05/03/2015", "Step 10;06/23/2015"]
      description = "Added 10 steps Again"
      reward = "No rewards"
      type = "Health"

      enterData(name, goalStartDate, goalEndDate, stepAndDueDateArr, description, reward, type)
      @form.clickSaveButton
      !5.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName(name)
      expect(index > -1).to eq(true)
    end

    it ".Progress history (%)", :broken => true do
      index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
      @goal.clickNthRow(index)
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Inactive", "statusOption_1")).to eq(true)

      expect(@goal.isProgressBarsVisible).to eq(false)

      expect(@goal.getProgressHistoryLabel).to eq("Progress History:")
      expect(@goal.isProgressBarsVisible).to eq(false)
      expect(@goal.isAddProgressButtonVisible).to eq(true)

      @goal.clickAddProgress
      !5.times{ break if (@modal.getConfirmationHeading() == "Add Progress"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Add Progress")
      expect(@modal.getConfirmationMessage()).to eq("Goal Progress (%):\n100\nSlider on\n0")

      @goal.moveProgressBarToRight(3)
      @modal.clickSaveButtonByFunctionName("modalContent.ok();")
      !5.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      !5.times{ break if (@goal.getNthProgressDate(1) == @today.to_s); sleep 1 }

      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("3%")
      expect(@goal.getNthProgressBarValue(1)).to eq("3%")

      @goal.clickAddProgress
      !5.times{ break if (@modal.getConfirmationHeading() == "Add Progress"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Add Progress")

      @goal.moveProgressBarToRight(5)
      @modal.clickSaveButtonByFunctionName("modalContent.ok();")
      !5.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      !5.times{ break if (@goal.getNThGoalProgress(1) == "8%"); sleep 1 }

      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("3%")
      expect(@goal.getNthProgressBarValue(1)).to eq("3%")

      expect(@goal.getNthProgressDate(2)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(2)).to eq("8%")
      expect(@goal.getNthProgressBarValue(2)).to eq("8%")

      @goal.clickAddProgress
      !5.times{ break if (@modal.getConfirmationHeading() == "Add Progress"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Add Progress")

      @goal.moveProgressBarToLeft(1)
      @modal.clickSaveButtonByFunctionName("modalContent.ok();")
      !5.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      !5.times{ break if (@goal.getNThGoalProgress(3) == "7%"); sleep 1 }

      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("3%")
      expect(@goal.getNthProgressBarValue(1)).to eq("3%")

      expect(@goal.getNthProgressDate(2)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(2)).to eq("8%")
      expect(@goal.getNthProgressBarValue(2)).to eq("8%")

      expect(@goal.getNthProgressDate(3)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(3)).to eq("7%")
      expect(@goal.getNthProgressBarValue(3)).to eq("7%")

      @goal.clickAddProgress
      !5.times{ break if (@modal.getConfirmationHeading() == "Add Progress"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Add Progress")

      @goal.moveProgressBarToRight(4)
      @modal.clickSaveButtonByFunctionName("modalContent.ok();")
      !5.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      !5.times{ break if (@goal.getNThGoalProgress(3) == "11%"); sleep 1 }

      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("8%")
      expect(@goal.getNthProgressBarValue(1)).to eq("8%")

      expect(@goal.getNthProgressDate(2)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(2)).to eq("7%")
      expect(@goal.getNthProgressBarValue(2)).to eq("7%")

      expect(@goal.getNthProgressDate(3)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(3)).to eq("11%")
      expect(@goal.getNthProgressBarValue(3)).to eq("11%")

      @goal.clickAddProgress
      !5.times{ break if (@modal.getConfirmationHeading() == "Add Progress"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Add Progress")

      @modal.clickCancelButtonByFunctionName("modalContent.close()")
      !5.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("8%")
      expect(@goal.getNthProgressBarValue(1)).to eq("8%")

      expect(@goal.getNthProgressDate(2)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(2)).to eq("7%")
      expect(@goal.getNthProgressBarValue(2)).to eq("7%")

      expect(@goal.getNthProgressDate(3)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(3)).to eq("11%")
      expect(@goal.getNthProgressBarValue(3)).to eq("11%")
    end

    it ".Step Complete", :broken => true do
      @goal.checkNthStepComplete(1)
      @goal.checkNthStepComplete(3)
      @goal.checkNthStepComplete(5)
      @goal.checkNthStepComplete(7)

      expect(@goal.isNthStepCompleteChecked(1)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(2)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(3)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(4)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(5)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(6)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(7)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(8)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(9)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(10)).to eq(false)

      @form.clickSaveButton
      !5.times{ break if (@goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again") > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
      expect(index > -1).to eq(true)

      @goal.clickNthRow(index)
      !5.times{ break if (@goal.isNthStepCompleteChecked(1) == true); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      expect(@goal.isNthStepCompleteChecked(1)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(2)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(3)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(4)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(5)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(6)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(7)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(8)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(9)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(10)).to eq(false)

      #unselect
      @goal.checkNthStepComplete(1)
      @goal.checkNthStepComplete(3)
      @goal.checkNthStepComplete(5)
      @goal.checkNthStepComplete(7)

      @goal.checkNthStepComplete(2)
      @goal.checkNthStepComplete(4)
      @goal.checkNthStepComplete(5)
      @goal.checkNthStepComplete(8)

      expect(@goal.isNthStepCompleteChecked(1)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(2)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(3)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(4)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(5)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(6)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(7)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(8)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(9)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(10)).to eq(false)

      @form.clickSaveButton
      !5.times{ break if (@goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again") > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
      expect(index > -1).to eq(true)

      @goal.clickNthRow(index)
      !5.times{ break if (@goal.isNthStepCompleteChecked(1) == true); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      expect(@goal.isNthStepCompleteChecked(1)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(2)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(3)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(4)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(5)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(6)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(7)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(8)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(9)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(10)).to eq(false)
      @form.clickCancelButton
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")
    end

    context "AC #JRNL-2808|TC #JRNL-2919 :  Save, Cancel, Delete" do
      #Save is covered in Add and Edit
      it ".Cancel", :broken => true do
        goalsCount = @goal.getGoalsCount
        !5.times{ break if (@goal.isAddButtonVisible  == true); sleep 1 }
        @goal.clickAddButton()
        !5.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
        !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
        expect(getPrimaryHeader).to eq("Add Goal Entry")

        @goal.setGoalName("Goal Cancel")
        @goal.setGoalEndDate(@tomorrow)

        @form.clickCancelButton
        !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
        expect(getPrimaryHeader).to eq("Goals")

        expect(@goal.getGoalsCount).to eq(goalsCount)

        index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
        @goal.clickNthRow(index)
        !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Goal Entry")

        @goal.setGoalEndDate("New Goal with 10 steps Edited Again Again")
        @form.clickCancelButton

        !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
        expect(getPrimaryHeader).to eq("Goals")

        @goal.clickNthRow(index)
        !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Goal Entry")
        #no update
        expect(@goal.getGoalName).to eq("New Goal with 10 steps Edited Again")
        @form.clickCancelButton
        !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
        expect(getPrimaryHeader).to eq("Goals")
      end

      it "Status = Complete", :broken => true do
        index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
        @goal.clickNthRow(index)
        !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Goal Entry")

        @goal.selectStatus("Complete")
        @form.clickSaveButton

        !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        @modal.clickContinueButton

        !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
        expect(getPrimaryHeader).to eq("Goals")

        @goal.selectStatus("Complete")
        @date_filter.clickFilterBtn

        !5.times{ break if (@goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again") > -1); sleep 1 }
        index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
        expect(index > -1).to eq(true)


        @goal.clickNthRow(index)
        !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Goal Entry")

        expect(@goal.allElementsDisabled?).to eq(true)

        @form.clickCancelButton
        !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
        expect(getPrimaryHeader).to eq("Goals")
      end

      it ".Delete", :broken => true do
        @goal.selectStatus("Active")
        @date_filter.clickFilterBtn
        !5.times{ break if (@goal.findIndexWithGivenGoalName("Goal without Steps") > -1); sleep 1 }
        index = @goal.findIndexWithGivenGoalName("Goal without Steps")
        expect(index > -1).to eq(true)

        goalsCount = @goal.getGoalsCount

        for i in 1..goalsCount

          @goal.clickNthRow(1)
          !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
          expect(getPrimaryHeader).to eq("Edit Goal Entry")

          @form.clickDeleteButton

          !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
          @modal.clickNoButton()

          !5.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
          expect(getPrimaryHeader).to eq("Edit Goal Entry")

          @form.clickDeleteButton

          !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
          @modal.clickYesButton

          !5.times{ break if (@goal.getGoalsCount == goalsCount - i); sleep 1 }
          expect(@goal.getGoalsCount).to eq(goalsCount - i)
        end
      end
    end
  end

  def verifyDataEntriesInEditForActiveGoal(goalName, goalStartDate, goalEndDate, description, stepAndDueDateArr, reward, type)
    index = @goal.findIndexWithGivenGoalName(goalName)
    @goal.clickNthRow(index)
    !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Edit Goal Entry")

    expect(@goal.getGoalName).to eq(goalName)
    expect(@goal.isStatusOptionPresent).to eq(true)
    #Active for new goal
    expect(isThisRadioButtonOrCheckBoxSelected("radio", "Active", "statusOption_0")).to eq(true)
    expect(isThisRadioButtonOrCheckBoxSelected("radio", "Inactive", "statusOption_1")).to eq(false)
    expect(isThisRadioButtonOrCheckBoxSelected("radio", "Complete", "statusOption_2")).to eq(false)
    expect(@goal.getGoalStartDate).to eq(goalStartDate)
    expect(@goal.getGoalEndDate).to eq(goalEndDate)
    expect(@goal.getType).to eq(type)

    for i in 0..(stepAndDueDateArr.length - 1)
      data = stepAndDueDateArr[i].split(";")
      step = data[0]
      dueDate = data[1]
      #puts "step is " + step
      #puts "duedate is " + dueDate
      expect(@goal.getNthStep(i + 1)).to eq(step.strip)
      expect(@goal.getNthStepDueDate(i + 1)).to eq(dueDate.strip)
    end
    expect(@goal.getDescription).to eq(description)
    expect(@goal.getRewardAtCompletion).to eq(reward)
  end

  def enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward, type)
    @goal.setGoalName(name)
    @goal.setGoalStartDate(goalStartDate)
    @goal.setGoalEndDate(goalEndDate)
    @goal.selectType(type)

    stepsCount = stepsAndDueDateArr.length
    for i in 0..(stepsCount - 1 )
      if(@goal.isNthStepPresent(i + 1) == false)
        @goal.clickAddStepButton
      end

      #puts "steps and due date array: " + stepsAndDueDateArr[i]

      stepsAndDate = stepsAndDueDateArr[i]
      data = stepsAndDate.split(";")

      if (data[0].strip != "" and data[0].strip != nil)
        @goal.setNthStep(i + 1, data[0].strip)
      end

      if (data[1].strip != "" and data[1].strip != nil)
        @goal.setNthStepDueDate(i + 1, data[1].strip)
      end
    end
    @goal.setDescription(description)
    @goal.setRewardAtCompletion(reward)
  end

  def addGoal(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward, type)
    @goal.clickAddButton()
    !5.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")

    enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward, type)

    @form.clickSaveButton
    !5.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
    expect(@goal.findIndexWithGivenGoalName(name) > -1).to eq(true)
  end
end












































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized


describe "[Story #JRNL-2469:  Goal - Edit/Delete]", :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("goals", "healthinventorydb")
    removeCollection("promptedresponses", "healthinventorydb")

    initializeAllObjects

    @tomorrow = getDateNthDaysFromNow(1,  "%m/%d/%Y")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @expectedValidationSummaryHeader = "The following errors were found:"

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory
    !45.times{ break if (getSecondaryHeader == "My Story"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Story")

  end

  after(:all) do
    quitDriver()
  end

    context "#AC #JRNL-2807|TC #JRNL-2919:  Goals - Edit Fields" do
    it ".All fields available in Add mode are shown and editable if status is Active or Inactive; Fields are shown as read only if status = Completed", :broken => true do
      @my_story.clickGoals
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      #scenario 1
      name = "New Goal with 10 Steps"
      goalStartDate = "10/01/2014"
      goalEndDate = "07/01/2015"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014", "Step4;11/01/2014", "Step 5;11/18/2014", "Step 6;12/29/2014", "Step 7;01/01/2015", "Step 8;03/26/2015", "Step9;05/03/2015", "Step 10;06/23/2015"]
      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "","Health")
      verifyDataEntriesInEditForActiveGoal(name, goalStartDate, goalEndDate, "", stepAndDueDateArr, "", "Health")

      @form.clickCancelButton
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      #scenario 2
      name = "Goal without Steps"
      goalStartDate = "10/01/2014"
      goalEndDate = "09/02/2015"
      stepAndDueDateArr = [" ; "]
      description = "Just do it"
      reward = ""
      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, description, reward, "Health")
      verifyDataEntriesInEditForActiveGoal(name, goalStartDate, goalEndDate, description, stepAndDueDateArr, reward, "Health")
      @form.clickCancelButton
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      #scenario 3
      name = "Goal with Reward at completion"
      goalStartDate = "10/23/2014"
      goalEndDate = "08/02/2015"
      stepAndDueDateArr = [" ; "]
      description = ""
      reward = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, description, reward, "Health")
      verifyDataEntriesInEditForActiveGoal(name, goalStartDate, goalEndDate, description, stepAndDueDateArr, reward, "Health")
      @form.clickCancelButton
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      #editable active/inactive mode
      index = @goal.findIndexWithGivenGoalName("New Goal with 10 Steps")
      @goal.clickNthRow(index)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Active", "statusOption_0")).to eq(true)
      @goal.selectStatus("Inactive")
      name = "New Goal with 10 steps Edited"
      goalStartDate = "10/01/2014"
      goalEndDate = "04/24/2015"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014", "Step4;11/01/2014", "Step 5;11/18/2014", "Step 6;12/29/2014", "Step 7;01/01/2015", "Step 8;03/26/2015", "Step9;04/03/2015", "Step 10;04/05/2015"]
      description = "Added 10 steps"
      reward = "Have a nice meal with family"
      type="Health"

      enterData(name, goalStartDate, goalEndDate, stepAndDueDateArr, description, reward, type)
      @form.clickSaveButton
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      @goal.selectStatus("Inactive")
      @date_filter.clickFilterBtn
      !45.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName(name)
      expect(index > -1).to eq(true)

      @goal.clickNthRow(index)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Inactive", "statusOption_1")).to eq(true)
      name = "New Goal with 10 steps Edited Again"
      goalStartDate = "10/02/2014"
      goalEndDate = "09/13/2015"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014", "Step4;11/01/2014", "Step 5;11/18/2014", "Step 6;12/29/2014", "Step 7;01/01/2015", "Step 8;03/26/2015", "Step9;05/03/2015", "Step 10;06/23/2015"]
      description = "Added 10 steps Again"
      reward = "No rewards"
      type = "Health"

      enterData(name, goalStartDate, goalEndDate, stepAndDueDateArr, description, reward, type)
      @form.clickSaveButton
      !45.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName(name)
      expect(index > -1).to eq(true)

    end


    it ".Progress history (%)", :broken => true do
      index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
      @goal.clickNthRow(index)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Inactive", "statusOption_1")).to eq(true)

      expect(@goal.isProgressBarsVisible).to eq(false)

      expect(@goal.getProgressHistoryLabel).to eq("Progress History:")
      expect(@goal.isProgressBarsVisible).to eq(false)
      expect(@goal.isAddProgressButtonVisible).to eq(true)

      @goal.clickAddProgress
      !45.times{ break if (@modal.getConfirmationHeading() == "Add Progress"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Add Progress")
      expect(@modal.getConfirmationMessage()).to eq("Goal Progress (%):\n100\nSlider on\n0")

      @goal.moveProgressBarToRight(3)
      @modal.clickSaveButtonByFunctionName("modalContent.ok();")
      !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      !45.times{ break if (@goal.getNthProgressDate(1) == @today.to_s); sleep 1 }

      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("3%")
      expect(@goal.getNthProgressBarValue(1)).to eq("3%")

      @goal.clickAddProgress
      !45.times{ break if (@modal.getConfirmationHeading() == "Add Progress"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Add Progress")

      @goal.moveProgressBarToRight(5)
      @modal.clickSaveButtonByFunctionName("modalContent.ok();")
      !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      !45.times{ break if (@goal.getNThGoalProgress(1) == "8%"); sleep 1 }

      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("3%")
      expect(@goal.getNthProgressBarValue(1)).to eq("3%")

      expect(@goal.getNthProgressDate(2)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(2)).to eq("8%")
      expect(@goal.getNthProgressBarValue(2)).to eq("8%")

      @goal.clickAddProgress
      !45.times{ break if (@modal.getConfirmationHeading() == "Add Progress"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Add Progress")

      @goal.moveProgressBarToLeft(1)
      @modal.clickSaveButtonByFunctionName("modalContent.ok();")
      !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      !45.times{ break if (@goal.getNThGoalProgress(3) == "7%"); sleep 1 }

      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("3%")
      expect(@goal.getNthProgressBarValue(1)).to eq("3%")

      expect(@goal.getNthProgressDate(2)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(2)).to eq("8%")
      expect(@goal.getNthProgressBarValue(2)).to eq("8%")

      expect(@goal.getNthProgressDate(3)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(3)).to eq("7%")
      expect(@goal.getNthProgressBarValue(3)).to eq("7%")

      @goal.clickAddProgress
      !45.times{ break if (@modal.getConfirmationHeading() == "Add Progress"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Add Progress")

      @goal.moveProgressBarToRight(4)
      @modal.clickSaveButtonByFunctionName("modalContent.ok();")
      !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      !45.times{ break if (@goal.getNThGoalProgress(3) == "11%"); sleep 1 }

      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("8%")
      expect(@goal.getNthProgressBarValue(1)).to eq("8%")

      expect(@goal.getNthProgressDate(2)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(2)).to eq("7%")
      expect(@goal.getNthProgressBarValue(2)).to eq("7%")

      expect(@goal.getNthProgressDate(3)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(3)).to eq("11%")
      expect(@goal.getNthProgressBarValue(3)).to eq("11%")

      @goal.clickAddProgress
      !45.times{ break if (@modal.getConfirmationHeading() == "Add Progress"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Add Progress")

      @modal.clickCancelButtonByFunctionName("modalContent.close()")
      !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("8%")
      expect(@goal.getNthProgressBarValue(1)).to eq("8%")

      expect(@goal.getNthProgressDate(2)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(2)).to eq("7%")
      expect(@goal.getNthProgressBarValue(2)).to eq("7%")

      expect(@goal.getNthProgressDate(3)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(3)).to eq("11%")
      expect(@goal.getNthProgressBarValue(3)).to eq("11%")
    end

    it ".Step Complete", :broken => true do
      @goal.checkNthStepComplete(1)
      @goal.checkNthStepComplete(3)
      @goal.checkNthStepComplete(5)
      @goal.checkNthStepComplete(7)

      expect(@goal.isNthStepCompleteChecked(1)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(2)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(3)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(4)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(5)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(6)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(7)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(8)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(9)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(10)).to eq(false)

      @form.clickSaveButton
      !45.times{ break if (@goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again") > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
      expect(index > -1).to eq(true)

      @goal.clickNthRow(index)
      !45.times{ break if (@goal.isNthStepCompleteChecked(1) == true); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      expect(@goal.isNthStepCompleteChecked(1)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(2)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(3)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(4)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(5)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(6)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(7)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(8)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(9)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(10)).to eq(false)

      #unselect
      @goal.checkNthStepComplete(1)
      @goal.checkNthStepComplete(3)
      @goal.checkNthStepComplete(5)
      @goal.checkNthStepComplete(7)

      @goal.checkNthStepComplete(2)
      @goal.checkNthStepComplete(4)
      @goal.checkNthStepComplete(5)
      @goal.checkNthStepComplete(8)

      expect(@goal.isNthStepCompleteChecked(1)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(2)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(3)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(4)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(5)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(6)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(7)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(8)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(9)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(10)).to eq(false)

      @form.clickSaveButton
      !45.times{ break if (@goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again") > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
      expect(index > -1).to eq(true)

      @goal.clickNthRow(index)
      !45.times{ break if (@goal.isNthStepCompleteChecked(1) == true); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      expect(@goal.isNthStepCompleteChecked(1)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(2)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(3)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(4)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(5)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(6)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(7)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(8)).to eq(true)
      expect(@goal.isNthStepCompleteChecked(9)).to eq(false)
      expect(@goal.isNthStepCompleteChecked(10)).to eq(false)
      @form.clickCancelButton
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")


    end

    context "AC #JRNL-2808|TC #JRNL-2919 :  Save, Cancel, Delete" do
      #Save is covered in Add and Edit
      it ".Cancel", :broken => true do
        goalsCount = @goal.getGoalsCount
        !45.times{ break if (@goal.isAddButtonVisible  == true); sleep 1 }
        @goal.clickAddButton()
        !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
        !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
        expect(getPrimaryHeader).to eq("Add Goal Entry")

        @goal.setGoalName("Goal Cancel")
        @goal.setGoalEndDate(@tomorrow)

        @form.clickCancelButton
        !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
        expect(getPrimaryHeader).to eq("Goals")

        expect(@goal.getGoalsCount).to eq(goalsCount)

        index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
        @goal.clickNthRow(index)
        !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Goal Entry")

        @goal.setGoalEndDate("New Goal with 10 steps Edited Again Again")
        @form.clickCancelButton

        !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
        expect(getPrimaryHeader).to eq("Goals")

        @goal.clickNthRow(index)
        !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Goal Entry")
        #no update
        expect(@goal.getGoalName).to eq("New Goal with 10 steps Edited Again")
        @form.clickCancelButton
        !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
        expect(getPrimaryHeader).to eq("Goals")

      end

      it "Status = Complete", :broken => true do
        index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
        @goal.clickNthRow(index)
        !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Goal Entry")

        @goal.selectStatus("Complete")
        @form.clickSaveButton

        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        @modal.clickContinueButton

        !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
        expect(getPrimaryHeader).to eq("Goals")

        @goal.selectStatus("Complete")
        @date_filter.clickFilterBtn

        !45.times{ break if (@goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again") > -1); sleep 1 }
        index = @goal.findIndexWithGivenGoalName("New Goal with 10 steps Edited Again")
        expect(index > -1).to eq(true)


        @goal.clickNthRow(index)
        !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Goal Entry")

        expect(@goal.allElementsDisabled?).to eq(true)

        @form.clickCancelButton
        !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
        expect(getPrimaryHeader).to eq("Goals")


      end

      it ".Delete", :broken => true do
        @goal.selectStatus("Active")
        @date_filter.clickFilterBtn
        !45.times{ break if (@goal.findIndexWithGivenGoalName("Goal without Steps") > -1); sleep 1 }
        index = @goal.findIndexWithGivenGoalName("Goal without Steps")
        expect(index > -1).to eq(true)

        goalsCount = @goal.getGoalsCount

        for i in 1..goalsCount

          @goal.clickNthRow(1)
          !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
          expect(getPrimaryHeader).to eq("Edit Goal Entry")

          @form.clickDeleteButton

          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
          @modal.clickNoButton()

          !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
          expect(getPrimaryHeader).to eq("Edit Goal Entry")

          @form.clickDeleteButton

          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
          @modal.clickYesButton

          !45.times{ break if (@goal.getGoalsCount == goalsCount - i); sleep 1 }
          expect(@goal.getGoalsCount).to eq(goalsCount - i)

        end

      end
    end

  end

  def verifyDataEntriesInEditForActiveGoal(goalName, goalStartDate, goalEndDate, description, stepAndDueDateArr, reward, type)
    index = @goal.findIndexWithGivenGoalName(goalName)
    @goal.clickNthRow(index)
    !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Edit Goal Entry")

    expect(@goal.getGoalName).to eq(goalName)
    expect(@goal.isStatusOptionPresent).to eq(true)
    #Active for new goal
    expect(isThisRadioButtonOrCheckBoxSelected("radio", "Active", "statusOption_0")).to eq(true)
    expect(isThisRadioButtonOrCheckBoxSelected("radio", "Inactive", "statusOption_1")).to eq(false)
    expect(isThisRadioButtonOrCheckBoxSelected("radio", "Complete", "statusOption_2")).to eq(false)
    expect(@goal.getGoalStartDate).to eq(goalStartDate)
    expect(@goal.getGoalEndDate).to eq(goalEndDate)
    expect(@goal.getType).to eq(type)

    for i in 0..(stepAndDueDateArr.length - 1)
      data = stepAndDueDateArr[i].split(";")
      step = data[0]
      dueDate = data[1]
      #puts "step is " + step
      #puts "duedate is " + dueDate
      expect(@goal.getNthStep(i + 1)).to eq(step.strip)
      expect(@goal.getNthStepDueDate(i + 1)).to eq(dueDate.strip)
    end
    expect(@goal.getDescription).to eq(description)
    expect(@goal.getRewardAtCompletion).to eq(reward)
  end

  def enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward, type)
    @goal.setGoalName(name)
    @goal.setGoalStartDate(goalStartDate)
    @goal.setGoalEndDate(goalEndDate)
    @goal.selectType(type)

    stepsCount = stepsAndDueDateArr.length
    for i in 0..(stepsCount - 1 )
      if(@goal.isNthStepPresent(i + 1) == false)
        @goal.clickAddStepButton
      end

      #puts "steps and due date array: " + stepsAndDueDateArr[i]

      stepsAndDate = stepsAndDueDateArr[i]
      data = stepsAndDate.split(";")

      if (data[0].strip != "" and data[0].strip != nil)
        @goal.setNthStep(i + 1, data[0].strip)
      end

      if (data[1].strip != "" and data[1].strip != nil)
        @goal.setNthStepDueDate(i + 1, data[1].strip)
      end
    end
    @goal.setDescription(description)
    @goal.setRewardAtCompletion(reward)
  end

  def addGoal(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward, type)
    @goal.clickAddButton()
    !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")

    enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward, type)

    @form.clickSaveButton
    !45.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
    expect(@goal.findIndexWithGivenGoalName(name) > -1).to eq(true)
  end
end
=end