require_relative '../../globalized'
include Globalized


describe "[Story #JRNL-2465: Customize Save Function for Completed Goals]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("goals", "healthinventorydb")

    initializeAllObjects

    @today = getDateNthDaysAgo(0, "%m/%d/%Y")

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyStory']").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader == "My Story"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Story")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC #JRNL-2813|TC #JRNL-1967: Saving a Completed Goal Confirmation message -- #JRNL-2814|TC #JRNL-1967: Return/Cancel" do
    it ".The personal reward field is not valued - Status = Completed", :broken => true do
      @my_story.clickGoals
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      name = "Goal without reward"
      goalStartDate = "10/01/2014"
      goalEndDate = "07/01/2015"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014"]
      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "")

      index = @goal.findIndexWithGivenGoalName(name)
      waitForPageToFinishLoading
      @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[2]/div/div/ul/li[1]/span[6]").click
      waitForPageToFinishLoading
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      @goal.selectStatus("Complete")
      @form.clickSaveButton

      !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      message = @modal.getConfirmationMessage
      expect(message.include?("Congratulations!")).to eq(true)
      expect(message.include?("You have completed the goal. Great work!")).to eq(true)
      expect(message.include?("Remember to reward your success.")).to eq(true)
      expect(message.include?("Please remember, completed Goals cannot be edited and all pending Notifications will be turned off.")).to eq(true)
    end

    it ".The personal reward field is valued - Status = Completed", :broken => true do
      @modal.clickReturnButton
      !5.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      @form.clickSaveButton

      !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      message = @modal.getConfirmationMessage
      expect(message.include?("Congratulations!")).to eq(true)
      expect(message.include?("You have completed the goal. Great work!")).to eq(true)
      expect(message.include?("Remember to reward your success. You indicated your reward for completing this goal was:")).to eq(true)
      expect(message.include?("Take a trip to the beach."))
      expect(message.include?("Please remember, completed Goals cannot be edited and all pending Notifications will be turned off.")).to eq(true)
      @modal.clickContinueButton

      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      @goal.selectStatus("Complete")
      @date_filter.clickFilterBtn
      name = "Goal without reward"
      !5.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName(name)
      #expect(index > -1).to eq(true)
      waitForPageToFinishLoading
      @driver.find_element(:css, "input[id='startDate']").clear
      @driver.find_element(:css, "input[id='startDate']").send_keys "01/01/2000"
      @driver.find_element(:css, "button[title='Apply Filter']").click
      waitForPageToFinishLoading

      #completed Date
      expect(@goal.getNthDateCompleted(1)).to eq(@today.to_s)
      waitForPageToFinishLoading
      @driver.find_element(:css, "span[class='table-last-col icon icon-nav-right-arrow']").click
      waitForPageToFinishLoading
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Complete", "statusOption_2")).to eq(true)
      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("100%")
      expect(@goal.getNthProgressBarValue(1)).to eq("100%")

      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014"]
      for i in 0..(stepAndDueDateArr.length - 1)
        data = stepAndDueDateArr[i].split(";")
        step = data[0]
        dueDate = data[1]

        expect(@goal.getNthStep(i + 1)).to eq(step.strip)
        expect(@goal.getNthStepDueDate(i + 1)).to eq(dueDate.strip)
        expect(@goal.isNthStepCompleteChecked(i + 1)).to eq(false)
      end

      @form.clickCancelButton
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")
    end

    it ".The personal reward field is not valued - Steps - Completed", :broken => true do
      @goal.selectStatus("Active")
      @date_filter.clickFilterBtn
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      name = "Goal without reward: Steps completed"
      goalStartDate = "10/01/2014"
      goalEndDate = "07/01/2015"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014"]
      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "")

      index = @goal.findIndexWithGivenGoalName(name)
      waitForPageToFinishLoading
      @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[2]/div/div/ul/li[1]/span[6]").click
      waitForPageToFinishLoading
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")
      @form.clickSaveButton
    end

    it ".The personal reward field is valued - Steps completed", :broken => true do
      waitForPageToFinishLoading
      @goal.selectStatus("Complete")
      @date_filter.clickFilterBtn
      name = "Goal without reward: Steps completed"
      !5.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName(name)
      #completed Date
      waitForPageToFinishLoading
      @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[2]/div/div/ul/li[1]/span[4]").click
      waitForPageToFinishLoading
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Complete", "statusOption_2")).to eq(true)
      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("100%")
      expect(@goal.getNthProgressBarValue(1)).to eq("100%")

      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014"]
      for i in 0..(stepAndDueDateArr.length - 1)
        data = stepAndDueDateArr[i].split(";")
        step = data[0]
        dueDate = data[1]

        expect(@goal.getNthStep(i + 1)).to eq(step.strip)
        expect(@goal.getNthStepDueDate(i + 1)).to eq(dueDate.strip)
      end
      waitForPageToFinishLoading
      @form.clickSaveButton
      waitForPageToFinishLoading
      @modal.clickContinueButton
      waitForPageToFinishLoading
    end

  end

  def enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)
    @goal.setGoalName(name)
    @goal.setGoalStartDate(goalStartDate)
    @goal.setGoalEndDate(goalEndDate)

    stepsCount = stepsAndDueDateArr.length
    for i in 0..(stepsCount - 1 )
      if(@goal.isNthStepPresent(i + 1) == false)
        @goal.clickAddStepButton
      end

      #puts "steps and due date array: " + stepsAndDueDateArr[i]

      stepsAndDate = stepsAndDueDateArr[i]
      data = stepsAndDate.split(";")

      if (data[0].strip != "" and data[0].strip != nil)
        @goal.setNthStep(i + 1, data[0].strip)
      end

      if (data[1].strip != "" and data[1].strip != nil)
        @goal.setNthStepDueDate(i + 1, data[1].strip)
      end
    end
    @goal.setDescription(description)
    @goal.setRewardAtCompletion(reward)
  end

  def addGoal(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)
    @goal.clickAddButton()
    !5.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")

    enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)

    @form.clickSaveButton
    !5.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
    expect(@goal.findIndexWithGivenGoalName(name) > -1).to eq(true)
  end

end















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized


describe "[Story #JRNL-2465: Customize Save Function for Completed Goals]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("goals", "healthinventorydb")

    initializeAllObjects

    @today = getDateNthDaysAgo(0, "%m/%d/%Y")

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory
    !45.times{ break if (getSecondaryHeader == "My Story"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Story")

  end

  after(:all) do
    quitDriver()
  end

  context "#AC #JRNL-2813|TC #JRNL-1967: Saving a Completed Goal Confirmation message -- #JRNL-2814|TC #JRNL-1967: Return/Cancel" do
    it ".The personal reward field is not valued - Status = Completed", :broken => true do
      @my_story.clickGoals
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      name = "Goal without reward"
      goalStartDate = "10/01/2014"
      goalEndDate = "07/01/2015"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014"]
      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "")

      index = @goal.findIndexWithGivenGoalName(name)
      @goal.clickNthRow(index)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      @goal.selectStatus("Complete")
      @form.clickSaveButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      message = @modal.getConfirmationMessage
      expect(message.include?("Congratulations!")).to eq(true)
      expect(message.include?("You have completed the goal. Great work!")).to eq(true)
      expect(message.include?("Remember to reward your success.")).to eq(true)
      expect(message.include?("Please remember, completed Goals cannot be edited and all pending Notifications will be turned off.")).to eq(true)
      expect(message.include?("If you have not completed this goal, select RETURN to return to the edit the Goal Progress, Status, or Step Complete fields.")).to eq(true)
      expect(message.include?("Otherwise, select CONTINUE to continue saving.")).to eq(true)
    end

    it ".The personal reward field is valued - Status = Completed", :broken => true do
      @modal.clickReturnButton
      !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }

      @goal.setRewardAtCompletion("Take a trip to the beach")
      @form.clickSaveButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      message = @modal.getConfirmationMessage
      expect(message.include?("Congratulations!")).to eq(true)
      expect(message.include?("You have completed the goal. Great work!")).to eq(true)
      expect(message.include?("Remember to reward your success. You indicated your reward for completing this goal was:")).to eq(true)
      expect(message.include?("Take a trip to the beach."))
      expect(message.include?("Please remember, completed Goals cannot be edited and all pending Notifications will be turned off.")).to eq(true)
      expect(message.include?("If you have not completed this goal, select RETURN to return to the edit the Goal Progress, Status, or Step Complete fields.")).to eq(true)
      expect(message.include?("Otherwise, select CONTINUE to continue saving.")).to eq(true)

      @modal.clickContinueButton

      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      @goal.selectStatus("Complete")
      @date_filter.clickFilterBtn
      name = "Goal without reward"
      !45.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName(name)
      expect(index > -1).to eq(true)

      #completed Date
      expect(@goal.getNthDateCompleted(1)).to eq(@today.to_s)
      @goal.clickNthRow(index)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Complete", "statusOption_2")).to eq(true)
      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("100%")
      expect(@goal.getNthProgressBarValue(1)).to eq("100%")

      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014"]
      for i in 0..(stepAndDueDateArr.length - 1)
        data = stepAndDueDateArr[i].split(";")
        step = data[0]
        dueDate = data[1]

        expect(@goal.getNthStep(i + 1)).to eq(step.strip)
        expect(@goal.getNthStepDueDate(i + 1)).to eq(dueDate.strip)
        expect(@goal.isNthStepCompleteChecked(i + 1)).to eq(false)
      end

      @form.clickCancelButton
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

    end

    it ".The personal reward field is not valued - Steps - Completed", :broken => true do
      @goal.selectStatus("Active")
      @date_filter.clickFilterBtn
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      name = "Goal without reward: Steps completed"
      goalStartDate = "10/01/2014"
      goalEndDate = "07/01/2015"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014"]
      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "")

      index = @goal.findIndexWithGivenGoalName(name)
      @goal.clickNthRow(index)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")

      @goal.checkNthStepComplete(1)
      @goal.checkNthStepComplete(2)

      @form.clickSaveButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      message = @modal.getConfirmationMessage
      expect(message.include?("Congratulations!")).to eq(true)
      expect(message.include?("You have completed the goal. Great work!")).to eq(true)
      expect(message.include?("Remember to reward your success.")).to eq(true)
      expect(message.include?("Please remember, completed Goals cannot be edited and all pending Notifications will be turned off.")).to eq(true)
      expect(message.include?("If you have not completed this goal, select RETURN to return to the edit the Goal Progress, Status, or Step Complete fields.")).to eq(true)
      expect(message.include?("Otherwise, select CONTINUE to continue saving.")).to eq(true)
    end

    it ".The personal reward field is valued - Steps completed", :broken => true do
      @modal.clickReturnButton
      !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }

      @goal.setRewardAtCompletion("Take a trip to the beach")
      @form.clickSaveButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      message = @modal.getConfirmationMessage
      expect(message.include?("Congratulations!")).to eq(true)
      expect(message.include?("You have completed the goal. Great work!")).to eq(true)
      expect(message.include?("Remember to reward your success. You indicated your reward for completing this goal was:")).to eq(true)
      expect(message.include?("Take a trip to the beach."))
      expect(message.include?("Please remember, completed Goals cannot be edited and all pending Notifications will be turned off.")).to eq(true)
      expect(message.include?("If you have not completed this goal, select RETURN to return to the edit the Goal Progress, Status, or Step Complete fields.")).to eq(true)
      expect(message.include?("Otherwise, select CONTINUE to continue saving.")).to eq(true)

      @modal.clickContinueButton

      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      @goal.selectStatus("Complete")
      @date_filter.clickFilterBtn
      name = "Goal without reward: Steps completed"
      !45.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
      index = @goal.findIndexWithGivenGoalName(name)
      expect(index > -1).to eq(true)
      #completed Date
      expect(@goal.getNthDateCompleted(1)).to eq(@today.to_s)
      @goal.clickNthRow(index)
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Goal Entry")
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Complete", "statusOption_2")).to eq(true)
      expect(@goal.getNthProgressDate(1)).to eq(@today.to_s)
      expect(@goal.getNThGoalProgress(1)).to eq("100%")
      expect(@goal.getNthProgressBarValue(1)).to eq("100%")

      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014"]
      for i in 0..(stepAndDueDateArr.length - 1)
        data = stepAndDueDateArr[i].split(";")
        step = data[0]
        dueDate = data[1]

        expect(@goal.getNthStep(i + 1)).to eq(step.strip)
        expect(@goal.getNthStepDueDate(i + 1)).to eq(dueDate.strip)
        expect(@goal.isNthStepCompleteChecked(i + 1)).to eq(true)
      end

    end

  end

  def enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)
    @goal.setGoalName(name)
    @goal.setGoalStartDate(goalStartDate)
    @goal.setGoalEndDate(goalEndDate)

    stepsCount = stepsAndDueDateArr.length
    for i in 0..(stepsCount - 1 )
      if(@goal.isNthStepPresent(i + 1) == false)
        @goal.clickAddStepButton
      end

      #puts "steps and due date array: " + stepsAndDueDateArr[i]

      stepsAndDate = stepsAndDueDateArr[i]
      data = stepsAndDate.split(";")

      if (data[0].strip != "" and data[0].strip != nil)
        @goal.setNthStep(i + 1, data[0].strip)
      end

      if (data[1].strip != "" and data[1].strip != nil)
        @goal.setNthStepDueDate(i + 1, data[1].strip)
      end
    end
    @goal.setDescription(description)
    @goal.setRewardAtCompletion(reward)
  end

  def addGoal(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)
    @goal.clickAddButton()
    !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
    !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
    expect(getPrimaryHeader).to eq("Add Goal Entry")

    enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)

    @form.clickSaveButton
    !45.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
    expect(@goal.findIndexWithGivenGoalName(name) > -1).to eq(true)
  end

end
=end