require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2469:  Goal - Add]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("goals", "healthinventorydb")
    removeCollection("promptedresponses", "healthinventorydb")
    initializeAllObjects

    @tomorrow = getDateNthDaysFromNow(1,  "%m/%d/%Y")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @expectedValidationSummaryHeader = "The following errors were found:"

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyStory']").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader == "My Story"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Story")
  end

  after(:all) do
    quitDriver()
  end

  context '#AC #JRNL-2804|TC #JRNL-2919:  Goal - Add Button' do
    it ".When the user views the Goals Table list, an Add button (+ icon, alt text Add), is available in the upper right corner of the Detail screen." do
      @my_story.clickGoals
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")
      expect(@goal.isAddButtonVisible()).to eq(true)
      expect(@goal.isAddButtonRightJustified).to eq(true)
    end
  end

  context '#AC #JRNL-2806|TC #JRNL-2919:  Goals - Add Goal Detail Page' do
    it ".When a user selects Add, the Add Goal screen is shown in the Detail Screen, header: Add Goal Entry" do
      @goal.clickAddButton
      !5.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Add Goal Entry")
    end

    it ".Name of Goal" do
      expect(@goal.getGoalReflectionText).to eq("Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals.")
      expect(@goal.isGoalNameRequired).to eq(true)
      expect(@goal.getGoalNameLabel).to eq("* Name of Goal:")

      #default to null
      expect(@goal.getGoalName()).to eq("")

      goalName_10 = "1234567890"
      @goal.setGoalName(goalName_10)
      expect(@goal.getGoalName().length).to eq(10)

      goalName_50 = "12345678901234567890123456789012345678901234567890"
      @goal.setGoalName(goalName_50)
      expect(@goal.getGoalName().length).to eq(50)

      goalName_55 = "1234567890123456789012345678901234567890123456789012345"
      @goal.setGoalName(goalName_50)
      expect(@goal.getGoalName().length).to eq(50)
    end

    it ".Status (field is hidden on add entry screen, all new goals are saved in active status)" do
      expect(@goal.isStatusOptionPresent).to eq(false)
    end

    it ".Description" do
      expect(@goal.getDescriptionLabel).to eq("Description:")
      expect(@goal.isDescriptionRequired).to eq(false)
      expect(@goal.getDescription).to eq("")

      description_50 = "12345678901234567890123456789012345678901234567890"
      @goal.setDescription(description_50)
      expect(@goal.getDescription.length).to eq(50)

      description_150 = description_50 + description_50 + description_50
      @goal.setDescription(description_150)
      expect(@goal.getDescription.length).to eq(150)

      description_200 = description_50 + description_50 + description_50 + description_50
      @goal.setDescription(description_150)
      expect(@goal.getDescription.length).to eq(150)
    end

    it ".Goal Start Date" do
      expect(@goal.isGoalStartDateRequired).to eq(true)

      #default: Today
      expect(@goal.getStartDateGuidanceText).to eq("MM/DD/YYYY")

      #Input behavior: Constrain fields to match format; prevent invalid month or day entry
      @goal.setGoalStartDate("06/32")
      expect(@goal.getGoalStartDate).to eq("06/3")

      @goal.setGoalStartDate("10/00/2")
      expect(@goal.getGoalStartDate).to eq("10/02")

      #Business Rules:  Cannot be after End Date
      @goal.setGoalEndDate(@today)
      @goal.setGoalStartDate(@tomorrow)

      @form.clickSaveButtonJump
      !5.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Goal Start Date must occur before Goal End Date.")).to eq(true)

    end

    it ".Goal End Date", :broken => true do
      @goal.clickBackButton

      !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      @modal.clickContinueButton
      !5.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      @goal.clickAddButton
      !5.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }

      expect(getPrimaryHeader).to eq("Add Goal Entry")

      expect(@goal.isGoalEndDateRequired).to eq(true)
      expect(@goal.getEndDateGuidanceText).to eq("MM/DD/YYYY")
      #default : null
      expect(@goal.getGoalEndDate).to eq("")

      #Input behavior: Constrain fields to match format; prevent invalid month or day entry
      @goal.setGoalEndDate("10/32")
      expect(@goal.getGoalEndDate).to eq("10/3")

      @goal.setGoalEndDate("10/00/2")
      expect(@goal.getGoalEndDate).to eq("10/02")

      #Business Rules:Cannot be before Start Date
      @goal.setGoalStartDate(@tomorrow)
      @goal.setGoalEndDate(@today)

      @form.clickSaveButton
      !5.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Goal Start Date must occur before Goal End Date.")).to eq(true)

      @goal.setGoalName("Goal without Steps")
      @goal.setGoalStartDate("10/01/2014")
      @goal.setGoalEndDate("09/02/2015")
      @goal.setDescription("Just do it")
      @form.clickSaveButton
      !5.times{ break if (@goal.findIndexWithGivenGoalName("Goal without Steps") > -1); sleep 1 }
    end

    it ".Reward at Completion", :broken => true do
      waitForPageToFinishLoading
      @goal.clickAddButton
      waitForPageToFinishLoading
      !5.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }

      expect(getPrimaryHeader).to eq("Add Goal Entry")

      @goal.setGoalName("Goal with Reward at completion")
      @goal.setGoalStartDate("10/23/2014")
      @goal.setGoalEndDate("08/02/2015")

      expect(@goal.getRewardLabel).to eq("Reward at Completion:")
      #default: null
      expect(@goal.getRewardAtCompletion).to eq("")

      reward_20 = "12345678901234567890"
      @goal.setRewardAtCompletion(reward_20)
      expect(@goal.getRewardAtCompletion().length).to eq(20)

      reward_100 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @goal.setRewardAtCompletion(reward_100)
      expect(@goal.getRewardAtCompletion().length).to eq(100)

      reward_120 = reward_100 + reward_20
      @goal.setRewardAtCompletion(reward_120)
      expect(@goal.getRewardAtCompletion().length).to eq(100)

      @form.clickSaveButton
      !5.times{ break if (@goal.findIndexWithGivenGoalName("Goal with Reward at completion") > -1); sleep 1 }
      expect(@goal.findIndexWithGivenGoalName("Goal with Reward at completion") > -1).to eq(true)
    end

    it ".Steps", :broken => true do
      #When a user views the detail screen, Steps field, the system displays an Add Step button
      #below the repeatable data entry fields: Step #<#>, Step Due Date.
      @goal.clickAddButton
      !5.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }

      expect(getPrimaryHeader).to eq("Add Goal Entry")

      @goal.setGoalName("Goal with Reward at completion")
      @goal.setGoalStartDate("10/22/2014")
      @goal.setGoalEndDate("10/01/2015")

      expect(@goal.getStepsLabel).to eq("Steps:")
      expect(@goal.getNthStepLabel(1)).to eq("Step #1:")
      expect(@goal.getNThDueDateLabel(1)).to eq("Due Date #1: M M / D D / Y Y Y Y:\nDue Date #1:")
      expect(@goal.isNthDeleteStepPresent(1)).to eq(false)

      expect(@goal.getNthStep(1)).to eq("")

      @goal.setNthStepDueDate(1, "10/07/2014")
      @form.clickSaveButton

      !5.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Step #1 field is required.")).to eq(true)

      @goal.setNthStepDueDate(1, "")

      #step textbox 50 characters
      step_10 = "1234567890"
      @goal.setNthStep(1, step_10)
      expect(@goal.getNthStep(1).length).to eq(10)

      step_50 = "12345678901234567890123456789012345678901234567890"
      @goal.setNthStep(1, step_50)
      expect(@goal.getNthStep(1).length).to eq(50)

      step_60 = step_50 + step_10
      @goal.setNthStep(1, step_60)
      expect(@goal.getNthStep(1).length).to eq(50)

      expect(@goal.isAddStepBtnVisible).to eq(true)
      #a.	Alt text same as label
      expect(@goal.getAddStepBtnText).to eq("Add Step")
      #Selecting the Add Step button, adds another data entry field below the last field.
      @goal.clickAddStepButton
      !5.times{ break if (@goal.getNthStepLabel(2) == "Step #2:"); sleep 1 }

      expect(@goal.getNthStepLabel(2)).to eq("Step #2:")
      expect(@goal.getNThDueDateLabel(2)).to eq("Due Date #2: M M / D D / Y Y Y Y:\nDue Date #2:")
      expect(@goal.isNthStepFocused(2)).to eq(true)

      #If more than one repeated field is added a delete button is added next to each field
      expect(@goal.isNthDeleteStepPresent(1)).to eq(true)
      expect(@goal.isNthDeleteStepPresent(2)).to eq(true)
      #Button label = “x Delete”, alt text reads: Delete Step # (#) fields
      expect(@goal.getNthDeleteStepButtonLabel(1)).to eq("Delete")
      expect(@goal.getNthDeleteStepButtonLabel(2)).to eq("Delete")

      expect(@goal.getNthDeleteStepButtonAltText(1)).to eq("Delete Step #1 fields")
      expect(@goal.getNthDeleteStepButtonAltText(2)).to eq("Delete Step #2 fields")

      @goal.clickAddStepButton
      !5.times{ break if (@goal.getNthStepLabel(3) == "Step #3:"); sleep 1 }
      expect(@goal.getNthStepLabel(3)).to eq("Step #3:")
      expect(@goal.getNThDueDateLabel(3)).to eq("Due Date #3: M M / D D / Y Y Y Y:\nDue Date #3:")
      expect(@goal.getNthDeleteStepButtonAltText(3)).to eq("Delete Step #3 fields")
      expect(@goal.isNthStepFocused(3)).to eq(true)
      expect(@goal.getStepsCount).to eq(3)
      #Delete may occur in any order and are not confirmed (no modal is shown)
      @goal.clickNthDeleteStepButton(2)
      !5.times{ break if (@goal.getStepsCount() == 2); sleep 1 }
      expect(@goal.getStepsCount).to eq(2)

      expect(@goal.getNthDeleteStepButtonAltText(1)).to eq("Delete Step #1 fields")
      expect(@goal.getNthDeleteStepButtonAltText(2)).to eq("Delete Step #2 fields")
      expect(@goal.isNthDeleteStepPresent(1)).to eq(true)
      expect(@goal.isNthDeleteStepPresent(2)).to eq(true)

      @goal.clickNthDeleteStepButton(1)
      !5.times{ break if (@goal.getStepsCount() == 1); sleep 1 }
      expect(@goal.getStepsCount).to eq(1)
      #When only one repeatable field is shown the delete option is removed.
      expect(@goal.isNthDeleteStepPresent(1)).to eq(false)
    end

    it ".Due Date", :broken => true do
      #Required only if Step# text field is valued
      name = "Walk 30 min everyday"
      goalStartDate = "09/30/2014"
      goalEndDate = "04/01/2015"
      #  step;date
      stepAndDueDateArr = ["Walk 30 min;"]
      expectedError = ["Due Date #1 field is required."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "",  expectedError)

      expect(@goal.getNthDueDateGuidanceText(1)).to eq("MM/DD/YYYY")

      @goal.setNthStepDueDate(1, "09/35/2014")
      expect(@goal.getNthStepDueDate(1)).to eq("09/30/")

      @goal.setNthStepDueDate(1, "10/40/2014")
      expect(@goal.getNthStepDueDate(1)).to eq("10/02/")

      name = "Walk 30 min everyday"
      goalStartDate = "09/30/2014"
      goalEndDate = "04/01/2015"
      #  step;date
      stepAndDueDateArr = ["Walk 30 min;10/40/2014"]
      expectedError = ["Due Date #1 must be formatted MM/DD/YYYY."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr,"", "", expectedError)

      name = "Walk 30 min everyday"
      goalStartDate = "09/30/2014"
      goalEndDate = "04/01/2015"
      #  step;date
      stepAndDueDateArr = ["Walk 30 min;09/31/2014"]
      expectedError = ["Due Date #1 is an invalid date."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "",  expectedError)

      #Must be on or between Goal Start Date and Goal End Date
      name = "Walk 30 min everyday"
      goalStartDate = "09/24/2014"
      goalEndDate = "11/24/2014"
      #  step;date
      stepAndDueDateArr = ["Walk 10k every day;09/23/2014"]
      expectedError = ["Step Due Dates must fall within or on the Goal’s Start Date and End Date range."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "", expectedError)

      stepAndDueDateArr = ["Walk 10k every day;11/25/2014"]
      expectedError = ["Step Due Dates must fall within or on the Goal’s Start Date and End Date range."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "",  expectedError)

      name = "Walk 10k"
      goalStartDate = "10/01/2014"
      goalEndDate = "10/01/2015"
      #  step;date
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;12/13/2014", "Step 3;02/13/2015", "Step 4;04/13/2015", "Step 5;03/18/2015", "Step 6;03/17/2015", "Step 7;10/01/2015", "Step 8;09/12/2015", "Step9;12/01/2014", "Step 10;12/23/2014"]
      expectedError = ["Steps must be entered in sequential order based on the Step Due Date."]
      #addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "",  expectedError)

      stepAndDueDateArr = ["Step 1;10/04/2014", ";", "Step 3;10/13/2014", ";", "Step 5;11/18/2014", "Step 6;12/29/2014", "Step 7;01/01/2015", "Step 8;03/26/2015", "Step9;05/03/2015", "Step 10;09/23/2015"]
      expectedError = ["Steps must be entered in sequential order based on the Step Due Date."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "",  expectedError)

      name = "New Goal with 10 Steps"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014", "Step4;11/01/2014", "Step 5;11/18/2014", "Step 6;12/29/2014", "Step 7;01/01/2015", "Step 8;03/26/2015", "Step9;05/03/2015", "Step 10;06/23/2015"]

      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "")

      @goal.clickAddButton
      !5.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
      !5.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Add Goal Entry")

      @form.clickCancelButton
      !5.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")
    end
  end

  def enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)
    @goal.setGoalName(name)
    @goal.setGoalStartDate(goalStartDate)
    @goal.setGoalEndDate(goalEndDate)

    stepsCount = stepsAndDueDateArr.length
    for i in 0..(stepsCount - 1 )
      if(@goal.isNthStepPresent(i + 1) == false)
        @goal.clickAddStepButton
      end

      #puts "steps and due date array: " + stepsAndDueDateArr[i]

      stepsAndDate = stepsAndDueDateArr[i]
      data = stepsAndDate.split(";")
      step = data[0]
      date = data[1]

      @goal.setNthStep(i + 1, step)
      @goal.setNthStepDueDate(i + 1, date)
    end
    @goal.setDescription(description)
    @goal.setRewardAtCompletion(reward)
  end

  def addGoal(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)
    enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)

    @form.clickSaveButton
    !5.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
    expect(@goal.findIndexWithGivenGoalName(name) > -1).to eq(true)
  end

  def addGoalEndOnError(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward, expectedError)

    enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)

    @form.clickSaveButton
    !5.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
    expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
  end
end
















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2469:  Goal - Add]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("goals", "healthinventorydb")
    removeCollection("promptedresponses", "healthinventorydb")
    initializeAllObjects

    @tomorrow = getDateNthDaysFromNow(1,  "%m/%d/%Y")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @expectedValidationSummaryHeader = "The following errors were found:"

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory
    !45.times{ break if (getSecondaryHeader == "My Story"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Story")

  end

  after(:all) do
    quitDriver()
  end

  context '#AC #JRNL-2804|TC #JRNL-2919:  Goal - Add Button' do
    it ".When the user views the Goals Table list, an Add button (+ icon, alt text Add), is available in the upper right corner of the Detail screen." do
      @my_story.clickGoals
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")
      expect(@goal.isAddButtonVisible()).to eq(true)
      expect(@goal.isAddButtonRightJustified).to eq(true)
    end
  end

  context '#AC #JRNL-2806|TC #JRNL-2919:  Goals - Add Goal Detail Page' do
    it ".When a user selects Add, the Add Goal screen is shown in the Detail Screen, header: Add Goal Entry" do
      @goal.clickAddButton
      !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Add Goal Entry")

    end

    it ".Name of Goal" do
      expect(@goal.getGoalReflectionText).to eq("Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals.")
      expect(@goal.isGoalNameRequired).to eq(true)
      expect(@goal.getGoalNameLabel).to eq("* Name of Goal:")

      #default to null
      expect(@goal.getGoalName()).to eq("")

      goalName_10 = "1234567890"
      @goal.setGoalName(goalName_10)
      expect(@goal.getGoalName().length).to eq(10)

      goalName_50 = "12345678901234567890123456789012345678901234567890"
      @goal.setGoalName(goalName_50)
      expect(@goal.getGoalName().length).to eq(50)

      goalName_55 = "1234567890123456789012345678901234567890123456789012345"
      @goal.setGoalName(goalName_50)
      expect(@goal.getGoalName().length).to eq(50)
    end

    it ".Status (field is hidden on add entry screen, all new goals are saved in active status)" do
      expect(@goal.isStatusOptionPresent).to eq(false)
    end

    it ".Description" do
      expect(@goal.getDescriptionLabel).to eq("Description:")
      expect(@goal.isDescriptionRequired).to eq(false)
      expect(@goal.getDescription).to eq("")

      description_50 = "12345678901234567890123456789012345678901234567890"
      @goal.setDescription(description_50)
      expect(@goal.getDescription.length).to eq(50)

      description_150 = description_50 + description_50 + description_50
      @goal.setDescription(description_150)
      expect(@goal.getDescription.length).to eq(150)

      description_200 = description_50 + description_50 + description_50 + description_50
      @goal.setDescription(description_150)
      expect(@goal.getDescription.length).to eq(150)
    end

    it ".Goal Start Date" do

      ####################################################################################################################
      ############################# THE LABEL FOR GOAL START DATE HAS BEEN REMOVED IN THE APP  ###########################
      ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
      ####################################################################################################################

      # expect(@goal.getStartDateLabel).to eq("* Goal Start Date:")

      ####################################################################################################################
      ############################# THE LABEL FOR GOAL START DATE HAS BEEN REMOVED IN THE APP  ###########################
      ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
      ####################################################################################################################

      expect(@goal.isGoalStartDateRequired).to eq(true)

      #default: Today
      expect(@goal.getGoalStartDate).to eq(@today)
      expect(@goal.getStartDateGuidanceText).to eq("MM/DD/YYYY")

      #Input behavior: Constrain fields to match format; prevent invalid month or day entry
      @goal.setGoalStartDate("06/32")
      expect(@goal.getGoalStartDate).to eq("06/3")

      @goal.setGoalStartDate("10/00/2")
      expect(@goal.getGoalStartDate).to eq("10/02")

      #Business Rules:  Cannot be after End Date
      @goal.setGoalEndDate(@today)
      @goal.setGoalStartDate(@tomorrow)

      @form.clickSaveButtonJump
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Goal Start Date must occur before Goal End Date.")).to eq(true)

    end

    it ".Goal End Date", :broken => true do
      @goal.clickBackButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton
      !45.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

      @goal.clickAddButton
      !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }

      expect(getPrimaryHeader).to eq("Add Goal Entry")


      ####################################################################################################################
      ############################# THE LABEL FOR GOAL START DATE HAS BEEN REMOVED IN THE APP  ###########################
      ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
      ####################################################################################################################

      # expect(@goal.getStartDateLabel).to eq("* Goal Start Date:")

      ####################################################################################################################
      ############################# THE LABEL FOR GOAL START DATE HAS BEEN REMOVED IN THE APP  ###########################
      ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
      ####################################################################################################################

      expect(@goal.isGoalEndDateRequired).to eq(true)
      expect(@goal.getEndDateGuidanceText).to eq("MM/DD/YYYY")
      #default : null
      expect(@goal.getGoalEndDate).to eq("")

      #Input behavior: Constrain fields to match format; prevent invalid month or day entry
      @goal.setGoalEndDate("10/32")
      expect(@goal.getGoalEndDate).to eq("10/3")

      @goal.setGoalEndDate("10/00/2")
      expect(@goal.getGoalEndDate).to eq("10/02")

      #Business Rules:Cannot be before Start Date
      @goal.setGoalStartDate(@tomorrow)
      @goal.setGoalEndDate(@today)

      @form.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Goal Start Date must occur before Goal End Date.")).to eq(true)

      @goal.setGoalName("Goal without Steps")
      @goal.setGoalStartDate("10/01/2014")
      @goal.setGoalEndDate("09/02/2015")
      @goal.setDescription("Just do it")
      @form.clickSaveButton
      !45.times{ break if (@goal.findIndexWithGivenGoalName("Goal without Steps") > -1); sleep 1 }
      expect(@goal.findIndexWithGivenGoalName("Goal without Steps") > -1).to eq(true)

    end

    it ".Reward at Completion", :broken => true do
      @goal.clickAddButton
      !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }

      expect(getPrimaryHeader).to eq("Add Goal Entry")

      @goal.setGoalName("Goal with Reward at completion")
      @goal.setGoalStartDate("10/23/2014")
      @goal.setGoalEndDate("08/02/2015")

      expect(@goal.getRewardLabel).to eq("Reward at Completion:")
      #default: null
      expect(@goal.getRewardAtCompletion).to eq("")

      reward_20 = "12345678901234567890"
      @goal.setRewardAtCompletion(reward_20)
      expect(@goal.getRewardAtCompletion().length).to eq(20)

      reward_100 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @goal.setRewardAtCompletion(reward_100)
      expect(@goal.getRewardAtCompletion().length).to eq(100)

      reward_120 = reward_100 + reward_20
      @goal.setRewardAtCompletion(reward_120)
      expect(@goal.getRewardAtCompletion().length).to eq(100)

      @form.clickSaveButton
      !45.times{ break if (@goal.findIndexWithGivenGoalName("Goal with Reward at completion") > -1); sleep 1 }
      expect(@goal.findIndexWithGivenGoalName("Goal with Reward at completion") > -1).to eq(true)

    end

    it ".Steps", :broken => true do
      #When a user views the detail screen, Steps field, the system displays an Add Step button
      #below the repeatable data entry fields: Step #<#>, Step Due Date.
      @goal.clickAddButton
      !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }

      expect(getPrimaryHeader).to eq("Add Goal Entry")

      @goal.setGoalName("Goal with Reward at completion")
      @goal.setGoalStartDate("10/22/2014")
      @goal.setGoalEndDate("10/01/2015")

      expect(@goal.getStepsLabel).to eq("Steps:")
      expect(@goal.getNthStepLabel(1)).to eq("Step #1:")
      expect(@goal.getNThDueDateLabel(1)).to eq("Due Date #1:")
      expect(@goal.isNthDeleteStepPresent(1)).to eq(false)

      expect(@goal.getNthStep(1)).to eq("")

      @goal.setNthStepDueDate(1, "10/07/2014")
      @form.clickSaveButton

      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Step #1 field is required.")).to eq(true)

      @goal.setNthStepDueDate(1, "")

      #step textbox 50 characters
      step_10 = "1234567890"
      @goal.setNthStep(1, step_10)
      expect(@goal.getNthStep(1).length).to eq(10)

      step_50 = "12345678901234567890123456789012345678901234567890"
      @goal.setNthStep(1, step_50)
      expect(@goal.getNthStep(1).length).to eq(50)

      step_60 = step_50 + step_10
      @goal.setNthStep(1, step_60)
      expect(@goal.getNthStep(1).length).to eq(50)

      expect(@goal.isAddStepBtnVisible).to eq(true)
      #a.	Alt text same as label
      expect(@goal.getAddStepBtnText).to eq("Add Step")
      #Selecting the Add Step button, adds another data entry field below the last field.
      @goal.clickAddStepButton
      !45.times{ break if (@goal.getNthStepLabel(2) == "Step #2:"); sleep 1 }

      expect(@goal.getNthStepLabel(2)).to eq("Step #2:")
      expect(@goal.getNThDueDateLabel(2)).to eq("Due Date #2:")
      expect(@goal.isNthStepFocused(2)).to eq(true)

      #If more than one repeated field is added a delete button is added next to each field
      expect(@goal.isNthDeleteStepPresent(1)).to eq(true)
      expect(@goal.isNthDeleteStepPresent(2)).to eq(true)
      #Button label = “x Delete”, alt text reads: Delete Step # (#) fields
      expect(@goal.getNthDeleteStepButtonLabel(1)).to eq("Delete")
      expect(@goal.getNthDeleteStepButtonLabel(2)).to eq("Delete")

      expect(@goal.getNthDeleteStepButtonAltText(1)).to eq("Delete Step #1 fields")
      expect(@goal.getNthDeleteStepButtonAltText(2)).to eq("Delete Step #2 fields")

      @goal.clickAddStepButton
      !45.times{ break if (@goal.getNthStepLabel(3) == "Step #3:"); sleep 1 }
      expect(@goal.getNthStepLabel(3)).to eq("Step #3:")
      expect(@goal.getNThDueDateLabel(3)).to eq("Due Date #3:")
      expect(@goal.getNthDeleteStepButtonAltText(3)).to eq("Delete Step #3 fields")
      expect(@goal.isNthStepFocused(3)).to eq(true)
      expect(@goal.getStepsCount).to eq(3)
      #Delete may occur in any order and are not confirmed (no modal is shown)
      @goal.clickNthDeleteStepButton(2)
      !45.times{ break if (@goal.getStepsCount() == 2); sleep 1 }
      expect(@goal.getStepsCount).to eq(2)

      expect(@goal.getNthDeleteStepButtonAltText(1)).to eq("Delete Step #1 fields")
      expect(@goal.getNthDeleteStepButtonAltText(2)).to eq("Delete Step #2 fields")
      expect(@goal.isNthDeleteStepPresent(1)).to eq(true)
      expect(@goal.isNthDeleteStepPresent(2)).to eq(true)

      @goal.clickNthDeleteStepButton(1)
      !45.times{ break if (@goal.getStepsCount() == 1); sleep 1 }
      expect(@goal.getStepsCount).to eq(1)
      #When only one repeatable field is shown the delete option is removed.
      expect(@goal.isNthDeleteStepPresent(1)).to eq(false)

      #	Users can add up to 10 steps and the related step due date.
      for i in 2..10
        @goal.clickAddStepButton
        !45.times{ break if (@goal.getNthStepLabel(i) == "Step #" + i.to_s + ":"); sleep 1 }
      end

      #When the maximum number of repeatable fields are added, the Add Step button is removed.
      expect(@goal.isAddButtonVisible).to eq(false)
    end

    it ".Step # <sequential number of step as added in the UI>", :broken => true do
      for i in 1..10
        expect(@goal.getNthStepLabel(i)).to eq("Step #" + i.to_s + ":")
      end
    end

    it ".Due Date", :broken => true do
      #Required only if Step# text field is valued
      name = "Walk 30 min everyday"
      goalStartDate = "09/30/2014"
      goalEndDate = "04/01/2015"
      #  step;date
      stepAndDueDateArr = ["Walk 30 min;"]
      expectedError = ["Due Date #1 field is required."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "",  expectedError)

      expect(@goal.getNthDueDateGuidanceText(1)).to eq("MM/DD/YYYY")

      @goal.setNthStepDueDate(1, "09/35/2014")
      expect(@goal.getNthStepDueDate(1)).to eq("09/30")

      @goal.setNthStepDueDate(1, "10/40/2014")
      expect(@goal.getNthStepDueDate(1)).to eq("10/02")

      name = "Walk 30 min everyday"
      goalStartDate = "09/30/2014"
      goalEndDate = "04/01/2015"
      #  step;date
      stepAndDueDateArr = ["Walk 30 min;10/40/2014"]
      expectedError = ["Due Date #1 must be formatted MM/DD/YYYY."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr,"", "", expectedError)

      name = "Walk 30 min everyday"
      goalStartDate = "09/30/2014"
      goalEndDate = "04/01/2015"
      #  step;date
      stepAndDueDateArr = ["Walk 30 min;09/31/2014"]
      expectedError = ["Due Date #1 is an invalid date."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "",  expectedError)

      #Must be on or between Goal Start Date and Goal End Date
      name = "Walk 30 min everyday"
      goalStartDate = "09/24/2014"
      goalEndDate = "11/24/2014"
      #  step;date
      stepAndDueDateArr = ["Walk 10k every day;09/23/2014"]
      expectedError = ["Step Due Dates must fall within or on the Goal’s Start Date and End Date range."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "", expectedError)

      stepAndDueDateArr = ["Walk 10k every day;11/25/2014"]
      expectedError = ["Step Due Dates must fall within or on the Goal’s Start Date and End Date range."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "",  expectedError)

      name = "Walk 10k"
      goalStartDate = "10/01/2014"
      goalEndDate = "10/01/2015"
      #  step;date
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;12/13/2014", "Step 3;02/13/2015", "Step 4;04/13/2015", "Step 5;03/18/2015", "Step 6;03/17/2015", "Step 7;10/01/2015", "Step 8;09/12/2015", "Step9;12/01/2014", "Step 10;12/23/2014"]
      expectedError = ["Steps must be entered in sequential order based on the Step Due Date."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "",  expectedError)

      stepAndDueDateArr = ["Step 1;10/04/2014", ";", "Step 3;10/13/2014", ";", "Step 5;11/18/2014", "Step 6;12/29/2014", "Step 7;01/01/2015", "Step 8;03/26/2015", "Step9;05/03/2015", "Step 10;09/23/2015"]
      expectedError = ["Steps must be entered in sequential order based on the Step Due Date."]
      addGoalEndOnError(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "",  expectedError)

      name = "New Goal with 10 Steps"
      stepAndDueDateArr = ["Step 1;10/04/2014", "Step 2;10/29/2014", "Step 3;10/30/2014", "Step4;11/01/2014", "Step 5;11/18/2014", "Step 6;12/29/2014", "Step 7;01/01/2015", "Step 8;03/26/2015", "Step9;05/03/2015", "Step 10;06/23/2015"]

      addGoal(name, goalStartDate, goalEndDate, stepAndDueDateArr, "", "")

      @goal.clickAddButton
      !45.times{ break if (getPrimaryHeader == "Add Goal Entry"); sleep 1 }
      !45.times{ break if (@goal.getGoalReflectionText == "Reflect on your life after using the other features of My Story. This vision will establish context and help you set goals."); sleep 1 }
      expect(getPrimaryHeader).to eq("Add Goal Entry")

      @form.clickCancelButton
      !45.times{ break if (getPrimaryHeader == "Goals"); sleep 1 }
      expect(getPrimaryHeader).to eq("Goals")

    end
  end

  def enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)
    @goal.setGoalName(name)
    @goal.setGoalStartDate(goalStartDate)
    @goal.setGoalEndDate(goalEndDate)

    stepsCount = stepsAndDueDateArr.length
    for i in 0..(stepsCount - 1 )
      if(@goal.isNthStepPresent(i + 1) == false)
        @goal.clickAddStepButton
      end

      #puts "steps and due date array: " + stepsAndDueDateArr[i]

      stepsAndDate = stepsAndDueDateArr[i]
      data = stepsAndDate.split(";")
      step = data[0]
      date = data[1]

      @goal.setNthStep(i + 1, step)
      @goal.setNthStepDueDate(i + 1, date)
    end
    @goal.setDescription(description)
    @goal.setRewardAtCompletion(reward)
  end

  def addGoal(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)
    enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)

    @form.clickSaveButton
    !45.times{ break if (@goal.findIndexWithGivenGoalName(name) > -1); sleep 1 }
    expect(@goal.findIndexWithGivenGoalName(name) > -1).to eq(true)
  end

  def addGoalEndOnError(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward, expectedError)

    enterData(name, goalStartDate, goalEndDate, stepsAndDueDateArr, description, reward)

    @form.clickSaveButton
    !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
    expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)

    for i in 0..(expectedError.length - 1)
      expect(@error.isErrorMessageDisplayed("form", expectedError[i])).to eq(true)
    end
  end
end
=end