require_relative '../../globalized'
include Globalized

describe "[ Story #JRNL-2520: Assessments - Well-being  ]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("assessments", "healthinventorydb")
    initializeAllObjects

    !5.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !5.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !5.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient05")

    !5.times{ break if (@main.getFooterText() == "Logged in as patient05, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isMyStoryButtonVisible).to eq(true)
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyStory']").click
    waitForPageToFinishLoading
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3179|TC #JRNL-3263: Until a value is entered (in any section), the 'Save Changes' button is disabled, and the disabled status is conveyed by the screen reader" do
    @my_story.clickAssessment
    !5.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    expect(@my_story.isWellBeingAccordion_Expanded).to eq(false)
    @my_story.clickWellBeing()
    !5.times{ break if (@my_story.getWellBeingInfoText == "On the following scales from 1-5, with 1 being miserable and 5 being great, select where you feel you are on the scale."); sleep 1 }

    expect(@my_story.isSaveChangesDisabled).to eq(true)
    expect(@my_story.isWellBeingAccordion_Expanded).to eq(true)
  end

  it "AC #JRNL-3181|TC #JRNL-3263: When the user makes a change to the state of any input (in any section), the 'Save Changes' button becomes enabled on the right-hand of the title bar" do
    @my_story.selectMentalWellBeing("2")

    !5.times{ break if (@my_story.isSaveChangesDisabled == false); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.selectMentalWellBeing("Select")

    !5.times{ break if (@my_story.isSaveChangesDisabled == false); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(false)
  end

  it "AC #JRNL-3182|TC #JRNL-3263: Upon saving using the 'Save Changes' button, the page is refreshed" do
    @my_story.selectMentalWellBeing("4")
    @my_story.selectPhysicalWellBeing("2")
    @my_story.selectDayToDayLife("1")

    @my_story.clickSaveChangesBtn
    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !5.times{ break if (@my_story.getWellBeing_LastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }

    expect(@my_story.getWellBeing_LastUpdatedDate).to eq("Last updated: " + today.to_s)
    expect(@my_story.getMentalWellBeingValue).to eq("4")
    expect(@my_story.getPhysicalWellBeingValue).to eq("2")
    expect(@my_story.getDayToDayLifeValue).to eq("1")
    expect(@my_story.isWellBeingAccordion_Expanded).to eq(true)
  end

  it "AC #JRNL-3183|TC #JRNL-3263: After an initial submission users are presented their most recently submitted answers within each section" do
    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    expect(@my_story.getWellBeing_LastUpdatedDate).to eq("Last updated: " + today.to_s)
  end

  it "AC #JRNL-3192|TC #JRNL-3263: Once a user makes a change, the 'Save Changes' button is enabled in the title bar", :broken => true do

    fiveDaysAgo = (Time.now - 5.days)
    updateWellBeingUpdatedDate(fiveDaysAgo, "D123401")
    refreshBrowser

    @my_story.clickWellBeing
    !5.times{ break if (@my_story.getWellBeing_LastUpdatedDate == "Last updated: " + fiveDaysAgo.strftime("%m/%d/%Y").to_s); sleep 1 }
    expect(@my_story.getMentalWellBeingValue).to eq("")
    expect(@my_story.getPhysicalWellBeingValue).to eq("")
    expect(@my_story.getDayToDayLifeValue).to eq("")

    @my_story.selectMentalWellBeing("1")
    @my_story.clickSaveChangesBtn

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !5.times{ break if (@my_story.getWellBeing_LastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }

    expect(@my_story.getMentalWellBeingValue).to eq("1")
    expect(@my_story.getPhysicalWellBeingValue).to eq("")
    expect(@my_story.getDayToDayLifeValue).to eq("")

    expect(@my_story.getWellBeing_LastUpdatedDate).to eq("Last updated: " + today.to_s)

    @my_story.selectPhysicalWellBeing("Select")
    @my_story.clickSaveChangesBtn
    !5.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }
    !5.times{ break if (@my_story.getWellBeing_LastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
    expect(@my_story.getPhysicalWellBeingValue).to eq("")
    expect(@my_story.getWellBeing_LastUpdatedDate).to eq("Last updated: " + today.to_s)
  end

  it "AC #JRNL-3203|TC #JRNL-3263: User is presented the Well-being section as the first accordion ('Well-being' label) in the assessment section" do
    expect(@my_story.getNthAccordionName(1).include?("Well-being")).to eq(true)
    expect(@my_story.getWellBeingInfoText).to eq("On the following scales from 1-5, with 1 being miserable and 5 being great, select where you feel you are on the scale.")
  end

  it "Improvement #MVAH-838|TC #JRNL-2756: Additional Language for 'Well-being' section of the assessment " do
    expect(@my_story.getWellBeingHotLineInfoText).to eq("If you ever have a crisis, call the Crisis Hotline 1-800-273-8255 and Press 1 to receive confidential support 24 hours a day, 7 days a week, 365 days a year.")
  end

  it "AC #JRNL-3239|TC #JRNL-3263: Prompt for Unsaved Changes" do
    expect(@my_story.getDayToDayLifeValue).to eq("")
    @my_story.selectDayToDayLife("5")
    @my_story.clickPersonalValues
    !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")

    @modal.clickReturnButton()
    !5.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }

    expect(@my_story.getDayToDayLifeValue).to eq("5")

    @my_story.clickSummary
    !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")

    @modal.clickContinueButton
    !5.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }
    !5.times{ break if (@my_story.getPrimaryHeader == "Summary"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Summary")

    @my_story.clickAssessment
    !5.times{ break if (@my_story.isAccordionCollapsed("Well-being") == true); sleep 1 }
    expect(@my_story.isAccordionCollapsed("Well-being")).to eq(true)

    @my_story.clickWellBeing()
    !5.times{ break if (@my_story.getWellBeingInfoText == "On the following scales from 1-5, with 1 being miserable and 5 being great, select where you feel you are on the scale."); sleep 1 }
    expect(@my_story.getDayToDayLifeValue).to eq("")
  end
end










































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized

describe "[ Story #JRNL-2520: Assessments - Well-being  ]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("assessments", "healthinventorydb")
    initializeAllObjects

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isMyStoryButtonVisible).to eq(true)

    @nav_menu.clickMyStory

    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3179|TC #JRNL-3263: Until a value is entered (in any section), the 'Save Changes' button is disabled, and the disabled status is conveyed by the screen reader" do
    @my_story.clickAssessment
    !45.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    expect(@my_story.isWellBeingAccordion_Expanded).to eq(false)
    @my_story.clickWellBeing()
    !45.times{ break if (@my_story.getWellBeingInfoText == "On the following scales from 1-5, with 1 being miserable and 5 being great, select where you feel you are on the scale."); sleep 1 }

    expect(@my_story.isSaveChangesDisabled).to eq(true)
    expect(@my_story.isWellBeingAccordion_Expanded).to eq(true)


  end

  it "AC #JRNL-3181|TC #JRNL-3263: When the user makes a change to the state of any input (in any section), the 'Save Changes' button becomes enabled on the right-hand of the title bar" do
    @my_story.selectMentalWellBeing("2")

    !45.times{ break if (@my_story.isSaveChangesDisabled == false); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(false)

    @my_story.selectMentalWellBeing("Select")

    !45.times{ break if (@my_story.isSaveChangesDisabled == false); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(false)

  end

  it "AC #JRNL-3182|TC #JRNL-3263: Upon saving using the 'Save Changes' button, the page is refreshed" do
    @my_story.selectMentalWellBeing("4")
    @my_story.selectPhysicalWellBeing("2")
    @my_story.selectDayToDayLife("1")

    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !45.times{ break if (@my_story.getWellBeing_LastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }

    expect(@my_story.getWellBeing_LastUpdatedDate).to eq("Last updated: " + today.to_s)
    expect(@my_story.getMentalWellBeingValue).to eq("4")
    expect(@my_story.getPhysicalWellBeingValue).to eq("2")
    expect(@my_story.getDayToDayLifeValue).to eq("1")

    expect(@my_story.isWellBeingAccordion_Expanded).to eq(true)

  end

  it "AC #JRNL-3183|TC #JRNL-3263: After an initial submission users are presented their most recently submitted answers within each section" do
    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    expect(@my_story.getWellBeing_LastUpdatedDate).to eq("Last updated: " + today.to_s)
  end

  it "AC #JRNL-3192|TC #JRNL-3263: Once a user makes a change, the 'Save Changes' button is enabled in the title bar", :broken => true do

    fiveDaysAgo = (Time.now - 5.days)
    updateWellBeingUpdatedDate(fiveDaysAgo, "D123401")
    refreshBrowser

    @my_story.clickWellBeing
    !45.times{ break if (@my_story.getWellBeing_LastUpdatedDate == "Last updated: " + fiveDaysAgo.strftime("%m/%d/%Y").to_s); sleep 1 }
    expect(@my_story.getWellBeing_LastUpdatedDate).to eq("Last updated: " + fiveDaysAgo.strftime("%m/%d/%Y").to_s)
    expect(@my_story.getMentalWellBeingValue).to eq("4")
    expect(@my_story.getPhysicalWellBeingValue).to eq("2")
    expect(@my_story.getDayToDayLifeValue).to eq("1")

    @my_story.selectMentalWellBeing("1")
    @my_story.clickSaveChangesBtn

    today = getDateNthDaysAgo(0,"%m/%d/%Y")
    !45.times{ break if (@my_story.getWellBeing_LastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }

    expect(@my_story.getMentalWellBeingValue).to eq("1")
    expect(@my_story.getPhysicalWellBeingValue).to eq("2")
    expect(@my_story.getDayToDayLifeValue).to eq("1")

    expect(@my_story.getWellBeing_LastUpdatedDate).to eq("Last updated: " + today.to_s)

    @my_story.selectPhysicalWellBeing("Select")
    @my_story.clickSaveChangesBtn
    !45.times{ break if (@my_story.isSaveChangesDisabled == true); sleep 1 }
    !45.times{ break if (@my_story.getWellBeing_LastUpdatedDate == "Last updated: " + today.to_s); sleep 1 }
    expect(@my_story.isSaveChangesDisabled).to eq(true)
    expect(@my_story.getPhysicalWellBeingValue).to eq("")
    expect(@my_story.getWellBeing_LastUpdatedDate).to eq("Last updated: " + today.to_s)

  end

  it "AC #JRNL-3203|TC #JRNL-3263: User is presented the Well-being section as the first accordion ('Well-being' label) in the assessment section" do
    expect(@my_story.getNthAccordionName(1).include?("Well-being")).to eq(true)
    expect(@my_story.getWellBeingInfoText).to eq("On the following scales from 1-5, with 1 being miserable and 5 being great, select where you feel you are on the scale.")
  end

  it "Improvement #MVAH-838|TC #JRNL-2756: Additional Language for 'Well-being' section of the assessment " do
    expect(@my_story.getWellBeingHotLineInfoText).to eq("If you ever have a crisis, call the Crisis Hotline 1-800-273-8255 and Press 1 to receive confidential support 24 hours a day, 7 days a week, 365 days a year.")
  end

  it "AC #JRNL-3239|TC #JRNL-3263: Prompt for Unsaved Changes" do
    expect(@my_story.getDayToDayLifeValue).to eq("1")
    @my_story.selectDayToDayLife("5")
    @my_story.clickPersonalValues

    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")

    ################################################################################################################################################################################################################
    # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
    ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
    ################################################################################################################################################################################################################

    # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    ################################################################################################################################################################################################################
    # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
    ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
    ################################################################################################################################################################################################################

    @modal.clickReturnButton()
    !45.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }

    expect(@my_story.getDayToDayLifeValue).to eq("5")

    @my_story.clickSummary
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")

    ################################################################################################################################################################################################################
    # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
    ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
    ################################################################################################################################################################################################################

    # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

    ################################################################################################################################################################################################################
    # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
    ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
    ################################################################################################################################################################################################################

    @modal.clickContinueButton
    !45.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }
    !45.times{ break if (@my_story.getPrimaryHeader == "Summary"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Summary")

    @my_story.clickAssessment
    !45.times{ break if (@my_story.isAccordionCollapsed("Well-being") == true); sleep 1 }
    expect(@my_story.isAccordionCollapsed("Well-being")).to eq(true)

    @my_story.clickWellBeing()
    !45.times{ break if (@my_story.getWellBeingInfoText == "On the following scales from 1-5, with 1 being miserable and 5 being great, select where you feel you are on the scale."); sleep 1 }
    expect(@my_story.getDayToDayLifeValue).to eq("1")
  end
end
=end