require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2517:  Assessment History]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("assessments", "healthinventorydb", "assessments_history")
    initializeAllObjects

    @windowSize = getWindowSize()

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyStory']").click
    waitForPageToFinishLoading
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

    @my_story.clickAssessment
    !5.times{ break if (@my_story.isHistoryButtonVisible == true ); sleep 1 }
     expect(@my_story.getPrimaryHeader).to eq("Assessment")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3285|TC #JRNL-2783: From the Assessment entry screen, users will access the history feature using the 'History' button (alt text 'Assessment History') in the left-hand portion of the utility bar, which is separated from the entry portion of the screen by a horizontal rule " do
    expect(@my_story.isHistoryButtonVisible).to eq(true)
    @my_story.clickHistoryButton
    !5.times{ break if ( @my_story_history.isAltTextFilterButtonDisplayed? == true); sleep 1 }
    expect(@my_story_history.isAltTextFilterButtonDisplayed?).to eq(true)
    #User is able to set filters, from a collapsible filter section (defaults to expanded)
    expect(@my_story_history.getAltTextFilterButton).to eq("Collapse filter options")
    expect(@my_story_history.getPrimaryHeader()).to eq("Assessment History")
  end

  it "#AC #JRNL-3286|TC #JRNL-2783: The Assessment History screen replaces the Assessment entry screen in the detail pane with a label 'Assessment History'", :broken => true do
    !5.times{ break if ( @my_story_history.isExpandCollapseFilterBUttonDisplayed == true); sleep 1 }
    #Alternate text is standard for filter control
    waitForPageToFinishLoading
    @my_story_history.toggleFilterBtn
    !5.times{ break if (@my_story_history.getAltTextFilterButton == "Expand filter options"); sleep 1 }
    expect(@my_story_history.getAltTextFilterButton).to eq("Expand filter options")

    @my_story_history.toggleFilterBtn
    !5.times{ break if (@my_story_history.getAltTextFilterButton == "Collapse filter options"); sleep 1 }
    expect(@my_story_history.getAltTextFilterButton).to eq("Collapse filter options")
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    today = getDateNthDaysFromNow(0, "%m/%d/%Y")
    oneYearAgo = getDateNthYearsAgo(1,"%m/%d/%Y")

    #Default time span is one year back from current date
    expect(@date_filter.getStartDate).to eq(oneYearAgo.to_s)
    expect(@date_filter.getEndDate).to eq(today.to_s)

    #User is able to set the date range for the filter
    waitForPageToFinishLoading
    expect(@my_story_history.getRequiredInfoText).to eq("* required field")

    expect(@date_filter.getStartDatePlaceHolder).to eq("MM/DD/YYYY")
    expect(@date_filter.getEndDatePlaceHolder).to eq("MM/DD/YYYY")

    #When the user accesses the history feature, the report is populated based on the filter's default values
    expect(@my_story_history.isReportPopulatedOnFilter("Well-being")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Working the body")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Recharge")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Food and Drink")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Personal Development")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Family, Friends, and Co-Workers")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Surroundings")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Power of the Mind")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Professional Care")).to eq(true)

    @date_filter.setDateRangeAndFilter(today.to_s, tomorrow.to_s)

    expectedValidationSummaryHeader = "The following errors were found:"

    !5.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
    expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
    if Time.new.year.to_s != tomorrow[-4..-1]
      expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.") ).to eq(true)
    else
      expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and "+ today.to_s + ".") ).to eq(true)
    end

    @date_filter.setDateRangeAndFilter("", "")

    !5.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
    expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
    expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(true)
    expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(true)

    expect(@my_story_history.isCheckBoxChecked("Well-being")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Working the body")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Recharge")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Food and Drink")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Personal Development")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Family, Friends, and Co-Workers")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Surroundings")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Power of the Mind")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Professional Care")).to eq(true)

    @my_story_history.checkFilterSection("Well-being")
    @my_story_history.checkFilterSection("Working the body")
    @my_story_history.checkFilterSection("Recharge")
    @my_story_history.checkFilterSection("Food and Drink")
    @my_story_history.checkFilterSection("Personal Development")
    @my_story_history.checkFilterSection("Family, Friends, and Co-Workers")
    @my_story_history.checkFilterSection("Spirit and Soul")
    @my_story_history.checkFilterSection("Surroundings")
    @my_story_history.checkFilterSection("Power of the Mind")
    @my_story_history.checkFilterSection("Professional Care")

    #Uncheck all sections
    expect(@my_story_history.isCheckBoxChecked("Well-being")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Working the body")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Recharge")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Food and Drink")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Personal Development")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Family, Friends, and Co-Workers")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Spirit and Soul")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Surroundings")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Power of the Mind")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Professional Care")).to eq(false)
    expect(@my_story_history.isFilterButtonDisabled).to eq(true)

    @my_story_history.checkFilterSection("Well-being")
    @my_story_history.checkFilterSection("Working the body")
    @my_story_history.checkFilterSection("Recharge")
    @my_story_history.checkFilterSection("Food and Drink")
    @my_story_history.checkFilterSection("Personal Development")
    @my_story_history.checkFilterSection("Family, Friends, and Co-Workers")
    @my_story_history.checkFilterSection("Spirit and Soul")
    @my_story_history.checkFilterSection("Surroundings")
    @my_story_history.checkFilterSection("Power of the Mind")
    @my_story_history.checkFilterSection("Professional Care")

    @date_filter.setDateRangeAndFilter("09/26/2010", "09/21/2014")
    !5.times{ break if (@my_story_history.isTableSectionDisplayed('Well-being') == true); sleep 1 }

    #When the user accesses the history feature, the report is populated based on the filter's default values
    expect(@my_story_history.isReportPopulatedOnFilter("Well-being")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Working the body")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Recharge")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Food and Drink")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Personal Development")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Family, Friends, and Co-Workers")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Surroundings")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Power of the Mind")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Professional Care")).to eq(true)

    @date_filter.setDateRangeAndFilter("09/26/2012", "06/01/2014")
    !5.times{ break if (@my_story_history.isTableSectionDisplayed('Well-being') == true); sleep 1 }

    #When the user accesses the history feature, the report is populated based on the filter's default values
    expect(@my_story_history.isReportPopulatedOnFilter("Well-being")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Working the body")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Recharge")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Food and Drink")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Personal Development")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Family, Friends, and Co-Workers")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Surroundings")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Power of the Mind")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Professional Care")).to eq(true)

  end

  it "AC #JRNL-3287|TC #JRNL-2783: Results will display for section(s) selected by section ", :broken => true do
    #uncheck sections
    @my_story_history.checkFilterSection("Well-being")
    @my_story_history.checkFilterSection("Recharge")
    @my_story_history.checkFilterSection("Food and Drink")
    @my_story_history.checkFilterSection("Family, Friends, and Co-Workers")
    @my_story_history.checkFilterSection("Surroundings")
    @my_story_history.checkFilterSection("Professional Care")

    @date_filter.setDateRangeAndFilter("09/26/2013", "09/16/2014")
    !5.times{ break if (@my_story_history.isTableSectionDisplayed('Personal Development') == true); sleep 1 }
    expect(@my_story_history.getNoAnswersGivenText("Working the body")).to eq("No answers given")
    expect(@my_story_history.isReportPopulatedOnFilter("Personal Development")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Power of the Mind")).to eq(true)
    expect(@my_story_history.isTableDisplayed?("Well-being")).to eq(false)
    expect(@my_story_history.isTableDisplayed?("Recharge")).to eq(false)
    expect(@my_story_history.isTableDisplayed?("Food and Drink")).to eq(false)
    expect(@my_story_history.isTableDisplayed?("Family, Friends, and Co-Workers")).to eq(false)
    expect(@my_story_history.isTableDisplayed?("Surroundings")).to eq(false)
    expect(@my_story_history.isTableDisplayed?("Professional Care")).to eq(false)
  end

  it "AC #JRNL-3288|TC #JRNL-2783: Each section's table includes a header based on the section (e.g. Working the body) "  do
    refreshBrowser
    !5.times{ break if (@my_story_history.getSectionHeader("Well-being") == "Well-being"); sleep 1 }
    expect(@my_story_history.isAltTextFilterButtonDisplayed?).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Well-being")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Working the body")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Recharge")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Food and Drink")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Personal Development")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Family, Friends, and Co-Workers")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Surroundings")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Power of the Mind")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Professional Care")).to eq(true)
    expect(@my_story_history.getSectionHeader("Well-being")).to eq("Well-being")
    expect(@my_story_history.getSectionHeader("Working the body")).to eq("Working the body")
    expect(@my_story_history.getSectionHeader("Recharge")).to eq("Recharge")
    expect(@my_story_history.getSectionHeader("Food and Drink")).to eq("Food and Drink")
    expect(@my_story_history.getSectionHeader("Personal Development")).to eq("Personal Development")
    expect(@my_story_history.getSectionHeader("Family, Friends, and Co-Workers")).to eq("Family, Friends, and Co-Workers")
    expect(@my_story_history.getSectionHeader("Spirit and Soul")).to eq("Spirit and Soul")
    expect(@my_story_history.getSectionHeader("Surroundings")).to eq("Surroundings")
    expect(@my_story_history.getSectionHeader("Power of the Mind")).to eq("Power of the Mind")
    expect(@my_story_history.getSectionHeader("Professional Care")).to eq("Professional Care")
  end

  it "AC #JRNL-3289|TC #JRNL-2783:  For a section that does not have data, the message 'No answers given' will be displayed instead of a table" do
    @date_filter.setDateRangeAndFilter("09/26/2008", "09/26/2009")
    !5.times{ break if (@my_story_history.isTableSectionDisplayed('Personal Development') == false); sleep 1 }
    expect(@my_story_history.getNoAnswersGivenText("Well-being")).to eq("")
    expect(@my_story_history.getNoAnswersGivenText("Working the body")).to eq("")
    expect(@my_story_history.getNoAnswersGivenText("Recharge")).to eq("")
    expect(@my_story_history.getNoAnswersGivenText("Food and Drink")).to eq("")
    expect(@my_story_history.getNoAnswersGivenText("Spirit and Soul")).to eq("")
    expect(@my_story_history.getNoAnswersGivenText("Personal Development")).to eq("")
    expect(@my_story_history.getNoAnswersGivenText("Family, Friends, and Co-Workers")).to eq("")
    expect(@my_story_history.getNoAnswersGivenText("Spirit and Soul")).to eq("")
    expect(@my_story_history.getNoAnswersGivenText("Surroundings")).to eq("")
    expect(@my_story_history.getNoAnswersGivenText("Power of the Mind")).to eq("")
    expect(@my_story_history.getNoAnswersGivenText("Professional Care")).to eq("")
  end

  it "AC #JRNL-3290|TC #JRNL-2783: Self-care results are displayed in a table showing 'Date' 'Current' and 'Future' headers (in order), and corresponding dates and values in each row", :broken => true do
    @date_filter.setDateRangeAndFilter("09/26/2010", "09/26/2014")
    !5.times{ break if (@my_story_history.isTableSectionDisplayed('Well-being') == true); sleep 1 }

    expect(@my_story_history.verifyTableHeader("Working the body", ["Date", "Current", "Future"])).to eq(true)
    expect(@my_story_history.isSortedReverseChronologicalOrder("Working the body")).to eq(true)
  end

  it "AC #JRNL-3291: 'Well-being' results are displayed in a table showing 'Date' 'Physical' 'Mental' and 'Day-to-day' column headers (in order), and corresponding dates and values in each row", :broken => true do
    resizeWindowTo(@windowSize.width, @windowSize.height)

    expect(@my_story_history.verifyTableHeader("Well-being", ["Date", "Physical", "Mental", "Day-to-day"])).to eq(true)
    expect(@my_story_history.isSortedReverseChronologicalOrder("Well-being")).to eq(true)
  end

  it "AC #JRNL-3300|TC #JRNL-2783: Professional Care", :broken => true do
    resizeWindowTo(@windowSize.width, @windowSize.height)
    expect(@my_story_history.verifyTableHeader("Professional Care", ["Date", "Prevention", "Working with Professional (Y/N)", "Clinical Care"])).to eq(true)
    expect(@my_story_history.isSortedReverseChronologicalOrder("Professional Care")).to eq(true)
  end

  it "AC #JRNL-3292|TC #JRNL-2783: Each table includes informational text about the scale for that table above the table, left-justified", :broken => true do
    resizeWindowTo(@windowSize.width, @windowSize.height)
    expect(@my_story_history.getScaleInfoText("Well-being")).to eq("")
    expect(@my_story_history.getScaleInfoText("Working the body")).to eq("")
    expect(@my_story_history.getScaleInfoText("Recharge")).to eq("")
    expect(@my_story_history.getScaleInfoText("Food and Drink")).to eq("")
    expect(@my_story_history.getScaleInfoText("Spirit and Soul")).to eq("")
    expect(@my_story_history.getScaleInfoText("Personal Development")).to eq("")
    expect(@my_story_history.getScaleInfoText("Family, Friends, and Co-Workers")).to eq("")
    expect(@my_story_history.getScaleInfoText("Spirit and Soul")).to eq("")
    expect(@my_story_history.getScaleInfoText("Surroundings")).to eq("")
    expect(@my_story_history.getScaleInfoText("Power of the Mind")).to eq("")
    expect(@my_story_history.getScaleInfoText("Professional Care")).to eq("")
  end

  it "AC #JRNL-3293|TC #JRNL-2783: Back button" do
    resizeWindowTo(400, 727)
    waitForPageToFinishLoading
    expect(@my_story_history.isBackButtonDisplayed?).to eq(true)
    expect(@common.getBackButtonAltText()).to eq("Return to Previous Screen")
    @common.clickBackButton()
    !5.times{ break if (@my_story.isHistoryButtonVisible == true ); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")
  end
end

































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2517:  Assessment History]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("assessments", "healthinventorydb", "assessments_history")
    initializeAllObjects

    @windowSize = getWindowSize()

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory
    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

    @my_story.clickAssessment
    !45.times{ break if (@my_story.isHistoryButtonVisible == true ); sleep 1 }
     expect(@my_story.getPrimaryHeader).to eq("Assessment")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3285|TC #JRNL-2783: From the Assessment entry screen, users will access the history feature using the 'History' button (alt text 'Assessment History') in the left-hand portion of the utility bar, which is separated from the entry portion of the screen by a horizontal rule " do
    expect(@my_story.isHistoryButtonVisible).to eq(true)

    @my_story.clickHistoryButton
    !45.times{ break if ( @my_story_history.isAltTextFilterButtonDisplayed? == true); sleep 1 }
    expect(@my_story_history.isAltTextFilterButtonDisplayed?).to eq(true)
    #User is able to set filters, from a collapsible filter section (defaults to expanded)
    expect(@my_story_history.getAltTextFilterButton).to eq("Collapse filter options")
    expect(@my_story_history.getPrimaryHeader()).to eq("Assessment History")

  end

  it "#AC #JRNL-3286|TC #JRNL-2783: The Assessment History screen replaces the Assessment entry screen in the detail pane with a label 'Assessment History'", :broken => true do
    !45.times{ break if ( @my_story_history.isExpandCollapseFilterBUttonDisplayed == true); sleep 1 }
    #Alternate text is standard for filter control
    waitForPageToFinishLoading
    @my_story_history.toggleFilterBtn
    !45.times{ break if (@my_story_history.getAltTextFilterButton == "Expand filter options"); sleep 1 }
    expect(@my_story_history.getAltTextFilterButton).to eq("Expand filter options")

    @my_story_history.toggleFilterBtn
    !45.times{ break if (@my_story_history.getAltTextFilterButton == "Collapse filter options"); sleep 1 }
    expect(@my_story_history.getAltTextFilterButton).to eq("Collapse filter options")
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    today = getDateNthDaysFromNow(0, "%m/%d/%Y")
    oneYearAgo = getDateNthYearsAgo(1,"%m/%d/%Y")

    #Default time span is one year back from current date
    expect(@date_filter.getStartDate).to eq(oneYearAgo.to_s)
    expect(@date_filter.getEndDate).to eq(today.to_s)

    #User is able to set the date range for the filter
    waitForPageToFinishLoading
    expect(@my_story_history.getRequiredInfoText).to eq("* required field")

    ####################################################################################################################
    ############################# THE LABEL FOR START DATE HAS BEEN REMOVED IN THE APP  ################################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # expect(@my_story_history.getStartDateLabel).to eq("* Start Date:")

    ####################################################################################################################
    ############################# THE LABEL FOR START DATE HAS BEEN REMOVED IN THE APP  ################################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    ####################################################################################################################
    ############################# THE LABEL FOR END DATE HAS BEEN REMOVED IN THE APP  ################################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # expect(@my_story_history.getEndDateLabel).to eq("* End Date:")

    ####################################################################################################################
    ############################# THE LABEL FOR END DATE HAS BEEN REMOVED IN THE APP  ################################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    expect(@date_filter.getStartDatePlaceHolder).to eq("MM/DD/YYYY")
    expect(@date_filter.getEndDatePlaceHolder).to eq("MM/DD/YYYY")

    #When the user accesses the history feature, the report is populated based on the filter's default values
    expect(@my_story_history.isReportPopulatedOnFilter("Well-being")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Working the body")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Recharge")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Food and Drink")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Personal Development")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Family, Friends, and Co-Workers")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Surroundings")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Power of the Mind")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Professional Care")).to eq(true)

    @date_filter.setDateRangeAndFilter(today.to_s, tomorrow.to_s)

    expectedValidationSummaryHeader = "The following errors were found:"

    !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
    expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
    if Time.new.year.to_s != tomorrow[-4..-1]
      expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.") ).to eq(true)
    else
      expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be between 01/01/1900 and "+ today.to_s + ".") ).to eq(true)
    end


    @date_filter.setDateRangeAndFilter("", "")

    !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
    expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
    expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(true)
    expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(true)

    #User is able to select the sections in the report
    #Default is for all sections to be selected
    expect(@my_story_history.isCheckBoxChecked("Well-being")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Working the body")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Recharge")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Food and Drink")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Personal Development")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Family, Friends, and Co-Workers")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Surroundings")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Power of the Mind")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Professional Care")).to eq(true)

    @my_story_history.checkFilterSection("Well-being")
    @my_story_history.checkFilterSection("Working the body")
    @my_story_history.checkFilterSection("Recharge")
    @my_story_history.checkFilterSection("Food and Drink")
    @my_story_history.checkFilterSection("Personal Development")
    @my_story_history.checkFilterSection("Family, Friends, and Co-Workers")
    @my_story_history.checkFilterSection("Spirit and Soul")
    @my_story_history.checkFilterSection("Surroundings")
    @my_story_history.checkFilterSection("Power of the Mind")
    @my_story_history.checkFilterSection("Professional Care")

    #Uncheck all sections
    expect(@my_story_history.isCheckBoxChecked("Well-being")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Working the body")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Recharge")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Food and Drink")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Personal Development")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Family, Friends, and Co-Workers")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Spirit and Soul")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Surroundings")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Power of the Mind")).to eq(false)
    expect(@my_story_history.isCheckBoxChecked("Professional Care")).to eq(false)

    expect(@my_story_history.isFilterButtonDisabled).to eq(true)

   # User is able to set the date range for the filter
    #check all sections

    @my_story_history.checkFilterSection("Well-being")
    @my_story_history.checkFilterSection("Working the body")
    @my_story_history.checkFilterSection("Recharge")
    @my_story_history.checkFilterSection("Food and Drink")
    @my_story_history.checkFilterSection("Personal Development")
    @my_story_history.checkFilterSection("Family, Friends, and Co-Workers")
    @my_story_history.checkFilterSection("Spirit and Soul")
    @my_story_history.checkFilterSection("Surroundings")
    @my_story_history.checkFilterSection("Power of the Mind")
    @my_story_history.checkFilterSection("Professional Care")

   # fourYearsAgo = getDateNthYearsAgo(4, "%m/%d/%Y")
   # fiveDaysAgo = getDateNthDaysAgo(5, "%m/%d/%Y")
    @date_filter.setDateRangeAndFilter("09/26/2010", "09/21/2014")
    !45.times{ break if (@my_story_history.isTableSectionDisplayed('Well-being') == true); sleep 1 }

    #When the user accesses the history feature, the report is populated based on the filter's default values
    expect(@my_story_history.isReportPopulatedOnFilter("Well-being")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Working the body")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Recharge")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Food and Drink")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Personal Development")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Family, Friends, and Co-Workers")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Surroundings")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Power of the Mind")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Professional Care")).to eq(true)

    #twoYearsAgo = getDateNthYearsAgo(2, "%m/%d/%Y")
    #hundredDaysAgo = getDateNthDaysAgo(100, "%m/%d/%Y")
    @date_filter.setDateRangeAndFilter("09/26/2012", "06/01/2014")
    !45.times{ break if (@my_story_history.isTableSectionDisplayed('Well-being') == true); sleep 1 }

    #When the user accesses the history feature, the report is populated based on the filter's default values
    expect(@my_story_history.isReportPopulatedOnFilter("Well-being")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Working the body")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Recharge")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Food and Drink")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Personal Development")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Family, Friends, and Co-Workers")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Surroundings")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Power of the Mind")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Professional Care")).to eq(true)

  end

  it "AC #JRNL-3287|TC #JRNL-2783: Results will display for section(s) selected by section ", :broken => true do
    #uncheck sections
    @my_story_history.checkFilterSection("Well-being")
    #@my_story_history.checkFilterSection("Working the body")
    @my_story_history.checkFilterSection("Recharge")
    @my_story_history.checkFilterSection("Food and Drink")
    #@my_story_history.checkFilterSection("Personal Development")
    @my_story_history.checkFilterSection("Family, Friends, and Co-Workers")
    #@my_story_history.checkFilterSection("Spirit and Soul")
    @my_story_history.checkFilterSection("Surroundings")
    #@my_story_history.checkFilterSection("Power of the Mind")
    @my_story_history.checkFilterSection("Professional Care")

    #oneYearAgo = getDateNthYearsAgo(1, "%m/%d/%Y")
    #tenDaysAgo = getDateNthDaysAgo(10, "%m/%d/%Y")
    @date_filter.setDateRangeAndFilter("09/26/2013", "09/16/2014")
    !45.times{ break if (@my_story_history.isTableSectionDisplayed('Personal Development') == true); sleep 1 }

    expect(@my_story_history.getNoAnswersGivenText("Working the body")).to eq("No answers given")
    expect(@my_story_history.isReportPopulatedOnFilter("Personal Development")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isReportPopulatedOnFilter("Power of the Mind")).to eq(true)

    expect(@my_story_history.isTableDisplayed?("Well-being")).to eq(false)
    expect(@my_story_history.isTableDisplayed?("Recharge")).to eq(false)
    expect(@my_story_history.isTableDisplayed?("Food and Drink")).to eq(false)
    expect(@my_story_history.isTableDisplayed?("Family, Friends, and Co-Workers")).to eq(false)
    expect(@my_story_history.isTableDisplayed?("Surroundings")).to eq(false)
    expect(@my_story_history.isTableDisplayed?("Professional Care")).to eq(false)

  end

  it "AC #JRNL-3288|TC #JRNL-2783: Each section's table includes a header based on the section (e.g. Working the body) "  do
    refreshBrowser

    !45.times{ break if (@my_story_history.getSectionHeader("Well-being") == "Well-being"); sleep 1 }
    expect(@my_story_history.isAltTextFilterButtonDisplayed?).to eq(true)

    expect(@my_story_history.isCheckBoxChecked("Well-being")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Working the body")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Recharge")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Food and Drink")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Personal Development")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Family, Friends, and Co-Workers")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Spirit and Soul")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Surroundings")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Power of the Mind")).to eq(true)
    expect(@my_story_history.isCheckBoxChecked("Professional Care")).to eq(true)

    expect(@my_story_history.getSectionHeader("Well-being")).to eq("Well-being")
    expect(@my_story_history.getSectionHeader("Working the body")).to eq("Working the body")
    expect(@my_story_history.getSectionHeader("Recharge")).to eq("Recharge")
    expect(@my_story_history.getSectionHeader("Food and Drink")).to eq("Food and Drink")
    expect(@my_story_history.getSectionHeader("Personal Development")).to eq("Personal Development")
    expect(@my_story_history.getSectionHeader("Family, Friends, and Co-Workers")).to eq("Family, Friends, and Co-Workers")
    expect(@my_story_history.getSectionHeader("Spirit and Soul")).to eq("Spirit and Soul")
    expect(@my_story_history.getSectionHeader("Surroundings")).to eq("Surroundings")
    expect(@my_story_history.getSectionHeader("Power of the Mind")).to eq("Power of the Mind")
    expect(@my_story_history.getSectionHeader("Professional Care")).to eq("Professional Care")

  end

  it "AC #JRNL-3289|TC #JRNL-2783:  For a section that does not have data, the message 'No answers given' will be displayed instead of a table" do
    #sixYearsAgo = getDateNthYearsAgo(6, "%m/%d/%Y")
    #fiveYearsAgo = getDateNthYearsAgo(5, "%m/%d/%Y")
    @date_filter.setDateRangeAndFilter("09/26/2008", "09/26/2009")
    !45.times{ break if (@my_story_history.isTableSectionDisplayed('Personal Development') == false); sleep 1 }

    expect(@my_story_history.getNoAnswersGivenText("Well-being")).to eq("No answers given")
    expect(@my_story_history.getNoAnswersGivenText("Working the body")).to eq("No answers given")
    expect(@my_story_history.getNoAnswersGivenText("Recharge")).to eq("No answers given")
    expect(@my_story_history.getNoAnswersGivenText("Food and Drink")).to eq("No answers given")
    expect(@my_story_history.getNoAnswersGivenText("Spirit and Soul")).to eq("No answers given")
    expect(@my_story_history.getNoAnswersGivenText("Personal Development")).to eq("No answers given")
    expect(@my_story_history.getNoAnswersGivenText("Family, Friends, and Co-Workers")).to eq("No answers given")
    expect(@my_story_history.getNoAnswersGivenText("Spirit and Soul")).to eq("No answers given")
    expect(@my_story_history.getNoAnswersGivenText("Surroundings")).to eq("No answers given")
    expect(@my_story_history.getNoAnswersGivenText("Power of the Mind")).to eq("No answers given")
    expect(@my_story_history.getNoAnswersGivenText("Professional Care")).to eq("No answers given")
  end

  it "AC #JRNL-3290|TC #JRNL-2783: Self-care results are displayed in a table showing 'Date' 'Current' and 'Future' headers (in order), and corresponding dates and values in each row", :broken => true do
    #fourYearsAgo = getDateNthYearsAgo(4, "%m/%d/%Y")
    #today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @date_filter.setDateRangeAndFilter("09/26/2010", "09/26/2014")
    !45.times{ break if (@my_story_history.isTableSectionDisplayed('Well-being') == true); sleep 1 }

    expect(@my_story_history.verifyTableHeader("Working the body", ["Date", "Current", "Future"])).to eq(true)
    expect(@my_story_history.isSortedReverseChronologicalOrder("Working the body")).to eq(true)
    resizeWindowTo(400, 727)

    #Working the body
    expect(@my_story_history.getPhoneViewCellData("Working the body", 1, 1)).to eq("Date:\n09/25/2014")
    expect(@my_story_history.getPhoneViewCellData("Working the body", 1, 2)).to eq("Current:\n5")
    expect(@my_story_history.getPhoneViewCellData("Working the body", 1, 3)).to eq("Future:\n5")

    expect(@my_story_history.getPhoneViewCellData("Working the body", 2, 1)).to eq("Date:\n06/08/2013")
    expect(@my_story_history.getPhoneViewCellData("Working the body", 2, 2)).to eq("Current:\n4")
    expect(@my_story_history.getPhoneViewCellData("Working the body", 2, 3)).to eq("Future:\n5")

    expect(@my_story_history.getPhoneViewCellData("Working the body", 3, 1)).to eq("Date:\n02/13/2012")
    expect(@my_story_history.getPhoneViewCellData("Working the body", 3, 2)).to eq("Current:\n4")
    expect(@my_story_history.getPhoneViewCellData("Working the body", 3, 3)).to eq("Future:\n3")

    #Recharge
    expect(@my_story_history.getPhoneViewCellData("Recharge", 1, 1)).to eq("Date:\n09/25/2014")
    expect(@my_story_history.getPhoneViewCellData("Recharge", 1, 2)).to eq("Current:\n4")
    expect(@my_story_history.getPhoneViewCellData("Recharge", 1, 3)).to eq("Future:\n5")

    expect(@my_story_history.getPhoneViewCellData("Recharge", 6, 1)).to eq("Date:\n02/13/2012")
    expect(@my_story_history.getPhoneViewCellData("Recharge", 6, 2)).to eq("Current:\n2")
    expect(@my_story_history.getPhoneViewCellData("Recharge", 6, 3)).to eq("Future:\n3")

    #Food and Drink
    expect(@my_story_history.getPhoneViewCellData("Food and Drink", 3, 1)).to eq("Date:\n02/13/2012")
    expect(@my_story_history.getPhoneViewCellData("Food and Drink", 3, 2)).to eq("Current:\n4")
    expect(@my_story_history.getPhoneViewCellData("Food and Drink", 3, 3)).to eq("Future:\n5")

    #Personal Development
    expect(@my_story_history.getPhoneViewCellData("Personal Development", 2, 1)).to eq("Date:\n06/08/2013")
    expect(@my_story_history.getPhoneViewCellData("Personal Development", 2, 2)).to eq("Current:\n5")
    expect(@my_story_history.getPhoneViewCellData("Personal Development", 2, 3)).to eq("Future:\n4")

    expect(@my_story_history.getPhoneViewCellData("Personal Development", 3, 1)).to eq("Date:\n11/29/2012")
    expect(@my_story_history.getPhoneViewCellData("Personal Development", 3, 2)).to eq("Current:\n3")
    expect(@my_story_history.getPhoneViewCellData("Personal Development", 3, 3)).to eq("Future:\n4")

    #Friends and Family
    expect(@my_story_history.getPhoneViewCellData("Family, Friends, and Co-Workers", 1, 1)).to eq("Date:\n12/14/2013")
    expect(@my_story_history.getPhoneViewCellData("Family, Friends, and Co-Workers", 1, 2)).to eq("Current:\n4")
    expect(@my_story_history.getPhoneViewCellData("Family, Friends, and Co-Workers", 1, 3)).to eq("Future:\n5")

    #Spirit and Soul
    expect(@my_story_history.getPhoneViewCellData("Spirit and Soul", 5, 1)).to eq("Date:\n02/13/2012")
    expect(@my_story_history.getPhoneViewCellData("Spirit and Soul", 5, 2)).to eq("Current:\n2")
    expect(@my_story_history.getPhoneViewCellData("Spirit and Soul", 5, 3)).to eq("Future:\n4")

    #Surroundings
    expect(@my_story_history.getPhoneViewCellData("Surroundings", 3, 1)).to eq("Date:\n06/08/2013")
    expect(@my_story_history.getPhoneViewCellData("Surroundings", 3, 2)).to eq("Current:\n4")
    expect(@my_story_history.getPhoneViewCellData("Surroundings", 3, 3)).to eq("Future:\n4")

    #Power of the Mind
    expect(@my_story_history.getPhoneViewCellData("Power of the Mind", 2, 1)).to eq("Date:\n04/07/2014")
    expect(@my_story_history.getPhoneViewCellData("Power of the Mind", 2, 2)).to eq("Current:\n3")
    expect(@my_story_history.getPhoneViewCellData("Power of the Mind", 2, 3)).to eq("Future:\n4")

  end

  it "AC #JRNL-3291: 'Well-being' results are displayed in a table showing 'Date' 'Physical' 'Mental' and 'Day-to-day' column headers (in order), and corresponding dates and values in each row", :broken => true do
    resizeWindowTo(@windowSize.width, @windowSize.height)

    expect(@my_story_history.verifyTableHeader("Well-being", ["Date", "Physical", "Mental", "Day-to-day"])).to eq(true)
    expect(@my_story_history.isSortedReverseChronologicalOrder("Well-being")).to eq(true)

    resizeWindowTo(400, 727)
    expect(@my_story_history.getPhoneViewCellData("Well-being", 1, 1)).to eq("Date:\n09/25/2014")
    expect(@my_story_history.getPhoneViewCellData("Well-being", 1, 2)).to eq("Physical:\n5")
    expect(@my_story_history.getPhoneViewCellData("Well-being", 1, 3)).to eq("Mental:\n5")
    expect(@my_story_history.getPhoneViewCellData("Well-being", 1, 4)).to eq("Day-to-day:\n4")

    expect(@my_story_history.getPhoneViewCellData("Well-being", 6, 1)).to eq("Date:\n02/13/2012")
    expect(@my_story_history.getPhoneViewCellData("Well-being", 6, 2)).to eq("Physical:\n2")
    expect(@my_story_history.getPhoneViewCellData("Well-being", 6, 3)).to eq("Mental:\n3")
    expect(@my_story_history.getPhoneViewCellData("Well-being", 6, 4)).to eq("Day-to-day:\n3")

  end

  it "AC #JRNL-3300|TC #JRNL-2783: Professional Care", :broken => true do
    resizeWindowTo(@windowSize.width, @windowSize.height)
    expect(@my_story_history.verifyTableHeader("Professional Care", ["Date", "Prevention", "Working with Professional (Y/N)", "Clinical Care"])).to eq(true)
    expect(@my_story_history.isSortedReverseChronologicalOrder("Professional Care")).to eq(true)

    resizeWindowTo(400, 727)
    expect(@my_story_history.getPhoneViewCellData("Professional Care", 1, 1)).to eq("Date:\n09/25/2014")
    expect(@my_story_history.getPhoneViewCellData("Professional Care", 1, 2)).to eq("Prevention:")
    expect(@my_story_history.getPhoneViewCellData("Professional Care", 1, 3)).to eq("Working with a healthcare professional (Y/N):\nY")
    expect(@my_story_history.getPhoneViewCellData("Professional Care", 1, 4)).to eq("Clinical Care:\n1")

    expect(@my_story_history.getPhoneViewCellData("Professional Care", 3, 1)).to eq("Date:\n12/14/2013")
    expect(@my_story_history.getPhoneViewCellData("Professional Care", 3, 2)).to eq("Prevention:")
    expect(@my_story_history.getPhoneViewCellData("Professional Care", 3, 3)).to eq("Working with a healthcare professional (Y/N):\nN")
    expect(@my_story_history.getPhoneViewCellData("Professional Care", 3, 4)).to eq("Clinical Care:")

  end

  it "AC #JRNL-3292|TC #JRNL-2783: Each table includes informational text about the scale for that table above the table, left-justified", :broken => true do
    resizeWindowTo(@windowSize.width, @windowSize.height)
    expect(@my_story_history.getScaleInfoText("Well-being")).to eq("1 = Miserable, 5 = Great")

    expect(@my_story_history.getScaleInfoText("Working the body")).to eq("1 = Low, 5 = High")
    expect(@my_story_history.getScaleInfoText("Recharge")).to eq("1 = Low, 5 = High")
    expect(@my_story_history.getScaleInfoText("Food and Drink")).to eq("1 = Low, 5 = High")
    expect(@my_story_history.getScaleInfoText("Spirit and Soul")).to eq("1 = Low, 5 = High")
    expect(@my_story_history.getScaleInfoText("Personal Development")).to eq("1 = Low, 5 = High")
    expect(@my_story_history.getScaleInfoText("Family, Friends, and Co-Workers")).to eq("1 = Low, 5 = High")
    expect(@my_story_history.getScaleInfoText("Spirit and Soul")).to eq("1 = Low, 5 = High")
    expect(@my_story_history.getScaleInfoText("Surroundings")).to eq("1 = Low, 5 = High")
    expect(@my_story_history.getScaleInfoText("Power of the Mind")).to eq("1 = Low, 5 = High")

    expect(@my_story_history.getScaleInfoText("Professional Care")).to eq("1 = Not at all, 5 = Very Much")

  end

  it "AC #JRNL-3293|TC #JRNL-2783: Back button" do
    resizeWindowTo(400, 727)
    waitForPageToFinishLoading
    expect(@my_story_history.isBackButtonDisplayed?).to eq(true)
    expect(@common.getBackButtonAltText()).to eq("Return to Previous Screen")
    @common.clickBackButton()
    !45.times{ break if (@my_story.isHistoryButtonVisible == true ); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")
  end
end
=end