# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2524: Access the PHI/Introductory Screen] [Story #JRNL-2522: PHI Navigation Menu]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    !5.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !5.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !5.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient05")

    !5.times{ break if (@main.getFooterText() == "Logged in as patient05, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")
  end

  # after(:all) do
  #   quitDriver()
  # end

  it "AC #JRNL-3025|JRNL-3233: The PHI feature will be accessible in the left-hand menu (1st column of 4 column view) through a tab labeled My Story" do

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    expect(@nav_menu.isMyStoryButtonVisible).to eq(true)
    #My Profile and My Medical are added
    ## JRNL-3025 AC states the "My Story" should now be the second nav item. It is now the 3rd as altered by JRNL-3138.
    expect(@nav_menu.getNthOptionName(3)).to eq("My Story")

    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyStory']").click
    waitForPageToFinishLoading

    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  it "AC #JRNL-3052|JRNL-3233: User can navigate to the different My Story features (corresponding pages are presented in the detail pane)" do
    expect(@my_story.getNthMyStoryFeatureName(1)).to eq("Summary")
    expect(@my_story.getNthMyStoryFeatureName(2)).to eq("Personal Values")
    expect(@my_story.getNthMyStoryFeatureName(3)).to eq("Assessment")
    expect(@my_story.getNthMyStoryFeatureName(4)).to eq("Reflections")
    expect(@my_story.getNthMyStoryFeatureName(5)).to eq("Goals")
    expect(@my_story.getNthMyStoryFeatureName(6)).to eq("Learn")

    @my_story.clickSummary
    !5.times{ break if (@my_story.getPrimaryHeader == "Summary"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Summary")

    @my_story.clickPersonalValues
    !5.times{ break if (@my_story.getPrimaryHeader == "Personal Values"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Personal Values")

    @my_story.clickAssessment
    !5.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickReflections
    !5.times{ break if (@my_story.getPrimaryHeader == "Reflections"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Reflections")

    @my_story.clickLearn
    !5.times{ break if (@my_story.getPrimaryHeader == "Learn"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Learn")
  end

  it "AC #JRNL-3063|JRNL-3233: Icons are included to the left of each navigation item" do
    expect(@my_story.isSummaryIconVisible).to eq(true)
    expect(@my_story.isPersonalValuesIconVisible).to eq(true)
    expect(@my_story.isAssessmentsIconVisible).to eq(true)
    expect(@my_story.isReflectionsIconVisible).to eq(true)
    expect(@my_story.isLearnIconVisible).to eq(true)

    expect(@my_story.isNthIconDisplayedLeftOfItem(1)).to eq(true)
    expect(@my_story.isNthIconDisplayedLeftOfItem(2)).to eq(true)
    expect(@my_story.isNthIconDisplayedLeftOfItem(3)).to eq(true)
    expect(@my_story.isNthIconDisplayedLeftOfItem(4)).to eq(true)
    expect(@my_story.isNthIconDisplayedLeftOfItem(5)).to eq(true)

    @main.clickNavMenu
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  it "AC #JRNL-3074|JRNL-3233: The user can navigate back to the navigation screen from these screens using a back button (< icon; alt text 'Navigation Screen') in the title bar (phone form factor and smaller)" do
    #resizeWindowTo(400, 727)
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[class='btn btn-default summary']").click
    waitForPageToFinishLoading
    !5.times{ break if (@my_story.getPrimaryHeader == "Summary"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Summary")

    @my_story.clickBackButton
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

    @my_story.clickPersonalValues
    !5.times{ break if (@my_story.getPrimaryHeader == "Personal Values"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Personal Values")

    @my_story.clickBackButton
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

    @my_story.clickAssessment
    !5.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickBackButton
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

    @my_story.clickReflections
    !5.times{ break if (@my_story.getPrimaryHeader == "Reflections"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Reflections")

    @my_story.clickBackButton
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

    @my_story.clickLearn
    !5.times{ break if (@my_story.getPrimaryHeader == "Learn"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Learn")

    @my_story.clickBackButton
    !5.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  it "AC #JRNL-3084|JRNL-3233: An i button is available in the title bar of the main view that contains introductory information " do
    resizeWindowTo(400, 727)
    refreshBrowser
    @my_story.clickIButton()

    !5.times{ break if (@modal.getConfirmationHeading() == "Introduction"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Introduction")
   #todo:  Introduction content will be changed later.
    expect(@modal.getConfirmationMessage()).to eq("You are on the road to better health. The first step is to know what is important in your life and what you want from your health. Knowing your life and health goals may not be easy and the MyStory app can help. If you haven’t begun entering your story yet, review the Learn section. Reflect on your values and other areas of your life by filling out the Personal Values and Assessment sections and view the Summary section to see your story.")

    @modal.clickOKFromInfoModal
  end
end






































































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2524: Access the PHI/Introductory Screen] [Story #JRNL-2522: PHI Navigation Menu]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3025|JRNL-3233: The PHI feature will be accessible in the left-hand menu (1st column of 4 column view) through a tab labeled My Story" do

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    expect(@nav_menu.isMyStoryButtonVisible).to eq(true)
    #My Profile and My Medical are added
    ## JRNL-3025 AC states the "My Story" should now be the second nav item. It is now the 3rd as altered by JRNL-3138.
    expect(@nav_menu.getNthOptionName(3)).to eq("My Story")

    @nav_menu.clickMyStory

    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  it "AC #JRNL-3052|JRNL-3233: User can navigate to the different My Story features (corresponding pages are presented in the detail pane)" do
    expect(@my_story.getNthMyStoryFeatureName(1)).to eq("Summary")
    expect(@my_story.getNthMyStoryFeatureName(2)).to eq("Personal Values")
    expect(@my_story.getNthMyStoryFeatureName(3)).to eq("Assessment")
    expect(@my_story.getNthMyStoryFeatureName(4)).to eq("Reflections")
    expect(@my_story.getNthMyStoryFeatureName(5)).to eq("Goals")
    expect(@my_story.getNthMyStoryFeatureName(6)).to eq("Learn")

    @my_story.clickSummary
    !45.times{ break if (@my_story.getPrimaryHeader == "Summary"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Summary")

    @my_story.clickPersonalValues
    !45.times{ break if (@my_story.getPrimaryHeader == "Personal Values"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Personal Values")

    @my_story.clickAssessment
    !45.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickReflections
    !45.times{ break if (@my_story.getPrimaryHeader == "Reflections"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Reflections")

    @my_story.clickLearn
    !45.times{ break if (@my_story.getPrimaryHeader == "Learn"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Learn")
  end

  it "AC #JRNL-3063|JRNL-3233: Icons are included to the left of each navigation item" do
    expect(@my_story.isSummaryIconVisible).to eq(true)
    expect(@my_story.isPersonalValuesIconVisible).to eq(true)
    expect(@my_story.isAssessmentsIconVisible).to eq(true)
    expect(@my_story.isReflectionsIconVisible).to eq(true)
    expect(@my_story.isLearnIconVisible).to eq(true)

    expect(@my_story.isNthIconDisplayedLeftOfItem(1)).to eq(true)
    expect(@my_story.isNthIconDisplayedLeftOfItem(2)).to eq(true)
    expect(@my_story.isNthIconDisplayedLeftOfItem(3)).to eq(true)
    expect(@my_story.isNthIconDisplayedLeftOfItem(4)).to eq(true)
    expect(@my_story.isNthIconDisplayedLeftOfItem(5)).to eq(true)

    @main.clickNavMenu
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyStory
    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  it "AC #JRNL-3074|JRNL-3233: The user can navigate back to the navigation screen from these screens using a back button (< icon; alt text 'Navigation Screen') in the title bar (phone form factor and smaller)" do
    resizeWindowTo(400, 727)
    @my_story.clickSummary
    !45.times{ break if (@my_story.getPrimaryHeader == "Summary"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Summary")

    @my_story.clickBackButton
    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

    @my_story.clickPersonalValues
    !45.times{ break if (@my_story.getPrimaryHeader == "Personal Values"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Personal Values")

    @my_story.clickBackButton
    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

    @my_story.clickAssessment
    !45.times{ break if (@my_story.getPrimaryHeader == "Assessment"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Assessment")

    @my_story.clickBackButton
    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

    @my_story.clickReflections
    !45.times{ break if (@my_story.getPrimaryHeader == "Reflections"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Reflections")

    @my_story.clickBackButton
    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")

    @my_story.clickLearn
    !45.times{ break if (@my_story.getPrimaryHeader == "Learn"); sleep 1 }
    expect(@my_story.getPrimaryHeader).to eq("Learn")

    @my_story.clickBackButton
    !45.times{ break if (@my_story.getSecondaryHeader == "My Story"); sleep 1 }
    expect(@my_story.getSecondaryHeader).to eq("My Story")
  end

  it "AC #JRNL-3084|JRNL-3233: An i button is available in the title bar of the main view that contains introductory information " do
    resizeWindowTo(400, 727)
    refreshBrowser
    @my_story.clickIButton()

    !45.times{ break if (@modal.getConfirmationHeading() == "Introduction"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Introduction")
   #todo:  Introduction content will be changed later.
    expect(@modal.getConfirmationMessage()).to eq("You are on the road to better health. The first step is to know what is important in your life and what you want from your health. Knowing your life and health goals may not be easy and the MyStory app can help. If you haven’t begun entering your story yet, review the Learn section. Reflect on your values and other areas of your life by filling out the Personal Values and Assessment sections and view the Summary section to see your story.")

    @modal.clickOKFromInfoModal
  end
end
=end