require_relative '../../../../globalized'
include Globalized

describe "[Story# JRNL-1617: Tetanus Vaccination]
          [Story# JRNL-1303: [Update Preventive Services header]", :broken => true, :acceptance => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("notifications", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")

    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    initializeAllObjects

    @ENTRY_FORM_CONTENT =  [\
                          "Tetanus Vaccination",
                          "Learn More",
                          "Last Administered:",
                          "MM/DD/YYYY",
                          "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
                          "Next Due Date:",
                          "MM/DD/YYYY",
                          "Next Due Date will become required if you turn on Notifications for this reminder.",
                          "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
                          "Check with your provider to see if you are due for a Tetanus and Diphtheria (Td) or Tetanus, Diphtheria and Pertussis (Tdap) vaccine. For your specific health needs, you may enter an alternate Next Due Date.",
                          "Notes:",
                          "250 character maximum",
                          "250 characters left",
                          "Notifications are available for future due dates only.",
                          "Notification:",
                          "Status:",
                          "On",
                          "Off",
                          "Notify Me About This Due Date:",
                          "On the date 1 day before 2 weeks before 4 weeks before",
                          "Notification Delivery:",
                          "In-App",
                          "Email",
                          "Email address has not been saved",
                          "You may update your Preferred Email address in the Notification feature by selecting the notification settings icon",
                          "You may update your Preferred Email address in the Notification feature by selecting the icon.", "Save Cancel"]



    #dob 12/13/1900
    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1104|TC JRNL-1101: Tetanus Vaccination Criteria" do

    it "Header: Edit Preventive Services " do
      @reminders.clickSubGroup("preventive-services")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !45.times{ break if ( @screening.findIndexWithGivenPSName("Tetanus Vaccination") > -1); sleep 1 }
      clickTetanusVaccinationAndVerifyHeader()
    end

    it "Labels" do
      pageContent = @screening.getScreenContent().split("\n")

      @ENTRY_FORM_CONTENT.each_with_index do | expectedScreenRow, i |
        expect(pageContent[i]).to eq(expectedScreenRow)
      end
      expect(pageContent.length).to eq(@ENTRY_FORM_CONTENT.length)
    end

    it "Last Administered (date, date picker, mm/dd/yyyy), cannot be future date" do
      setDate(@tomorrow, "input[name='lastAdministered']")
      @screening.clickSaveButton

      checkingInlineError("Last Administered must be between 01/01/1900 and " + @today + ".")
      setDate("", "input[name='lastAdministered']")
    end

    it "Next Due Date Text Message" do
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Check with your provider to see if you are due for a Tetanus and Diphtheria (Td) or Tetanus, Diphtheria and Pertussis (Tdap) vaccine. For your specific health needs, you may enter an alternate Next Due Date.")
    end

    it "Note (text 250 characters), display character count down" do
      expect(getTextForElement(:css, Screening::NOTES_LABEL)).to eq("Notes:")
      #verify that Notes will be 250 characters with character countdown
      expect(@screening.verifyTotalCharacterInNarrative()).to eq(true)


      #Phone View
      resizeWindowToPhone()

      @screening.clickCancelButton

      !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

      clickTetanusVaccinationAndVerifyHeader

      resizeWindowToDefault()
    end

    it "Default NDD = Users 11th birthday" do
      expect(@screening.getNextDueDate).to eq("12/13/1911")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Check with your provider to see if you are due for a Tetanus and Diphtheria (Td) or Tetanus, Diphtheria and Pertussis (Tdap) vaccine. For your specific health needs, you may enter an alternate Next Due Date.")
    end

    it "Hyperlink vaccine names in statement below NDD " do
      click(:css,  Screening::TETANUS_TD_URL)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://www.cdc.gov/vaccines/hcp/vis/vis-statements/td.html")
      closeBrowser()
      switchWindowToWindowHandleFirst()

      click(:css,  Screening::TETANUS_TDAP_URL)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://www.cdc.gov/vaccines/hcp/vis/vis-statements/tdap.html")
      closeBrowser()

      switchWindowToWindowHandleFirst()
    end

    it "Display information icon" do
      @screening.clickInformationButton()
      !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
      expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")
      #close
      @modal.clickNoButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
    end

    it "Update the NDD field to LAD+10 years." do
      thirtyDaysAgo = getDateNthDaysFromNow(-30, "%m/%d/%Y")
      setDate(thirtyDaysAgo, "input[name='lastAdministered']")
      expect(@screening.getNextDueDate).to eq(getDateNThYearFromGivenDate(thirtyDaysAgo, 10))

      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Check with your provider to see if you are due for a Tetanus and Diphtheria (Td) or Tetanus, Diphtheria and Pertussis (Tdap) vaccine. For your specific health needs, you may enter an alternate Next Due Date.")
      @screening.selectNotificationStatus("Off")
      @screening.clickSaveButton

      !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    end

    it "Update Entry and verify" do
      lastAdministeredDate = getDateNthDaysFromNow(-35, "%m/%d/%Y")
      nextDueDate = getDateNthDaysFromNow(200, "%m/%d/%Y")
      note = "Testing 1"
      UpdateEntryAndVerify(lastAdministeredDate, nextDueDate, note)

      lastAdministeredDate = getDateNthDaysFromNow(-35, "%m/%d/%Y")
      nextDueDate = ""
      note = "Testing 2"
      UpdateEntryAndVerify(lastAdministeredDate, nextDueDate, note)

    end

  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

  def clickTetanusVaccinationAndVerifyHeader()
    indexID = @screening.findIndexWithGivenPSName("Tetanus Vaccination")
    expect(indexID).not_to eq(-1)

    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
  end

  def UpdateEntryAndVerify (lastAdministeredDate, nextDueDate, note)
    clickTetanusVaccinationAndVerifyHeader

    setDate(lastAdministeredDate, "input[name='lastAdministered']")
    prePopulatedNextDueDate = getDateNThYearFromGivenDate(lastAdministeredDate, 10)
    expect(@screening.getNextDueDate).to eq(prePopulatedNextDueDate)
    @screening.setNote(note)

    @screening.selectNotificationStatus("Off")

    @screening.clickSaveButton()

    #verify Results field is not required and saved without the error
    !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    indexID = @screening.findIndexWithGivenPSName("Tetanus Vaccination")

    expect(indexID).not_to eq(-1)
    #puts "row index is " + indexID.to_s
    expect(@reminders.getTextForRowCol(indexID, 3)).to eq(prePopulatedNextDueDate)
    clickTetanusVaccinationAndVerifyHeader()

    expect(getTextFromInput(:css, "input[name='lastAdministered']")).to eq(lastAdministeredDate)
    expect(@screening.getNextDueDate).to eq(prePopulatedNextDueDate)
    expect(@screening.getNote).to eq(note)

    setDate("", "input[name='lastAdministered']")
    @screening.setNextDueDate(nextDueDate)
    @screening.selectNotificationStatus("Off")

    @screening.clickSaveButton()

    #verify Results field is not required and saved without the error
    !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    indexID = @screening.findIndexWithGivenPSName("Tetanus Vaccination")

    expect(indexID).not_to eq(-1)
    #puts "row index is " + indexID.to_s
    if (nextDueDate == "")
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq("None")
    elsif
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq(nextDueDate)
    end


    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

    expect(getTextFromInput(:css, "input[name='lastAdministered']")).to eq("")
    expect(@screening.getNextDueDate).to eq(nextDueDate)
    expect(@screening.getNote).to eq(note)

    @screening.clickCancelButton
    !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")


  end

end