require_relative '../../../../globalized'
include Globalized

describe "Story# JRNL-2493: [CPS_Shingles_Vaccination_JRNL_2493_spec.rb] | JRNL-1303: [Update Preventive Services header]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.female96", "female96, zztest")
    expect(@main.getFooterText()).to eq("Logged in as female96, zztest")

    sleep 5

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  context 'AC(JRNL-2737|), TC(JRNL-2762): Shingles Vaccine Appears in Preventive Service Table' do

    it "Shingles Vaccine Appears in Preventive Service Table" do
      @reminders.clickSubGroup("preventive-services")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      #verify that default Next Due date is set to the date of the user’s 60th birthday
      dob = @screening.getPatientDOB("0000000181")
      isDateFormatValid?(dob,"%m/%d/%Y")
      dob = Date.parse(dob)
      # numberOfDaysAgo.year.ago.strftime(format=formatStr)
      sixtiethBirthday = (dob >> 60 * 12).strftime("%m/%d/%Y")
      expect(@screening.verifyDueDate("Shingles Vaccination", sixtiethBirthday)).not_to eq(-1)
    end

  end

  context 'AC(JRNL-2848|JRNL-2911), TC(JRNL-2762): Update Shingles default notification settings' do

    it "Shingles Notification Defaults" do
      @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("Shingles Vaccination"))
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

      #Verify that the Notification radio button is defaulted to Off
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Off", "notificationOption")).to eq(true)
      #Notification Delivery is disabled
      expect(isThisElementDisabled(:css, "input[name='notificationDelivery']")).to eq(true)
      #Notify me is disabled
      expect(isThisElementDisabled(:css, "input[name='notificationTriggerDate']")).to eq(true)
      #verify that, next due date, notification delivery, and notify me is optional
      clearDateOrTime("input[name='nextDueDate']")

      @screening.clickButton("save")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

  end

  context 'AC(JRNL-2738|JRNL-2739), TC(JRNL-2762): Shingles Vaccine - Edit Mode.; Shingles Vaccine Edit Mode - Save and Cancel' do

    it "Shingles Vaccine - Edit Mode.; Shingles Vaccine Edit Mode - Save and Cancel" do
      @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("Shingles Vaccination"))
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

      #verify Learn more about Shingles Vaccination
      @screening.clickLearnMoreLink()
      !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      expect(@modal.getConfirmationHeading()).to eq("Learn More About Shingles Vaccination")

      @modal.clickNoButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      #Verifying the Header, Text and Button information for the "Next Due Date Modal"
      @screening.clickInformationButton()
      !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
      expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

      @modal.clickNoButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      time = Time.new()
      today = time.strftime("%m/%d/%Y")
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

      setDate(tomorrow, "input[name='lastAdministered']")

      #verify that Notes will be 250 characters with character countdown
      expect(@screening.verifyTotalCharacterInNarrative()).to eq(true)
      @screening.setNote("Shingles Vaccination is done.")

      @screening.clickSaveButton()
      if time.year.to_s != tomorrow[-4..-1]
        checkingInlineError("Last Administered must be formatted MM/DD/YYYY.")
      else
        #Verify that, last shingles vaccination date cannot be future date
        checkingInlineError("Last Administered must be between 01/01/1900 and " + today + ".")
      end

      clearDateOrTime("input[name='lastAdministered']")
      clearDateOrTime("input[name='nextDueDate']")
      expect(@screening.isNotificationStatusSelected("Off")).to eq(true)
      expect(isThisElementDisabled(:css, "input[name*='notificationOption']")).to eq(true)

      setDate(today, "input[name='lastAdministered']")

      #verify notification guideline text
      expect(@screening.getGuidelineText()).to eq("You have met the recommended vaccination guidelines. Any pending notifications for this reminder will be turned off.")

      #verify that, Next Due Date and Notification are disabled
      expect(isThisElementDisabled(:css, "input[name='nextDueDate']")).to eq(true)
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Off", "notificationOption")).to eq(true)

      @screening.clickSaveButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      #verify that, Due Date is null after entering last administered date
      expect(@screening.verifyDueDate("Shingles Vaccination", "None")).not_to eq(-1)
    end

  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

end