require_relative '../../../../globalized'
include Globalized

describe "[Story# JRNL-1557: Preventive Services - PPSV23 - Pneumococcal Vaccination]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")

    @PS_NAME = "PPSV23 - Pneumococcal Vaccination"

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.female96", "female96, zztest")
    expect(@main.getFooterText()).to eq("Logged in as female96, zztest")

    sleep 5

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")

    @reminders.clickSubGroup("preventive-services")
    waitForPageToFinishLoading()

    ## Get user's 65th birthday and format
    dob = @screening.getPatientDOB("0000000181")
    dob = Date.parse(dob)
    @sixtyFifthBirthday = (dob >> 65 * 12).strftime("%m/%d/%Y")
  end

  after(:all) do
    quitDriver()
  end

  describe 'AC JRNL-1234|TC JRNL-1207: Table View' do

    it "Present and Correct" do
      expect(@screening.verifyDueDate(@PS_NAME, @sixtyFifthBirthday)).not_to eq(-1)
    end

    it "Sorted" do
      expect(@screening.isThePSScreeningsSortedCorrectlyInTableView()).to eq(true)
    end

  end

  describe 'AC JRNL-1233|TC JRNL-1207: Edit' do

    it "Click Row" do
      @reminders.clickNthReminder(@screening.findIndexWithGivenPSName(@PS_NAME))
      waitForPageToFinishLoading()
    end

    it "Defaults" do
      expect(@screening.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)
      expect(@screening.getDetailHeader()).to eq(@PS_NAME)
      expect(@screening.isLearnMoreLinkPresent()).to eq(true)
      expect(@screening.getTextFromInput(:css, Screening::LAST_ADMINISTERED_DATE)).to eq('')
      expect(@screening.getNextDueDate()).to eq(@sixtyFifthBirthday)
      expect(@screening.isLearnMoreLinkPresent()).to eq(true)
      expect(@screening.getTextFromInput(:css, Screening::NOTES)).to eq('')
    end

    describe "Learn More Modal" do

      it "Clickable" do
        @screening.clickLearnMoreLink()
        !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
        expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      end

      it "Header" do
        expect(@modal.getConfirmationHeading()).to eq("Learn More About PPSV23 - Pneumococcal Vaccination")
      end

      it "Button" do
        expect(@modal.isCancelButtonPresent()).to eq(true)
        expect(@modal.getCancelButtonText()).to eq("OK")
      end

      it "Click Button" do
        @modal.clickReturnButton()
        !30.times{ break if(@modal.isConfirmationPopUpNotPresent()); sleep 1 }
        expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
      end

      it "Focus" do
        !15.times { break if(@screening.getFocusedElementText() == "Learn More"); sleep 1 }
        expect(@screening.getFocusedElementText()).to eq("Learn More")
      end

    end

    describe "Information Modal" do

      it "Clickable" do
        @screening.clickInformationButton()
        !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
        expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      end

      it "Header" do
        expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
      end

      it "Body" do
        expect(@modal.getConfirmationMessage()).to eq("This app provides a recommended next due date to assist you with setting your reminder for this service. However, you should always check with your provider to confirm your next due date recommendation.\nFor your specific health needs, you can enter an alternate Next Due Date at any time.")
      end

      it "Button" do
        expect(@modal.isCancelButtonPresent()).to eq(true)
        expect(@modal.getCancelButtonText()).to eq("OK")
      end

      it "Click Button" do
        @modal.clickReturnButton()
        !30.times{ break if(@modal.isConfirmationPopUpNotPresent()); sleep 1 }
        expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
      end

      it "Focus" do
        ## The information button has no text and won't focus correctly in FF
        ## expect(@screening.getFocusedElementText()).to eq("")
      end

    end

  end

  describe "AC JRNL-1232: Notification" do
    ## Notification for this preventive service is tested in scripts: CPS_PS_Notification_MVAH_8_spec.rb & CPS_Notify_Me_Rework_MVAH_1291_spec.rb
  end

  describe 'AC JRNL-1231|TC JRNL-1207: Navigation' do

    describe "Save" do

      context "Min" do

        it "Changes" do
          @screening.setNextDueDate('')

          @screening.clickSaveButton()
          waitForPageToFinishLoading()
        end

        it "Focus" do
          expect(@screening.getFocusedElementText()).to eq("Preventive Services")
        end

        it "Verify Table" do
          expect(@screening.verifyDueDate(@PS_NAME, 'None')).not_to eq(-1)
          expect(@screening.isThePSScreeningsSortedCorrectlyInTableView()).to eq(true)
        end

        it "Click Row" do
          @reminders.clickNthReminder(@screening.findIndexWithGivenPSName(@PS_NAME))
          waitForPageToFinishLoading()
        end

        it "Verify Data" do
          expect(@screening.getTextFromInput(:css, Screening::LAST_ADMINISTERED_DATE)).to eq('')
          expect(@screening.getNextDueDate()).to eq('')
          expect(@screening.getTextFromInput(:css, Screening::NOTES)).to eq('')
        end

      end

      context "Max" do

        it "Changes" do
          @screening.setLastAdministeredDate('02/02/2015')
          @screening.setNextDueDate('02/02/2015')
          @screening.setNote('MaximumNoteCharacterTest & SpecialCharacterTest 1234567890 -_=+!@$%^*(){}[]<>:;,.? MaximumNoteCharacterTest & SpecialCharacterTest 1234567890 -_=+!@$%^*(){}[]<>:;,.? MaximumNoteCharacterTest & SpecialCharacterTest 1234567890 -_=+!@$%^*(){}[]<>:;,.? MaximumNoteCharacterTest & SpecialCharacterTest 1234567890 -_=+!@$%^*(){}[]<>:;,.?')

          @screening.clickSaveButton()
          waitForPageToFinishLoading()
        end

        it "Focus" do
          expect(@screening.getFocusedElementText()).to eq("Preventive Services")
        end

        it "Verify Table" do
          expect(@screening.verifyDueDate(@PS_NAME, '02/02/2015')).not_to eq(-1)
          expect(@screening.isThePSScreeningsSortedCorrectlyInTableView()).to eq(true)
        end

        it "Click Row" do
          @reminders.clickNthReminder(@screening.findIndexWithGivenPSName(@PS_NAME))
          waitForPageToFinishLoading()
        end

        it "Verify Data" do
          expect(@screening.getTextFromInput(:css, Screening::LAST_ADMINISTERED_DATE)).to eq('02/02/2015')
          expect(@screening.getNextDueDate()).to eq('02/02/2015')
          expect(@screening.getTextFromInput(:css, Screening::NOTES)).to eq('MaximumNoteCharacterTest & SpecialCharacterTest 1234567890 -_=+!@$%^*(){}[]<>:;,.? MaximumNoteCharacterTest & SpecialCharacterTest 1234567890 -_=+!@$%^*(){}[]<>:;,.? MaximumNoteCharacterTest & SpecialCharacterTest 1234567890 -_=+!@$%^*(){}[]<>:;,.? M')
        end

      end

    end

    describe "Cancel" do

      it "Change" do
        @screening.setNextDueDate('01/01/2017')

        @screening.clickCancelButton()
        waitForPageToFinishLoading()
      end

      it "Focus" do
        expect(@screening.getFocusedElementText()).to eq("Preventive Services")
      end

      it "Verify Table" do
        expect(@screening.verifyDueDate(@PS_NAME, '02/02/2015')).not_to eq(-1)
      end

      it "Click Row" do
        @reminders.clickNthReminder(@screening.findIndexWithGivenPSName(@PS_NAME))
        waitForPageToFinishLoading()
      end

      it "Verify Data" do
        expect(@screening.getNextDueDate()).to eq('02/02/2015')
      end

    end

    describe "Back Button" do

      it "Visible" do
        expect(@common.isBackButtonVisible()).to eq(true)
      end

      it "Alt Text" do
        expect(@common.getBackButtonAltText()).to eq("Return to Previous Screen")
      end

      context "Without Changes" do

        it "Click Back Button" do
          @common.clickBackButton()
          waitForPageToFinishLoading()
        end

      end

      context "With Changes" do

        it "Navigate Back" do
          @reminders.clickNthReminder(@screening.findIndexWithGivenPSName(@PS_NAME))
          waitForPageToFinishLoading()
        end

        it "Modal" do
          @screening.setNextDueDate('01/01/2017')

          @common.clickBackButton()
          !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
          expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
        end

        it "Header" do
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        end

        it "Body" do
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        end

        it "Return" do
          @modal.clickReturnButton()
          !30.times{ break if(@modal.isConfirmationPopUpNotPresent()); sleep 1 }
          expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
        end

        it "Focus" do
          expect(@screening.getFocusedElementText()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)
        end

        it "Continue" do
          @common.clickBackButton()
          !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
          expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())

          @modal.clickContinueButton()
          waitForPageToFinishLoading()
        end

        it "Verify Table" do
          expect(@screening.verifyDueDate(@PS_NAME, '02/02/2015')).not_to eq(-1)
        end

        it "Click Row" do
          @reminders.clickNthReminder(@screening.findIndexWithGivenPSName(@PS_NAME))
          waitForPageToFinishLoading()
        end

        it "Verify Data" do
          expect(@screening.getNextDueDate()).to eq('02/02/2015')
        end

      end

    end

    describe "Menu Item" do

      it "Modal" do
        @screening.setNextDueDate('01/01/2017')

        @reminders.clickSubGroup("preventive-services")
        !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
        expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      end

      it "Header" do
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      end

      it "Body" do
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
      end

      it "Return" do
        @modal.clickReturnButton()
        !30.times{ break if(@modal.isConfirmationPopUpNotPresent()); sleep 1 }
        expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
      end

      it "Focus" do
        expect(@screening.getFocusedElementText()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)
      end

      it "Continue" do
        @reminders.clickSubGroup("preventive-services")
        !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
        expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())

        @modal.clickContinueButton()
        waitForPageToFinishLoading()
      end

      it "Verify Table" do
        expect(@screening.verifyDueDate(@PS_NAME, '02/02/2015')).not_to eq(-1)
      end

      it "Click Row" do
        @reminders.clickNthReminder(@screening.findIndexWithGivenPSName(@PS_NAME))
        waitForPageToFinishLoading()
      end

      it "Verify Data" do
        expect(@screening.getNextDueDate()).to eq('02/02/2015')

        @screening.clickCancelButton()
        waitForPageToFinishLoading()
      end

    end

  end

end