require_relative '../../../../globalized'
include Globalized

describe "Story# JRNL-1120: [CPS_Osteoporosis_Screening_JRNL_1120_spec.rb] | JRNL-1303: [Update Preventive Services header]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")


    @main.clickNavMenu()
    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3200|TC#JRNL-3270: Osteoporosis Screening Display in Table." do
    @screening.clickPreventiveServices()
    waitForPageToFinishLoading()
  end

  it "AC #JRNL-3201, #JRNL-3202, #JRNL-3204|TC#JRNL-3270: Osteoporosis Screening Detail. | Required Field Validations | Save Osteoporosis Screening Entry | Cancel Osteoporosis Screening Entry.", :broken => true do
    indexID = @screening.findIndexWithGivenPSName("Osteoporosis Screening")

    expect(indexID).not_to eq(-1)

    @reminders.clickNthReminder(indexID)
    waitForPageToFinishLoading()

    #Verifying the Header, Text and Button information for the "Next Due Date Modal"
    @screening.clickInformationButton()
    !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
    expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
    expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

    @modal.clickNoButton()
    !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

    #Verify Last Completed Date cannot be future Date
    time = Time.new()
    today = time.strftime("%m/%d/%Y")
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    setDate(tomorrow, "input[name='lastCompleted']")
    @screening.selectOsteoResult("Normal")
    setDate(today, "input[name='nextDueDate']")
    @screening.verifyTotalCharacterInNarrative()
    @screening.selectNotificationStatus("Off")

    #Clicking Save button to verify required validations for invalid entries
    @screening.clickSaveButton()
    if time.year.to_s != tomorrow[-4..-1]
      checkingInlineError("Last Completed must be formatted MM/DD/YYYY.")
    else
      checkingInlineError("Last Completed must be between 01/01/1900 and " + today + ".")
    end

    setDate(today, "input[name='lastCompleted']")

    @screening.clickSaveButton()
    waitForPageToFinishLoading()
    # clickBackButtonOnBrowser
    # @modal.clickContinueButton()
    waitForPageToFinishLoading()

    #Verify Osteoporosis Screening is not available for Male Users
    @screening.switchUserAndLogBackInToPS("zztest.patient01", "patient01, zztest")
    expect(@screening.findIndexWithGivenPSName("Osteoporosis Screening")).to eq(-1)

    #Verify Osteoporosis Screening is not available for Female Users < 65 years of age
    @screening.switchUserAndLogBackInToPS("zztest.female90", "female90, zztest")
    expect(@screening.findIndexWithGivenPSName("Osteoporosis Screening")).to eq(-1)
  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

end