require_relative '../../../../globalized'
include Globalized

describe "Story# JRNL-2502: [CPS_HPV_Vaccine_JRNL_2502_spec.rb] | JRNL-1303: [Update Preventive Services header]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.female96", "female96, zztest")

    sleep 5

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  context 'AC(JRNL-2839|), TC(JRNL-2875):Display HPV vaccine in list' do

    it "Display HPV vaccine in list" do
      @reminders.clickSubGroup("preventive-services")
      waitForPageToFinishLoading()

      # Verify that default Next Due date is set to the date of the user’s 11th birthday
      isDateFormatValid?(@screening.getPatientDOB("0000000181"), "%m/%d/%Y")
      # Default next due date
      expect(@screening.verifyDueDate("HPV Vaccination", "01/01/2007")).not_to eq(-1)
    end

  end

  context 'AC(JRNL-2852), TC(JRNL-2875):Display reminder details in Detail Screen' do

    it "Display reminder details in Detail Screen;" do
      @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("HPV Vaccination"))
      waitForPageToFinishLoading()

      # Verify 'Learn More About HPV'
      @screening.clickLearnMoreLink()
      !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      expect(@modal.getConfirmationHeading()).to eq("Learn More About HPV Vaccination")

      @modal.clickNoButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      # Next due date required field when notification set to "On"
      expect(@screening.isRequiredFieldIndicatorPresent("label[for='nextDueDate'] span[ng-if='isRequired']")).to eq(false)
      setDate(getDateNthDaysFromNow(10, "%m/%d/%Y"), "input[name='nextDueDate']")
      @screening.selectNotificationStatus("On")
      expect(@screening.isRequiredFieldIndicatorPresent("label[for='nextDueDate'] span[ng-if='isRequired']")).to eq(true)
      expect(@screening.getGuidelineMessage()).to eq("For your specific health needs, you can enter an alternate Next Due date.")
      @screening.selectNotificationStatus("Off")

      expect(getTextFromInput(:css, "input[name='administered-1']")).to eq("")
      expect(isThisElementDisabled(:css, "input[name='administered-2']")).to eq(true)
      expect(isThisElementDisabled(:css, "input[name='administered-3']")).to eq(true)

      setDate(getDateNthDaysAgo(30, "%m/%d/%Y"), "input[name='administered-1']")
      expect(isThisElementDisabled(:css, "input[name='administered-2']")).to eq(false)

      setDate(getDateNthDaysAgo(35, "%m/%d/%Y"), "input[name='administered-2']")

      @screening.clickButton("save")
      checkingInlineError("Vaccinations must be entered in chronological order.")

      setDate(getDateNthDaysAgo(20, "%m/%d/%Y"), "input[name='administered-2']")
      expect(isThisElementDisabled(:css, "input[name='administered-3']")).to eq(false)

      setDate(getDateNthDaysAgo(35, "%m/%d/%Y"), "input[name='administered-3']")

      @screening.clickButton("save")
      checkingInlineError("Vaccinations must be entered in chronological order.")

      setDate(getDateNthDaysAgo(10, "%m/%d/%Y"), "input[name='administered-3']")
      expect(isThisElementDisabled(:css, "input[name='nextDueDate']")).to eq(true)
      expect(@screening.getGuidelineMessage()).to eq("You have met the recommended vaccination guidelines. Any pending notifications for this reminder will be turned off.")
      expect(isThisElementDisabled(:css, "input[name='nextDueDate']")).to eq(true)

      @screening.clickButton("cancel")
      waitForPageToFinishLoading()
    end

  end

  context 'AC(JRNL-2854), TC(JRNL-2875):Edited/Updated Reminder Rules - Next Due Date' do

    it "Edited/Updated Reminder Rules - Next Due Date;" do
      @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("HPV Vaccination"))
      waitForPageToFinishLoading()

      # Verifying the Header, Text and Button information for the "Next Due Date Modal"
      @screening.clickInformationButton()
      !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
      expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

      @modal.clickNoButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      # Verify that if date for vaccination 1 is null, retain default due dates
      expect(getTextFromInput(:css, "input[name='administered-1']")).to eq("")
      expect(getTextFromInput(:css, "input[name='nextDueDate']")).to eq("01/01/2007")

      # Verify that if date for Vaccination 1 is supplied, then next is due on 30 days from the Vaccination 1 Administered date
      setDate(getDateNthDaysAgo(20, "%m/%d/%Y"), "input[name='administered-1']")

      @screening.clickButton("setRecommendNextDueDate")
      !10.times{ break if(getTextFromInput(:css, "input[name='nextDueDate']") == getDateNthDaysFromNow(10, "%m/%d/%Y")); sleep 1 }
      expect(getTextFromInput(:css, "input[name='nextDueDate']")).to eq(getDateNthDaysFromNow(10, "%m/%d/%Y"))

      sleep 5
      # Verify that if date for Vaccination 2 is supplied, then next is due in 180 days from the Vaccination 1 Administered date
      setDate(getDateNthDaysAgo(10, "%m/%d/%Y"), "input[name='administered-2']")

      @screening.clickButton("setRecommendNextDueDate")
      !10.times{ break if(getTextFromInput(:css, "input[name='nextDueDate']") == getDateNthDaysFromNow(160, "%m/%d/%Y")); sleep 1 }
      expect(getTextFromInput(:css, "input[name='nextDueDate']")).to eq(getDateNthDaysFromNow(160, "%m/%d/%Y"))

      # Verify that if Vaccination 1, 2, and 3 dates are valued, Next due date is disabled and nullified, and static text is shown
      setDate(getDateNthDaysAgo(2, "%m/%d/%Y"), "input[name='administered-3']")
      expect(isThisElementDisabled(:css, "input[name='nextDueDate']")).to eq(true)
      expect(@screening.getGuidelineMessage()).to eq("You have met the recommended vaccination guidelines. Any pending notifications for this reminder will be turned off.")

      # Verify that Notes will be 250 characters with character countdown
      expect(@screening.verifyTotalCharacterInNarrative()).to eq(true)
      @screening.setNote("HPV Vaccination is partially covered by insurance.")

      @screening.clickSaveButton()
      waitForPageToFinishLoading()
    end

  end

  context 'AC(JRNL-2852), TC(JRNL-2875):Default due date behavior - female and male' do

    it "Default due date behavior - female and male; " do
      #user is 11 or older and less than 27 years old
      updateMockUsersTable(209, "FEMALE", "01/01/1990")
      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.female90", "female90, zztest")

      sleep 5

      @nav_menu.clickReminders()
      !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())

      @reminders.clickSubGroup("preventive-services")
      waitForPageToFinishLoading()

      #verify that, HPV is available for female user
      expect(@screening.verifyDueDate("HPV Vaccination", "01/01/2001")).not_to eq(-1)

      @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("HPV Vaccination"))
      waitForPageToFinishLoading()

      #Verify that, Next Due date is set to the user's 11th birthday
      expect(@screening.getNextDueDate()).to eq("01/01/2001")

      updateMockUsersTable(209, "FEMALE", "01/01/1986")
      refreshBrowser()

      @screening.clickButton("cancel")
      waitForPageToFinishLoading()

      expect(@screening.verifyDueDate("HPV Vaccination", "01/01/2001")).not_to eq(-1)

      @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("HPV Vaccination"))
      waitForPageToFinishLoading()

      expect(@screening.getNextDueDate()).to eq("01/01/2001")

      # female user, 26 or older (carla watson)
      updateMockUsersTable(209, "FEMALE", "01/01/1990")
      @common.switchUserThenLogBackInAndGoToLeftSideNav("carla.watson", "Watson, Carla")

      sleep 5

      @nav_menu.clickReminders()
      !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())

      @reminders.clickSubGroup("preventive-services")
      waitForPageToFinishLoading()

      @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("HPV Vaccination"))
      waitForPageToFinishLoading()

      expect(getTextForElement(:css, "date-control[label='Next Due Date'] input")).to eq("")
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Off", "notificationOption")).to eq(true)
      expect(isThisElementDisabled(:css, "input[name='notificationTriggerDate']")).to eq(true)
      expect(isThisElementDisabled(:css, "input[name='notificationDelivery']")).to eq(true)

      # male user (patient01)
      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.patient01", "patient01, zztest")

      sleep 5

      @nav_menu.clickReminders()
      !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())

      @reminders.clickSubGroup("preventive-services")
      waitForPageToFinishLoading()

      @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("HPV Vaccination"))
      waitForPageToFinishLoading()

      expect(getTextForElement(:css, "date-control[label='Next Due Date'] input")).to eq("")
      expect(@screening.getGuidelineMessage()).to eq("Men ages 19-26 check with your provider to determine need for an HPV vaccine.")
    end

  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

end