require_relative '../../../../globalized'
include Globalized

describe "[Story# JRNL-1619: HIV Screening]
          [Story# JRNL-1303: Update Preventive Services header]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("notifications", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")

    initializeAllObjects

    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    @ENTRY_FORM_CONTENT =  [\
                    "HIV Screening",
                    "Learn More",
                    "Last Tested:",
                    "MM/DD/YYYY",
                    "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
                    "Results:",
                    "Select",
                    "Normal",
                    "Abnormal",
                    "Next Due Date:",
                    "MM/DD/YYYY",
                    "Next Due Date will become required if you turn on Notifications for this reminder.",
                    "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
                    "For your specific health needs, you may enter an alternate Next Due Date.",
                    "Notes:",
                    "250 character maximum",
                    "250 characters left",
                    "Notifications are available for future due dates only.",
                    "Notification:",
                    "Status:",
                    "On",
                    "Off",
                    "Notify Me About This Due Date:",
                    "On the date 1 day before 2 weeks before 4 weeks before",
                    "Notification Delivery:",
                    "In-App",
                    "Email",
                    "Email address has not been saved",
                    "You may update your Preferred Email address in the Notification feature by selecting the notification settings icon",
                    "You may update your Preferred Email address in the Notification feature by selecting the icon.", "Save Cancel"]

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")

    @reminders.clickSubGroup("preventive-services")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1105|TC JRNL-1102: HIV Screening Criteria"  do
    it "Header: Edit Preventive Services " do
      clickHIVScreeningAndVerifyHeader()
    end

    it "Labels", :broken => true do
      pageContent = @screening.getScreenContent().split("\n")

      @ENTRY_FORM_CONTENT.each_with_index do | expectedScreenRow, i |
        expect(pageContent[i]).to eq(expectedScreenRow)
      end
      expect(pageContent.length).to eq(@ENTRY_FORM_CONTENT.length)
    end

    it "If User is >=66 set NDD = Null; display as None in table list view." do
      #zztest.patient05 >= 66
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")
      @screening.clickSaveButton()

      #verify Results field is not required and saved without the error
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      indexID = @screening.findIndexWithGivenPSName("HIV Screening")

      expect(indexID).not_to eq(-1)
      #puts "row index is " + indexID.to_s
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq("None")
      clickHIVScreeningAndVerifyHeader()
    end

    it "Last Tested (date, date picker, mm/dd/yyyy), cannot be future date" do
      setDate(@tomorrow, "input[name='lastCompleted']")
      @screening.clickSaveButton

      checkingInlineError("Last Tested must be between 01/01/1900 and " + @today + ".")
      setDate(@today, "input[name='lastCompleted']")

      #If a user updates the Last Test Date, the Results field and the NDD are nullified and the user  must manually  update  make any further updates
      expect(getSelectedOptionValue(:css, "select[name='result']")).to eq("")
      expect(@screening.getNextDueDate).to eq("")

    end

    it "Results (single select, values: Select, Normal, Abnormal, default to Select)" do
      expect(areAllTheseValuesAvailableInDropDown("select[name='result']", "Select,Normal,Abnormal")).to eq(true)
      expect(getSelectedOptionValue(:css, "select[name='result']")).to eq("")
      @screening.clickSaveButton()

      checkingInlineError("Results field is required.")
    end

    it "Display information icon" do
      @screening.clickInformationButton()
      !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
      expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")
      #close
      @modal.clickNoButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
    end

    it "Note (text 250 characters), display character count down" do
      expect(getTextForElement(:css, Screening::NOTES_LABEL)).to eq("Notes:")
      #verify that Notes will be 250 characters with character countdown
      expect(@screening.verifyTotalCharacterInNarrative()).to eq(true)

      #Phone View
      resizeWindowToPhone()

      @screening.clickCancelButton

      !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
      indexID = @screening.findIndexWithGivenPSName("HIV Screening")

      expect(indexID).not_to eq(-1)

      @reminders.clickNthReminder(indexID)
      !45.times { break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

      resizeWindowToDefault()
    end

    it "User must manually update; the system will not update NDD based on last tested date or results." do
      expect(@screening.getNextDueDate).to eq("")
      setDate(@yesterday, "input[name='lastCompleted']")
      expect(@screening.getNextDueDate).to eq("")
      @screening.selectResult("Normal")

      @screening.clickSaveButton
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      indexID = @screening.findIndexWithGivenPSName("HIV Screening")

      expect(indexID).not_to eq(-1)
      #puts "row index is " + indexID.to_s
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq("None")

    end

    it "Enter HIV entry and Verify for user >= 66 " do
      addEntriesAndVerifyEntries

    end

    it "User < 66, NDD = User's 15th birthday ", :broken => true do
      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.male90", "male90, zztest")
      @nav_menu.clickReminders()
      !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
      expect(@reminders.getSecondaryHeader()).to eq("My Reminders")

      @reminders.clickSubGroup("preventive-services")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

      clickHIVScreeningAndVerifyHeader()

      expect(@screening.getNextDueDate).to eq("01/01/2005")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")
      @screening.clickSaveButton()

      #verify Results field is not required and saved without the error
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      addEntriesAndVerifyEntries

    end

  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

  def clickHIVScreeningAndVerifyHeader()
    indexID = @screening.findIndexWithGivenPSName("HIV Screening")

    expect(indexID).not_to eq(-1)

    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
  end

  def updateHIVEntryAndVerify(lastTestedDate, result, nextDueDate, notes, nddColumn, nddText)
    indexID = @screening.findIndexWithGivenPSName("HIV Screening")
    expect(indexID).not_to eq(-1)
    clickHIVScreeningAndVerifyHeader()

    setDate(lastTestedDate, "input[name='lastCompleted']")
    expect(getSelectedOptionValue(:css, "select[name='result']")).to eq("")
    expect(@screening.getNextDueDate).to eq("")

    @screening.setNextDueDate(nextDueDate)
    @screening.selectResult(result)

    #If the user sets Results = Abnormal, nullify the NDD
    #show NDD text as: Because your screening test was abnormal...
    if (result == "Abnormal")
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Because your screening test was abnormal, please consult with your physician to determine your next due date.")
    elsif
    #If the Results are Null or Normal, the NDD is not updated by the system and the NDD text remains as shown in 8.3.
      expect(@screening.getNextDueDate).to eq(nextDueDate)
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")
    end

    @screening.setNextDueDate(nextDueDate)
    @screening.setNote(notes)
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq(nddText)

    @screening.selectNotificationStatus("Off")

    @screening.clickSaveButton()

    #verify Results field is not required and saved without the error
    !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    indexID = @screening.findIndexWithGivenPSName("HIV Screening")

    expect(indexID).not_to eq(-1)
    #puts "row index is " + indexID.to_s
    expect(@reminders.getTextForRowCol(indexID, 3)).to eq(nddColumn)
    clickHIVScreeningAndVerifyHeader()

    expect(getTextFromInput(:css, "input[name='lastCompleted']")).to eq(lastTestedDate)
    expect(getSelectedOptionValue(:css, "select[name='result']")).to eq(result)
    expect(@screening.getNextDueDate).to eq(nextDueDate)
    expect(@screening.getNote).to eq(notes)
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq(nddText)

    @screening.clickCancelButton
    !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

  end

  def addEntriesAndVerifyEntries
    lastTestedDate = getDateNthDaysFromNow(-40, "%m/%d/%Y")
    result = "Normal"
    nextDueDate = ""
    notes = "Testing Normal results - 2"
    nddColumn = "None"
    nddText = "For your specific health needs, you may enter an alternate Next Due Date."
    updateHIVEntryAndVerify(lastTestedDate, result, nextDueDate, notes, nddColumn, nddText)

    lastTestedDate =getDateNthDaysFromNow(-33, "%m/%d/%Y")
    result = "Normal"
    nextDueDate = ""
    notes = "Testing Normal results - 3"
    nddColumn = "None"
    nddText = "For your specific health needs, you may enter an alternate Next Due Date."
    updateHIVEntryAndVerify(lastTestedDate, result, nextDueDate, notes, nddColumn, nddText)

    lastTestedDate = getDateNthDaysFromNow(-20, "%m/%d/%Y")
    result = "Normal"
    nextDueDate = getDateNthDaysFromNow(60, "%m/%d/%Y")
    notes = "Testing Normal results - 3"
    nddColumn = nextDueDate
    nddText = "For your specific health needs, you may enter an alternate Next Due Date."
    updateHIVEntryAndVerify(lastTestedDate, result, nextDueDate, notes, nddColumn, nddText)

    lastTestedDate = getDateNthDaysFromNow(-40, "%m/%d/%Y")
    result = "Abnormal"
    nextDueDate = getDateNthDaysFromNow(80, "%m/%d/%Y")
    notes = "Testing Abnormal results"
    nddColumn = nextDueDate
    nddText = "Because your screening test was abnormal, please consult with your physician to determine your next due date."
    updateHIVEntryAndVerify(lastTestedDate, result, nextDueDate, notes, nddColumn, nddText)


    lastTestedDate = getDateNthDaysFromNow(-10, "%m/%d/%Y")
    result = "Abnormal"
    nextDueDate = ""
    notes = "Testing Normal results - 3"
    nddColumn = "Consult Provider"
    nddText = "Because your screening test was abnormal, please consult with your physician to determine your next due date."
    updateHIVEntryAndVerify(lastTestedDate, result, nextDueDate, notes, nddColumn, nddText)
  end

end