require_relative '../../../../globalized'
include Globalized

describe "Story# JRNL-2528|JRNL-2471: [CPS_Flu_Vaccination_MVAH_4_1241_spec.rb] | JRNL-1303: [Update Preventive Services header]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    sleep 5

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-2746|TC#JRNL-2771: Flu Vaccination Display in Table." do
    @screening.clickPreventiveServices()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
  end

  it "AC #JRNL-2747, #JRNL-2748, #JRNL-2749|TC#JRNL-2771: Flu Vaccination Screening Detail. | Required Field Validations | Save Flu Vaccination Entry | Cancel Flu Vaccination Entry." do
    indexID = @screening.findIndexWithGivenPSName("Flu Vaccination")

    expect(indexID).not_to eq(-1)

    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

    #Verifying the Header, Text and Button information for the "Next Due Date Modal"
    @screening.clickInformationButton()
    !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
    expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
    expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

    @modal.clickNoButton()
    !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

    #Verify Last Taken Date cannot be future Date
    time = Time.new()
    today = time.strftime("%m/%d/%Y")
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    setDate(tomorrow, "input[name='lastAdministered']")
    setDate(today, "input[name='nextDueDate']")
    @screening.verifyTotalCharacterInNarrative()
    @screening.selectNotificationStatus("Off")

    #Clicking Save button to verify required validations for invalid entries
    @screening.clickSaveButton()
    if time.year.to_s != tomorrow[-4..-1]
      checkingInlineError("Last Administered must be formatted MM/DD/YYYY.")
    else
      checkingInlineError("Last Administered must be between 01/01/1900 and " + today + ".")
    end

    setDate(today, "input[name='lastAdministered']")

    @screening.clickSaveButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
  end

  it "AC #JRNL-2849, #JRNL-2850|TC#JRNL-2910: Flu Vaccine reminder default date. | Recommend Next Due Date button. " do
    @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("Flu Vaccination"))
    !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

    #Clearing Last Administered Date and clicking Recommend Next Due Date button
    setDate("", "input[name='lastAdministered']")
    @screening.clickButton("setRecommendNextDueDate")

    presentTime = Time.new()
    dateBetwnLastAndCurrentAug = Time.new(presentTime.year-1, 8, 1).strftime("%m/%d/%Y")
    dateBeforeLastAug = Time.new(presentTime.year-1, 7, 31).strftime("%m/%d/%Y")
    dateAfterCurrentAug = Time.new(presentTime.year, 8, 1).strftime("%m/%d/%Y")

    #Verifying Default Next Due Date based on Current Date
    date = Time.new(presentTime.year, 8, 1)
    expectedYear = presentTime.year

    if (presentTime < date)
      expectedYear = presentTime.year-1
    end

    expectedDate = Time.new(expectedYear, 9, 1).strftime("%m/%d/%Y")
    expect(getTextFromInput(:css, "input[name='nextDueDate']")).to eq(expectedDate)

    #If Last Administered Date is before 8/1 of previous year
    setDate(dateBeforeLastAug, "input[name='lastAdministered']")
    @screening.clickButton("setRecommendNextDueDate")
    expect(getTextFromInput(:css, "input[name='nextDueDate']")).to eq(Time.new(presentTime.year-1, 9, 1).strftime("%m/%d/%Y"))

    #If Last Administered Date is on 8/1 of previous year or between 8/1 of previous year and 8/1 of Current year
    setDate(dateBetwnLastAndCurrentAug, "input[name='lastAdministered']" )
    @screening.clickButton("setRecommendNextDueDate")
    expect(getTextFromInput(:css, "input[name='nextDueDate']")).to eq(Time.new(presentTime.year, 9, 1).strftime("%m/%d/%Y"))

    #If Last Administered Date is after 8/1 of Current year
    setDate(dateAfterCurrentAug, "input[name='lastAdministered']")
    @screening.clickButton("setRecommendNextDueDate")
    expect(getTextFromInput(:css, "input[name='nextDueDate']")).to eq(Time.new(presentTime.year+1, 9, 1).strftime("%m/%d/%Y"))
  end

  it "AC #JRNL-2913|TC#JRNL-2910: Flu - Notification Defaults." do
    @screening.clickCancelButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("Flu Vaccination"))
    !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

    expect(isThisRadioButtonOrCheckBoxSelected("radio", "Off", "notificationOption")).to eq(true)
    expect(isThisElementDisabled(:css, "input[name='notificationTriggerDate']")).to eq(true)
    expect(isThisElementDisabled(:css, "input[name='notificationDelivery']")).to eq(true)

    @screening.clickCancelButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

end