require_relative '../../../../globalized'
include Globalized

describe "Story# JRNL-1620: [CPS_Colorectal_Cancer_Screening_JRNL_1620_spec.rb] | JRNL-1303: [Update Preventive Services header]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    sleep 5

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3208|TC#JRNL-3273: Colorectal Cancer Screening Display in Table" do
    @screening.clickPreventiveServices()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
  end

  it "AC #JRNL-3209, #JRNL-3211, #JRNL-3212|TC#JRNL-3273: Colorectal Cancer Screening Detail. | Required Field Validations | Save Colorectal Cancer Screening Entry | Cancel Colorectal Cancer Screening Entry." do
    indexID = @screening.findIndexWithGivenPSName("Colorectal Cancer Screening")

    expect(indexID).not_to eq(-1)

    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

    #Verifying the Header, Text and Button information for the "Next Due Date Modal"
    @screening.clickInformationButton()
    !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
    expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
    expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

    @modal.clickNoButton()
    !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

    #Verify Last Completed Date cannot be future date
    time = Time.new()
    today = time.strftime("%m/%d/%Y")
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    setDate(tomorrow, "input[name='lastCompleted']")
    @screening.selectTypeOfTest("Colonoscopy")
    @screening.selectResult("Normal")
    setDate(today, "input[name='nextDueDate']")
    @screening.verifyTotalCharacterInNarrative()

    @screening.selectNotificationStatus("Off")

    #Clicking Save button to verify required validations for invalid entries
    @screening.clickSaveButton()
    if time.year.to_s != tomorrow[-4..-1]
      checkingInlineError("Last Completed must be formatted MM/DD/YYYY.")
    else
      checkingInlineError("Last Completed must be between 01/01/1900 and " + today + ".")
    end

    setDate(today, "input[name='lastCompleted']")

    @screening.clickSaveButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

end