require_relative '../../../../globalized'
include Globalized

describe "[Story #JRNL-1621: Cholesterol Screening ]
          [Story #JRNL-1303: [Update Preventive Services header]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("notifications", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")

    initializeAllObjects

    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    @ENTRY_FORM_CONTENT =  [\
                    "Cholesterol Screening",
                    "Learn More",
                    "Last Tested:",
                    "MM/DD/YYYY",
                    "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
                    "Results:",
                    "Select",
                    "Normal",
                    "Abnormal",
                    "Next Due Date:",
                    "MM/DD/YYYY",
                    "Next Due Date will become required if you turn on Notifications for this reminder.",
                    "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
                    "For your specific health needs, you may enter an alternate Next Due Date.",
                    "Notes:",
                    "250 character maximum",
                    "250 characters left",
                    "Send yourself a notice about this preventive service due date.",
                    "Notification:",
                    "Status:",
                    "On",
                    "Off",
                    "Notify Me About This Due Date:",
                    "On the date 1 day before 2 weeks before 4 weeks before",
                    "Notification Delivery:",
                    "In-App",
                    "Email",
                    "Email address has not been saved",
                    "You may update your Preferred Email address in the Notification feature by selecting the notification settings icon",
                    "You may update your Preferred Email address in the Notification feature by selecting the icon.", "Save Cancel"]


    @common.loginEndsOnLandingPage("zztest.female90", "female90, zztest")
    expect(@main.getFooterText()).to eq("Logged in as female90, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")

    @reminders.clickSubGroup("preventive-services")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !45.times{ break if (@reminders.getRemindersCount == 13); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    waitForPageToFinishLoading()
  end

  after(:all) do
    quitDriver()
  end

  context "AC #MVAH - | TC MVAH-5661 " do
    it "Header will display 'Edit Preventive Service' " do
      clickCholesterolScreeningAndVerifyHeader()
    end

    it "Labels" do
      pageContent = @screening.getScreenContent().split("\n")

      @ENTRY_FORM_CONTENT.each_with_index do | expectedScreenRow, i |
        expect(pageContent[i]).to eq(expectedScreenRow)
      end
      expect(pageContent.length).to eq(@ENTRY_FORM_CONTENT.length)
    end

    it "Last Tested (date, date picker, mm/dd/yyyy), cannot be future date" do
      setDate(@tomorrow, "input[name='lastCompleted']")
      @screening.clickSaveButton

      checkingInlineError("Last Tested must be between 01/01/1900 and " + @today + ".")
      setDate(@today, "input[name='lastCompleted']")
    end

    it "Results (single select, values: Select, Normal, Abnormal, default to Select)" do
      expect(areAllTheseValuesAvailableInDropDown("select[name='result']", "Select,Normal,Abnormal")).to eq(true)
      @screening.clickSaveButton()
      checkingInlineError("Results field is required.")
    end

    it "Display information icon which links to a modal window showing the following text: " do
      @screening.clickInformationButton()
      !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
      expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")
      #ok button
      @modal.clickNoButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      @screening.clickCancelButton
      !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

      clickCholesterolScreeningAndVerifyHeader()

    end

    it "Females:  Default NDD => Default to user's 45th birthday" do
      #zztest.female 90 (dob 01/01/1990)
      defaultNextDueDate = "01/01/2035"
      verifyBusinessLogic (defaultNextDueDate)

    end

    it "Male: Default NDD => user's 35th birthday " do
      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.male90", "male90, zztest")
      @nav_menu.clickReminders()
      !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
      expect(@reminders.getSecondaryHeader()).to eq("My Reminders")

      @reminders.clickSubGroup("preventive-services")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !45.times{ break if (@reminders.getRemindersCount == 10); sleep 1 }
      !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

      clickCholesterolScreeningAndVerifyHeader()

      defaultNextDueDate = "01/01/2025"
      verifyBusinessLogic (defaultNextDueDate)

    end

  end

  def verifyBusinessLogic (defaultNextDueDate)
    expect(@screening.getNextDueDate()).to eq(defaultNextDueDate)
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

    #When a user (at any age, any gender) enters a LTD, Nullify Results and show Results field as required.
    setDate(@yesterday, "input[name='lastCompleted']")
    expect(getSelectedOptionValue(:css, "select[name='result']")).to eq("")
    @screening.clickSaveButton()
    checkingInlineError("Results field is required.")

    nextDueDate =  getDateNThYearFromGivenDate(@yesterday, 5)
    #result == null
    expect(@screening.getNextDueDate).to eq(nextDueDate)
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

    #result = normal
    @screening.selectCholesterolResult("Normal")
    expect(@screening.getNextDueDate).to eq(nextDueDate)
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

    #Select Off from Notification Preference
    @screening.selectNotificationStatus("Off")

    @screening.clickSaveButton()

    !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    indexID = @screening.findIndexWithGivenPSName("Cholesterol Screening")
    expect(indexID).not_to eq(-1)
    puts "row index is " + indexID.to_s
    expect(@reminders.getTextForRowCol(indexID, 3)).to eq(nextDueDate)

    clickCholesterolScreeningAndVerifyHeader()

    expect(getSelectedOptionValue(:css, "select[name='result']")).to eq("Normal")
    expect(@screening.getNextDueDate).to eq(nextDueDate)
    expect(getTextFromInput(:css, "input[name='lastCompleted']")).to eq(@yesterday)
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

    @screening.selectCholesterolResult("Abnormal")
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Because your screening test was abnormal, please consult with your physician to determine your next due date.")
    expect(@screening.getNextDueDate).to eq("")

    @screening.clickSaveButton()
    !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    indexID = @screening.findIndexWithGivenPSName("Cholesterol Screening")
    expect(indexID).not_to eq(-1)
    puts "row index is " + indexID.to_s
    expect(@reminders.getTextForRowCol(indexID, 3)).to eq("Consult Provider")

    clickCholesterolScreeningAndVerifyHeader()

    expect(@screening.getNextDueDate).to eq("")
    expect(getTextFromInput(:css, "input[name='lastCompleted']")).to eq(@yesterday)
    expect(getSelectedOptionValue(:css, "select[name='result']")).to eq("Abnormal")
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Because your screening test was abnormal, please consult with your physician to determine your next due date.")

    setDate("", "input[name='lastCompleted']")
    expect(@screening.getNextDueDate).to eq("")
    expect(getSelectedOptionValue(:css, "select[name='result']")).to eq("")
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

    @screening.clickSaveButton()

    !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !10.times { break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    indexID = @screening.findIndexWithGivenPSName("Cholesterol Screening")
    expect(indexID).not_to eq(-1)
    puts "row index is " + indexID.to_s
    expect(@reminders.getTextForRowCol(indexID, 3)).to eq("None")

    clickCholesterolScreeningAndVerifyHeader()

    expect(getSelectedOptionValue(:css, "select[name='result']")).to eq("")
    expect(@screening.getNextDueDate).to eq("")
    expect(getTextFromInput(:css, "input[name='lastCompleted']")).to eq("")
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")
  end

  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

  def clickCholesterolScreeningAndVerifyHeader
    indexID = @screening.findIndexWithGivenPSName("Cholesterol Screening")

    expect(indexID).not_to eq(-1)

    @reminders.clickNthReminder(indexID)
    !45.times { break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
  end

end