require_relative '../../../../globalized'
include Globalized

describe "[Story# JRNL-1625: Cervical Cancer Screening]
          [Story# JRNL-1303: Update Preventive Services header]
          [Story# JRNL-1068: Update Cervical Cancer Logic ]", :broken => true, :acceptance => true do

  before(:all) do
    initializeConfigurations(BASE_URL)

    removeCollection("preferences", "healthtrackerdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("notifications", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")
    initializeAllObjects

    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    #patient < 30 years old
    #dob 11/4/1998
    #@common.loginEndsOnLandingPage( "rosemary.payne", "Payne, Rosemary")
    #expect(@main.getFooterText()).to eq("Logged in as Payne, Rosemary")

    @common.loginEndsOnLandingPage("zztest.female96", "female96, zztest")
    expect(@main.getFooterText()).to eq("Logged in as female96, zztest")

    @nav_menu.clickReminders()

    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")

    @reminders.clickSubGroup("preventive-services")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !45.times{ break if (@reminders.getRemindersCount == 13); sleep 1 }
    !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    waitForPageToFinishLoading()

  end

  after(:all) do
    quitDriver()
  end

  context "AC #JRNL-1056|TC JRNL-1042: Update Cervical Cancer Logic for a user < 30 yrs old" do
    it "When patient is under 30, hide HPV Test date and HPV Test results fields " do

      indexID = @screening.findIndexWithGivenPSName("Cervical Cancer Screening")

      @reminders.clickNthReminder(indexID)
      waitForPageToFinishLoading()

      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(getTextForElement(:css, Screening::PS_TITLE)).to eq("Cervical Cancer Screening")

      pageContent = @screening.getScreenContent().to_s

      expect(pageContent).not_to include("Last HPV Test")
      expect(pageContent).not_to include("Last HPV Test Results")
    end

  end

  context "AC #JRNL-1115|TC JRNL-1108: Cervical Cancer Screening - Update Logic" do
    it "Header will display service name: Edit Preventive Service" do
       @common.fastSwitchUserThenLogBackInAndGoToLeftSideNav("len.pogach", "Len", "Pogach", "1010101032")

       @nav_menu.clickReminders()
       !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
       expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
       expect(@reminders.getSecondaryHeader()).to eq("My Reminders")

       @reminders.clickSubGroup("preventive-services")
       !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
       !45.times{ break if (@reminders.getRemindersCount == 13); sleep 1 }
       !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

       expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

       indexID = @screening.findIndexWithGivenPSName("Cervical Cancer Screening")
       expect(indexID).not_to eq(-1)

       @reminders.clickNthReminder(indexID)
       waitForPageToFinishLoading()

       !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
       expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
       expect(getTextForElement(:css, Screening::PS_TITLE)).to eq("Cervical Cancer Screening")
     end

     it "Last Pap Smear, date picker, mm/dd/yyyy), cannot be future date" do
       expect(getTextForElement(:css, Screening::LAST_PAP_DATE_LABEL)).to eq("Last Pap Smear:")
       setDate(@tomorrow, "input[name='Pap Smear-lastCompleted']")
       @screening.clickSaveButton

       checkingInlineError("Last Pap Smear must be between 01/01/1900 and " + @today + ".")

       setDate(@today, "input[name='Pap Smear-lastCompleted']")
     end

     it "Last Pap Smear Results (Select, Normal, Abnormal)" do
       expect(getTextForElement(:css, Screening::LAST_PAP_RESULTS_LABEL)).to eq("* Last Pap Smear Results:")

       expect(areAllTheseValuesAvailableInDropDown("select[name='Pap Smear-result']", "Select,Normal,Abnormal")).to eq(true)
       @screening.clickSaveButton()
       checkingInlineError("Last Pap Smear Results field is required.")
     end

     it "Last HPV Test (date, date picker, mm/dd/yyyy), cannot be future date " do
       expect(getTextForElement(:css, Screening::LAST_HPV_TEST_LABEL)).to eq("Last HPV Test:")
       setDate(@tomorrow, "input[name='HPV Test-lastCompleted']")
       @screening.clickSaveButton

       checkingInlineError("Last HPV Test must be between 01/01/1900 and " + @today + ".")

       setDate(@today, "input[name='HPV Test-lastCompleted']")
     end

     it "Last HPV Test Results (Select, Normal, Abnormal) " do
       expect(getTextForElement(:css, Screening::LAST_HPV_TEST_RESULTS_LABEL)).to eq("* Last HPV Test Results:")

       expect(areAllTheseValuesAvailableInDropDown("select[name='HPV Test-result']", "Select,Normal,Abnormal")).to eq(true)
       @screening.clickSaveButton()
       checkingInlineError("Last HPV Test Results field is required.")
     end

     it "Next Due Date (date, date picker, mm/dd/yyyy) " do
       expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_LABEL)).to eq("Next Due Date:")
       #business logic will be tested below
     end

     it "Display Information icon" do
        #Verifying the Header, Text and Button information for the "Next Due Date Modal"
        @screening.clickInformationButton()
        !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
        expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
        expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
        expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")
        #ok button
        @modal.clickNoButton()
       !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
        expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
     end

     it "Note (text 250 characters), display character count down" do
       expect(getTextForElement(:css, Screening::NOTES_LABEL)).to eq("Notes:")
       #verify that Notes will be 250 characters with character countdown
       expect(@screening.verifyTotalCharacterInNarrative()).to eq(true)

       #Phone View
       resizeWindowToPhone()

       @screening.clickCancelButton

       !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
       !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

       expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
       indexID = @screening.findIndexWithGivenPSName("Cervical Cancer Screening")

       expect(indexID).not_to eq(-1)

       @reminders.clickNthReminder(indexID)
       !45.times { break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
       expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

       resizeWindowToDefault()
     end

     it "User < 66, set NDD = user's 21st birthday" do
       ##########
       # Normal #
       ##########

       for_your_specific_health_message = "For your specific health needs, you may enter an alternate Next Due Date."

       #Set the NDD to the user’s 21st birthday.
       lastPapSmearDate = ""
       papResult = ""
       lastHpvDate = ""
       hpvResult = ""
       nextDueDate =  "05/05/1976"
       message = for_your_specific_health_message
       nddColumn = "05/05/1976"
       verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn)

       #If Last Pap Smear date is added or edited and the user is 66 or younger,  Nullify Last Pap Smear Results
       setDate(getDateNthDaysFromNow(30, "%m/%d/%Y"), "input[name='Pap Smear-lastCompleted']")
       expect(getSelectedOptionValue(:css, "select[name='Pap Smear-result']")).to eq("")
       expect(getTextForElement(:css, Screening::LAST_PAP_RESULTS_LABEL)).to eq("* Last Pap Smear Results:")
       @screening.clickSaveButton()
       checkingInlineError("Last Pap Smear Results field is required.")

       #If Last HPV Test date is added or edited and the user is 66 or younger, then Nullify: Last HPV Test Results, required
       setDate(getDateNthDaysFromNow(20, "%m/%d/%Y"), "input[name='HPV Test-lastCompleted']")
       expect(getSelectedOptionValue(:css, "select[name='HPV Test-result']")).to eq("")
       expect(getTextForElement(:css, Screening::LAST_HPV_TEST_RESULTS_LABEL)).to eq("* Last HPV Test Results:")
       @screening.clickSaveButton()
       checkingInlineError("Last HPV Test Results field is required.")

       lastPapSmearDate = ""
       papResult = "Normal"
       lastHpvDate = ""
       hpvResult = ""
       nextDueDate =  ""
       message = for_your_specific_health_message
       nddColumn = "None"
       verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

       #user can edit NDD
       nextDueDate = getDateNthDaysFromNow(30, "%m/%d/%Y")
       editNddAndVerifyNddColumn(nextDueDate)
       verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)

       #	If Last Pap Smear results value = Normal AND if Last HPV results = null, Set NDD = Last Pap Smear date + 3 years;
       thirtyDaysAgo = getDateNthDaysFromNow(-30, "%m/%d/%Y")
       lastPapSmearDate = thirtyDaysAgo
       papResult = "Normal"
       lastHpvDate = ""
       hpvResult = ""
       nextDueDate = getDateNThYearFromGivenDate(thirtyDaysAgo, 3)
       message = for_your_specific_health_message
       nddColumn = nextDueDate
       verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )


       #	If Last Pap Smear results value = Normal AND if Last HPV results = normal, then Set NDD = Last Pap Smear date + 5 years;
       twentyFive = getDateNthDaysFromNow(-25, "%m/%d/%Y")
       lastPapSmearDate = twentyFive
       papResult = "Normal"
       lastHpvDate = getDateNthDaysFromNow(-35, "%m/%d/%Y")
       hpvResult = "Normal"
       nextDueDate = getDateNThYearFromGivenDate(twentyFive, 5)
       message = for_your_specific_health_message
       nddColumn = nextDueDate
       verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

       ############
       # Abnormal #
       ############

       because_results_abnormal_message = "Because your results were abnormal, please consult with your physician to determine your next due date."

       #	If Last Pap Smear results value = Abnormal, (regardless of HPV results value) then, 	Display NDD as null (do not disable);
       twentyFive = getDateNthDaysFromNow(-25, "%m/%d/%Y")
       lastPapSmearDate = twentyFive
       papResult = "Abnormal"
       lastHpvDate = getDateNthDaysFromNow(-35, "%m/%d/%Y")
       hpvResult = "Normal"
       nextDueDate = ""
       message = because_results_abnormal_message
       nddColumn = "Consult Provider"
       verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

       #user can edit NDD
       nextDueDate = getDateNthDaysFromNow(40, "%m/%d/%Y")
       editNddAndVerifyNddColumn(nextDueDate)
       verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)

       tenDaysAgo = getDateNthDaysFromNow(-10, "%m/%d/%Y")
       lastPapSmearDate = tenDaysAgo
       papResult = "Abnormal"
       lastHpvDate = ""
       hpvResult = "Abnormal"
       nextDueDate = ""
       message = because_results_abnormal_message
       nddColumn =  "Consult Provider"
       verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

       #	If the Pap Smear Results are null, NDD= null, then Display “None” in the NDD column of the table list view
       lastPapSmearDate = ""
       papResult = ""
       lastHpvDate = getDateNthDaysFromNow(-60, "%m/%d/%Y")
       hpvResult = "Normal"
       nextDueDate = ""
       message = for_your_specific_health_message
       nddColumn =  "None"
       verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

       #user can edit NDD
       nextDueDate = getDateNthDaysFromNow(40, "%m/%d/%Y")
       editNddAndVerifyNddColumn(nextDueDate)
       verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)

       #If the HPV Test Results are abnormal, NDD= null, NDD will display as "Consult Provider" in table list view
       fiftyFiveDaysAgo = getDateNthDaysFromNow(-55, "%m/%d/%Y")
       lastPapSmearDate = fiftyFiveDaysAgo
       papResult = "Normal"
       lastHpvDate = getDateNthDaysFromNow(-60, "%m/%d/%Y")
       hpvResult = "Abnormal"
       nextDueDate = ""
       message = because_results_abnormal_message
       nddColumn =  "Consult Provider"
       verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

       #user can edit NDD
       nextDueDate = getDateNthDaysFromNow(40, "%m/%d/%Y")
       editNddAndVerifyNddColumn(nextDueDate)
       #defect:  when saved and opened again, invalid message is displayed
       verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)

       @screening.clickCancelButton

       !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
       !45.times { break if (@reminders.getRemindersCount() == 13); sleep 1 }

     end

    it "Patient > = 66" do
      #patient >= 65 yrs old
      @common.switchUserThenLogBackInAndGoToLeftSideNav("pat.sanchez", "sanchez, pat")
      @nav_menu.clickReminders()
      !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
      expect(@reminders.getSecondaryHeader()).to eq("My Reminders")

      @reminders.clickSubGroup("preventive-services")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !45.times{ break if (@reminders.getRemindersCount == 13); sleep 1 }
      !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
      indexID = @screening.findIndexWithGivenPSName("Cervical Cancer Screening")

      @reminders.clickNthReminder(indexID)
      waitForPageToFinishLoading()

      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(getTextForElement(:css, Screening::PS_TITLE)).to eq("Cervical Cancer Screening")

      women_65_older_message = "Women who are older than 65 who have had normal Pap Smear results previously and are not at high risk for cervical cancer may not need to be screened. Please discuss with your provider."
      lastPapSmearDate = ""
      papResult = ""
      lastHpvDate = ""
      hpvResult = ""
      nextDueDate = ""
      message = women_65_older_message
      nddColumn =  "None"
      verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

      #user can edit NDD
      nextDueDate = getDateNthDaysFromNow(10, "%m/%d/%Y")
      editNddAndVerifyNddColumn(nextDueDate)
      verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)

      #If Last Pap Smear date is added or edited and the user is 66 or younger,  Nullify Last Pap Smear Results
      setDate(getDateNthDaysFromNow(30, "%m/%d/%Y"), "input[name='Pap Smear-lastCompleted']")
      expect(getSelectedOptionValue(:css, "select[name='Pap Smear-result']")).to eq("")
      expect(getTextForElement(:css, Screening::LAST_PAP_RESULTS_LABEL)).to eq("Last Pap Smear Results:")

      #If Last HPV Test date is added or edited and the user is 66 or younger, then Nullify: Last HPV Test Results, required
      setDate(getDateNthDaysFromNow(20, "%m/%d/%Y"), "input[name='HPV Test-lastCompleted']")
      expect(getSelectedOptionValue(:css, "select[name='HPV Test-result']")).to eq("")
      expect(getTextForElement(:css, Screening::LAST_HPV_TEST_RESULTS_LABEL)).to eq("Last HPV Test Results:")

      cervical_cancel_screening_not_recommended = "Cervical Cancer screening after the age of 65 is not recommended unless you are at high risk for cervical cancer or have had inadequate screening. You may discuss this with your provider."
      lastPapSmearDate = ""
      papResult = "Normal"
      lastHpvDate = ""
      hpvResult = ""
      nextDueDate = ""
      message = cervical_cancel_screening_not_recommended
      nddColumn =  "None"
      verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

      #user can edit NDD
      nextDueDate = getDateNthDaysFromNow(24, "%m/%d/%Y")
      editNddAndVerifyNddColumn(nextDueDate)
      verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)

      twentyTwoDaysAgo = getDateNthDaysFromNow(-22, "%m/%d/%Y")
      lastPapSmearDate = twentyTwoDaysAgo
      papResult = ""
      lastHpvDate = ""
      hpvResult = ""
      nextDueDate = ""
      message = cervical_cancel_screening_not_recommended
      nddColumn =  "None"
      verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

      #user can edit NDD
      nextDueDate = getDateNthDaysFromNow(19, "%m/%d/%Y")
      editNddAndVerifyNddColumn(nextDueDate)
      verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)

      twentyEightDaysAgo = getDateNthDaysFromNow(-28, "%m/%d/%Y")
      lastPapSmearDate = twentyEightDaysAgo
      papResult = "Normal"
      lastHpvDate =  getDateNthDaysFromNow(-30, "%m/%d/%Y")
      hpvResult = "Normal"
      nextDueDate = ""
      message = cervical_cancel_screening_not_recommended
      nddColumn =  "None"
      verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

      #user can edit NDD
      nextDueDate = getDateNthDaysFromNow(14, "%m/%d/%Y")
      editNddAndVerifyNddColumn(nextDueDate)
      verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)

      #Abnormal
      twentyEightDaysAgo = getDateNthDaysFromNow(-28, "%m/%d/%Y")
      lastPapSmearDate = twentyEightDaysAgo
      papResult = "Abnormal"
      lastHpvDate =  getDateNthDaysFromNow(-30, "%m/%d/%Y")
      hpvResult = ""
      nextDueDate = ""
      message = cervical_cancel_screening_not_recommended
      nddColumn =  "Consult Provider"
      verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

      #user can edit NDD
      nextDueDate = getDateNthDaysFromNow(4, "%m/%d/%Y")
      editNddAndVerifyNddColumn(nextDueDate)
      verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)

      lastPapSmearDate = getDateNthDaysFromNow(-8, "%m/%d/%Y")
      papResult = "Normal"
      lastHpvDate =  getDateNthDaysFromNow(-56, "%m/%d/%Y")
      hpvResult = "Abnormal"
      nextDueDate = ""
      message = cervical_cancel_screening_not_recommended
      nddColumn =  "Consult Provider"
      verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

      #user can edit NDD
      nextDueDate = getDateNthDaysFromNow(33, "%m/%d/%Y")
      editNddAndVerifyNddColumn(nextDueDate)
      verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)

      lastPapSmearDate = getDateNthDaysFromNow(-8, "%m/%d/%Y")
      papResult = "Abnormal"
      lastHpvDate =  getDateNthDaysFromNow(-56, "%m/%d/%Y")
      hpvResult = "Abnormal"
      nextDueDate = ""
      message = cervical_cancel_screening_not_recommended
      nddColumn =  "Consult Provider"
      verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

      #If a user nullifies Last Pap Smear date, or the Last Pap Smear result set NDD to null.
      lastPapSmearDate = ""
      papResult = ""
      lastHpvDate = ""
      hpvResult = ""
      nextDueDate = ""
      message = women_65_older_message

      nddColumn =  "None"
      verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn )

    end

  end




  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end


  def verifyBusinessLogic(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message, nddColumn)
    setDate(lastPapSmearDate, "input[name='Pap Smear-lastCompleted']")
    @screening.selectPapResult(papResult)
    #Last HPV Date
    setDate(lastHpvDate, "input[name='HPV Test-lastCompleted']")
    @screening.selectHPVResult(hpvResult)

    expect(@screening.getNextDueDate).to eq(nextDueDate)
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq(message)

    #Select Off from Notification Preference
    @screening.selectNotificationStatus("Off")

    @screening.clickSaveButton()

    !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    indexID = @screening.findIndexWithGivenPSName("Cervical Cancer Screening")

    expect(indexID).not_to eq(-1)
    expect(@reminders.getTextForRowCol(indexID, 3)).to eq(nddColumn)

    @reminders.clickNthReminder(indexID)
    !45.times { break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

    verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)

  end

  def verifyFields(lastPapSmearDate, papResult, lastHpvDate, hpvResult, nextDueDate, message)
    expect(getTextFromInput(:css, "input[name='Pap Smear-lastCompleted']")).to eq(lastPapSmearDate)
    expect(getSelectedOptionValue(:css, "select[name='Pap Smear-result']")).to eq(papResult)
    expect(getTextFromInput(:css, "input[name='HPV Test-lastCompleted']")).to eq(lastHpvDate)
    expect(getSelectedOptionValue(:css, "select[name='HPV Test-result']")).to eq(hpvResult)
    expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq(message)
    expect(@screening.getNextDueDate).to eq(nextDueDate)
  end


  def editNddAndVerifyNddColumn(nextDueDate)
    @screening.setNextDueDate(nextDueDate)
    @screening.selectNotificationStatus("Off")

    @screening.clickSaveButton()

    !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    indexID = @screening.findIndexWithGivenPSName("Cervical Cancer Screening")

    expect(indexID).not_to eq(-1)
    expect(@reminders.getTextForRowCol(indexID, 3)).to eq(nextDueDate)

    @reminders.clickNthReminder(indexID)
    !45.times { break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
  end

end