require_relative '../../../../globalized'
include Globalized

describe "[Story # JRNL-1626: Breast Cancer Screening]
          [Story #JRNL-1303: [Update Preventive Services header]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    #clean up preventiveservices collection
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")
    #clean up notificationPreferences and import
    removeCollection("notificationPreferences", "notificationsdb")
    #clean up preferences and import
    removeCollection("preferences", "notificationsdb")
    #clean up reminders
    removeCollection("reminders", "remindersdb")
    removeCollection("notifications", "notificationsdb")

    initializeAllObjects

    @today = getDateNthDaysFromNow(0, "%m/%d/%Y")

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    #sleep 5
    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyReminders']").click
    waitForPageToFinishLoading
    !5.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  # after(:all) do
  #   quitDriver()
  # end

  context "#AC JRNL-1123|TC JRNL-1109: Breast Cancer Screening - update logic" do
    it "Header :  Edit Preventive Service" do
      @reminders.clickSubGroup("preventive-services")
      !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !5.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

      puts "table header : " + @screening.getTableViewHeader

      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      waitForPageToFinishLoading
      @driver.find_element(:css, "button[ng-click='showSettings()']").click
      waitForPageToFinishLoading

      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")
      @driver.find_element(:xpath, "html/body/div[4]/div/div/div/div[2]/form/div/div[2]/label/input").click
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[ng-click='save()']").click
      waitForPageToFinishLoading

      #@reminders.clickNthReminder(indexID)
      !5.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    end

    it "Business Logic -  User age < 75" do
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[ng-click='cancel()']").click
      waitForPageToFinishLoading
      @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[3]/list-table/div/div/ul/li/span[2]/span").click
      waitForPageToFinishLoading
      #zztest.veteran11: DOB (05/05/1951)
      #set NDD = user's 50th brithday
      expect(getTextForElement(:css, Screening::LAST_MAMMOGRAM_DATE)).to eq("")
      #expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")
    end

    it "Last Mammogram (date, date picker, mm/dd/yyyy), cannot be future date" do
      time = Time.new()
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

      setDate(tomorrow, "input[name='Mammogram-lastCompleted']")

      @screening.clickSaveButton()
      if time.year.to_s != tomorrow[-4..-1]
        checkingInlineError("Last Mammogram must be formatted MM/DD/YYYY.")
      else
        checkingInlineError("Last Mammogram must be between 01/01/1900 and " + @today + ".")
      end
    end

    it "Last Mammogram Results (Select: Normal, Abnormal)" do
      sevenDaysAgo = getDateNthDaysFromNow(-7, "%m/%d/%Y")
      setDate(sevenDaysAgo, "input[name='Mammogram-lastCompleted']")

      #Verify that, drop down input default to Select and all expected values are available
      #todo: Results of Last Mammogram  <-- label in the rqmt.
      expect(getTextForElement(:css, Screening::LAST_MAMMOGRAM_RESULTS_LABEL)).to eq("* Last Mammogram Results:")
      expect(areAllTheseValuesAvailableInDropDown("select[name='Mammogram-result']", "Select,Normal,Abnormal")).to eq(true)
      @screening.clickSaveButton()
      checkingInlineError("Last Mammogram Results field is required.")
    end

    it "Display information icon  which links to a modal window showing the following text: " do
      #Verifying the Header, Text and Button information for the "Next Due Date Modal"
      @screening.clickInformationButton()
      !5.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
      expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

      @modal.clickNoButton()
      !5.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

    end

    it "Note (text 250 characters), display character count down" do
      expect(getTextForElement(:css, Screening::NOTES_LABEL)).to eq("Notes:")
      #verify that Notes will be 250 characters with character countdown
      expect(@screening.verifyTotalCharacterInNarrative()).to eq(true)
    end

    it "Patient < 75 : Update NDD when Last Mammogram date is updated", :broken => true do
      #Last Mammogram Date = Null, Result = Normal, NDD = no system update
      @screening.setNextDueDate(@today)
      setDate("", Screening::LAST_MAMMOGRAM_DATE)
      #When Last Mammogram date is updated,  set result to null
      expect(getSelectBoxText(Screening::LAST_MAMMOGRAM_RESULTS)).to eq("Select")
      expect(@screening.getNextDueDate()).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      #Null or Normal Results: When a user enters a Last Mammogram date,
      setDate(@today, Screening::LAST_MAMMOGRAM_DATE)
      expect(getSelectBoxText(Screening::LAST_MAMMOGRAM_RESULTS)).to eq("Select")
      twoYearsLater = getDateNthYeasFromNow(2, "%m/%d/%Y")
      expect(@screening.getNextDueDate()).to eq("")

      @screening.clickSaveButton()
      checkingInlineError("Last Mammogram Results field is required.")

      #If the results field updated to normal, then keep the NDD = Last Mammogram date + 2 years
      #@screening.selectMammogramResult("Normal")
      waitForPageToFinishLoading
      @driver.find_element(:css, "select[name='Mammogram-result']").send_keys "Normal"
      waitForPageToFinishLoading
      expect(@screening.getNextDueDate()).to eq("")

      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      #Abnormal Results: When the user enters a results value, if the value is set to abnormal, then nullify NDD
      #@screening.selectMammogramResult("Abnormal")
      waitForPageToFinishLoading
      #@driver.find_element(:css, "select[name='Mammogram-result']").send_keys "Abnormal"
      @screening.selectMammogramResult("Abnormal")
      waitForPageToFinishLoading
      !5.times{ break if (@screening.getNextDueDate() == ""); sleep 1 }
      expect(@screening.getNextDueDate()).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      @screening.clickSaveButton()
      !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
      !5.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")
      expect(indexID).not_to eq(-1)
      #6.2.2.	Display "None" in NDD column of list view
      puts "row index is " + indexID.to_s
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq("Consult Provider")

      @reminders.clickNthReminder(indexID)
      !5.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

      @screening.setNextDueDate(@today)
      @screening.clickSaveButton()
      !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
      !5.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")
      expect(indexID).not_to eq(-1)
      #display a date if NDD is available
      puts "row index is " + indexID.to_s
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq(@today)

      #Cancel button
      @reminders.clickNthReminder(indexID)
      !5.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

      @screening.setNextDueDate("")
      @screening.clickCancelButton()

      !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
      !5.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")
      expect(indexID).not_to eq(-1)

      @reminders.clickNthReminder(indexID)
      !5.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getNextDueDate()).to eq(@today)

      #Last Mammogram date is nullified, NDD is nullified, and the results field is not required
      setDate("", Screening::LAST_MAMMOGRAM_DATE)
      expect(@screening.getNextDueDate()).to eq("")
      @screening.selectMammogramResult("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      @screening.clickSaveButton()

      !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
      !5.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")
      expect(indexID).not_to eq(-1)

      @reminders.clickNthReminder(indexID)
      !5.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

      @screening.selectMammogramResult("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      @screening.selectMammogramResult("Abnormal")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      @screening.clickCancelButton()

      !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
      !5.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }
    end

    it "Business Logic : User's age >= 75 ", :broken => true do
      #@common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.patient05", "patient05, zztest")
      @main.clickNavMenu()
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='MyReminders']").click
      waitForPageToFinishLoading
      !5.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
      expect(@reminders.getSecondaryHeader()).to eq("My Reminders")

      @reminders.clickSubGroup("preventive-services")
      !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !5.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")

      expect(indexID).not_to eq(-1)
      #6.2.2.	Display "None" in NDD column of list view
      puts "row index is " + indexID.to_s
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq("Consult Provider")

      @reminders.clickNthReminder(indexID)
      !5.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

      #zztest.patient05: DOB (12/13/1900)
      #set NDD to Null
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      # If Last Mammogram = Null, Result = Null, NDD = null, show “Please discuss with your provider...” message
      expect(getTextFromInput(:css, Screening::LAST_MAMMOGRAM_DATE)).to eq("")
      @screening.selectMammogramResult("")
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      @screening.selectMammogramResult("Normal")
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      #Set Last Mammogram date, Result = Normal, NDD = null
      setDate(@today, Screening::LAST_MAMMOGRAM_DATE)
      @screening.selectMammogramResult("Normal")
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      #Last Mammogram date Exists
      @screening.selectMammogramResult("")
      @screening.setNextDueDate(@today)
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      #Nullify Last Mammogram date
      setDate("", Screening::LAST_MAMMOGRAM_DATE)
      @screening.selectMammogramResult("Normal")
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      # If Abnormal, show "Please discuss with your provider whether continued screening is recommended.” message
      @screening.setNextDueDate(@today)
      @screening.selectMammogramResult("Abnormal")
      #set NDD = null
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      @screening.clickSaveButton()

      !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !5.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")

      expect(indexID).not_to eq(-1)
      #6.2.2.	Display "None" in NDD column of list view
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq("Consult Provider")

    end

    it "Verify that 'Breast Cancer' is hidden for male user", :broken => true do
      @main.clickNavMenu()
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='MyReminders']").click
      waitForPageToFinishLoading
      !5.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
      expect(@reminders.getTitle()).to eq("My Reminders")

      @reminders.clickSubGroup("preventive-services")
      !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      expect(@screening.findIndexWithGivenPSName("Breast Cancer Screening")).to eq(1)
    end

  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !5.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

end



















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../../globalized'
include Globalized

describe "[Story # JRNL-1626: Breast Cancer Screening]
          [Story #JRNL-1303: [Update Preventive Services header]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    #clean up preventiveservices collection
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")
    #clean up notificationPreferences and import
    removeCollection("notificationPreferences", "notificationsdb")
    #clean up preferences and import
    removeCollection("preferences", "notificationsdb")
    #clean up reminders
    removeCollection("reminders", "remindersdb")
    removeCollection("notifications", "notificationsdb")

    initializeAllObjects

    @today = getDateNthDaysFromNow(0, "%m/%d/%Y")

    @common.loginEndsOnLandingPage("zztest.veteran12", "veteran12, zztest")
    expect(@main.getFooterText()).to eq("Logged in as veteran12, zztest")

    #sleep 5
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1123|TC JRNL-1109: Breast Cancer Screening - update logic" do
    it "Header :  Edit Preventive Service" do
      @reminders.clickSubGroup("preventive-services")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

      puts "table header : " + @screening.getTableViewHeader

      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")

      expect(indexID).not_to eq(-1)

      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

    end

    it "Business Logic -  User age < 75" do
      #zztest.veteran11: DOB (05/05/1951)
      #set NDD = user's 50th brithday
      expect(getSelectBoxText(Screening::LAST_MAMMOGRAM_RESULTS)).to eq("Select")
      expect(getTextForElement(:css, Screening::LAST_MAMMOGRAM_DATE)).to eq("")
      expect(@screening.getNextDueDate).to eq("05/05/2002")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

    end

    it "Last Mammogram (date, date picker, mm/dd/yyyy), cannot be future date" do
      time = Time.new()
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

      setDate(tomorrow, "input[name='Mammogram-lastCompleted']")

      @screening.clickSaveButton()
      if time.year.to_s != tomorrow[-4..-1]
        checkingInlineError("Last Mammogram must be formatted MM/DD/YYYY.")
      else
        checkingInlineError("Last Mammogram must be between 01/01/1900 and " + @today + ".")
      end

    end


    it "Last Mammogram Results (Select: Normal, Abnormal)" do
      sevenDaysAgo = getDateNthDaysFromNow(-7, "%m/%d/%Y")
      setDate(sevenDaysAgo, "input[name='Mammogram-lastCompleted']")

      #Verify that, drop down input default to Select and all expected values are available
      #todo: Results of Last Mammogram  <-- label in the rqmt.
      expect(getTextForElement(:css, Screening::LAST_MAMMOGRAM_RESULTS_LABEL)).to eq("* Last Mammogram Results:")
      expect(areAllTheseValuesAvailableInDropDown("select[name='Mammogram-result']", "Select,Normal,Abnormal")).to eq(true)
      @screening.clickSaveButton()
      checkingInlineError("Last Mammogram Results field is required.")
    end

    it "Display information icon  which links to a modal window showing the following text: " do
      #Verifying the Header, Text and Button information for the "Next Due Date Modal"
      @screening.clickInformationButton()
      !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
      expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

      @modal.clickNoButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

    end

    it "Note (text 250 characters), display character count down" do
      expect(getTextForElement(:css, Screening::NOTES_LABEL)).to eq("Notes:")
      #verify that Notes will be 250 characters with character countdown
      expect(@screening.verifyTotalCharacterInNarrative()).to eq(true)
    end

    it "Patient < 75 : Update NDD when Last Mammogram date is updated", :broken => true do
      #Last Mammogram Date = Null, Result = Normal, NDD = no system update
      @screening.setNextDueDate(@today)
      setDate("", Screening::LAST_MAMMOGRAM_DATE)
      #When Last Mammogram date is updated,  set result to null
      expect(getSelectBoxText(Screening::LAST_MAMMOGRAM_RESULTS)).to eq("Select")
      expect(@screening.getNextDueDate()).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      #Null or Normal Results: When a user enters a Last Mammogram date,
      setDate(@today, Screening::LAST_MAMMOGRAM_DATE)
      expect(getSelectBoxText(Screening::LAST_MAMMOGRAM_RESULTS)).to eq("Select")
      twoYearsLater = getDateNthYeasFromNow(2, "%m/%d/%Y")
      expect(@screening.getNextDueDate()).to eq(twoYearsLater)

      @screening.clickSaveButton()
      checkingInlineError("Last Mammogram Results field is required.")

      #If the results field updated to normal, then keep the NDD = Last Mammogram date + 2 years
      @screening.selectMammogramResult("Normal")
      expect(@screening.getNextDueDate()).to eq(twoYearsLater)

      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      #Abnormal Results: When the user enters a results value, if the value is set to abnormal, then nullify NDD
      @screening.selectMammogramResult("Abnormal")
      !45.times{ break if (@screening.getNextDueDate() == ""); sleep 1 }
      expect(@screening.getNextDueDate()).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Because your Mammogram was abnormal, please consult with your physician to determine your next due date.")

      @screening.clickSaveButton()
      !10.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
      !10.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")
      expect(indexID).not_to eq(-1)
      #6.2.2.	Display "None" in NDD column of list view
      puts "row index is " + indexID.to_s
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq("Consult Provider")

      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

      @screening.setNextDueDate(@today)
      @screening.clickSaveButton()
      !10.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
      !10.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")
      expect(indexID).not_to eq(-1)
      #display a date if NDD is available
      puts "row index is " + indexID.to_s
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq(@today)

      #Cancel button
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

      @screening.setNextDueDate("")
      @screening.clickCancelButton()

      !10.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
      !10.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")
      expect(indexID).not_to eq(-1)

      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getNextDueDate()).to eq(@today)

      #Last Mammogram date is nullified, NDD is nullified, and the results field is not required
      setDate("", Screening::LAST_MAMMOGRAM_DATE)
      expect(@screening.getNextDueDate()).to eq("")
      @screening.selectMammogramResult("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      @screening.clickSaveButton()

      !10.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
      !10.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")
      expect(indexID).not_to eq(-1)

      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

      @screening.selectMammogramResult("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      @screening.selectMammogramResult("Abnormal")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Because your Mammogram was abnormal, please consult with your physician to determine your next due date.")

      @screening.clickCancelButton()

      !10.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
      !10.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }
    end

    it "Business Logic : User's age >= 75 ", :broken => true do
      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.patient05", "patient05, zztest")
      @nav_menu.clickReminders()
      !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
      expect(@reminders.getSecondaryHeader()).to eq("My Reminders")

      @reminders.clickSubGroup("preventive-services")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !45.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")

      expect(indexID).not_to eq(-1)
      #6.2.2.	Display "None" in NDD column of list view
      puts "row index is " + indexID.to_s
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq("None")

      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())

      #zztest.patient05: DOB (12/13/1900)
      #set NDD to Null
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      # If Last Mammogram = Null, Result = Null, NDD = null, show “Please discuss with your provider...” message
      expect(getTextFromInput(:css, Screening::LAST_MAMMOGRAM_DATE)).to eq("")
      @screening.selectMammogramResult("")
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      @screening.selectMammogramResult("Normal")
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      #Set Last Mammogram date, Result = Normal, NDD = null
      setDate(@today, Screening::LAST_MAMMOGRAM_DATE)
      @screening.selectMammogramResult("Normal")
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      #Last Mammogram date Exists
      @screening.selectMammogramResult("")
      @screening.setNextDueDate(@today)
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      #Nullify Last Mammogram date
      setDate("", Screening::LAST_MAMMOGRAM_DATE)
      @screening.selectMammogramResult("Normal")
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      # If Abnormal, show "Please discuss with your provider whether continued screening is recommended.” message
      @screening.setNextDueDate(@today)
      @screening.selectMammogramResult("Abnormal")
      #set NDD = null
      expect(@screening.getNextDueDate).to eq("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("Please discuss with your provider whether continued screening is recommended.")

      @screening.clickSaveButton()

      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !45.times{ break if (@reminders.getRemindersCount() == 14); sleep 1 }

      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")

      expect(indexID).not_to eq(-1)
      #6.2.2.	Display "None" in NDD column of list view
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq("Consult Provider")

    end

    it "Verify that 'Breast Cancer' is hidden for male user", :broken => true do
      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.patient01", "patient01, zztest")

      @nav_menu.clickReminders()
      !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
      expect(@reminders.getTitle()).to eq("My Reminders")

      @reminders.clickSubGroup("preventive-services")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      expect(@screening.findIndexWithGivenPSName("Breast Cancer Screening")).to eq(-1)
    end

  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

end
=end