require_relative '../../../../globalized'
include Globalized

describe "[Story# JRNL-1624 :  Blood Pressure Screening]
          [Story# JRNL-2477: [CPS_BP_Screening_JRNL_1624_2477_spec.rb]
          |Story #JRNL-1303: [Update Preventive Services header]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")

    initializeAllObjects

    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @ENTRY_FORM_CONTENT = [\
                          "Blood Pressure Screening",
                          "Learn More",
                          "Last Taken:",
                          "MM/DD/YYYY",
                          "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
                          "Results:",
                          "Systolic (mmHg)",
                          "Between 80 and 200",
                          "Diastolic (mmHg)",
                          "Between 50 and 150",
                          "Next Due Date:",
                          "MM/DD/YYYY",
                          "Next Due Date will become required if you turn on Notifications for this reminder.",
                          "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
                          "For your specific health needs, you may enter an alternate Next Due Date.",
                          "Notes:",
                          "250 character maximum",
                          "250 characters left",
                          "Notifications are available for future due dates only.",
                          "Notification:",
                          "Status:",
                          "On",
                          "Off",
                          "Notify Me About This Due Date:",
                          "On the date 1 day before 2 weeks before 4 weeks before",
                          "Notification Delivery:",
                          "In-App",
                          "Email",
                          "Email address has not been saved",
                          "You may update your Preferred Email address in the Notification feature by selecting the notification settings icon",
                          "You may update your Preferred Email address in the Notification feature by selecting the icon.",
                          "Save Cancel"]


    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1103| TC JRNL-1100: Blood Pressure Screening" do
    it "Header will display the service name: Edit Preventive Service " do
      @reminders.clickSubGroup("preventive-services")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !45.times{ break if ( @screening.findIndexWithGivenPSName("Blood Pressure Screening") > -1); sleep 1 }

      clickBPScreeningAndVerifyHeader()
    end

    it "Labels" do
      pageContent = @screening.getScreenContent().split("\n")

      @ENTRY_FORM_CONTENT.each_with_index do | expectedScreenRow, i |
        expect(pageContent[i]).to eq(expectedScreenRow)
      end
      expect(pageContent.length).to eq(@ENTRY_FORM_CONTENT.length)
    end

    it "Last Taken (date, date picker, mm/dd/yyyy)" do
      setDate(@tomorrow, "input[name='lastCompleted']")
      @screening.setSystolic("90")
      @screening.setDiastolic("80")
      setDate(@today, "input[name='nextDueDate']")
      @screening.verifyTotalCharacterInNarrative()
      @screening.selectNotificationStatus("Off")

      #Clicking Save button to verify required validations for invalid entries
      @screening.clickSaveButton()
      checkingInlineError("Last Taken must be between 01/01/1900 and " + @today + ".")

      setDate("02/03", "input[name='lastCompleted']")
      @screening.clickSaveButton()
      checkingInlineError("Last Taken must be formatted MM/DD/YYYY.")

    end

    it "AC #JRNL-2885|TC#MVAH-1671: Blood Pressure Screening Preventative Service Guidance Text for Systolic and Diastolic" do
      @screening.setSystolic("")
      @screening.setDiastolic("")

      expect(getPlaceHolderByCSS(:css, "input[name='Systolic']")).to eq("Between 80 and 200")
      expect(getPlaceHolderByCSS(:css, "input[name='Diastolic']")).to eq("Between 50 and 150")
    end

    it "Results: (primary label, displayed over Systolic and Diastolic values)" do
      @screening.setSystolic("60")
      @screening.setDiastolic("40")

      @screening.clickSaveButton
      checkingInlineError("Systolic (mmHg) is outside the expected range. Please enter a value between 80 and 200.")
      checkingInlineError("Diastolic (mmHg) is outside the expected range. Please enter a value between 50 and 150.")

      @screening.setSystolic("210")
      @screening.setDiastolic("160")

      @screening.clickSaveButton()
      checkingInlineError("Systolic (mmHg) is outside the expected range. Please enter a value between 80 and 200.")
      checkingInlineError("Diastolic (mmHg) is outside the expected range. Please enter a value between 50 and 150.")

      #Checking Systolic must be greater than Diastolic Validation
      setDate(@today, "input[name='lastCompleted']")
      @screening.setSystolic("80")
      @screening.setDiastolic("80")

      @screening.clickSaveButton()
      checkingInlineError("The Systolic (mmHg) value must be greater than the Diastolic (mmHg) value. Please check the values and re-enter.")
    end

    it "Information icon" do
      @screening.clickInformationButton()
      !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
      expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")
      #ok button
      @modal.clickNoButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
    end

    it "Note (text 250 characters), display character count down" do
      expect(getTextForElement(:css, Screening::NOTES_LABEL)).to eq("Notes:")
      #verify that Notes will be 250 characters with character countdown
      expect(@screening.verifyTotalCharacterInNarrative()).to eq(true)

      #Phone View
      resizeWindowToPhone()
      expect(@common.isBackButtonVisible).to eq(true)

      @screening.clickCancelButton

      !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

      clickBPScreeningAndVerifyHeader

      resizeWindowToDefault()
    end

    it "Default Next Due Date" do
      #zztest.patient05 (dob :  12/13/1900)
      expect(@screening.getNextDueDate).to eq("12/13/1918")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")
    end

    it "Update Next Due Date based on Last Taken Value" do
      #When a LTD is entered or updated: Previous results (systolic/diastolic values) are nullified
      setDate(@yesterday, "input[name='lastCompleted']")
      expect(@screening.getSystolic()).to eq("")
      expect(@screening.getDiastolic()).to eq("")
      #Systolic and Diastolic values are shown as required
      expect(getTextForElement(:css,  Screening::SYSTOLIC_LABEL)).to include("* Systolic (mmHg)")
      expect(getTextForElement(:css,  Screening::DIASTOLIC_LABEL)).to include("* Diastolic (mmHg)")

      @screening.clickSaveButton
      checkingInlineError("Systolic (mmHg) field is required.")
      checkingInlineError("Diastolic (mmHg) field is required.")

      #The system sets the NDD to LTD + 2 years
      @screening.setSystolic("120")
      @screening.setDiastolic("80")
      expect(@screening.getNextDueDate).to eq(getDateNThYearFromGivenDate(@yesterday, 2))
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      @screening.setSystolic("119")
      @screening.setDiastolic("79")
      expect(@screening.getNextDueDate).to eq(getDateNThYearFromGivenDate(@yesterday, 2))
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      #When a user enters a systolic value, if the systolic value is 121 or higher, update NDD to LTD + 1 year.
      @screening.setSystolic("121")
      expect(@screening.getNextDueDate).to eq(getDateNThYearFromGivenDate(@yesterday, 1))
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      #When a user enters a diastolic value, if the diastolic value is 81 or higher, update NDD to LTD +1
      @screening.setDiastolic("81")
      expect(@screening.getNextDueDate).to eq(getDateNThYearFromGivenDate(@yesterday, 1))
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      #Retain text below NDD: “For your specific health needs, you may enter an alternate Next Due Date."
      @screening.setSystolic("122")
      @screening.setDiastolic("79")
      expect(@screening.getNextDueDate).to eq(getDateNThYearFromGivenDate(@yesterday, 1))
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      @screening.setSystolic("112")
      @screening.setDiastolic("81")
      expect(@screening.getNextDueDate).to eq(getDateNThYearFromGivenDate(@yesterday, 1))
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      @screening.clickCancelButton
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !45.times{ break if ( @screening.findIndexWithGivenPSName("Blood Pressure Screening") > -1); sleep 1 }

    end

    it "Update Entry and Verify" do
      lastTakenDate = getDateNthDaysFromNow(-24, "%m/%d/%Y")
      systolic = "118"
      diastolic = "76"
      autoPopulatedNextDueDate = getDateNThYearFromGivenDate(lastTakenDate, 2)
      newNextDueDate = ""
      nextDueDateColumn = autoPopulatedNextDueDate
      notes = "systolic is <=120 and diastolic is <=80, then the system sets the NDD to LTD + 2 years"

      UpdateEntryAndVerify(lastTakenDate, systolic, diastolic, autoPopulatedNextDueDate, newNextDueDate, nextDueDateColumn, notes)

      lastTakenDate = getDateNthDaysFromNow(-40, "%m/%d/%Y")
      systolic = "122"
      diastolic = "82"
      autoPopulatedNextDueDate = getDateNThYearFromGivenDate(lastTakenDate, 1)
      newNextDueDate = getDateNthDaysFromNow(-20, "%m/%d/%Y")
      nextDueDateColumn = newNextDueDate
      notes = " the systolic value is >120 OR if the diastolic is >80, then update NDD to LTD + 1 year."
      UpdateEntryAndVerify(lastTakenDate, systolic, diastolic, autoPopulatedNextDueDate, newNextDueDate, nextDueDateColumn, notes)

      lastTakenDate = ""
      systolic = ""
      diastolic = ""
      autoPopulatedNextDueDate = ""
      newNextDueDate = ""
      nextDueDateColumn = "None"
      notes = "Everything is null"
      UpdateEntryAndVerify(lastTakenDate, systolic, diastolic, autoPopulatedNextDueDate, newNextDueDate, nextDueDateColumn, notes)

    end

    def UpdateEntryAndVerify(lastTakenDate, systolic, diastolic, autoPopulatedNextDueDate, newNextDueDate, nextDueDateColumn, notes)
      clickBPScreeningAndVerifyHeader()

      setDate(lastTakenDate, "input[name='lastCompleted']")
      @screening.setSystolic(systolic)
      @screening.setDiastolic(diastolic)

      expect(@screening.getNextDueDate).to eq(autoPopulatedNextDueDate)
      @screening.setNote(notes)

      if (newNextDueDate != "")
        @screening.setNextDueDate(newNextDueDate)
      end

      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      @screening.selectNotificationStatus("Off")
      @screening.clickSaveButton

      !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !45.times { break if (@screening.findIndexWithGivenPSName("Blood Pressure Screening") > -1); sleep 1 }

      indexID = @screening.findIndexWithGivenPSName("Blood Pressure Screening")

      expect(indexID).not_to eq(-1)
      #6.2.2.	Display "None" in NDD column of list view
      puts "row index is " + indexID.to_s
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq(nextDueDateColumn)

      clickBPScreeningAndVerifyHeader()

      expect(@screening.getSystolic).to eq(systolic)
      expect(@screening.getDiastolic).to eq(diastolic)

      if(newNextDueDate != "")
        expect(@screening.getNextDueDate).to eq(newNextDueDate)
      else
        expect(@screening.getNextDueDate).to eq(autoPopulatedNextDueDate)
      end

      @screening.setNextDueDate("")
      expect(getTextForElement(:css, Screening::NEXT_DUE_DATE_MSG)).to eq("For your specific health needs, you may enter an alternate Next Due Date.")

      @screening.clickSaveButton

      !45.times { break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      !45.times { break if (@screening.findIndexWithGivenPSName("Blood Pressure Screening") > -1); sleep 1 }

      expect(indexID).not_to eq(-1)
      #6.2.2.	Display "None" in NDD column of list view
      puts "row index is " + indexID.to_s
      expect(@reminders.getTextForRowCol(indexID, 3)).to eq("None")

    end

  end


  it "AC #JRNL-3215, #JRNL-3216, #JRNL-3217|TC#JRNL-3274: BP Screening Detail. | Required Field Validations | Save BP Screening Entry | Cancel BP Screening Entry." do
    indexID = @screening.findIndexWithGivenPSName("Blood Pressure Screening")

    expect(indexID).not_to eq(-1)

    @reminders.clickNthReminder(indexID)
    waitForPageToFinishLoading()

    #Verifying the Header, Text and Button information for the "Next Due Date Modal"
    @screening.clickInformationButton()
    !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
    expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
    expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

    @modal.clickNoButton()
    !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
    expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

    time = Time.new()
    today = time.strftime("%m/%d/%Y")
    tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    setDate(tomorrow, "input[name='lastCompleted']")
    @screening.setSystolic("60")
    @screening.setDiastolic("40")
    setDate(today, "input[name='nextDueDate']")
    @screening.verifyTotalCharacterInNarrative()
    @screening.selectNotificationStatus("Off")

    #Clicking Save button to verify required validations for invalid entries
    @screening.clickSaveButton()
    # If tomorrow is the start of a new year, will get a format error because the last digit of the year will be chopped off
    if time.year.to_s != tomorrow[-4..-1]
      checkingInlineError("Last Taken must be formatted MM/DD/YYYY.")
    else
      checkingInlineError("Last Taken must be between 01/01/1900 and " + today + ".")
    end
    checkingInlineError("Systolic (mmHg) is outside the expected range. Please enter a value between 80 and 200.")
    checkingInlineError("Diastolic (mmHg) is outside the expected range. Please enter a value between 50 and 150.")

    @screening.setSystolic("210")
    @screening.setDiastolic("160")

    @screening.clickSaveButton()
    checkingInlineError("Systolic (mmHg) is outside the expected range. Please enter a value between 80 and 200.")
    checkingInlineError("Diastolic (mmHg) is outside the expected range. Please enter a value between 50 and 150.")

    #Checking Systolic must be greater than Diastolic Validation
    setDate(today, "input[name='lastCompleted']")
    @screening.setSystolic("80")
    @screening.setDiastolic("80")

    @screening.clickSaveButton()
    checkingInlineError("The Systolic (mmHg) value must be greater than the Diastolic (mmHg) value. Please check the values and re-enter.")

    @screening.setSystolic("120")
    @screening.setDiastolic("80")

    @screening.clickSaveButton()
    waitForPageToFinishLoading()
  end

  it "AC #JRNL-2885|TC#MVAH-1671: Blood Pressure Screening Preventative Service Guidance Text" do
    @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("Blood Pressure Screening"))
    waitForPageToFinishLoading()

    @screening.setSystolic("")
    @screening.setDiastolic("")

    expect(getPlaceHolderByCSS(:css, "input[name='Systolic']")).to eq("Between 80 and 200")
    expect(getPlaceHolderByCSS(:css, "input[name='Diastolic']")).to eq("Between 50 and 150")

    @screening.clickCancelButton()
    waitForPageToFinishLoading()
  end

######################
### Local Function ###
######################
def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
end

def clickBPScreeningAndVerifyHeader()
    indexID = @screening.findIndexWithGivenPSName("Blood Pressure Screening")
    expect(indexID).not_to eq(-1)

    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
end

end
