require_relative '../../../globalized'
include Globalized

describe "Story#JRNL-2529: [Reminders_Preventive_Service_JRNL_2529_spec.rb]
          Story#JRNL-1304:[Add Pneumococcal vaccinations to Preventive Services Settings modal]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preferences", "healthtrackerdb")
    resetCollection("preventiveservices", "healthtrackerdb", "PSlistForTableView")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    sleep 5
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3147|TC#JRNL-3266|: Verify that all reminders groups are displayed in the group view and are sorted alphabetically" do
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    waitForPageToFinishLoading()

    #Verify that when there are records in the list, the default message displayed as follow
    !30.times{ break if (@reminders.getDefaultMsg() == "Select an item from the Reminders list to view details or add a new Reminder entry."); sleep 1 }
    expect(@reminders.getDefaultMsg()).to eq("Select an item from the Reminders list to view details or add a new Reminder entry.")

    expect(@reminders.isThisReminderGroupAvailableAndDisplayedInRightOrder(1, "Appointments")).to eq(true)
    expect(@reminders.isThisReminderGroupAvailableAndDisplayedInRightOrder(2, "Medications")).to eq(true)
    expect(@reminders.isThisReminderGroupAvailableAndDisplayedInRightOrder(3, "Preventive Services")).to eq(true)
    expect(@reminders.isThisReminderGroupAvailableAndDisplayedInRightOrder(4, "Other")).to eq(true)

    @reminders.clickSubGroup("preventive-services")
    waitForPageToFinishLoading()
  end

  it "AC#JRNL-3148|TC#JRNL-3266: Verify that the Preventive Service Reminders are displayed correctly in the table view" do
    #Edit each reminder to meet the test data requirement for the scenarios.
    #Last screening date
    overOneYearAgo = getDateNthDaysAgo(370, "%m/%d/%Y")

    #Past due due date
    oneMonthAgo = getDateNthDaysAgo(30, "%m/%d/%Y")
    twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")

    #Due now due date
    today = getDateNthDaysAgo(0, "%m/%d/%Y")

    #Due in the future
    oneYearFromNow = getDateNthYeasFromNow(1, "%m/%d/%Y")




    ###BUG Cervical Cancer Screening is not saving
    # #Update the Cervical Cancer Screening
    # indexID = @screening.findIndexWithGivenPSName("Cervical Cancer Screening")
    # @reminders.clickNthReminder(indexID)
    # waitForPageToFinishLoading()
    #
    # #update the last screening date to be one year ago
    # setDate(overOneYearAgo, "date-control[label='Last Pap Smear'] input")
    # #update the Next Due Date to one month ago
    # setDate(oneMonthAgo, "input[name='nextDueDate']")
    # #Note, status is left to be Off and Notify Me are all disabled.
    # @screening.clickSaveButton()
    # waitForPageToFinishLoading()
    #
    # #Verify the status for this screening is Past due
    # expect(@screening.checkNthScreeningStatus(1, "Past Due"))

    ###BUG Breast Cancer Screening is not saving
    # #Update the Breast Cancer Screening
    # indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")
    # @reminders.clickNthReminder(indexID)
    # waitForPageToFinishLoading()
    # #update the last screening date to be one year ago and set results dropdown
    # setDate(overOneYearAgo, "date-control[label='Last Mammogram'] input")
    # @screening.selectMammogramResult("Normal")
    # #update the Next Due Date to one month ago
    # setDate(twoDaysAgo, "input[name='nextDueDate']")
    # #Note, status is left to be Off and Notify Me are all disabled.
    # @screening.clickSaveButton()
    # waitForPageToFinishLoading()
    #
    # #Verify the status for this screening is Past due
    # expect(@screening.checkNthScreeningStatus(2, "Past Due"))

    ###BUG Cholesterol Screening is not saving
    #Update the Cholesterol Screening
    # indexID = @screening.findIndexWithGivenPSName("Cholesterol Screening")
    # @reminders.clickNthReminder(indexID)
    # waitForPageToFinishLoading()
    #
    # #update the last screening date to be one year ago and set results dropdown
    # setDate(overOneYearAgo, "input[name='lastCompleted']")
    # @screening.selectResult("Normal")
    # #update the Next Due Date to be today
    # setDate(today, "input[name='nextDueDate']")
    # #Note, status is left to be Off and Notify Me are all disabled.
    # @screening.clickSaveButton()
    # waitForPageToFinishLoading()
    #
    # #Verify the status for this screening is Due
    # expect(@screening.checkNthScreeningStatus(3, "Due Now"))

    ###BUG Osteoporosis Screening is not saving
    #Update the Osteoporosis Screening
    # indexID = @screening.findIndexWithGivenPSName("Osteoporosis Screening")
    # @reminders.clickNthReminder(indexID)
    # waitForPageToFinishLoading()
    #
    # #update the last screening date to be one year ago
    # setDate(overOneYearAgo, "input[name='lastCompleted']")
    # #update the Next Due Date to be today
    # setDate(today, "input[name='nextDueDate']")
    # #Note, status is left to be Off and Notify Me are all disabled.
    # @screening.clickSaveButton()
    # waitForPageToFinishLoading()
    #
    # #Verify the status for this screening is Due
    # expect(@screening.checkNthScreeningStatus(4, "Due Now"))

    ###BUG Blood Pressure Screening is not saving

    #Update the Blood Pressure Screening
    indexID = @screening.findIndexWithGivenPSName("Blood Pressure Screening")
    @reminders.clickNthReminder(indexID)
    waitForPageToFinishLoading()
    @modalpop.clickBPPInfoIconSystolic
    expect(@modalpop.getInfoIconDiastolicHeader()).to eq("About Systolic Blood Pressure\nClose")
    expect(@modalpop.getInfoIconDiastolicParagraph()).to eq("Systolic Pressure is the top number. It is the force that blood exerts on the artery walls during a heart beat.")
    @modalpop.clickInfoIconOKButton
    @modalpop.clickBPPInfoIconDiastolic
    expect(@modalpop.getInfoIconSystolicHeader()).to eq("About Diastolic Blood Pressure\nClose")
    expect(@modalpop.getInfoIconSystolicParagraph()).to eq("Diastolic Pressure is the lower number. It is the force that blood exerts on the arteries between heart beats.")
    @modalpop.clickInfoIconOKButton


    #
    # #update the last screening date to be one year ago and set bp fields
    # setDate(overOneYearAgo, "input[name='lastCompleted']")
    # @screening.setSystolic("90")
    # @screening.setDiastolic("80")
    # #update the Next Due Date to be one year from now
    # setDate(oneYearFromNow, "input[name='nextDueDate']")
    # #check On the date checkbox for Notify Me
    # @screening.clickNotificationDeliveryCheckBox("On the date")
    # @screening.clickSaveButton()
    # waitForPageToFinishLoading()
    #
    # #Verify the status for this screening is blank/null
    # expect(@screening.checkNthScreeningStatus(5, ""))

    ###BUG Colorectal Cancer Screening is not saving
    # #Update the Colorectal Cancer Screening
    # indexID = @screening.findIndexWithGivenPSName("Colorectal Cancer Screening")
    # @reminders.clickNthReminder(indexID)
    # waitForPageToFinishLoading()
    #
    # #update the last screening date to be one year ago
    # setDate(overOneYearAgo, "input[name='lastCompleted']")
    # #update the Next Due Date to one year from now
    # setDate(oneYearFromNow, "input[name='nextDueDate']")
    # #check On the date checkbox for Notify Me
    # @screening.clickNotificationDeliveryCheckBox("On the date")
    # @screening.clickSaveButton()
    # waitForPageToFinishLoading()
    #
    # #Verify the status for this screening is blank/null
    # expect(@screening.checkNthScreeningStatus(6, ""))
  end

  it 'AC#JRNL-1230|TC #JRNL-3266: Verify that the Preventive Service Reminders are displayed correctly in the table view ' do
    # #Edit each reminder to meet the test data requirement for the scenarios.
    # #Last screening date
    # overOneYearAgo = getDateNthDaysAgo(370, "%m/%d/%Y")
    # #Due in the future
    # oneYearFromNow = getDateNthYeasFromNow(1, "%m/%d/%Y")
    # #update the PCV13 - Pneumococcal Vaccination
    # indexID = @screening.findIndexWithGivenPSName("PCV13 - Pneumococcal Vaccination")
    # @reminders.clickNthReminder(indexID)
    # waitForPageToFinishLoading()
    #
    # #update the last screening date to be one year ago
    # setDate(overOneYearAgo, "input[name='lastAdministered']")
    # #update the Next Due Date to one year from now
    # setDate(oneYearFromNow, "input[name='nextDueDate']")
    # #check On the date checkbox for Notify Me
    # @screening.clickNotificationDeliveryCheckBox("On the date")
    # @screening.clickSaveButton()
    # waitForPageToFinishLoading()
    #
    # #Verify the status for this screening is blank/null
    # expect(@screening.checkNthScreeningStatus(6, ""))
    #
    # #update the PPSV23 - Pneumococcal Vaccination
    #
    # indexID = @screening.findIndexWithGivenPSName("PPSV23 - Pneumococcal Vaccination")
    # @reminders.clickNthReminder(indexID)
    # waitForPageToFinishLoading()
    #
    # #update the last screening date to be one year ago
    # setDate(overOneYearAgo, "input[name='lastAdministered']")
    # #update the Next Due Date to one year from now
    # setDate(oneYearFromNow, "input[name='nextDueDate']")
    # #check On the date checkbox for Notify Me
    # @screening.clickNotificationDeliveryCheckBox("On the date")
    # @screening.clickSaveButton()
    # waitForPageToFinishLoading()

    #Verify the status for this screening is blank/null
    # expect(@screening.checkNthScreeningStatus(6, ""))
  end

  it "AC#JRNL-3150|TC#JRNL-3266: Verify that all preventive service screenings are sorted per requirements" do
    # expect(@screening.isThePSScreeningsSortedCorrectlyInTableView()).to eq(true)
  end

end