require_relative '../../../globalized'
include Globalized

describe "Story#JRNL-2515: [Reminders_Initialize_Update_MVAH_80_spec.rb]", :regression => true do


  startTime = Time.new
  puts "Start Time: " + startTime.inspect

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("reminders", "remindersdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient14", "patient14, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient14, zztest")
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3189|TC#JRNL-3259|: Verify that upon login for the first time system initiates all applicable preventive service reminders are saved in mongodb", :broken => true do
    #Verify that the preventive service available for this user are generated in mongodb
    sleep 5
    returnStr = retrieveThisFieldInDocumentWithMultiRows("preventiveservices", "healthtrackerdb", "EDIPI", "PATID13", "name")
    expect(returnStr.include?("Blood Pressure Screening")).to eq(true)
    expect(returnStr.include?("Breast Cancer Screening")).to eq(true)
    expect(returnStr.include?("Cervical Cancer Screening")).to eq(true)
    expect(returnStr.include?("Cholesterol Screening")).to eq(true)
    expect(returnStr.include?("Colorectal Cancer Screening")).to eq(true)
    expect(returnStr.include?("Osteoporosis Screening")).to eq(true)

    @nav_menu.navigate("MyReminders")
    !45.times{ break if(@reminders.getPrimaryHeader() == "My Reminders"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")

    @reminders.clickSubGroup("preventive-services")
    waitForPageToFinishLoading()
  end

  it "AC#JRNL-3191|TC#JRNL-3259: Verify that any new services show up on the list if they meet the age and gender criteria", :broken => true do
    #User patient14 is a Female and 114 years old, she will see all 7 PS on the list
    list = "Blood Pressure Screening/yes,Breast Cancer Screening/yes,Cholesterol Screening/yes,Colorectal Cancer Screening/yes,Cervical Cancer Screening/yes,Osteoporosis Screening/yes,Shingles Vaccination/yes"
    isThisPSOnTheList(list)

    #Logout and login as Female96
    @screening.switchUserAndLogBackInToPS("zztest.female96", "female96, zztest")

    list = "Blood Pressure Screening/yes,Breast Cancer Screening/yes,Cholesterol Screening/yes,Colorectal Cancer Screening/yes,Cervical Cancer Screening/yes,Osteoporosis Screening/no,Shingles Vaccination/yes"
    isThisPSOnTheList(list)

    #Logout and login as male90
    @screening.switchUserAndLogBackInToPS("zztest.male90", "male90, zztest")

    list = "Blood Pressure Screening/yes,Breast Cancer Screening/no,Cholesterol Screening/yes,Colorectal Cancer Screening/yes,Cervical Cancer Screening/no,Osteoporosis Screening/no,Shingles Vaccination/yes"
    isThisPSOnTheList(list)
  end

  it "AC#JRNL-3191|TC#JRNL-3259: Verify when user age and gender no longer meet the PS criteria, it will be removed from the list and pending notifications are deleted", :broken => true do
    #Logout and login as Rosemary Payne, who is a female and is currently 16 years old
    updateMockUsersTable(193, "FEMALE", "11/4/1998")
    sleep 2

    @screening.switchUserAndLogBackInToPS("Rosemary.Payne", "Payne, Rosemary")

    list = "Blood Pressure Screening/yes,Breast Cancer Screening/yes,Cholesterol Screening/yes,Colorectal Cancer Screening/yes,Cervical Cancer Screening/yes,Osteoporosis Screening/no,Shingles Vaccination/yes"
    isThisPSOnTheList(list)

    #Update the mySQL MOCK_USERS table to change the gender to a male
    #clean up notificationPreferences
    removeCollection("notificationPreferences", "notificationsdb")
    #clean up preventiveservices collection
    removeCollection("preventiveservices", "healthtrackerdb")
    updateMockUsersTable(193, "MALE", "11/4/1948")
    sleep 2

    #Logout and login as Rosemary Payne again, who is now a male
    @screening.switchUserAndLogBackInToPS("Rosemary.Payne", "Payne, Rosemary")

    list = "Blood Pressure Screening/yes,Breast Cancer Screening/no,Cholesterol Screening/yes,Colorectal Cancer Screening/yes,Cervical Cancer Screening/no,Osteoporosis Screening/no,Shingles Vaccination/yes"
    isThisPSOnTheList(list)

    #Update the mySQL MOCK_USERS table to simulate the case when she grows up and turns 65 years old
    #clean up notificationPreferences
    removeCollection("notificationPreferences", "notificationsdb")
    #clean up preventiveservices collection
    removeCollection("preventiveservices", "healthtrackerdb")
    updateMockUsersTable(193, "FEMALE", "11/4/1948")
    sleep 2

    #Logout and login as Rosemary Payne again, who is now 65 years old
    @screening.switchUserAndLogBackInToPS("Rosemary.Payne", "Payne, Rosemary")

    list = "Blood Pressure Screening/yes,Breast Cancer Screening/yes,Cholesterol Screening/yes,Colorectal Cancer Screening/yes,Cervical Cancer Screening/yes,Osteoporosis Screening/yes,Shingles Vaccination/yes"
    isThisPSOnTheList(list)
  end

  it "AC#JRNL-3191,638|TC#JRNL-3259: Verify when patient age or gender changes invalid PS will be removed and pending notificaitons are deleted;Default to Off and disabled", :broken => true do
    removeCollection("reminders", "remindersdb")
    sleep 2

    beforeCount = getTotalDocumentCountByPatientIdentifier("preventiveservices", "healthtrackerdb", "EDIPI", "1367650709")

    @reminders.clickNthReminder(@screening.findIndexWithGivenPSName("Cervical Cancer Screening"))
    waitForPageToFinishLoading()

    #Verify that the Notification radio button is set on Off because Next Due Date is null
    expect(isThisRadioButtonOrCheckBoxSelected("radio", "Off", "notificationOption")).to eq(true)
    #Verify that all four checkboxes for Notify Me are disabled
    verifyThisCheckboxIsDisabled("On the date", true)
    verifyThisCheckboxIsDisabled("1 day before", true)
    verifyThisCheckboxIsDisabled("2 weeks before", true)
    verifyThisCheckboxIsDisabled("4 weeks before", true)
    #Verify that the Notification Delivery Method is disabled too
    expect(isThisElementDisabled(:css, ".notification-delivery input[ng-true-value='In-App']")).to eq(true)
    expect(isThisElementDisabled(:css, ".notification-delivery input[ng-true-value='Email']")).to eq(true)

    #Provide a value to Next Due Date field
    setDate(getDateNthDaysFromNow(1, "%m/%d/%Y"), "date-control[label='Next Due Date'] input")

    #Select On from Notification Preference
    expect(@screening.isNotificationStatusSelected("On")).to eq(true)

    #Verify that the In-app checkbox is checked
    expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)
    #Check one checkbox under Notify Me
    @screening.clickNotificationDeliveryCheckBox("On the date")
    expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate")).to eq(true)

    #retun to the Table View screen
    @screening.clickSaveButton()
    waitForPageToFinishLoading()

    afterCount = getTotalDocumentCountByPatientIdentifier("preventiveservices", "healthtrackerdb", "EDIPI", "1367650709")
    expect(afterCount - beforeCount).to eq(1)

    updateMockUsersTable(193, "MALE", "11/4/1998")
    sleep 2

    #Log back in with the new age
    @screening.switchUserAndLogBackInToPS("Rosemary.Payne", "Payne, Rosemary")

    #Verify that the PS that is no longer available for the user should not show up
    list = "Blood Pressure Screening/yes,Breast Cancer Screening/no,Cholesterol Screening/yes,Colorectal Cancer Screening/yes,Cervical Cancer Screening/no,Osteoporosis Screening/no,Shingles Vaccination/yes"
    isThisPSOnTheList(list)

    #Verify that pending reminder is tagged as deleted from mongoDB since the Cervical Cancer PS is no longer available to the user
    expect(retrieveThisFieldInDocument("reminders", "remindersdb", "EDIPI", "1367650709", "deletedFlag")).to eq(true)
  end

  #######################
  ### Local Functions ###
  #######################
  def isThisPSOnTheList(list)
    sleep 2
    listArryLength = list.split(",").length
    listArry = list.split(",")

    !45.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }
    for i in 0..listArryLength-1
      newArry = listArry[i].split("/")
      #puts newArry[0], newArry[1]
      if newArry[1] == "yes" then
        expect(@screening.findIndexWithGivenPSName(newArry[0])).not_to eq(-1)
      else
        expect(@screening.findIndexWithGivenPSName(newArry[0])).to eq(-1)
      end
    end
  end

  def verifyThisCheckboxIsDisabled(value, trueOrFalse)
    expect(isThisElementDisabled(:css, "input[type='checkbox'][value='" + value + "']")).to eq(trueOrFalse)
  end

end