require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1553: Settings Feature for Preventive Services]| [Story #JRNL-1303: Update Preventive Services header] | [Story #JRNL-1304: Add Penumococcal Vaccinations]", :regression => true do

  before(:all) do

    @INSTRUCTIONAL_TEXT = [
        "Select services to include in your Preventive Service list.",
        "Removing a service from your list will not remove your data, however all notifications tied to that service will be turned off.",
        "You may add a service back to your list at any time."
    ]

    @REMINDERS_FOR_MALES = [
      "Blood Pressure Screening",
      "Cholesterol Screening",
      "Colorectal Cancer Screening",
      "Flu Vaccination",
      "HIV Screening",
      "HPV Vaccination",
      "PCV13 - Pneumococcal Vaccination",
      "PPSV23 - Pneumococcal Vaccination",
      "Shingles Vaccination",
      "Tetanus Vaccination",
      "ZZ TEST"
    ]

    @REMINDERS_FOR_FEMALES = [
        "Blood Pressure Screening",
        "Breast Cancer Screening",
        "Cervical Cancer Screening",
        "Chlamydia and Gonorrhea Screening",
        "Cholesterol Screening",
        "Colorectal Cancer Screening",
        "Flu Vaccination",
        "HIV Screening",
        "HPV Vaccination",
        "Osteoporosis Screening",
        "PCV13 - Pneumococcal Vaccination",
        "PPSV23 - Pneumococcal Vaccination",
        "Shingles Vaccination",
        "Tetanus Vaccination"
    ]

    initializeConfigurations(BASE_URL)

    ########################
    ### CLEAR MONGO DATA ###
    ########################
    removeCollection("reminders", "remindersdb")
    removeCollection("preferences", "healthtrackerdb")
    removeCollection("preventiveservices", "healthtrackerdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");
    #Pause to allow app to POST setting preferences because all was cleared from mongo
    sleep 7.0

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")

    @reminders.clickSubGroup("preventive-services")
    #[AC: JRNL-1228 Update Detail Headers]|[TC: JRNL-1212 Update Detail Header ]
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    ## Add custom Preventive Service
    @screening.clickAddEntry()
    #[AC: JRNL-1228 Update Detail Headers]|[TC: JRNL-1212 Update Detail Header ]
    !45.times{ break if (@screening.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_NEW); sleep 1 }
    expect(@screening.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_NEW)

    @screening.setServiceName("ZZ TEST")
    @screening.clickSaveButton()
    #[AC: JRNL-1228 Update Detail Headers]|[TC: JRNL-1212 Update Detail Header ]
    !45.times{ break if (@screening.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@screening.getPrimaryHeader()).to eq("Preventive Services")

    ## Needed for looping later on
    clearDefaultNextDueDates()
  end

  after(:all) do
    removeCollection("preferences", "healthtrackerdb")
    quitDriver()
  end

  describe "AC JRNL-1315|TC JRNL-1300: Gear Icon" do

    it "Visible" do
      expect(@preventiveService_settings.isElementPresentAndVisible(:css, PreventiveService_Settings::GEAR_ICON)).to eq(true)
    end

  end

  describe "AC JRNL-1314|TC JRNL-1300: Gear Icon Modal" do

    it "Initial List" do
      @REMINDERS_FOR_MALES.each do | reminder |
        expect(@screening.findIndexWithGivenPSName(reminder)).not_to eq(-1)
      end
    end

    it "Modal Heading" do
      @preventiveService_settings.clickTheGearIcon()
      !30.times{ break if (@preventiveService_settings.getHeading() == PreventiveService_Settings::MODAL_HEADING); sleep 1 }
      expect(@preventiveService_settings.getHeading()).to eq(PreventiveService_Settings::MODAL_HEADING)
    end

    it "Instructional Text" do
      @preventiveService_settings.getInstructionalText().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@INSTRUCTIONAL_TEXT[i])
      end
    end

    it "All Preventive Services Visible & Alphabetical && Story JRNL-1304|AC JRNL-1230|TC JRNL-1216: Add PCV13 and PPSV23" do
      @preventiveService_settings.getModalFormText().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@REMINDERS_FOR_MALES[i])
      end
      expect(@preventiveService_settings.getCPSReminderCount()).to eq(@REMINDERS_FOR_MALES.length)
    end

    it "All Checked" do
      for i in 1..@preventiveService_settings.getCPSReminderCount() do
        expect(@preventiveService_settings.isCPSReminderSelected(i)).to eq(true)
        @preventiveService_settings.toggleCPSReminder(i)
      end
    end

    it "Cancel" do
      @preventiveService_settings.clickCancelButton()
      !30.times{ break if(@preventiveService_settings.isModalVisible() === false); sleep 1 }
      expect(@preventiveService_settings.isModalVisible()).to eq(false)
    end

    it "List Unchanged" do
      @REMINDERS_FOR_MALES.each do | reminder |
        expect(@screening.findIndexWithGivenPSName(reminder)).not_to eq(-1)
      end
    end

    it "[AC: JRNL-1228 Update Detail Headers]|[TC: JRNL-1212 Update Detail Header ]Add Notifications", :broken => true do
      ## Go through all Preventive Services and add a notification
      ## The table is sorted after each update. So continue to click the last entry.
      for i in 1..getCount() do
        clickNthRow(getCount())
        #[AC: JRNL-1228 Update Detail Headers]|[TC: JRNL-1212 Update Detail Header ]
        !45.times{ break if(@screening.getPrimaryHeader() === Screening::CPS_ENTRY_HEADER_EDIT); sleep 1 }
        expect(@screening.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)

        addNotification()
        !45.times{ break if(@screening.getPrimaryHeader() === "Preventive Services"); sleep 1 }
        expect(@screening.getPrimaryHeader()).to eq("Preventive Services")
      end
    end

    it "Open Modal", :broken => true do
      @preventiveService_settings.clickTheGearIcon()
      #[AC: JRNL-1228 Update Detail Headers]|[TC: JRNL-1212 Update Detail Header ]
      !30.times{ break if (@preventiveService_settings.getHeading() == PreventiveService_Settings::MODAL_HEADING); sleep 1 }
      expect(@preventiveService_settings.getHeading()).to eq(PreventiveService_Settings::MODAL_HEADING)
    end

    it "Verify Content", :broken => true do
      @preventiveService_settings.getModalFormText().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@REMINDERS_FOR_MALES[i])
        expect(@preventiveService_settings.isCPSReminderSelected(i+1)).to eq(true)
      end

      expect(@preventiveService_settings.getCPSReminderCount()).to eq(@REMINDERS_FOR_MALES.length)
    end

    it "Un-check Half" do
      for i in 1..(@preventiveService_settings.getCPSReminderCount()/2) do
        @preventiveService_settings.toggleCPSReminder(i)
        expect(@preventiveService_settings.isCPSReminderSelected(i)).to eq(false)
      end
    end

    it "Save", :broken => true do
      @preventiveService_settings.clickSaveButton()
      !30.times{ break if(@preventiveService_settings.isModalVisible() === false); sleep 1 }
      expect(@preventiveService_settings.isModalVisible()).to eq(false)
    end

    it "Updated List", :broken => true do
      expect(getCount()).to eq(6)
      @REMINDERS_FOR_MALES[5..@REMINDERS_FOR_MALES.length - 1].each do | reminder |
        expect(@screening.findIndexWithGivenPSName(reminder)).not_to eq(-1)
      end
    end

    it "Open Modal", :broken => true do
      @preventiveService_settings.clickTheGearIcon()
      #[AC: JRNL-1228 Update Detail Headers]|[TC: JRNL-1212 Update Detail Header ]
      !30.times{ break if (@preventiveService_settings.getHeading() == PreventiveService_Settings::MODAL_HEADING); sleep 1 }
      expect(@preventiveService_settings.getHeading()).to eq(PreventiveService_Settings::MODAL_HEADING)
    end

    it "Verify Content", :broken => true do
      @preventiveService_settings.getModalFormText().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@REMINDERS_FOR_MALES[i])
        if(i < 5)
          expect(@preventiveService_settings.isCPSReminderSelected(i+1)).to eq(false)
        else
          expect(@preventiveService_settings.isCPSReminderSelected(i+1)).to eq(true)
        end
      end

      expect(@preventiveService_settings.getCPSReminderCount()).to eq(@REMINDERS_FOR_MALES.length)
    end

    it "Un-check Remaining" do
      for i in 6..@preventiveService_settings.getCPSReminderCount() do
        @preventiveService_settings.toggleCPSReminder(i)
        expect(@preventiveService_settings.isCPSReminderSelected(i)).to eq(false)
      end
    end

    it "Save", :broken => true do
      @preventiveService_settings.clickSaveButton()
      !30.times{ break if(@preventiveService_settings.isModalVisible() === false); sleep 1 }
      expect(@preventiveService_settings.isModalVisible()).to eq(false)
    end

    it "AC JRNL-1313|TC-4742: No Results Message", :broken => true do
      expect(@preventiveService_settings.getNoResultsMessage()).to eq("All Preventive Services are currently hidden. Use the gear icon above to add services.")
    end

    it "Open Modal", :broken => true do
      @preventiveService_settings.clickTheGearIcon()
      !30.times{ break if (@preventiveService_settings.getHeading() == PreventiveService_Settings::MODAL_HEADING); sleep 1 }
      expect(@preventiveService_settings.getHeading()).to eq(PreventiveService_Settings::MODAL_HEADING)
    end

    it "Verify Content", :broken => true do
      @preventiveService_settings.getModalFormText().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@REMINDERS_FOR_MALES[i])
        expect(@preventiveService_settings.isCPSReminderSelected(i+1)).to eq(false)
      end

      expect(@preventiveService_settings.getCPSReminderCount()).to eq(@REMINDERS_FOR_MALES.length)
    end

    it "Re-select All" do
      for i in 1..@preventiveService_settings.getCPSReminderCount() do
        @preventiveService_settings.toggleCPSReminder(i)
        expect(@preventiveService_settings.isCPSReminderSelected(i)).to eq(true)
      end
    end

    it "Save", :broken => true do
      @preventiveService_settings.clickSaveButton()
      !30.times{ break if(@preventiveService_settings.isModalVisible() === false); sleep 1 }
      expect(@preventiveService_settings.isModalVisible()).to eq(false)
    end

    it "List", :broken => true do
      @REMINDERS_FOR_MALES.each do | reminder |
        expect(@screening.findIndexWithGivenPSName(reminder)).not_to eq(-1)
      end
      expect(getCount()).to eq(@REMINDERS_FOR_MALES.length)
    end

    it "Notifications Turned Off", :broken => true do
      for i in 1..getCount() do
        clickNthRow(i)
        !45.times{ break if (@screening.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_EDIT); sleep 1 }
        expect(@screening.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)

        expect(@screening.getNotificationStatus()).to eq("Off")

        @screening.clickCancelButton()
        !45.times{ break if (@screening.getPrimaryHeader() == "Preventive Services"); sleep 1 }
        expect(@screening.getPrimaryHeader()).to eq("Preventive Services")
      end
    end

    it "Delete Custom", :broken => true do
      clickNthRow(getCount())
      !45.times{ break if (@screening.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_EDIT); sleep 1 }
      expect(@screening.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)

      @screening.clickDeleteButton()
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      @modal.clickYesButton()
      !45.times{ break if (@screening.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@screening.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "Verify List", :broken => true do
      @REMINDERS_FOR_MALES[0...@REMINDERS_FOR_MALES.length - 1].each do | reminder |
        expect(@screening.findIndexWithGivenPSName(reminder)).not_to eq(-1)
      end
      expect(getCount()).to eq(@REMINDERS_FOR_MALES.length - 1)
    end

    it "Open Modal", :broken => true do
      @preventiveService_settings.clickTheGearIcon()
      !30.times{ break if (@preventiveService_settings.getHeading() == PreventiveService_Settings::MODAL_HEADING); sleep 1 }
      expect(@preventiveService_settings.getHeading()).to eq(PreventiveService_Settings::MODAL_HEADING)
    end

    it "Verify Content", :broken => true do
      @preventiveService_settings.getModalFormText().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@REMINDERS_FOR_MALES[i])
        expect(@preventiveService_settings.isCPSReminderSelected(i+1)).to eq(true)
      end

      expect(@preventiveService_settings.getCPSReminderCount()).to eq(@REMINDERS_FOR_MALES.length - 1)
    end

    it "Switch to Female", :broken => true do
      ## This user is over 65 so will show all female preventive services
      ## 'Cervical Cancer Screening' only shows for age >= 30
      ## 'Osteoporosis Screening' only shows for age >= 65
      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.patient05", "patient05, zztest")

      @navMenu.clickReminders()
      !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
      expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
      expect(@reminders.getPrimaryHeader()).to eq("My Reminders")

      @reminders.clickSubGroup("preventive-services")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "Defaults", :broken => true do
      @REMINDERS_FOR_FEMALES.each do | reminder |
        expect(@screening.findIndexWithGivenPSName(reminder)).not_to eq(-1)
      end
      expect(getCount()).to eq(@REMINDERS_FOR_FEMALES.length)
    end

    it "Open Modal", :broken => true do
      @preventiveService_settings.clickTheGearIcon()
      !30.times{ break if (@preventiveService_settings.getHeading() == PreventiveService_Settings::MODAL_HEADING); sleep 1 }
      expect(@preventiveService_settings.getHeading()).to eq(PreventiveService_Settings::MODAL_HEADING)
    end

    it "Verify Content", :broken => true do
      @preventiveService_settings.getModalFormText().split("\n").each_with_index do | screenRow, i |
        expect(screenRow).to eq(@REMINDERS_FOR_FEMALES[i])
        expect(@preventiveService_settings.isCPSReminderSelected(i+1)).to eq(true)
      end

      expect(@preventiveService_settings.getCPSReminderCount()).to eq(@REMINDERS_FOR_FEMALES.length)
    end

  end

  def addNotification()
    @screening.setNextDueDate(getDateNthDaysFromNow(30, '%m/%d/%Y'))
    @screening.selectNotificationStatus("On")
    @screening.clickNotifyMeAboutThisDueDateCheckbox("On the date")
    @screening.clickSaveButton()
  end

  def clearDefaultNextDueDates()
    getCount().downto(1) do |i|
      if(getTextForRowColumn(i, 3) != "")
        clickNthRow(i)
        !45.times{ break if (@screening.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_EDIT); sleep 1 }
        expect(@screening.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)

        @screening.setNextDueDate("")
        @screening.clickSaveButton()
        !45.times{ break if (@screening.getPrimaryHeader() == "Preventive Services"); sleep 1 }
        expect(@screening.getPrimaryHeader()).to eq("Preventive Services")
      end
    end
  end

end
