# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1324: Preventive Services Recommendations] | JRNL-1303: [Update Preventive Services header]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  after(:all) do
    quitDriver()
  end

  context "Male User" do

    before(:all) do
      clickNavMenu()
      clickReminders()
      clickPreventiveServices()
    end

    it "AC JRNL-1312|TC JRNL-1299: Recommendation Instructional Text" do
      isHealthFinderTextCorrect?()
    end

    it "AC JRNL-1311|TC JRNL-1299: Click Hyperlink", :broken => true do
      @preventative_services.clickLink()

      switchWindowToWindowHandleLast()
      !45.times{ break if (@preventative_services.isUrlCorrect?()); sleep 1 }
      expect(@preventative_services.isUrlCorrect?()).to eq(true)
      expect(@preventative_services.isUrlGenderMale?()).to eq(true)
      expect(@preventative_services.isUrlPregnantFalse?()).to eq(true)
    end

  end

  context "Female User", :broken => true do

    before(:all) do
      closeBrowser()
      switchWindowToWindowHandleFirst()

      @screening.switchUserAndLogBackInToPS("zztest.patient05", "patient05, zztest")
    end

    it "AC JRNL-1312|TC JRNL-1299: Recommendation Instructional Text" do
      isHealthFinderTextCorrect?()
    end

    describe "AC JRNL-1311|TC JRNL-1299: Connecting to HealthFinder.gov" do

      it "Modal Header" do
        @preventative_services.clickLink()
        30.times{ break if(@modal.getConfirmationHeading() == "Recommended Services – Pregnancy Status"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Recommended Services – Pregnancy Status")
      end

      it "Modal Text" do
        expect(@modal.getModalText()).to eq("Please provide your pregnancy status so the appropriate services are recommended for you.")
      end

      it "Modal Radio Buttons" do
        radioButtons = @modal.getModalRadioButtons()
        expected = ["Pregnant", "Not Pregnant"]

        for i in 0...radioButtons.length do
          expect(radioButtons[i].text).to eq(expected[i])
        end
      end

      it "Default Selection" do
        expect(@modal.isNotPregnantSelected?()).to eq(true)
      end

      it "Select Pregnant and Continue", :broken => true do
        @modal.selectPregnantButton()
        @modal.clickSaveButton()
        switchWindowToWindowHandleLast()
        !45.times{ break if (@preventative_services.isUrlCorrect?()); sleep 1 }
        expect(@preventative_services.isUrlCorrect?()).to eq(true)
        expect(@preventative_services.isUrlPregnantTrue?()).to eq(true)
        expect(@preventative_services.isUrlGenderFemale?()).to eq(true)
        closeBrowser()
        switchWindowToWindowHandleFirst()
      end

      it "Modal", :broken => true do
        @preventative_services.clickLink()
        30.times{ break if(@modal.getConfirmationHeading() == "Recommended Services – Pregnancy Status"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Recommended Services – Pregnancy Status")
      end

      it "Select Not Pregnant and Continue", :broken => true do
        @modal.clickSaveButton()
        switchWindowToWindowHandleLast()
        !45.times{ break if (@preventative_services.isUrlCorrect?()); sleep 1 }
        expect(@preventative_services.isUrlCorrect?()).to eq(true)
        expect(@preventative_services.isUrlPregnantFalse?()).to eq(true)
        expect(@preventative_services.isUrlGenderFemale?()).to eq(true)
        closeBrowser()
        switchWindowToWindowHandleFirst()
      end

      it "Modal", :broken => true do
        @preventative_services.clickLink()
        30.times{ break if(@modal.getConfirmationHeading() == "Recommended Services – Pregnancy Status"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Recommended Services – Pregnancy Status")
      end

      it "Click Cancel", :broken => true do
        @modal.clickCancelButton()
        !30.times{ break if(@modal.isConfirmationPopUpNotPresent()); sleep 1 }
        expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
      end

      it "Focus", :broken => true do
        !30.times{ break if(@screening.getFocusedElementText() == "preventive services recommendations"); sleep 1 }
        expect(@screening.getFocusedElementText()).to eq("preventive services recommendations")
      end

    end

  end

  def clickNavMenu
    @main.clickNavMenu()
    !45.times { break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
  end

  def clickReminders
    @nav_menu.clickReminders()
    waitForPageToFinishLoading()
  end

  def clickPreventiveServices
    @reminders.clickSubGroup("preventive-services")
    waitForPageToFinishLoading()
  end

  def isHealthFinderTextCorrect?
    expect(@preventative_services.getHealthFinderText()).to eq("Connect to healthfinder.gov to view a list of key preventive services recommendations based upon your age.")
    expect(@preventative_services.getHealthFinderLinkText()).to eq("preventive services recommendations")
  end

end