require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1122: Preventive Service Notifications - Updated View Logic ]", :broken => true, :regression => true do

  startTime = Time.new
  puts "Start Time: " + startTime.inspect

  before(:all) do
    initializeConfigurations(BASE_URL)
    #clean up preventiveservices collection
    removeCollection("preventiveservices", "healthtrackerdb")
    #clean up notificationPreferences and import
    removeCollection("notificationPreferences", "notificationsdb")
    #clean up preferences and import
    removeCollection("preferences", "notificationsdb")
    #clean up reminders
    removeCollection("reminders", "remindersdb")
    removeCollection("notifications", "notificationsdb")

    resetQuartzNotificationDb()

    initializeAllObjects

    @INITIAL_NOTIFICATION_CONTENT = [\
            "Notification:",
            "Status:",
            "On",
            "Off",
            "* Notify Me About This Due Date:",
            "On the date 1 day before 2 weeks before 4 weeks before",
            "* Notification Delivery:",
            "In-App",
            "Email",
            "Email address has not been saved",
            "You may update your Preferred Email address in the Notification feature by selecting the notification settings icon",
            "You may update your Preferred Email address in the Notification feature by selecting the icon."]


    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")
    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")

    @main.clickNavMenu()
    !10.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !10.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }

    @reminders.clickSubGroup("preventive-services")
    !10.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
    !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

  end


  after(:all) do
    quitDriver()
  end

 for ps in [ "Shingles Vaccination", "PCV13 - Pneumococcal Vaccination", "PPSV23 - Pneumococcal Vaccination", "Flu Vaccination", "Cervical Cancer Screening", "Blood Pressure Screening", "Breast Cancer Screening", "Cholesterol Screening", "HIV Screening", "HPV Vaccination", "Osteoporosis Screening", "Tetanus Vaccination"]
   #for ps in ["Cervical Cancer Screening"]
    context "AC #JRNL-1117|TC JRNL-1111 : " + ps do
     #for ps in [ "Shingles Vaccination"]
      preventive_service_being_tested = ps
      it "Testing Preventive Service Notification ", :broken => true  do


        puts "PS " + preventive_service_being_tested
        #Open the PS
        indexID = @screening.findIndexWithGivenPSName(preventive_service_being_tested)
        @reminders.clickNthReminder(indexID)

        #Add double wait since the header is loaded at differently time as the form
        !10.times{ break if (@reminders.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_EDIT); sleep 1 }
        !10.times{ break if (isElementVisible(:css, "input[name*='notificationOption'][type='radio']") == true); sleep 1 }

      end

      it "Instructional Text (display varies based on NDD)", :broken => true do
        #default status is off
        expect(@screening.getNotificationStatus).to eq("Off")

        #null date
        #defect:Rishi is working on it
        setDate("", Screening::NEXT_DUE_DATE)
       expect(getTextForElement(:css, Screening::INSTRUCTIONAL_TEXT)).to eq("Notifications are available for future due dates only.")

        #Present Date
        setDate(@today, Screening::NEXT_DUE_DATE)
        expect(getTextForElement(:css, Screening::INSTRUCTIONAL_TEXT)).to eq("Notifications are available for future due dates only.")

        #Past Date
        setDate(@yesterday, Screening::NEXT_DUE_DATE)
        expect(getTextForElement(:css, Screening::INSTRUCTIONAL_TEXT)).to eq("Notifications are available for future due dates only.")

        #When a Future Date is entered, correct instructional text displays
        setDate(@tomorrow, Screening::NEXT_DUE_DATE)
        expect(getTextForElement(:css, Screening::INSTRUCTIONAL_TEXT)).to eq("Send yourself a notice about this preventive service due date.")

      end

      it "Notification Labels, Bell icon", :broken => true do
        notificationContent = @screening.getNotificationContent().split("\n")

        @INITIAL_NOTIFICATION_CONTENT.each_with_index do | expectedScreenRow, i |
          expect(notificationContent[i]).to eq(expectedScreenRow)
        end
        expect(notificationContent.length).to eq(@INITIAL_NOTIFICATION_CONTENT.length)

        expect(isElementPresentAndVisible(:css, Screening::BELL_ICON)).to eq(true)
      end

      it "Status (On/Off radio buttons)", :broken => true do
        setDate("", Screening::NEXT_DUE_DATE)
        expect(@screening.getNotificationStatus).to eq("Off")
        verifyThisCheckboxIsDisabled("On the date", true)
        verifyThisCheckboxIsDisabled("1 day before", true)
        verifyThisCheckboxIsDisabled("2 weeks before", true)
        verifyThisCheckboxIsDisabled("4 weeks before", true)

        verifyThisCheckboxIsDisabled("In-App", true)
        verifyThisCheckboxIsDisabled("Email", true)

        #Select On from Notification Preference
        fourtyDaysLater = getDateNthDaysFromNow(40, "%m/%d/%Y")
        setDate(fourtyDaysLater, Screening::NEXT_DUE_DATE)
        #@screening.selectNotificationStatus("On")
        #Verify that four checkboxes are present
        expect(@screening.getNotifyMeLabel()).to eq("* Notify Me About This Due Date:")
        verifyThisCheckboxIsDisabled("On the date", false)
        verifyThisCheckboxIsDisabled("1 day before", false)
        verifyThisCheckboxIsDisabled("2 weeks before", false)
        verifyThisCheckboxIsDisabled("4 weeks before", false)

        verifyThisCheckboxIsDisabled("In-App", false)
        verifyThisCheckboxIsDisabled("Email", true)

        @screening.clickSaveButton
        checkingInlineError("The Notify Me field is needed to save this record. Please select at least one option and save again.", 0)

        #Check all four checkboxes
        @screening.clickNotificationDeliveryCheckBox("On the date")
        @screening.clickNotificationDeliveryCheckBox("1 day before")
        @screening.clickNotificationDeliveryCheckBox("2 weeks before")
        @screening.clickNotificationDeliveryCheckBox("4 weeks before")

        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)

        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate")).to eq(true)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "1 day before", "notificationTriggerDate")).to eq(true)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "2 weeks before", "notificationTriggerDate")).to eq(true)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "4 weeks before", "notificationTriggerDate")).to eq(true)


        if ps == "Shingles Vaccination" then
          @screening.setLastAdministeredDate(getDateNthDaysAgo(1, "%m/%d/%Y"))
          expect(isThisElementDisabled(:css, Screening::NEXT_DUE_DATE)).to eq(true)
          expect(@screening.getNotificationStatus).to eq("Off")

        else
          #Select Off from Notification Preference
          @screening.selectNotificationStatus("Off")
        end
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "1 day before", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "2 weeks before", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "4 weeks before", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(false)

        verifyThisCheckboxIsDisabled("On the date", true)
        verifyThisCheckboxIsDisabled("1 day before", true)
        verifyThisCheckboxIsDisabled("2 weeks before", true)
        verifyThisCheckboxIsDisabled("4 weeks before", true)

        verifyThisCheckboxIsDisabled("In-App", true)
        verifyThisCheckboxIsDisabled("Email", true)
      end

      it "Notify Me About This Due Date", :broken => true do
        #default all to unchecked
        @screening.selectNotificationStatus("On")

        #Verify that four checkboxes are present
        expect(@screening.getNotifyMeLabel()).to eq("* Notify Me About This Due Date:")

        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "1 day before", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "2 weeks before", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "4 weeks before", "notificationTriggerDate")).to eq(false)

        #null NDD
        if ps == "Shingles Vaccination" then
          @screening.setLastAdministeredDate("")
          fourtyDaysLater = getDateNthDaysFromNow(40, "%m/%d/%Y")
          setDate(fourtyDaysLater, Screening::NEXT_DUE_DATE)
        end
        verifyNotifyMeFields("", true, true, true, true)

        verifyNotifyMeFields(@today, true, true, true, true)

        verifyNotifyMeFields(@tomorrow, false, true, true, true)

        threeDaysLater = getDateNthDaysFromNow(3, "%m/%d/%Y")
        verifyNotifyMeFields(threeDaysLater, false, false, true, true)

        fourteenDaysLater = getDateNthDaysFromNow(14, "%m/%d/%Y")
        verifyNotifyMeFields(fourteenDaysLater, false, false, true, true)

        fifteenDaysLater = getDateNthDaysFromNow(15, "%m/%d/%Y")
        verifyNotifyMeFields(fifteenDaysLater, false, false, false, true)
        twentyEightDaysLater = getDateNthDaysFromNow(28, "%m/%d/%Y")
        verifyNotifyMeFields(twentyEightDaysLater, false, false, false, true)

        twentyNineDaysLater = getDateNthDaysFromNow(29, "%m/%d/%Y")
        verifyNotifyMeFields(twentyNineDaysLater, false, false, false, false)

      end

      it "Notification Delivery", :broken => true do
        expect(@screening.getNotificationStatus).to eq("On")
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)
        @screening.selectNotificationStatus("Off")
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(false)

        @screening.selectNotificationStatus("On")
        #no email set in the preference
        verifyThisCheckboxIsDisabled("Email", true)
        expect(@screening.getEmailFromNotification()).to eq("Email address has not been saved")

        #Verify the instructional text is displayed
        expect(@screening.getInstructionalTextWhenEmailIsNotAvailable()).to eq("You may update your Preferred Email address in the Notification feature by selecting the notification settings icon")

        setDate(@tomorrow, Screening::NEXT_DUE_DATE)
        @screening.clickNotificationDeliveryCheckBox("On the date")
        @screening.clickSaveButton

        !10.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
        !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

        @common.navigateToNotificationSettingAndSetOrRemoveEmail("test@testAgilex.com")
        #Come back to Preventive Service table view
        @screening.returnToPSAndEditAPS(preventive_service_being_tested)
        expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)
        expect(isElementVisible(:css, "input[name='notificationOption'][type='radio']")).to eq(true)

        verifyThisCheckboxIsDisabled("Email", false)
        #Verify that the email address is displayed in the edit box
        expect(@screening.getEmailFromNotification()).to eq("test@testAgilex.com")
        # un-check the In-App option
        @screening.clickNotificationDeliveryCheckBox("In-App")
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(false)
        # check the Email option
        @screening.clickNotificationDeliveryCheckBox("Email")
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(true)

        #'On the date' option is selected
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate")).to eq(true)

        @screening.clickSaveButton

        !10.times{ break if (@reminders.getPrimaryHeader() == "Preventive Service"); sleep 1 }
        !10.times{ break if (@screening.getTableViewHeader() == "Status"); sleep 1 }

        #Navigate to the Notification Setting screen to remove the email address
        @common.navigateToNotificationSettingAndSetOrRemoveEmail("")
        !15.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
        expect(@modal.getTopLayerModalConfirmationHeading()).to eq("Warning")

        @modal.clickSaveButton()
        !15.times{ break if (@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
        expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

        #Return to Preventive Service screen
        @screening.returnToPSAndEditAPS(preventive_service_being_tested)
        expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)
        expect(isElementVisible(:css, "input[name='notificationOption'][type='radio']")).to eq(true)

        #Verify that now the Notification Status is set to Off and email checkbox is unchecked
        expect(@screening.getNotificationStatus).to eq("Off")
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(false)

        #All notification fields nullified
        #line 312 is failing on ci build
        !15.times{ break if (isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate") == true); sleep 1 }

        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "1 day before", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "2 weeks before", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "4 weeks before", "notificationTriggerDate")).to eq(false)

        # Turn the Status to On
        @screening.selectNotificationStatus("On")
        expect(@screening.getNotificationStatus).to eq("On")
        @screening.clickNotificationDeliveryCheckBox("In-App")
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(false)
        @screening.clickSaveButton()
        checkingInlineError("A Notification Delivery method is needed to save this record. Please select a method and save again.", 0)

      end

      it "If the NDD is updated to a valid NDD (one or more of the Notify Me fields are enabled), then Status is set to On (Criteria 1.3.2 applies)", :broken => true do
        @screening.setNextDueDate(@tomorrow)
        #status enabled and set to On
        expect(@screening.getNotificationStatus).to eq("On")
        #Notify Me fields enabled
        verifyThisCheckboxIsDisabled("On the date", false)
        verifyThisCheckboxIsDisabled("1 day before", true)
        verifyThisCheckboxIsDisabled("2 weeks before", true)
        verifyThisCheckboxIsDisabled("4 weeks before", true)
        #Notification delivery option enabled
        verifyThisCheckboxIsDisabled("In-App", false)
      end

      it "If the NDD is updated to an invalid NDD (no notifications can be sent based on the date) then all Notification fields (Status, Notify Me, Delivery Method) are nullified and disabled.", :broken => true do
        @screening.setNextDueDate(@yesterday)
        verifyThisRadioBUttonIsDiabled("On", true)
        verifyThisRadioBUttonIsDiabled("Off", true)
        expect(isThisRadioButtonOrCheckBoxSelected("radio", "On", "notificationOption")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("radio", "Off", "notificationOption")).to eq(true)

        verifyThisCheckboxIsDisabled("On the date", true)
        verifyThisCheckboxIsDisabled("1 day before", true)
        verifyThisCheckboxIsDisabled("2 weeks before", true)
        verifyThisCheckboxIsDisabled("4 weeks before", true)

        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "1 day before", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "2 weeks before", "notificationTriggerDate")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "4 weeks before", "notificationTriggerDate")).to eq(false)

        verifyThisCheckboxIsDisabled("In-App", true)
        verifyThisCheckboxIsDisabled("Email", true)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(false)
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(false)

        @screening.clickSaveButton()
        !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
        sleep 1

        puts "End of PS : "  + preventive_service_being_tested

      end
    end
  end

    def checkingInlineError(errMsg, seqNum)
      #Verify that the error message section header is displayed
      if seqNum == 0 then
        !10.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
      end
      #Verify the error message is displayed
      expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to be true

    end

    def verifyThisCheckboxPresentAndVisible(value, trueOrFalse)
      expect(isElementPresentAndVisible(:css, "input[type='checkbox'][value='" + value + "']")).to eq(trueOrFalse)
    end

    def verifyThisCheckboxIsDisabled(value, trueOrFalse)
      expect(isThisElementDisabled(:css, "input[type='checkbox'][value='" + value + "']")).to eq(trueOrFalse)
    end

    def verifyThisRadioBUttonIsDiabled(value, trueOrFalse)
      expect(isThisElementDisabled(:css, "input[type='radio'][value='" + value + "']")).to eq(trueOrFalse)
    end


    def verifyNotifyMeFields(date, isOnTheDayDisabled, isOneDayBeforeDisabled, isTwoWeeksBeforeDisabled, isFourWeeksBeforeDisabled)
      setDate(date, Screening::NEXT_DUE_DATE)
      verifyThisCheckboxIsDisabled("On the date", isOnTheDayDisabled)
      verifyThisCheckboxIsDisabled("1 day before", isOneDayBeforeDisabled)
      verifyThisCheckboxIsDisabled("2 weeks before", isTwoWeeksBeforeDisabled)
      verifyThisCheckboxIsDisabled("4 weeks before", isFourWeeksBeforeDisabled)
    end

end
