#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "Story# JRNL-1138: Revise Learn More Text for Preventive Services", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "Logged in as patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    sleep 5

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }

    #Verify the group navigation header
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    #Verify the Table View header
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    @reminders.clickSubGroup("preventive-services")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1116|TC JRNL-1110: Revise Learn More Text for Preventive Services" do

    it "TDAP/Tetanus Text ", :broken => true do
      #verify that, Tetanus Vaccination is available on the list
      expect(@screening.findIndexWithGivenPSName("Tetanus Vaccination")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("Tetanus Vaccination")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("Tetanus Vaccination")

      #verify Learn more about Tetanus Vaccination
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About Tetanus Vaccination")
      expect(@modal.getConfirmationMessage()).to eq("Childhood Recommendations\nChildren should get 5 doses of DTaP, one dose at each of the following ages: 2, 4, 6, and 15-18 months and 4-6 years. DT does not contain pertussis, and is used as a substitute for DTaP for children who cannot tolerate pertussis vaccine.\nAfter the above primary vaccination series is completed, the adult recommendations start.\nAdult Recommendations\nTalk to your provider if you are unsure if you have received your complete childhood vaccination series.\nPersons aged 11 years or older who have not received Tdap vaccine should receive a dose of Tdap followed by tetanus and diphtheria toxoids (Td) booster doses every 10 years thereafter.\nDuring every pregnancy, 1 dose of Tdap vaccine should be received (preferably during 27 to 36 weeks’ gestation) regardless of when the last Td or Tdap vaccination was received.\nTetanus (Td) boosters are also given after an exposure to tetanus.\nMore information is available at the Centers for Disease Control and Prevention: Tetanus Vaccination webpage.")

      click(:css, Screening::TETANUS_VACCINE_URL)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://www.cdc.gov/tetanus/vaccination.html")
      closeBrowser()

      switchWindowToWindowHandleFirst()

      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end
    it "Chlamydia and Gonorrhea Text ", :broken => true do
      #verify that, Chlamydia and Gonorrhea Screening is available on the list
      expect(@screening.findIndexWithGivenPSName("Chlamydia and Gonorrhea Screening")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("Chlamydia and Gonorrhea Screening")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      #title
      expect(@screening.getDetailHeader()).to eq("Chlamydia and Gonorrhea Screening")

      #learn more icon and Learn More Label
      expect(isElementPresentAndVisible(:css, Screening::GRADUATION_CAP)).to eq(true)
      expect(getTextForElement(:css, Screening::LEARN_MORE_TEXT)).to eq("Learn More")

      #verify Learn more about Chlamydia and Gonorrhea Screening
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About Chlamydia and Gonorrhea Screening")
      expect(@modal.getConfirmationMessage()).to eq("Females:\nCurrent guidelines recommend yearly Chlamydia and Gonorrhea Screening for all sexually active asymptomatic women younger than 25 years, as well as asymptomatic older women who are at increased risk of infection (risk factors include: new or multiple sex partners, a sex partner with concurrent partners, or a sex partner with a sexually transmitted infection (STI); inconsistent condom use among persons who are not in mutually monogamous relationships; previous or concurrent STI; and exchanging sex for money or drugs).\nView additional information on Screening for Chlamydia and Gonorrhea.")

      click(:css, Screening::SCREENING_FOR_CHLAMYDIA_GONORRHEA_PDF_LINK)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://localhost:8080/my-va-health/_assets/pdfs/gonchlamfinalrsfact.pdf")
      closeBrowser()

      switchWindowToWindowHandleFirst()

      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "Breast Cancer Screening Text ", :broken => true do
      #verify that, Breast Cancer Screening is available on the list
      expect(@screening.findIndexWithGivenPSName("Breast Cancer Screening")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("Breast Cancer Screening")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("Breast Cancer Screening")

      #learn more icon and Learn More Label
      expect(isElementPresentAndVisible(:css, Screening::GRADUATION_CAP)).to eq(true)
      expect(getTextForElement(:css, Screening::LEARN_MORE_TEXT)).to eq("Learn More")

      #verify Learn more about Breast Cancer Screening
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About Breast Cancer Screening")
      expect(@modal.getConfirmationMessage()).to eq("Current guidelines recommend screening for breast cancer with mammography every two years for average risk women age 50 through 74.\nThe decision to start regular screening every 2 years with mammography for average risk women age 40 to 49 years should be an individual decision and take your values into account including values about specific benefits and harms.\nThe current evidence is insufficient to assess the balance of benefits and harms of screening for breast cancer with mammography in women age 75 and older.\nCertain risk factors including having a sister, mother or daughter with breast cancer or confirmation of genetic tests that increase your risk of breast cancer may lead your provider to recommend more frequent or earlier screening. Optimal timing of your mammogram or other breast imaging should be determined by discussing with your provider, taking into account your personal needs and risk factors.")
      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "Cervical Cancer Screening Text ", :broken => true do
      #verify that, Cervical Cancer Screening is available on the list
      expect(@screening.findIndexWithGivenPSName("Cervical Cancer Screening")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("Cervical Cancer Screening")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("Cervical Cancer Screening")

      #learn more icon and Learn More Label
      expect(isElementPresentAndVisible(:css, Screening::GRADUATION_CAP)).to eq(true)
      expect(getTextForElement(:css, Screening::LEARN_MORE_TEXT)).to eq("Learn More")

      #verify Learn more about Cervical Cancer Screening
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About Cervical Cancer Screening")
      expect(@modal.getConfirmationMessage()).to eq("Current guidelines recommend screening for cervical cancer with a Pap smear every 3 years for women ages 21-65 OR, for women ages 30-65 who want to lengthen the screening interval, screening with a combination of a Pap smear and human papillomavirus (HPV) test every 5 years. These recommendations do not apply to high risk women.\nIf you have had a hysterectomy talk to your provider about whether or not you need cervical cancer screening.\nWomen who are older than 65 who have had normal Pap smear results previously and are not at high risk for cervical cancer may not need to be screened.\nWomen with HIV, who are immunosuppressed, who have been exposed to diethylstilbestrol (DES) before birth, or who have had a prior precancerous cervical lesion or cervical cancer need to have more frequent Pap smears.\nWomen who have had the HPV vaccine series should follow the guidelines above.\nTiming of your Pap smear and HPV testing should be determined by discussing with your provider taking into account your personal needs and risk factors.")
      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "Osteoporosis Text ", :broken => true do
      #verify that, Osteoporosis Screening is available on the list
      expect(@screening.findIndexWithGivenPSName("Osteoporosis Screening")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("Osteoporosis Screening")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("Osteoporosis Screening")

      #learn more icon and Learn More Label
      expect(isElementPresentAndVisible(:css, Screening::GRADUATION_CAP)).to eq(true)
      expect(getTextForElement(:css, Screening::LEARN_MORE_TEXT)).to eq("Learn More")

      #verify Learn more about Osteoporosis Screening
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About Osteoporosis Screening")
      expect(@modal.getConfirmationMessage()).to eq("Osteoporosis screening is recommended for women 65 or older. Men over the age of 50 with risk factors can discuss with their provider if Osteoporosis screening is recommended.\nRisk factors may lead your provider to recommend early screening including but not limited to: a personal history of bone fracture, tobacco or alcohol use, taking oral steroids, or a history of rheumatoid arthritis.\nTalk to your provider about when you should be screened for osteoporosis. They will take into account your personal needs and possible risk factors.\nMore information can be found at the United States Department of Veteran Affairs, Osteoporosis: Screening for Bone Loss webpage.")

      click(:css, Screening::OSTEOPOROSIS_URL)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://www.veteranshealthlibrary.org/Search/142,85779_VA")
      closeBrowser()

      switchWindowToWindowHandleFirst()

      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "Colorectal Cancer Screening Text ", :broken => true do
      #verify that, Colorectal Cancer Screening is available on the list
      expect(@screening.findIndexWithGivenPSName("Colorectal Cancer Screening")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("Colorectal Cancer Screening")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("Colorectal Cancer Screening")

      #learn more icon and Learn More Label
      expect(isElementPresentAndVisible(:css, Screening::GRADUATION_CAP)).to eq(true)
      expect(getTextForElement(:css, Screening::LEARN_MORE_TEXT)).to eq("Learn More")

      #verify Learn more about Colorectal Cancer Screening
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About Colorectal Cancer Screening")
      expect(@modal.getConfirmationMessage()).to eq("Current guidelines recommend screening for colorectal cancer (blood testing, sigmoidoscopy or colonoscopy) in all adults age 50 through 75 at recommended intervals. Adults age 76 through 85 should talk to their provider about whether or not they need to be screened. Routine screening is not recommended for adults older than age 85.\nPlease discuss with your provider appropriate screening recommendations if you are at an increased risk for colon cancer based upon a previous abnormal colonoscopy, family history of colorectal cancer, inflammatory bowel disease, or other inherited conditions.\nMore information can be found at the healthfinder.gov: Get Tested for Colorectal Cancer webpage.")

      click(:css, Screening::COLORECTAL_CANCEL_URL)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://www.healthfinder.gov/HealthTopics/Category/doctor-visits/screening-tests/get-tested-for-colorectal-cancer")
      closeBrowser()

      switchWindowToWindowHandleFirst()

      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "Blood Pressure Text ", :broken => true do
      #verify that, Blood Pressure Screening is available on the list
      expect(@screening.findIndexWithGivenPSName("Blood Pressure Screening")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("Blood Pressure Screening")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("Blood Pressure Screening")

      #learn more icon and Learn More Label
      expect(isElementPresentAndVisible(:css, Screening::GRADUATION_CAP)).to eq(true)
      expect(getTextForElement(:css, Screening::LEARN_MORE_TEXT)).to eq("Learn More")

      #verify Learn more about Blood Pressure
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About Blood Pressure Screening")
      expect(@modal.getConfirmationMessage()).to eq("Current guidelines recommend screening for high blood pressure at least every 1-2 years for all adults over 18 years old who have not been diagnosed with hypertension.\nScreening should occur at least every 2 years in persons with blood pressure less than 120/80 mm Hg and at least every year for those whose systolic blood pressure (top number) is 120 to 139 mm Hg or diastolic blood pressure (bottom number) is 80 to 89 mm Hg. Please discuss with your provider if more frequent monitoring is necessary. If you are diagnosed with high blood pressure, your provider will determine the frequency of monitoring.")
      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "Cholesterol Screening Text ", :broken => true do
      #verify that, Cholesterol Screening is available on the list
      expect(@screening.findIndexWithGivenPSName("Cholesterol Screening")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("Cholesterol Screening")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("Cholesterol Screening")

      #verify Learn more about Cholesterol screening
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About Cholesterol Screening")
      expect(@modal.getConfirmationMessage()).to eq("For Men\nCurrent guidelines recommend screening for dyslipidemia (cholesterol abnormalities) every 5 years for men age 35 and older and for men between the ages of 20-34 who are at increased risk for coronary heart disease.\nFor Women\nCurrent guidelines recommend screening for dyslipidemia (cholesterol abnormalities) every 5 years for women age 45 and older and for women between the ages of 20-44 who are at increased risk for coronary heart disease.\nPlease discuss with your provider whether you need more frequent screening. If you are diagnosed with high blood cholesterol, your provider will determine the frequency of monitoring.\nMore information can be found at the Agency for Healthcare Research and Quality: What is High Cholesterol? webpage.")

      click(:css, Screening::HIGH_CHOLESTEROL_URL)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://www.ahrq.gov/patients-consumers/prevention/disease/cholpatient.html")
      closeBrowser()

      switchWindowToWindowHandleFirst()

      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "Flu Vaccine Text ", :broken => true do
      #verify that, Flu Vaccination is available on the list
      expect(@screening.findIndexWithGivenPSName("Flu Vaccination")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("Flu Vaccination")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("Flu Vaccination")

      #verify Learn more about Flu Vaccination
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About Flu Vaccination")
      expect(@modal.getConfirmationMessage().strip).to eq("Everyone 6 months of age and older should receive a flu vaccine every season. Flu vaccination should begin soon after flu vaccine is available, and ideally by October. However, as long as flu viruses are circulating, vaccination should continue throughout the flu season, even in January or later. Universal flu vaccination in the United States helps to protect your family and community. This vaccination is particularly important for people who are at high risk of serious complications from influenza. See People at High Risk of Developing Flu-Related Complications for a full list of age and health factors that confer increased risk.\nMore information is available at Who Should Get Vaccinated Against Influenza.")
      click(:css, Screening::FLU_COMPLICATIONS_URL)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://www.cdc.gov/flu/about/disease/high_risk.htm")
      closeBrowser()

      switchWindowToWindowHandleFirst()

      click(:css, Screening::WHO_SHOULD_VACCINE_URL)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://www.cdc.gov/flu/protect/whoshouldvax.htm")
      closeBrowser()

      switchWindowToWindowHandleFirst()

      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "HIV Text ", :broken => true do
      #verify that, Flu Vaccination is available on the list
      expect(@screening.findIndexWithGivenPSName("HIV Screening")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("HIV Screening")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("HIV Screening")

      #verify Learn more about HIV Screening
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About HIV Screening")
      expect(@modal.getConfirmationMessage()).to eq("Everyone aged 15 to 65 years should be screened for HIV infection. Teens younger than age 15 and adults older than 65 also should be screened if they are at increased risk for HIV infection.\nAll pregnant women, including women in labor who do not know their HIV status, should be screened for HIV infection.\nPersons at high risk for HIV infection should be screened for HIV at least annually.\nTalk to your provider to determine your risk.\nMore information is available at the Centers for Disease Control and Prevention: HIV Testing webpage.")

      click(:css, Screening::HIV_URL)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://www.cdc.gov/hiv/basics/testing.html")
      closeBrowser()

      switchWindowToWindowHandleFirst()

      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "Shingles Vaccination Text ", :broken => true do
      #verify that, Cervical Cancer Screening is available on the list
      expect(@screening.findIndexWithGivenPSName("Shingles Vaccination")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("Shingles Vaccination")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("Shingles Vaccination")

      #learn more icon and Learn More Label
      expect(isElementPresentAndVisible(:css, Screening::GRADUATION_CAP)).to eq(true)
      expect(getTextForElement(:css, Screening::LEARN_MORE_TEXT)).to eq("Learn More")

      #verify Learn more about Cervical Cancer Screening
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About Shingles Vaccination")
      expect(@modal.getConfirmationMessage()).to eq("A single dose of the shingles vaccine is recommended for all adults aged 60 years or older. Even people who have had shingles can receive the vaccine to help prevent future occurrences of the disease.\nShingles, also known as zoster or herpes zoster, is a painful skin rash. It is caused by varicella zoster virus (VZV), the same virus that causes chickenpox. Anyone who has had chickenpox or received chickenpox vaccine in the past may develop shingles. The only way to reduce the risk of developing shingles and the long-term pain from post-herpetic neuralgia (PHN) is to get vaccinated.")
      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "PCV13 - Pneumococcal Vaccination Text ", :broken => true do
      #verify that, Cervical Cancer Screening is available on the list
      expect(@screening.findIndexWithGivenPSName("PCV13 - Pneumococcal Vaccination")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("PCV13 - Pneumococcal Vaccination")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("PCV13 - Pneumococcal Vaccination")

      #learn more icon and Learn More Label
      expect(isElementPresentAndVisible(:css, Screening::GRADUATION_CAP)).to eq(true)
      expect(getTextForElement(:css, Screening::LEARN_MORE_TEXT)).to eq("Learn More")

      #verify Learn more about Cervical Cancer Screening
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About PCV13 - Pneumococcal Vaccination")
      expect(@modal.getConfirmationMessage()).to eq("Pneumococcal conjugate vaccine (PCV13) is recommended for adults over 65 years old, all children younger than 5 years old, and people 6 years or older with certain risk factors. If you are under 65 years old, check with your provider to see if you need the vaccination now. If you received a dose of PCV13 prior to turning 65 years of age (due to a medical indication), you do not need an additional dose of PCV13.\nThere are 2 pneumococcal vaccines (PCV13 and PPSV23) recommended for all adults 65 years or older. You should receive a dose of PCV13 first, followed by a dose of the PPSV23, at least 8 weeks or ideally 6 to 12 months later. If you've already received any doses of PPSV23, the dose of PCV13 should be given at least 1 year after receipt of the most recent PPSV23 dose. If you've already received a dose of PCV13 at a younger age, another dose of PCV13 is not recommended.\nMore information is available at the Centers for Disease Control and Prevention: Pneumococcal Vaccination webpage.")

      click(:css, Screening::PNEUMOCOCCAL_VACCIN_URL)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://www.cdc.gov/pneumococcal/vaccination.html")
      closeBrowser()

      switchWindowToWindowHandleFirst()

      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "PPSV23 - Pneumococcal Vaccination Text ", :broken => true do
      #verify that, Cervical Cancer Screening is available on the list
      expect(@screening.findIndexWithGivenPSName("PPSV23 - Pneumococcal Vaccination")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("PPSV23 - Pneumococcal Vaccination")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("PPSV23 - Pneumococcal Vaccination")

      #learn more icon and Learn More Label
      expect(isElementPresentAndVisible(:css, Screening::GRADUATION_CAP)).to eq(true)
      expect(getTextForElement(:css, Screening::LEARN_MORE_TEXT)).to eq("Learn More")

      #verify Learn more about Cervical Cancer Screening
      @screening.clickLearnMoreLink()
      expect(@modal.getConfirmationHeading()).to eq("Learn More About PPSV23 - Pneumococcal Vaccination")
      expect(@modal.getConfirmationMessage()).to eq("Pneumococcal polysaccharide vaccine (PPSV23) is recommended for all adults 65 years or older. People 2 years through 64 years of age who are at high risk of pneumococcal disease should also receive PPSV23. Usually only one dose of PPSV23 is needed, but under some circumstances a second dose may be given. Check with your provider to see if you should receive the vaccine before age 65 or if you need more than one dose.\nThere are 2 pneumococcal vaccines (PCV13 and PPSV23) recommended for all adults 65 years or older. You should receive a dose of PCV13 first, followed by a dose of the PPSV23, at least 8 weeks or ideally 6 to 12 months later. If you've already received any doses of PPSV23, the dose of PCV13 should be given at least 1 year after receipt of the most recent PPSV23 dose. If you've already received a dose of PCV13 at a younger age, another dose of PCV13 is not recommended.\nMore information is available at the Centers for Disease Control and Prevention: Pneumococcal Vaccination webpage.")

      click(:css, Screening::PNEUMOCOCCAL_VACCIN_URL)
      switchWindowToWindowHandleLast()
      expect(getCurrentURL()).to eq("http://www.cdc.gov/pneumococcal/vaccination.html")
      closeBrowser()

      switchWindowToWindowHandleFirst()

      @modal.clickNoButton()
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

    it "Human Papilloma Virus (HPV) Vaccine Text ", :broken => true do
      #verify that, HPV Vaccination is available on the list
      expect(@screening.findIndexWithGivenPSName("HPV Vaccination")).not_to eq(-1)
      indexID = @screening.findIndexWithGivenPSName("HPV Vaccination")
      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == @screening.getEditEntryHeader()); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(@screening.getEditEntryHeader())
      expect(@screening.getDetailHeader()).to eq("HPV Vaccination")

      #verify Learn more about HPV
      @screening.clickLearnMoreLink()
      !45.times{ break if (@modal.getConfirmationHeading()== "Learn More About HPV Vaccination"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Learn More About HPV Vaccination")
      expect(@modal.getConfirmationMessage()).to eq("Human Papillomavirus (HPV) is a common virus that is spread through sexual contact. Most of the time HPV has no symptoms so people do not know they have it. Some types of HPV can cause cervical cancer in women and can also cause other cancers in both men and women. Other HPV types cause genital warts.\nThe HPV vaccine works by preventing the most common types of HPV that cause cervical cancer and genital warts. It is given as a 3-dose vaccine starting at age 11 years old. Women can receive both the bivalent HPV vaccine Cervarix and the quadravalent HPV vaccine Gardisil; men can only receive the quadravalent HPV vaccine Gardisil. Females can receive either vaccine with the 3-dose series starting at age 11 or 12 years and through age 26 years if not vaccinated previously. Males can receive routine vaccination with 3-dose series at age 11 or 12 years and through age 21 years if not vaccinated previously. Vaccination is recommended through age 26 years for men who have sex with men and men who are immunocompromised (including those with HIV infection). If females or males reach age 27 years before the vaccination series is complete, the second and/or third doses of vaccine can be administered after age 26 years to complete the vaccination series.")
      @modal.clickNoButton()
    end

  end

end