require_relative '../../../globalized'
include Globalized

describe "Story# JRNL-2454, JRNL-2495: [CPS_Custom_Reminder_JRNL_2454_2495_spec.rb] | JRNL-1303: [Update Preventive Services header]", :broken => true, :regression => true do

  include DriverUtility
  include MongoUtility
  include CommonTests

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")
    removeCollection("preventiveservices", "healthtrackerdb")
    removeCollection("preferences", "healthtrackerdb")

    initializeAllObjects
    CUSTOM_REMINDER = "button[ng-click='getDetails()']"

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    sleep 5

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")
  end

  after(:all) do
    quitDriver()
  end

  context 'AC(JRNL-3225), TC(JRNL-3262): Add custom reminder icon' do

    it "When the user views the PS reminder list in the Detail screen, the system displays a Add button  in the header bar (right justified)" do
      @reminders.clickSubGroup("preventive-services")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      #verify that, Custom Reminder icon is visible
      expect(isElementVisible(:css, CUSTOM_REMINDER)).to eq(true)
      expect(@screening.isAddButtonRightJustified).to eq(true)

      @screening.clickAddEntry()
      !45.times{ break if (@reminders.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_NEW); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_NEW)
    end

  end

  context 'AC(JRNL-3226|JRNL-3227|JRNL-3228), TC(JRNL-3262): Add Other Preventive Service Detail; Save Other Preventive Service Reminder; Cancel Other Preventive Service Reminder;' do

    it "Add Other Preventive Service Detail; Save Other Preventive Service Reminder; Cancel Other Preventive Service Reminder;" do
      #Verifying the Header, Text and Button information for the "Next Due Date Modal"
      @screening.clickInformationButton()
      !30.times{ break if(@reminders.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq(@modal.getConfirmationHeading())
      expect(@modal.getConfirmationHeading()).to eq("About Next Due Date")
      expect(@modal.getConfirmationMessage()).to eq("Please enter the date your provider has given you for your next test.\nIf you are not sure of your next date, please discuss with your provider.")

      @modal.clickNoButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      @screening.selectNotificationStatus("Off")

      #Clicking Save button to verify required field validations
      @screening.clickSaveButton()
      checkingInlineError("Service Name field is required.")

      time = Time.new()
      today = time.strftime("%m/%d/%Y")
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      setDate(tomorrow, "input[name='lastCompleted']")

      #Verify that the Service Name only allows maximum of 50 characters
      textareaMaxLengthTest("serviceName", 50, false)
      @screening.setServiceName("Ebola Vaccine")
      setDate(today, "input[name='nextDueDate']")

      #verify that Notes will be 250 characters with character countdown
      expect(@screening.verifyTotalCharacterInNarrative()).to eq(true)
      @screening.setNote("Insurance Company is not responsible for Custom Screening.")
      @screening.selectNotificationStatus("Off")

      @screening.clickSaveButton()
      if time.year.to_s != tomorrow[-4..-1]
        checkingInlineError("Last Completed must be formatted MM/DD/YYYY.")
      else
        #Verify that, last completed date cannot be future date
        checkingInlineError("Last Completed must be between 01/01/1900 and " + today + ".")
      end

      setDate(today, "input[name='lastCompleted']")
      @screening.selectNotificationStatus("Off")

      @screening.clickSaveButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

  end

  context 'AC(JRNL-2880), TC(JRNL-3262): Prevent duplicate custom tracker names' do

    it "Prevent duplicate custom tracker names" do
      # JRNL-2495: Prevent duplicate custom tracker names
      @screening.clickAddEntry()
      !45.times{ break if (@reminders.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_NEW); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_NEW)

      @screening.setServiceName("Ebola Vaccine")
      @screening.selectNotificationStatus("Off")

      @screening.clickSaveButton()
      checkingInlineError("A Preventive Service Reminder with the same name currently exists in your reminder list, or a future reminder with the same name may be added to your list. Please change the name of this reminder before saving.")

      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      @screening.clickAddEntry()
      !45.times{ break if (@reminders.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_NEW); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_NEW)

      @screening.setServiceName("Flu Vaccination")
      @screening.selectNotificationStatus("Off")

      @screening.clickSaveButton()
      checkingInlineError("A Preventive Service Reminder with the same name currently exists in your reminder list, or a future reminder with the same name may be added to your list. Please change the name of this reminder before saving.")

      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

  end

  context 'AC(JRNL-2934), TC(JRNL-3262): Edit Custom Reminder' do

    it "Edit Custom Reminder" do
      #Edit custom reminder
      indexID = @screening.findIndexWithGivenPSName("Ebola Vaccine")

      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_EDIT); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)

      #Service Name should be disabled when user opens an existing custom reminder
      @reminders.isThisFieldReadOnly("input[name='serviceName']")
      @screening.selectNotificationStatus("On")

      setDate(getDateNthDaysFromNow(7, "%m/%d/%Y"), "input[name='nextDueDate']")
      @screening.clickNotificationDeliveryCheckBox("On the date")

      @screening.clickSaveButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")
    end

  end

  context 'AC(JRNL-3230|), TC(JRNL-3262): Delete Other Preventive Service Reminder' do

    it "Delete Other Preventive Service Reminder" do
      #Delete custom reminder
      indexID = @screening.findIndexWithGivenPSName("Ebola Vaccine")

      @reminders.clickNthReminder(indexID)
      !45.times{ break if (@reminders.getPrimaryHeader() == Screening::CPS_ENTRY_HEADER_EDIT); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(Screening::CPS_ENTRY_HEADER_EDIT)

      @screening.selectNotificationStatus("Off")

      @screening.clickDeleteButton()
      !45.times{ break if (@modal.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@modal.getFocusedElementText()).to eq(@modal.getConfirmationHeading())

      @modal.clickNoButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      @screening.clickDeleteButton()
      !45.times{ break if (@modal.getFocusedElementText() == @modal.getConfirmationHeading()); sleep 1 }
      expect(@modal.getFocusedElementText()).to eq(@modal.getConfirmationHeading())

      @modal.clickYesButton()
      !30.times{ break if(@modal.isConfirmationPopUpNotPresent() == true); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

      expect(@screening.findIndexWithGivenPSName("Blood Test Screening (Edited Name - 50 characters)")).to eq(-1)
    end

  end

  ######################
  ### Local Function ###
  ######################
  def checkingInlineError(errMsg)
    #Verify that the error message section header is displayed
    !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

end