require_relative '../../../globalized'
include Globalized

describe "Story#JRNL-2499: [Reminders_Other_Table_View_JRNL_2499_spec.rb]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("reminders", "remindersdb", "otherReminders")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
  end

  after(:all) do
    quitDriver()
  end

  context 'AC(JRNL-1860), TC(JRNL-1806): Other Reminder List View' do

    it "2). Verify that If no reminders exist, the system displays the default filter and displays a text No records found.", :broken => true do
      @nav_menu.clickReminders()
      !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
      #Verify the group navigation header
      expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
      #Verify the Table View header
      expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
      @reminders.clickSubGroup("other")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Other Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Other Reminders")
      @reminders.selectStatus("All")
      !30.times{ break if (@reminders.isStatusSelected("All") == true); sleep 1 }
      @reminders.clickFilter
      !30.times{ break if (getFocusedElementText().include?("No results")); sleep 1 }
      expect(getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
      @reminders.selectStatus("On")
      !30.times{ break if (@reminders.isStatusSelected("On") == true); sleep 1 }
      @reminders.clickFilter
      !30.times{ break if (getFocusedElementText().include?("No results")); sleep 1 }
      expect(getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
      @reminders.selectStatus("Off")
      !30.times{ break if (@reminders.isStatusSelected("Off") == true); sleep 1 }
      @reminders.clickFilter
      !30.times{ break if (getFocusedElementText().include?("No results")); sleep 1 }
      expect(getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
    end

    it "Story JRNL-1696|AC JRNL-1583: Reset Button", :broken => true do
      expect(@date_filter.isResetButtonPresent()).to eq(true)
      expect(@date_filter.getResetButtonLabel()).to eq("Reset")

      @date_filter.clickResetBtn()
      !30.times { break if (getFocusedElementText().include?("No results")); sleep 1 }
      expect(getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")

      # DEFAULTS
      expect(@reminders.isStatusSelected("All")).to eq(true)
    end

    it "Other Reminder List View ", :broken => true do
      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.patient01", "patient01, zztest")
      @nav_menu.clickReminders()
      !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
      #Verify the group navigation header
      expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
      #Verify the Table View header
      expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
      @reminders.clickSubGroup("other")
      !45.times{ break if (@reminders.getPrimaryHeader() == "Other Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Other Reminders")

      #Verify that the Filter button is available
      expect(@reminders.isTheFilterButtonVisible()).to eq(true)

      #Unread is a defaulted option
      expect(@reminders.isStatusSelected("On")).to eq(false)
      expect(@reminders.isStatusSelected("Off")).to eq(false)
      expect(@reminders.isStatusSelected("All")).to eq(true)

      remindersCountAll = @reminders.getRemindersCount()
      @reminders.selectStatus("All")
      !30.times{ break if (@reminders.isStatusSelected("All") == true); sleep 1 }
      @reminders.clickFilter

      !30.times{ break if (@reminders.getRemindersCount() == remindersCountAll); sleep 1 }

      #Filter by "On"
      @reminders.selectStatus("On")
      !30.times{ break if (@reminders.isStatusSelected("On") == true); sleep 1 }
      @reminders.clickFilter

      !30.times{ break if (@reminders.getRemindersCount() < remindersCountAll); sleep 1 }
      remindersCountOn = @reminders.getRemindersCount()

      for i in 1..remindersCountOn
        expect(@reminders.getNthReminderStatus(i)).to eq("On")
      end

      #Filter by "Off"
      @reminders.selectStatus("Off")
      !30.times{ break if (@reminders.isStatusSelected("Off") == true); sleep 1 }
      @reminders.clickFilter
      !30.times{ break if (@reminders.getRemindersCount() < remindersCountAll); sleep 1 }
      remindersCountOff = @reminders.getRemindersCount()

      for i in 1..remindersCountOff
        expect(@reminders.getNthReminderStatus(i)).to eq("Off")
      end

      #Reset it to "All"
      @reminders.selectStatus("All")
      !30.times{ break if (@reminders.isStatusSelected("All") == true); sleep 1 }
      @reminders.clickFilter
      !30.times{ break if (@reminders.getRemindersCount() == remindersCountAll); sleep 1 }

      #Click the hide filter button
      @reminders.showOrHideFilter()
      sleep 1
      #Verify the status filter options are hidden
      expect(@reminders.isTheFilterButtonVisible()).to eq(false)

      #Flip the hide filter button again
      @reminders.showOrHideFilter()
      sleep 1
      expect(@reminders.isTheFilterButtonVisible()).to eq(true)

      #Verify the sorting order is correct
      expect(@reminders.isRemindersListSortedByNameFrequencyStatus()).to eq(true)
    end
  end

  def getNoResultsFoundMessage()
    return getTextForElement(:css, '.no-results-message')
  end

end