require_relative '../../../globalized'
include Globalized

describe "Story# JRNL-2498: [Reminders_AddEditDelete_Other_Reminder_JRNL_2498_spec.rb]", :regression => true do

  table_view_header = "Other Reminders"
  add_entry_header = "Add Other Reminder"
  edit_entry_header = "Edit Other Reminder"

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient66", "patient66, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient66, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")

    @initialCount = @reminders.getRemindersCount()
  end

  after(:all) do
    quitDriver()
  end

  context 'AC(JRNL-1867) |TC(JRNL-1815): Add Other Reminder' do

      it "Add Other Reminder" do
        !45.times{ break if (@reminders.getDefaultMsg() == "Select an item from the Reminders list to view details or add a new Reminder entry."); sleep 1 }
        expect(@reminders.getDefaultMsg()).to eq("Select an item from the Reminders list to view details or add a new Reminder entry.")

        @reminders.clickSubGroup("other")
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)

        #Click the Add Entry button
        @reminders.clickAddEntryButton()
        !45.times{ break if (@reminders.getPrimaryHeader() == add_entry_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(add_entry_header)
      end

      it "Reminder Name (required, text, 50 characters) ", :broken => true do
        @reminders.clickSaveButton()
        !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")

        #Validate that the error messages are displayed
        expect(@error.isErrorMessageDisplayed("entryForm", "Reminder Name field is required.")).to eq(true)

        #Verify that the Reminder Name only allows maximum of 50 characters
        textareaMaxLengthTest("title", 50, false)
      end

      it "Note (max 250 characters) " do
        textareaMaxLengthTest("Note", 250, true)
      end

  end

  context 'AC(JRNL-1866)|TC(JRNL-1815): Notification Setup' do

      it "Verify when Notification is turned on, Start Date, Notify Me and Notification Time become required. ", :broken => true do
        @reminders.selectNotificationStatus("On")
        expect(@reminders.isNotificationStatusSelected("On")).to eq(true)

        @reminders.clickSaveButton()
        !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
        expect(@error.isErrorMessageDisplayed("entryForm", "Start Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Notify Me field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Notification Time field is required.")).to eq(true)
      end

      it "Verify that the Cancel functionality works properly" do
        @reminders.clickCancelButton()
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)

        #Verify that reminders count should stay the same since the Add Reminder was canceled
        expect(@reminders.getRemindersCount()).to eq(@initialCount)
      end

      it "Date can be future, past dates are not allowed.", :broken => true do
        @reminders.clickAddEntryButton()
        !45.times{ break if (@reminders.getPrimaryHeader() == add_entry_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(add_entry_header)

        #Verify the Start Date can't be past
        twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")

        @reminders.selectNotificationStatus("On")
        expect(@reminders.isNotificationStatusSelected("On")).to eq(true)

        setDate(twoDaysAgo, "input[name='notificationStartDate']")
        @reminders.clickSaveButton()
        !15.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        if Time.new.year.to_s != twoDaysAgo[-4..-1]
          expect(@error.isErrorMessageDisplayed("entryForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(true)
        else
          expect(@error.isErrorMessageDisplayed("entryForm", "Start Date must be between " + getDateNthDaysAgo(0, "%m/%d/%Y") +  " and 12/31/2099.")).to eq(true)
        end
      end

      it "When a date is selected, the Day of the week is displayed in read only text. ", :broken => true do
        tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
        setDate(tomorrow, "input[name='notificationStartDate']")
        @reminders.verifyTheDayofWeekIsDisplayedCorrectly(tomorrow)
      end

      it "Verify Notify Me field has Select,Daily,Weekly,Monthly values; Verify it defaults to Select"  do
        expect(areAllTheseValuesAvailableInDropDown("select[name='notificationFrequency']", "Select,Daily,Weekly,Monthly")).to eq(true)
        expect(@screening.isThisValueDefaultToTheDropdown("Select", "notificationFrequency")).to eq(true)
      end

      it "Verify Notification Time is configured to show 5 minute increments; Set a Time and verify it's displayed as it is and not modified", :broken => true do
        @time_picker.clickTimePickerButton()
        !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
        expect(@driver.find_element(:id, "set-button").displayed?).to eq(true)
        expect(@time_picker.areMinutesIn5MinIntervals()).to eq(true)

        #Set a Time and verify it's displayed as it is and not modified
        @time_picker.setTimeFromGUI(11, "05", "AM")
        !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }
        expect(is_element_present(:id, "set-button")).to eq(false)
        expect(@time_picker.isTimeDisplayedCorrectly("11:05 AM")).to eq(true)
      end

      it "Verify that any entered time that does not end with 0 or 5 will not be entered. ", :broken => true do
        setTime("11:23 AM", "input[name='time_0']")
        expect(@time_picker.isTimeDisplayedCorrectly("11:2")).to eq(true)
      end

      it "1)g.i. If Notification frequency = daily, users may add up to 5 time values per reminder.", :broken => true do
        @reminders.selectFrequency("Daily")
        !45.times{ break if (is_element_present(:css, "button[ng-click='addTimeEntry()']")); sleep 1 }
        expect(is_element_present(:css, "button[ng-click='addTimeEntry()']")).to eq(true)
        expect(getTextForElement(:css, "button[ng-click='addTimeEntry()']")).to eq("Add Time")

        #Add the first time entry
        timeStr = ["11:05 AM", "02:05 PM", "04:05 PM", "06:05 PM", "08:05 PM"]
        timeEntryCount = @reminders.getTotalTimeEntries()
        setTime(timeStr[0], "input[name='time_0']")

        for i in 1..4
          #Click Add Time button to add a time
          @reminders.clickAddTimeEntry()
          setTime(timeStr[i], "input[name='time_#{i.to_s}']")
          !45.times{ break if (@reminders.getTotalTimeEntries() > timeEntryCount); sleep 1 }
          expect(@reminders.getTotalTimeEntries()).to eq(i+1)
        end
      end

      it "Verify after all 5 entries are displayed, the Add Time button is gone, and Delete button shows up; Also verify that the Delete button is gone when there is only one time entry left" do
        expect(is_element_present(:css, "button[ng-click='addTimeEntry()']")).to eq(false)

        timeEntryCount = @reminders.getTotalTimeEntries()
        #puts "timeEntryCount=" + timeEntryCount.to_s
        for i in 5..1
          if i > 1 then
            #Click the Delete button to remove a time entry
            @reminders.clickDeleteTimeEntryButton(i)
            !45.times{ break if (@reminders.getTotalTimeEntries() < timeEntryCount); sleep 1 }
            expect(@reminders.getTotalTimeEntries()).to eq(i-1)
          else
            #Verify that the Delete button is gone when there is only one time entry left
            expect(is_element_present(:css, 'button[name="deleteTime_0"')).to eq(false)
          end
        end
      end

  end

  context 'AC(JRNL-1866)|TC(JRNL-1815): In both add and edit mode, when the user views the other reminder, the Notification fields are displayed' do

      it "Verify In-App is selected as default when Status is On", :broken => true do
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)
      end

      it "if no email exists display 'Email address has not been saved'; Also display the instructional text " do
        #Email is disabled since this user does not have email provided
        expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(true)
        #Verify that the text is displayed when email is not available and this box is disabled
        expect(@screening.getEmailFromNotification()).to eq("Email address has not been saved")
        #Verify the instructional text is displayed
        expect(@screening.getInstructionalTextWhenEmailIsNotAvailable()).to eq("You may update your Preferred Email address in the Notification feature by selecting the notification settings icon")
      end

      it "Verify that At least one checkbox must be valued on Save, otherwise, show error message: A Notification Delivery method is needed to save this record. Please select a method and save again.", :broken => true do
        #unCheck the In-App option
        @screening.clickNotificationDeliveryCheckBox("In-App")
        expect(@screening.isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(false)

        @reminders.clickSaveButton()
        !15.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        expect(@error.isErrorMessageDisplayed("entryForm", "A Notification Delivery method is needed to save this record. Please select a method and save again.")).to eq(true)

        @reminders.clickCancelButton()
        !30.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
      end

  end

  context 'AC(JRNL-1862), TC(JRNL-1815):Happy Path testing - Save Functionality' do

      it "Verify after adding and saving the reminders, the data show up in the Table View correctly", :broken => true do
        tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

        #Add the first reminder
        startTimeArry = ["12:00 PM"]
        listViewCount = @reminders.getRemindersCount()
        @reminders.addReminder("Yoga Class", tomorrow, "Weekly", startTimeArry, "On")
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
        #Verify that the reminder is displayed on the list view
        !45.times{ break if (@reminders.getRemindersCount() > listViewCount); sleep 1 }
        expect(@reminders.getRemindersCount() > listViewCount).to eq(true)

        indexID = @reminders.findIndexWithGivenName("Yoga Class")
        expect(@reminders.getNthReminderName(indexID)).to eq("Yoga Class")
        expect(@reminders.getNthReminderFrequency(indexID)).to eq("Weekly")
        expect(@reminders.getNthReminderStatus(indexID)).to eq("On")

        #Add the second reminder
        startTimeArry = ["02:00 PM"]
        listViewCount = @reminders.getRemindersCount()
        @reminders.addReminder("Soccer Practice", tomorrow, "Monthly", startTimeArry, "On")
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
        #Verify that the reminder is displayed on the list view
        !45.times{ break if (@reminders.getRemindersCount() > listViewCount); sleep 1 }
        expect(@reminders.getRemindersCount() > listViewCount).to eq(true)

        indexID = @reminders.findIndexWithGivenName("Soccer Practice")
        expect(@reminders.getNthReminderName(indexID)).to eq("Soccer Practice")
        expect(@reminders.getNthReminderFrequency(indexID)).to eq("Monthly")
        expect(@reminders.getNthReminderStatus(indexID)).to eq("On")

        #Add the third reminder
        startTimeArry = ["11:05 AM", "02:05 PM", "04:05 PM", "06:05 PM", "08:05 PM"]
        listViewCount = @reminders.getRemindersCount()
        @reminders.addReminder("Take vitamins", tomorrow, "Daily", startTimeArry, "Off")
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
        #Verify that the reminder is displayed on the list view
        !45.times{ break if (@reminders.getRemindersCount() > listViewCount); sleep 1 }
        expect(@reminders.getRemindersCount() > listViewCount).to eq(true)

        indexID = @reminders.findIndexWithGivenName("Take vitamins")
        expect(@reminders.getNthReminderName(indexID)).to eq("Take vitamins")
        expect(@reminders.getNthReminderFrequency(indexID)).to eq("Daily")
        expect(@reminders.getNthReminderStatus(indexID)).to eq("Off")

        #Open the reminder in the detail view to verify that time entries are displayed correctly
        @reminders.clickNthReminder(indexID)
        !30.times{ break if(@reminders.getPrimaryHeader() == edit_entry_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(edit_entry_header)

        for i in 0..4
          expect(@time_picker.getTimePerEntry(i)).to eq(startTimeArry[i])
        end

        @reminders.clickCancelButton()
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
      end

  end

  context 'AC(JRNL-1825)|TC(JRNL-1815): Edit Other Reminder' do

    it "Edit Other Reminder", :broken => true do
      @reminders.clickNthReminder(@reminders.findIndexWithGivenName("Yoga Class"))
      !45.times{ break if (@reminders.getPrimaryHeader() == edit_entry_header); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(edit_entry_header)

      @screening.setReminderTitle("Yoga class is fun")

      @reminders.clickSaveButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
    end

  end

  context 'AC(JRNL-1862)|TC(JRNL-1815): Delete Other Reminder' do

    it "Delete Other Reminder", :broken => true do
      @reminders.clickNthReminder(@reminders.findIndexWithGivenName("Soccer Practice"))
      !45.times{ break if (@reminders.getPrimaryHeader() == edit_entry_header); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(edit_entry_header)

      @reminders.clickDeleteButton()
      !45.times{ break if (@reminders.getModalHeader() == "Confirmation"); sleep 1 }
      expect(@reminders.getModalHeader()).to eq("Confirmation")
      expect(@reminders.getModalBody()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")

      @modal.clickNoButton()
      !15.times{ break if (@reminders.getFocusedElementText() == "Delete"); sleep 1 }
      expect(@reminders.getFocusedElementText()).to eq("Delete")

      @reminders.clickDeleteButton()
      !45.times{ break if (@reminders.getModalHeader() == "Confirmation"); sleep 1 }
      expect(@reminders.getModalHeader()).to eq("Confirmation")

      @modal.clickYesButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(table_view_header)

      expect(@screening.findIndexWithGivenPSName("Soccer Practice)")).to eq(-1)
    end

  end

end