require_relative '../../../globalized'
include Globalized

describe "Story#JRNL-2514: [Reminders_Medications_Table_View_JRNL_2514_spec.rb]", :regression=>true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("reminders", "remindersdb", "reminders")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3143|TC#JRNL-3178: Reminders list display; List filtering; Filter Action; Verify List sorting order", :broken => true do

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }

    #Verify the group navigation header
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    #Verify the Table View header
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")

    @reminders.clickSubGroup("medications")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Medication Reminders"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Medication Reminders")

    #Verify that the Filter button is available
    expect(@reminders.isTheFilterButtonVisible()).to eq(true)

    #Unread is a defaulted option
    expect(@reminders.isStatusSelected("On")).to eq(false)
    expect(@reminders.isStatusSelected("Off")).to eq(false)
    expect(@reminders.isStatusSelected("All")).to eq(true)

    remindersCountAll = @reminders.getRemindersCount()
    @reminders.selectStatus("All")
    !45.times{ break if (@reminders.isStatusSelected("All") == true); sleep 1 }
    @reminders.clickFilter

    !45.times{ break if (@reminders.getRemindersCount() == remindersCountAll); sleep 1 }

    #Filter by "On"
    @reminders.selectStatus("On")
    !45.times{ break if (@reminders.isStatusSelected("On") == true); sleep 1 }
    @reminders.clickFilter

    !45.times{ break if (@reminders.getRemindersCount() < remindersCountAll); sleep 1 }
    remindersCountOn = @reminders.getRemindersCount()
    #puts "remindersCountOn=" + remindersCountOn.to_s

    for i in 1..remindersCountOn
      expect(@reminders.getNthReminderStatus(i)).to eq("On")
    end

    #Filter by "Off"
    @reminders.selectStatus("Off")
    !45.times{ break if (@reminders.isStatusSelected("Off") == true); sleep 1 }
    @reminders.clickFilter
    sleep 2
    !45.times{ break if (@reminders.getRemindersCount() < remindersCountAll); sleep 1 }
    remindersCountOff = @reminders.getRemindersCount()
    #puts "remindersCountOff=" + remindersCountOff.to_s

    for i in 1..remindersCountOff
      expect(@reminders.getNthReminderStatus(i)).to eq("Off")
    end

    #Reset it to "All"
    @reminders.selectStatus("All")
    !45.times{ break if (@reminders.isStatusSelected("All") == true); sleep 1 }
    @reminders.clickFilter
    !45.times{ break if (@reminders.getRemindersCount() == remindersCountAll); sleep 1 }

    #Click the hide filter button
    @reminders.showOrHideFilter()
    sleep 1
    #Verify the status filter options are hidden
    expect(@reminders.isTheFilterButtonVisible()).to eq(false)

    #Flip the hide filter button again
    @reminders.showOrHideFilter()
    sleep 1
    expect(@reminders.isTheFilterButtonVisible()).to eq(true)

    #Verify the sorting order is correct
    expect(@reminders.isRemindersListSortedByNameFrequencyStatus()).to eq(true)

    @reminders.selectStatus("Off")
    !10.times{ break if (@reminders.isStatusSelected("Off") == true); sleep 1 }
    @reminders.clickFilter()
    !10.times { break if (getFocusedElementText().include?("Medication Name")); sleep 1 }
  end

  it "Story JRNL-1696|AC JRNL-1583: Reset Button", :broken => true do
    expect(@date_filter.isResetButtonPresent()).to eq(true)

    expect(@date_filter.getResetButtonLabel()).to eq("Reset")

    @date_filter.clickResetBtn()
    !10.times { break if (getFocusedElementText().include?("Medication Name")); sleep 1 }
    expect(getFocusedElementText()).to eq(getTextForRow(1) + " ")
    expect(getCount()).to eq(6)
    expect(@reminders.isRemindersListSortedByNameFrequencyStatus()).to eq(true)

    # DEFAULT
    expect(@reminders.isStatusSelected("All")).to eq(true)
  end

  it "AC#JRNL-3144,3145|TC#JRNL-3178: User can go to Add Reminder from this Table view; User can go to Edit or Delete reminder from this Table view", :broken => true do
    #click the + button to open the Add Reminder screen
    @reminders.clickAddEntryButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Add Medication Reminder"); sleep 1 }
    #Click Cancel to return to Table View
    @reminders.clickCancelButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Medication Reminders"); sleep 1 }

    #Click to open an existing medication reminder
    @reminders.clickNthReminder(1)
    !45.times{ break if (@reminders.getPrimaryHeader() == "Edit Medication Reminder"); sleep 1 }
    sleep 1
    expect(@reminders.isDeleteButtonVisible()).to eq(true)
    expect(@reminders.isSaveButtonVisible()).to eq(true)
    expect(@reminders.isCancelButtonVisible()).to eq(true)

  end



end