require_relative '../../../globalized'
include Globalized

describe "Story#NR-59,60,7,82: [Reminders_Edit_Delete_Medication_Reminder_NR_59_60_spec.rb]", :regression=>true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("reminders", "remindersdb", "remindersEditAndDelete")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient66", "patient66, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient66, zztest")

  end

  after(:all) do
    quitDriver()
  end

  it "AC #NR-194,195,197,JRNL-3139,3141,442|TC#NR-302,JRNL-2009,3178|: Validate read-only, required fields; Test Cancel Edit Reminder", :broken => true do

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }

    #Verify the group navigation header
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    #Verify the Table View header
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")

    #Verify that when there are records in the list, the default message displayed as follow

    !45.times{ break if (@reminders.getDefaultMsg() == "Select an item from the Reminders list to view details or add a new Reminder entry."); sleep 1 }
    expect(@reminders.getDefaultMsg()).to eq("Select an item from the Reminders list to view details or add a new Reminder entry.")

    @reminders.clickSubGroup("medications")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Medication Reminders"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Medication Reminders")

    #Click a reminder to Edit
    indexID = @reminders.findIndexWithGivenName("TAKE TYLENOL 81MG")
    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == "Edit Medication Reminder"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Edit Medication Reminder")

    #Verify that the name, start date are read-only; frequency, notification time and are available
    #Name is readonly
    expect(@reminders.isThisFieldReadOnly("input[name='title']")).to eq(true)

    #Start Date is read-only
    expect(@reminders.isThisFieldReadOnly("input[name='notificationStartDate']")).to eq(true)

    #Required field text is present
    expect(getTextContentForElement(:css, "form[name='entryForm'] span")).to eq("* required field")

    #Cancel out of an Edit Reminder
    @reminders.clickCancelButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Medication Reminders"); sleep 1 }

  end

  it "AC #NR-194,JRNL-3143|TC#NR-302,JRNL-3178: Update reminder then Save; Validate pop up confirmation when leave without save", :broken => true do
    #<Scenario 1> - update the frequency

    #Open the reminder with the weekly frequency
    indexID = @reminders.findIndexWithGivenName("TAKE TYLENOL 81MG")
    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == "Edit Medication Reminder"); sleep 1 }
    
    #Change the frequency to Monthly
    @reminders.selectFrequency("Monthly")
    
    #Without saving, attempt to leave the Edit Medication Reminder screen by clicking the Appointments group
    @reminders.clickSubGroup("appointments")
    
    #Verify the modal dialog pops up
    expect(@modal.isConfirmationPopUpPresent()).to be true
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
    
    #Verify clicking Continue button
    @modal.clickReturnButton()
    
    #Click Save
    @reminders.clickSaveButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Medication Reminders"); sleep 1 }
    expect(@reminders.getNthReminderFrequency(indexID)).to eq("Monthly")
    
    #Attempt to change it back to Weekly again to make sure it allows
    indexID = @reminders.findIndexWithGivenName("TAKE TYLENOL 81MG")
    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == "Edit Medication Reminder"); sleep 1 }
    @reminders.selectFrequency("Weekly")
    @reminders.clickSaveButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Medication Reminders"); sleep 1 }

    #<Scenario 2> - update the Notification Setting
    indexID = @reminders.findIndexWithGivenName("SHINGLE VACCINE")
    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == "Edit Medication Reminder"); sleep 1 }
    sleep 1

    #Change the Notification Status to be Off
    @reminders.selectNotificationStatus("Off")
    @reminders.clickSaveButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Medication Reminders"); sleep 1 }
    expect(@reminders.getNthReminderStatus(indexID)).to eq("Off")

    #<Scenario 3> - update the Notification Time Entry
    indexID = @reminders.findIndexWithGivenName("take CoQ10 150mg")
    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == "Edit Medication Reminder"); sleep 1 }

    #Set the status to be On
    @reminders.selectNotificationStatus("On")

    #UPdate the last time entry
    lastEntryIndex = @reminders.getTotalTimeEntries() - 1
    setTime("10:00 PM", "input[name='time_" + lastEntryIndex.to_s + "']")
    sleep 1
    @reminders.clickSaveButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Medication Reminders"); sleep 1 }
    @reminders.clickNthReminder(indexID)
    
    #Verify the last time entry is updated
    expect(@time_picker.getTimePerEntry(lastEntryIndex)).to eq("10:00 PM")
    @reminders.clickCancelButton()

  end

  it "AC#NR-198,199,200,JRNL-3143|TC#NR-302,JRNL-3178: Delete button present; Delete triggers the modal dialog; Reminder is removed from the list but not from the database", :broken => true do

    indexID = @reminders.findIndexWithGivenName("SHINGLE VACCINE")
    @reminders.clickNthReminder(indexID)
    !45.times{ break if (@reminders.getPrimaryHeader() == "Edit Medication Reminder"); sleep 1 }
    sleep 1
    expect(@driver.find_element(:css, "button[ng-click='delete()']").displayed?).to eq(true)
    
    #Click the Delete
    @reminders.clickDeleteButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()
    !45.times{ break if (@reminders.getPrimaryHeader() == "Medication Reminders"); sleep 1 }
    
    #Verify that the reminder is no longer present in the list view
    expect(@reminders.findIndexWithGivenName("SHINGLE VACCINE")).to eq(-1)
    
    #Verify that the reminder retain in the database
    expect(verifyNotificationDeleted("reminders", "remindersdb", "53ecc0c70364fc5335eaabe8", "deletedFlag")).to eq(true)

  end

end