require_relative '../../../globalized'
include Globalized

describe "Story# NR-58,JRNL-2494: [Reminders_Create_Medications_Reminder_JRNL_2494_spec.rb]", :regression => true do

  table_view_header = "Medication Reminders"
  add_entry_header = "Add Medication Reminder"

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyReminders']").click
    waitForPageToFinishLoading
    !5.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")

    @initialCount = @reminders.getRemindersCount()
  end

  # after(:all) do
  #   quitDriver()
  # end

  context '#AC#JRNL-1809 |TC #JRNL-1811:  Medication Reminder Add view meta data validations' do

      it "Verify that when there are records in the list, the default message displayed as follow" do
        !5.times{ break if (@reminders.getDefaultMsg() == "Select an item from the Reminders list to view details or add a new Reminder entry."); sleep 1 }
        expect(@reminders.getDefaultMsg()).to eq("Select an item from the Reminders list to view details or add a new Reminder entry.")

        @reminders.clickSubGroup("medications")
        !5.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
      end

      it "Verify that the header text for Add screen is Add Medication Reminder" do
        #Click the Add Entry button
        @reminders.clickAddEntryButton()
        !5.times{ break if (@reminders.getPrimaryHeader() == add_entry_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(add_entry_header)
      end

      it "1)a. Medication Name (required) (free text, 100 characters) ", :broken => true do
        @reminders.clickSaveButton()
        !5.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq("")
        #Validate that the error messages are displayed
        expect(@error.isErrorMessageDisplayed("entryForm", "Medication Name field is required.")).to eq(true)

        #Verify that the Medication Name only allows maximum of 100 characters
        textareaMaxLengthTest("title", 100, false)
      end

      it "1)b. Note (max 250 characters) " do
        textareaMaxLengthTest("Note", 250, true)
      end

      it "1)d,e,f,g  Verify when Notification is turned on, Start Date, Notify Me and Notification Time become required. ", :broken => true do
        @reminders.selectNotificationStatus("On")
        expect(@reminders.isNotificationStatusSelected("On")).to eq(true)

        @reminders.clickSaveButton()
        !5.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
        expect(@error.isErrorMessageDisplayed("entryForm", "Start Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Notify Me field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Notification Time field is required.")).to eq(true)
      end

      it "Verify that the Cancel functionality works properly" do
        @reminders.clickCancelButton()
        !5.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)

        #Verify that reminders count should stay the same since the Add Reminder was canceled
        expect(@reminders.getRemindersCount()).to eq(@initialCount)
      end

      it "1)e.i  Date may be future, past dates are not allowed.", :broken => true do
        @reminders.clickAddEntryButton()
        !5.times{ break if (@reminders.getPrimaryHeader() == add_entry_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(add_entry_header)

        #Verify the Start Date can't be past
        twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")

        @reminders.selectNotificationStatus("On")
        expect(@reminders.isNotificationStatusSelected("On")).to eq(true)

        setDate(twoDaysAgo, "input[name='notificationStartDate']")

        @reminders.clickSaveButton()
        !5.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        if Time.new.year.to_s != twoDaysAgo[-4..-1]
          expect(@error.isErrorMessageDisplayed("entryForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(true)
        else
          expect(@error.isErrorMessageDisplayed("entryForm", "Start Date must be between " + getDateNthDaysAgo(0, "%m/%d/%Y") +  " and 12/31/2099.")).to eq(true)
        end
      end

      it "1)e.ii  When a date is selected, the Day of the week is displayed in read only text. ", :broken => true do
        tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
        setDate(tomorrow, "input[name='notificationStartDate']")
        @reminders.verifyTheDayofWeekIsDisplayedCorrectly(tomorrow)
      end

      it "1)f. Verify Notify Me field has Select,Daily,Weekly,Monthly values; Verify it defaults to Select"  do
        expect(areAllTheseValuesAvailableInDropDown("select[name='notificationFrequency']", "Select,Daily,Weekly,Monthly")).to eq(true)
        expect(@screening.isThisValueDefaultToTheDropdown("Select", "notificationFrequency")).to eq(true)
      end

      it "1)g.  Verify Notification Time is configured to show 5 minute increments; Set a Time and verify it's displayed as it is and not modified", :broken => true do
        @time_picker.clickTimePickerButton()
        waitForPageToFinishLoading
        expect(@time_picker.areMinutesIn5MinIntervals()).to eq(true)

        #Set a Time and verify it's displayed as it is and not modified
        waitForPageToFinishLoading
        @driver.find_element(:css, "button[id='set-btn']").click
        waitForPageToFinishLoading
        @driver.find_element(:css, "input[id='time_0']").clear
        waitForPageToFinishLoading
        @driver.find_element(:css, "input[id='time_0']").send_keys "11:05 AM"
        waitForPageToFinishLoading
        !5.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }
        expect(is_element_present(:id, "set-button")).to eq(false)
        expect(@time_picker.isTimeDisplayedCorrectly("11:05 AM")).to eq(true)
      end

      it "1)g. Verify that any entered time that does not end with 0 or 5 will not be entered. ", :broken => true do
        setTime("11:23 AM", "input[name='time_0']")
        expect(@time_picker.isTimeDisplayedCorrectly("11:2")).to eq(true)
      end

      it "1)g.i. If Notification frequency = daily, users may add up to 5 time values per reminder.", :broken => true do
        @reminders.selectFrequency("Daily")

        !5.times{ break if (is_element_present(:css, "button[ng-click='addTimeEntry()']")); sleep 1 }
        expect(is_element_present(:css, "button[ng-click='addTimeEntry()']")).to eq(true)
        expect(getTextForElement(:css, "button[ng-click='addTimeEntry()']")).to eq("Add Time")

        #Add the first time entry
        timeStr = ["11:05 AM", "02:05 PM", "04:05 PM", "06:05 PM", "08:05 PM"]
        timeEntryCount = @reminders.getTotalTimeEntries()

        setTime(timeStr[0], "input[name='time_0']")

        # for i in 1..4
        #   #Click Add Time button to add a time
        #   @reminders.clickAddTimeEntry()
        #   setTime(timeStr[i], "input[name='time_#{i.to_s}']")
        #   !5.times{ break if (@reminders.getTotalTimeEntries() > timeEntryCount); sleep 1 }
        #   expect(@reminders.getTotalTimeEntries()).to eq(i+1)
        # end
      end

      it "1)g.ii.  Verify after all 5 entries are displayed, the Add Time button is gone, and Delete button shows up; Also verify that the Delete button is gone when there is only one time entry left" do
        expect(is_element_present(:css, "button[ng-click='addTimeEntry()']")).to eq(true)

        timeEntryCount = @reminders.getTotalTimeEntries()

        for i in 5..1
          if i > 1 then
            #Click the Delete button to remove a time entry
            @reminders.clickDeleteTimeEntryButton(i)
            !5.times{ break if (@reminders.getTotalTimeEntries() < timeEntryCount); sleep 1 }
            expect(@reminders.getTotalTimeEntries()).to eq(i-1)
          else
            #Verify that the Delete button is gone when there is only one time entry left
            present = is_element_present(:css, 'button[name="deleteTime_0"')
            expect(present).to eq(false)
          end
        end
      end

  end

  context 'AC#JRNL-1809|TC #JRNL-1811:  In both add and edit mode, when the user views the Medication reminder, the Notification fields are displayed' do

    it "4)c.i. Verify In-App is selected as default when Status is On", :broken => true do
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)
      end

      it "4)c.iii.  if no email exists display 'Email address has not been saved'; Also display the instructional text " do
        #Email is disabled since this user does not have email provided
        expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(false)
        #Verify that the text is displayed when email is not available
        #expect(@screening.getEmailFromNotification()).to eq("Email address has not been saved")
        #Verify the instructional text is displayed
        expect(@screening.getInstructionalTextWhenEmailIsNotAvailable()).to eq("You may update your Preferred Email address in the Notification feature by selecting the notification settings icon")
      end

      it "4)c.iv  Verify that At least one checkbox must be valued on Save, otherwise, show error message: A Notification Delivery method is needed to save this record. Please select a method and save again.", :broken => true do
        #unCheck the In-App option
        @screening.clickNotificationDeliveryCheckBox("In-App")
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(false)

        @reminders.clickSaveButton()
        !5.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        expect(@error.isErrorMessageDisplayed("entryForm", "A Notification Delivery method is needed to save this record. Please select a method and save again.")).to eq(true)

        @reminders.clickCancelButton()
        !5.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
      end

  end

  context 'Happy Path testing - add serveral reminders and verify the data show up in the Table View correctly' do

      it "Verify after adding and saving the reminders, the data show up in the Table View correctly", :broken => true do
        tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

        #Add the first reminder
        startTimeArry = ["12:00 PM"]
        listViewCount = @reminders.getRemindersCount()
        @reminders.clickSaveButton
        waitForPageToFinishLoading
        @reminders.addReminder("TAKE TYLENOL 81MG", tomorrow, "Weekly", startTimeArry, "On")
        !5.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
        #Verify that the reminder is displayed on the list view
        !5.times{ break if (@reminders.getRemindersCount() > listViewCount); sleep 1 }
        expect(@reminders.getRemindersCount() > listViewCount).to eq(true)

        indexID = @reminders.findIndexWithGivenName("TAKE TYLENOL 81MG")
        expect(@reminders.getNthReminderName(indexID)).to eq("TAKE TYLENOL 81MG")
        expect(@reminders.getNthReminderFrequency(indexID)).to eq("Weekly")
        expect(@reminders.getNthReminderStatus(indexID)).to eq("On")

        #Add the second reminder
        startTimeArry = ["02:00 PM"]
        listViewCount = @reminders.getRemindersCount()
        @reminders.addReminder("SHINGLE VACCINE", tomorrow, "Monthly", startTimeArry, "On")
        !5.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
        #Verify that the reminder is displayed on the list view
        !5.times{ break if (@reminders.getRemindersCount() > listViewCount); sleep 1 }
        expect(@reminders.getRemindersCount() > listViewCount).to eq(true)

        indexID = @reminders.findIndexWithGivenName("SHINGLE VACCINE")
        expect(@reminders.getNthReminderName(indexID)).to eq("SHINGLE VACCINE")
        expect(@reminders.getNthReminderFrequency(indexID)).to eq("Monthly")
        expect(@reminders.getNthReminderStatus(indexID)).to eq("On")

        #Add the third reminder
        startTimeArry = ["11:05 AM", "02:05 PM", "04:05 PM", "06:05 PM", "08:05 PM"]
        listViewCount = @reminders.getRemindersCount()
        @reminders.addReminder("take CoQ10 150mg", tomorrow, "Daily", startTimeArry, "Off")
        !5.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
        #Verify that the reminder is displayed on the list view
        !5.times{ break if (@reminders.getRemindersCount() > listViewCount); sleep 1 }
        expect(@reminders.getRemindersCount() > listViewCount).to eq(true)

        indexID = @reminders.findIndexWithGivenName("take CoQ10 150mg")
        expect(@reminders.getNthReminderName(indexID)).to eq("take CoQ10 150mg")
        expect(@reminders.getNthReminderFrequency(indexID)).to eq("Daily")
        expect(@reminders.getNthReminderStatus(indexID)).to eq("Off")

        #Open the reminder in the detail view to verify that time entries are displayed correctly
        @reminders.clickNthReminder(indexID)
        !5.times{ break if(@reminders.getPrimaryHeader() == "Edit Medication Reminder"); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq("Edit Medication Reminder")

        for i in 0..4
          expect(@time_picker.getTimePerEntry(i)).to eq(startTimeArry[i])
        end
      end

  end

end



































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "Story# NR-58,JRNL-2494: [Reminders_Create_Medications_Reminder_JRNL_2494_spec.rb]", :regression => true do

  table_view_header = "Medication Reminders"
  add_entry_header = "Add Medication Reminder"

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("reminders", "remindersdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient66", "patient66, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient66, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    expect(@reminders.getFocusedElementText()).to eq(@reminders.getSecondaryHeader())
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")
    expect(@reminders.getTitle()).to eq("My Reminders")

    @initialCount = @reminders.getRemindersCount()
  end

  after(:all) do
    quitDriver()
  end

  context '#AC#JRNL-1809 |TC #JRNL-1811:  Medication Reminder Add view meta data validations' do

      it "Verify that when there are records in the list, the default message displayed as follow" do
        !45.times{ break if (@reminders.getDefaultMsg() == "Select an item from the Reminders list to view details or add a new Reminder entry."); sleep 1 }
        expect(@reminders.getDefaultMsg()).to eq("Select an item from the Reminders list to view details or add a new Reminder entry.")

        @reminders.clickSubGroup("medications")
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
      end

      it "Verify that the header text for Add screen is Add Medication Reminder" do
        #Click the Add Entry button
        @reminders.clickAddEntryButton()
        !45.times{ break if (@reminders.getPrimaryHeader() == add_entry_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(add_entry_header)
      end

      it "1)a. Medication Name (required) (free text, 100 characters) ", :broken => true do
        @reminders.clickSaveButton()
        !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
        #Validate that the error messages are displayed
        expect(@error.isErrorMessageDisplayed("entryForm", "Medication Name field is required.")).to eq(true)

        #Verify that the Medication Name only allows maximum of 100 characters
        textareaMaxLengthTest("title", 100, false)
      end

      it "1)b. Note (max 250 characters) " do
        textareaMaxLengthTest("Note", 250, true)
      end

      it "1)d,e,f,g  Verify when Notification is turned on, Start Date, Notify Me and Notification Time become required. ", :broken => true do
        @reminders.selectNotificationStatus("On")
        expect(@reminders.isNotificationStatusSelected("On")).to eq(true)

        @reminders.clickSaveButton()
        !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
        expect(@error.isErrorMessageDisplayed("entryForm", "Start Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Notify Me field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Notification Time field is required.")).to eq(true)
      end

      it "Verify that the Cancel functionality works properly" do
        @reminders.clickCancelButton()
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)

        #Verify that reminders count should stay the same since the Add Reminder was canceled
        expect(@reminders.getRemindersCount()).to eq(@initialCount)
      end

      it "1)e.i  Date may be future, past dates are not allowed.", :broken => true do
        @reminders.clickAddEntryButton()
        !45.times{ break if (@reminders.getPrimaryHeader() == add_entry_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(add_entry_header)

        #Verify the Start Date can't be past
        twoDaysAgo = getDateNthDaysAgo(2, "%m/%d/%Y")

        @reminders.selectNotificationStatus("On")
        expect(@reminders.isNotificationStatusSelected("On")).to eq(true)

        setDate(twoDaysAgo, "input[name='notificationStartDate']")

        @reminders.clickSaveButton()
        !15.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        if Time.new.year.to_s != twoDaysAgo[-4..-1]
          expect(@error.isErrorMessageDisplayed("entryForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(true)
        else
          expect(@error.isErrorMessageDisplayed("entryForm", "Start Date must be between " + getDateNthDaysAgo(0, "%m/%d/%Y") +  " and 12/31/2099.")).to eq(true)
        end
      end

      it "1)e.ii  When a date is selected, the Day of the week is displayed in read only text. ", :broken => true do
        tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
        setDate(tomorrow, "input[name='notificationStartDate']")
        @reminders.verifyTheDayofWeekIsDisplayedCorrectly(tomorrow)
      end

      it "1)f. Verify Notify Me field has Select,Daily,Weekly,Monthly values; Verify it defaults to Select"  do
        expect(areAllTheseValuesAvailableInDropDown("select[name='notificationFrequency']", "Select,Daily,Weekly,Monthly")).to eq(true)
        expect(@screening.isThisValueDefaultToTheDropdown("Select", "notificationFrequency")).to eq(true)
      end

      it "1)g.  Verify Notification Time is configured to show 5 minute increments; Set a Time and verify it's displayed as it is and not modified", :broken => true do
        @time_picker.clickTimePickerButton()
        !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
        expect(@driver.find_element(:id, "set-button").displayed?).to eq(true)
        expect(@time_picker.areMinutesIn5MinIntervals()).to eq(true)

        #Set a Time and verify it's displayed as it is and not modified
        @time_picker.setTimeFromGUI(11, "05", "AM")
        !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }
        expect(is_element_present(:id, "set-button")).to eq(false)
        expect(@time_picker.isTimeDisplayedCorrectly("11:05 AM")).to eq(true)
      end

      it "1)g. Verify that any entered time that does not end with 0 or 5 will not be entered. ", :broken => true do
        setTime("11:23 AM", "input[name='time_0']")
        expect(@time_picker.isTimeDisplayedCorrectly("11:2")).to eq(true)
      end

      it "1)g.i. If Notification frequency = daily, users may add up to 5 time values per reminder.", :broken => true do
        @reminders.selectFrequency("Daily")

        !45.times{ break if (is_element_present(:css, "button[ng-click='addTimeEntry()']")); sleep 1 }
        expect(is_element_present(:css, "button[ng-click='addTimeEntry()']")).to eq(true)
        expect(getTextForElement(:css, "button[ng-click='addTimeEntry()']")).to eq("Add Time")

        #Add the first time entry
        timeStr = ["11:05 AM", "02:05 PM", "04:05 PM", "06:05 PM", "08:05 PM"]
        timeEntryCount = @reminders.getTotalTimeEntries()

        setTime(timeStr[0], "input[name='time_0']")

        for i in 1..4
          #Click Add Time button to add a time
          @reminders.clickAddTimeEntry()
          setTime(timeStr[i], "input[name='time_#{i.to_s}']")
          !45.times{ break if (@reminders.getTotalTimeEntries() > timeEntryCount); sleep 1 }
          expect(@reminders.getTotalTimeEntries()).to eq(i+1)
        end
      end

      it "1)g.ii.  Verify after all 5 entries are displayed, the Add Time button is gone, and Delete button shows up; Also verify that the Delete button is gone when there is only one time entry left" do
        expect(is_element_present(:css, "button[ng-click='addTimeEntry()']")).to eq(false)

        timeEntryCount = @reminders.getTotalTimeEntries()

        for i in 5..1
          if i > 1 then
            #Click the Delete button to remove a time entry
            @reminders.clickDeleteTimeEntryButton(i)
            !45.times{ break if (@reminders.getTotalTimeEntries() < timeEntryCount); sleep 1 }
            expect(@reminders.getTotalTimeEntries()).to eq(i-1)
          else
            #Verify that the Delete button is gone when there is only one time entry left
            present = is_element_present(:css, 'button[name="deleteTime_0"')
            expect(present).to eq(false)
          end
        end
      end

  end

  context 'AC#JRNL-1809|TC #JRNL-1811:  In both add and edit mode, when the user views the Medication reminder, the Notification fields are displayed' do

    it "4)c.i. Verify In-App is selected as default when Status is On", :broken => true do
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)
      end

      it "4)c.iii.  if no email exists display 'Email address has not been saved'; Also display the instructional text " do
        #Email is disabled since this user does not have email provided
        expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(true)
        #Verify that the text is displayed when email is not available
        expect(@screening.getEmailFromNotification()).to eq("Email address has not been saved")
        #Verify the instructional text is displayed
        expect(@screening.getInstructionalTextWhenEmailIsNotAvailable()).to eq("You may update your Preferred Email address in the Notification feature by selecting the notification settings icon")
      end

      it "4)c.iv  Verify that At least one checkbox must be valued on Save, otherwise, show error message: A Notification Delivery method is needed to save this record. Please select a method and save again.", :broken => true do
        #unCheck the In-App option
        @screening.clickNotificationDeliveryCheckBox("In-App")
        expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(false)

        @reminders.clickSaveButton()
        !15.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
        expect(@error.isErrorMessageDisplayed("entryForm", "A Notification Delivery method is needed to save this record. Please select a method and save again.")).to eq(true)

        @reminders.clickCancelButton()
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
      end

  end

  context 'Happy Path testing - add serveral reminders and verify the data show up in the Table View correctly' do

      it "Verify after adding and saving the reminders, the data show up in the Table View correctly", :broken => true do
        tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")

        #Add the first reminder
        startTimeArry = ["12:00 PM"]
        listViewCount = @reminders.getRemindersCount()
        @reminders.addReminder("TAKE TYLENOL 81MG", tomorrow, "Weekly", startTimeArry, "On")
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
        #Verify that the reminder is displayed on the list view
        !45.times{ break if (@reminders.getRemindersCount() > listViewCount); sleep 1 }
        expect(@reminders.getRemindersCount() > listViewCount).to eq(true)

        indexID = @reminders.findIndexWithGivenName("TAKE TYLENOL 81MG")
        expect(@reminders.getNthReminderName(indexID)).to eq("TAKE TYLENOL 81MG")
        expect(@reminders.getNthReminderFrequency(indexID)).to eq("Weekly")
        expect(@reminders.getNthReminderStatus(indexID)).to eq("On")

        #Add the second reminder
        startTimeArry = ["02:00 PM"]
        listViewCount = @reminders.getRemindersCount()
        @reminders.addReminder("SHINGLE VACCINE", tomorrow, "Monthly", startTimeArry, "On")
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
        #Verify that the reminder is displayed on the list view
        !45.times{ break if (@reminders.getRemindersCount() > listViewCount); sleep 1 }
        expect(@reminders.getRemindersCount() > listViewCount).to eq(true)

        indexID = @reminders.findIndexWithGivenName("SHINGLE VACCINE")
        expect(@reminders.getNthReminderName(indexID)).to eq("SHINGLE VACCINE")
        expect(@reminders.getNthReminderFrequency(indexID)).to eq("Monthly")
        expect(@reminders.getNthReminderStatus(indexID)).to eq("On")

        #Add the third reminder
        startTimeArry = ["11:05 AM", "02:05 PM", "04:05 PM", "06:05 PM", "08:05 PM"]
        listViewCount = @reminders.getRemindersCount()
        @reminders.addReminder("take CoQ10 150mg", tomorrow, "Daily", startTimeArry, "Off")
        !45.times{ break if (@reminders.getPrimaryHeader() == table_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(table_view_header)
        #Verify that the reminder is displayed on the list view
        !45.times{ break if (@reminders.getRemindersCount() > listViewCount); sleep 1 }
        expect(@reminders.getRemindersCount() > listViewCount).to eq(true)

        indexID = @reminders.findIndexWithGivenName("take CoQ10 150mg")
        expect(@reminders.getNthReminderName(indexID)).to eq("take CoQ10 150mg")
        expect(@reminders.getNthReminderFrequency(indexID)).to eq("Daily")
        expect(@reminders.getNthReminderStatus(indexID)).to eq("Off")

        #Open the reminder in the detail view to verify that time entries are displayed correctly
        @reminders.clickNthReminder(indexID)
        !45.times{ break if(@reminders.getPrimaryHeader() == "Edit Medication Reminder"); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq("Edit Medication Reminder")

        for i in 0..4
          expect(@time_picker.getTimePerEntry(i)).to eq(startTimeArry[i])
        end
      end

  end

end
=end