require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2501, 1949:  Appointments_List_View_JRNL_2501_JRNL_1949_spec.rb]", :regression=>true do

  list_view_header = "Appointment Reminders"

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("reminders", "remindersdb", "appointmentListReminders")
    resetCollection("appointments", "medicalhistorydb", "appointmentsMedicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyReminders']").click
    waitForPageToFinishLoading
    !5.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
  end

  # after(:all) do
  #   quitDriver()
  # end

  context '#AC #JRNL-2881|TC #JRNL-2914:  Goal - Display Appointments reminders in List View' do
    it "1)a. Verify that the List View Header is: Appointment Reminders" do

      @reminders.clickSubGroup("appointments")
      !5.times{ break if (@reminders.getPrimaryHeader() == list_view_header); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(list_view_header)
    end


    it "2). Verify that If no reminders exist, the system displays the default filter and displays a text No records found." do
      expect(getNoResultsFoundMessage()).to eq("")
    end


    xit "1)b. Verify that the Filter view display includes: Status (On, Off, All(defult)); Filter button - clicking the button updates the table view based on the filter parameters.", :broken => true do
      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.patient14", "patient14, zztest")
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='MyReminders']").click
      waitForPageToFinishLoading
      !5.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
      @reminders.clickSubGroup("appointments")
      !5.times{ break if (@reminders.getPrimaryHeader() == list_view_header); sleep 1 }
      !5.times{ break if (getTextForElement(:css, ".text-left") == "Notification Status:"); sleep 1 }

      #Verify that the Filter button is available
      expect(@reminders.isTheFilterButtonVisible()).to eq(true)

      #All is a defaulted option
      expect(@reminders.isStatusSelected("On")).to eq(false)
      expect(@reminders.isStatusSelected("Off")).to eq(false)
      expect(@reminders.isStatusSelected("All")).to eq(true)

      remindersCountAll = @reminders.getRemindersCount()
      @reminders.selectStatus("All")
      !5.times{ break if (@reminders.isStatusSelected("All") == true); sleep 1 }
      @reminders.clickFilter

      !5.times{ break if (@reminders.getRemindersCount() == remindersCountAll); sleep 1 }

      #Filter by "On"
      @reminders.selectStatus("On")
      !5.times{ break if (@reminders.isStatusSelected("On") == true); sleep 1 }
      @reminders.clickFilter

      !5.times{ break if (@reminders.getRemindersCount() < remindersCountAll); sleep 1 }
      remindersCountOn = @reminders.getRemindersCount()
      #puts "remindersCountOn=" + remindersCountOn.to_s

      for i in 1..remindersCountOn
        # expect(@reminders.getNthReminderStatus(i)).to eq("On")
        expect(getTextForRowColumn(i,4)).to eq("On")
      end

      #Filter by "Off"
      @reminders.selectStatus("Off")
      !5.times{ break if (@reminders.isStatusSelected("Off") == true); sleep 1 }
      @reminders.clickFilter
      sleep 2
      !5.times{ break if (@reminders.getRemindersCount() < remindersCountAll); sleep 1 }
      remindersCountOff = @reminders.getRemindersCount()
      #puts "remindersCountOff=" + remindersCountOff.to_s

      for i in 1..remindersCountOff
        # expect(@reminders.getNthReminderStatus(i)).to eq("Off")
        expect(getTextForRowColumn(i,4)).to eq("Off")
      end



      #Reset it to "All"
      @reminders.selectStatus("All")
      !5.times{ break if (@reminders.isStatusSelected("All") == true); sleep 1 }
      @reminders.clickFilter
      !5.times{ break if (@reminders.getRemindersCount() == remindersCountAll); sleep 1 }

      #Click the hide filter button
      @date_filter.clickFilterAccordion
      #Verify the status filter options are hidden
      expect(@date_filter.isFilterAccordionExpanded).to eq(false)

      #Flip the hide filter button again
      @date_filter.clickFilterAccordion
      expect(@date_filter.isFilterAccordionExpanded).to eq(true)

      @reminders.selectStatus("Off")
      !5.times{ break if (@reminders.isStatusSelected("Off") == true); sleep 1 }
      @reminders.clickFilter()
      !5.times { break if (getFocusedElementText().include?(%(Clinic/Organization))); sleep 1 }

    end

    xit "Story JRNL-1696|AC JRNL-1583: Reset Button", :broken => true do
      expect(isResetButtonPresent()).to eq(true)

      expect(getResetButtonLabel()).to eq("Reset")

      clickResetBtn()
      !5.times { break if (getFocusedElementText().include?("Medication Name")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + " ")
      expect(getCount()).to eq(4)
      expect(@reminders.isRemindersListSortedByNameFrequencyStatus()).to eq(true)

      # DEFAULT
      expect(@reminders.isStatusSelected("All")).to eq(true)
    end

    xit "1)c. Verify that the following columns are displayed in the table view: Provider, Appointment Date/Time, Status", :broken => true do
      expect(getTableHeaders()).to eq(["Clinic/Organization","Provider", "Appointment Date/Time", "Status"])

    end

    xit "1)c.ii. Verify that the table is sorted by Appointment Date/Time in chronological order", :broken => true do
      expect(isSortedByChronologicalOrder("%m/%d/%Y %I:%M %p", 3)).to eq(true)
    end
   end
end



















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2501, 1949:  Appointments_List_View_JRNL_2501_JRNL_1949_spec.rb]", :regression=>true do

  list_view_header = "Appointment Reminders"

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("reminders", "remindersdb", "appointmentListReminders")
    resetCollection("appointments", "medicalhistorydb", "appointmentsMedicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }

  end

  after(:all) do
    quitDriver()
  end

  context '#AC #JRNL-2881|TC #JRNL-2914:  Goal - Display Appointments reminders in List View' do
    it "1)a. Verify that the List View Header is: Appointment Reminders" do

      @reminders.clickSubGroup("appointments")
      !45.times{ break if (@reminders.getPrimaryHeader() == list_view_header); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq(list_view_header)

    end


    it "2). Verify that If no reminders exist, the system displays the default filter and displays a text No records found." do

      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")

    end


    xit "1)b. Verify that the Filter view display includes: Status (On, Off, All(defult)); Filter button - clicking the button updates the table view based on the filter parameters.", :broken => true do

      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.patient14", "patient14, zztest")


      @nav_menu.clickReminders()
      !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
      @reminders.clickSubGroup("appointments")
      !10.times{ break if (@reminders.getPrimaryHeader() == list_view_header); sleep 1 }
      !15.times{ break if (getTextForElement(:css, ".text-left") == "Notification Status:"); sleep 1 }

      #Verify that the Filter button is available
      expect(@reminders.isTheFilterButtonVisible()).to eq(true)

      #All is a defaulted option
      expect(@reminders.isStatusSelected("On")).to eq(false)
      expect(@reminders.isStatusSelected("Off")).to eq(false)
      expect(@reminders.isStatusSelected("All")).to eq(true)

      remindersCountAll = @reminders.getRemindersCount()
      @reminders.selectStatus("All")
      !10.times{ break if (@reminders.isStatusSelected("All") == true); sleep 1 }
      @reminders.clickFilter

      !30.times{ break if (@reminders.getRemindersCount() == remindersCountAll); sleep 1 }

      #Filter by "On"
      @reminders.selectStatus("On")
      !10.times{ break if (@reminders.isStatusSelected("On") == true); sleep 1 }
      @reminders.clickFilter

      !30.times{ break if (@reminders.getRemindersCount() < remindersCountAll); sleep 1 }
      remindersCountOn = @reminders.getRemindersCount()
      #puts "remindersCountOn=" + remindersCountOn.to_s

      for i in 1..remindersCountOn
        # expect(@reminders.getNthReminderStatus(i)).to eq("On")
        expect(getTextForRowColumn(i,4)).to eq("On")
      end



      #Filter by "Off"
      @reminders.selectStatus("Off")
      !10.times{ break if (@reminders.isStatusSelected("Off") == true); sleep 1 }
      @reminders.clickFilter
      sleep 2
      !10.times{ break if (@reminders.getRemindersCount() < remindersCountAll); sleep 1 }
      remindersCountOff = @reminders.getRemindersCount()
      #puts "remindersCountOff=" + remindersCountOff.to_s

      for i in 1..remindersCountOff
        # expect(@reminders.getNthReminderStatus(i)).to eq("Off")
        expect(getTextForRowColumn(i,4)).to eq("Off")
      end



      #Reset it to "All"
      @reminders.selectStatus("All")
      !45.times{ break if (@reminders.isStatusSelected("All") == true); sleep 1 }
      @reminders.clickFilter
      !45.times{ break if (@reminders.getRemindersCount() == remindersCountAll); sleep 1 }

      #Click the hide filter button
      @date_filter.clickFilterAccordion
      #Verify the status filter options are hidden
      expect(@date_filter.isFilterAccordionExpanded).to eq(false)

      #Flip the hide filter button again
      @date_filter.clickFilterAccordion
      expect(@date_filter.isFilterAccordionExpanded).to eq(true)

      @reminders.selectStatus("Off")
      !10.times{ break if (@reminders.isStatusSelected("Off") == true); sleep 1 }
      @reminders.clickFilter()
      !10.times { break if (getFocusedElementText().include?(%(Clinic/Organization))); sleep 1 }

    end

    xit "Story JRNL-1696|AC JRNL-1583: Reset Button", :broken => true do
      expect(isResetButtonPresent()).to eq(true)

      expect(getResetButtonLabel()).to eq("Reset")

      clickResetBtn()
      !10.times { break if (getFocusedElementText().include?("Medication Name")); sleep 1 }
      expect(getFocusedElementText()).to eq(getTextForRow(1) + " ")
      expect(getCount()).to eq(4)
      expect(@reminders.isRemindersListSortedByNameFrequencyStatus()).to eq(true)

      # DEFAULT
      expect(@reminders.isStatusSelected("All")).to eq(true)
    end

    xit "1)c. Verify that the following columns are displayed in the table view: Provider, Appointment Date/Time, Status", :broken => true do
      expect(getTableHeaders()).to eq(["Clinic/Organization","Provider", "Appointment Date/Time", "Status"])

    end

    xit "1)c.ii. Verify that the table is sorted by Appointment Date/Time in chronological order", :broken => true do
      expect(isSortedByChronologicalOrder("%m/%d/%Y %I:%M %p", 3)).to eq(true)
    end
   end
end
=end