require_relative '../../../globalized'
include Globalized

describe "Story# JRNL-2500: [Add_Appointment_Reminder_JRNL_2500_spec.rb]", :acceptance => true do
  list_view_header = "Appointment Reminders"
  first_name = "provider-Fname"
  last_name = "provider-Lname"
  clinic = "clinic"
  facility = "location"
  reason = "reason"

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("appointments", "medicalhistorydb")
    removeCollection("reminders", "remindersdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyReminders']").click
    waitForPageToFinishLoading
    !5.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
    expect(@reminders.getTitle()).to eq("My Reminders")

    @reminders.clickSubGroup("appointments")
    !5.times{ break if (@reminders.getPrimaryHeader() == list_view_header); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(list_view_header)
  end

  # after(:all) do
  #   quitDriver()
  # end

  context'AC #JRNL-1805 |TC #JRNL-1956: Appointments Reminder Detail' do

    it "Appointment Header and Required field indicator" do
      @reminders.clickAddEntryButton()
      !5.times{ break if(@reminders.getPrimaryHeader() == "Add Appointment Reminder"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Add Appointment Reminder")
      expect(@reminders.getrequiredFieldIndicator()).to eq("* required field")
    end

    it "Appointment Date and Time" do
      waitForPageToFinishLoading
      expect(@reminders.getDateGuidanceText()).to eq("MM/DD/YYYY")
      expect(@reminders.isDateRequired()).to eq(true)
      expect(@reminders.getTimeGuidanceText()).to eq("HH:MM AM/PM")
      expect(@reminders.isTimeRequired()).to eq(true)
    end

    it "Provider Label and First Name, Last Name Fields" do
      expect(@reminders.getProviderLabelText()).to eq("Provider")
      expect(@reminders.verifyMaxCharactersForField(first_name, 30)).to eq(true)
      expect(@reminders.verifyMaxCharactersForField(last_name, 40)).to eq(true)
    end

    it "Clinic/Organization name" do
      expect(@reminders.getClinicLabelText()).to eq("* Clinic/Organization Name:")
      expect(@reminders.isClinicRequired()).to eq(true)
      expect(@reminders.verifyMaxCharactersForField(clinic, 50))
    end

    it "Facility/Location" do
      expect(@reminders.getFacilityLabelText()).to eq("Facility/Location:")
      expect(@reminders.verifyMaxCharactersForField(facility, 150)).to eq(true)
    end

    it "Reason" do
      expect(@reminders.getReasonLabelText()).to eq("Reason:")
      expect(@reminders.verifyMaxCharactersForField(reason, 50)).to eq(true)
    end

    it "Phone", :broken => true do
      expect(@reminders.getPhoneLabelText()).to eq("Phone:")
      expect(@reminders.getPhoneGuidanceText()).to eq("(___) ___-____")
    end

    it "Note" do
      expect(@reminders.getNoteLabelText()).to eq("Note:")
      expect(verifyTotalCharacterInNarrative()).to eq(true)
    end

  end

  context 'AC #JRNL-1804 |TC #JRNL-1956: Notification Details for Appointment Reminder' do
    it "Notification Lable and Radio Buttons" do
      expect(@reminders.getNotificationLabelText()).to eq("Notification:")
      expect(@reminders.isOnRadioVisible()).to eq(true)
      expect(@reminders.isOffRadioVisible()).to eq(true)
    end

    it "Notify me label and Checkbox verification" do
      @screening.selectNotificationStatus("On")
      #Verify the Notify Label
      expect(@screening.getNotifyMeLabel()).to eq("* Notify Me About This Appointment:")
      #Verify that four checkboxes are present
      verifyThisCheckboxPresentAndVisible("On the date", true)
      verifyThisCheckboxPresentAndVisible("1 day before", true)
      verifyThisCheckboxPresentAndVisible("2 weeks before", true)
      verifyThisCheckboxPresentAndVisible("4 weeks before", true)

      #VErify that four checkboxes are disabled when Next Due Date = null
      verifyThisCheckboxIsDisabled("On the date", true)
      verifyThisCheckboxIsDisabled("1 day before", true)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)
    end

    it "When notification status is on, notify me checkboxes are enabled/disabled based on Next Due Date; Also verify error handling upon save" do
      today = getDateNthDaysFromNow(0, "%m/%d/%Y")
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      the3rdDay = getDateNthDaysFromNow(2, "%m/%d/%Y")
      the15thDay = getDateNthDaysFromNow(14, "%m/%d/%Y")
      the16thDay = getDateNthDaysFromNow(15, "%m/%d/%Y")
      the29thDay = getDateNthDaysFromNow(28, "%m/%d/%Y")
      the30theDay = getDateNthDaysFromNow(29, "%m/%d/%Y")

      #When NDD = today, all checkboxes are disabled
      setDate(today, "date-control[label='Appointment Date'] input")
      setTime("11:45 AM", "time-control[label='Appointment Time'] input")
      verifyThisCheckboxIsDisabled("On the date", true)
      verifyThisCheckboxIsDisabled("1 day before", true)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      @screening.clickConfirmSaveButton
      #Verify error messages are displayed at the top of the screen
      checkingInlineError("Notifications cannot be provided for the Appointment Date you entered. Turn the Notification off to save the reminder.", 0)

      #Set Status to Off then Save
      @screening.selectNotificationStatus("Off")
      @reminders.setClinicName("Abc Hospital")

      @screening.clickConfirmSaveButton
      !5.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")

      @reminders.clickAddEntryButton()
      !5.times{ break if(@reminders.getPrimaryHeader() == "Add Appointment Reminder"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Add Appointment Reminder")

      @screening.selectNotificationStatus("On")

      #When NDD = tomorrow, 3 checkboxes are disabled, one is enabled
      setDate(tomorrow, "date-control[label='Appointment Date'] input")
      setTime("11:45 AM", "time-control[label='Appointment Time'] input")
      @reminders.setClinicName("Inova Hospital")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", true)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      #When NDD = the3rdDay, 2w, 4w disabled; On the date, 1 day before enabled
      setDate(the3rdDay, "date-control[label='Appointment Date'] input")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", false)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      #When NDD = the15thDay, 2w, 4w disabled; On the date, 1 day before enabled
      setDate(the15thDay, "date-control[label='Appointment Date'] input")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", false)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      #When NDD = the16thDay, 4w disabled; On the date, 1 day before, 2w enabled
      setDate(the16thDay, "date-control[label='Appointment Date'] input")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", false)
      verifyThisCheckboxIsDisabled("2 weeks before", false)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      #When NDD = the29thDay, 2w, 4w disabled; On the date, 1 day before enabled
      setDate(the29thDay, "date-control[label='Appointment Date'] input")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", false)
      verifyThisCheckboxIsDisabled("2 weeks before", false)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      #When NDD = the30theDay, all enabled
      setDate(the30theDay, "date-control[label='Appointment Date'] input")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", false)
      verifyThisCheckboxIsDisabled("2 weeks before", false)
      verifyThisCheckboxIsDisabled("4 weeks before", false)

      #Check all four checkboxes
      @screening.clickNotificationDeliveryCheckBox("On the date")
      @screening.clickNotificationDeliveryCheckBox("1 day before")
      @screening.clickNotificationDeliveryCheckBox("2 weeks before")
      @screening.clickNotificationDeliveryCheckBox("4 weeks before")
      # waitForPageToFinishLoading
      # @screening.selectNotificationStatus("Off")
      # waitForPageToFinishLoading

    end

    it "Verify that when user does not have an email in the system the Notification fields - Notification Method are displayed according to acceptance criteria" do
      #Verify the Notification Method
      #In app is checked as default
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)
      #Email is disabled since this user does not have email provided
      expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(true)
      #Verify that the text is displayed when email is not available
      expect(@screening.getEmailFromNotification()).to eq("Email address has not been saved")
      #Verify the instructional text is displayed
      expect(@screening.getInstructionalTextWhenEmailIsNotAvailable()).to eq("You may update your Preferred Email address in the Notification feature by selecting the notification settings icon")
    end

    it "Verify that when user has an email in the system the Notification fields - Notification Method are displayed according to acceptance criteria", :broken => true do
      @screening.clickCancelButton()
      !5.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")

      #Set the email to the user
      @common.navigateToNotificationSettingAndSetOrRemoveEmail("adil.vohra@agilex.com")

      #Returning to Reminder Detail
      waitForPageToFinishLoading
      @main.clickNavMenu
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='MyReminders']").click
      waitForPageToFinishLoading
      @screening.clickAppointments
      @appointments.clickAddEntryButton
      expect(@reminders.getPrimaryHeader()).to eq("Add Appointment Reminder")

      @screening.selectNotificationStatus("On")
      #In app is checked as default
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)
      #Email is enabled since this user has an email provided
      expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(false)
      #Verify that the email address is displayed in the edit box
      expect(@screening.getEmailFromNotification()).to eq("adil.vohra@agilex.com")

      # unCheck the In-App option
      @screening.clickNotificationDeliveryCheckBox("In-App")
      # Check the Email option
      @screening.clickNotificationDeliveryCheckBox("Email")
      #Provide values to Next Due Date
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      setDate(tomorrow, "date-control[label='Appointment Date'] input")
      setTime("11:45 AM", "time-control[label='Appointment Time'] input")
      @reminders.setClinicName("Inova Hospital")

      #Check On the date checkbox from Notify Me
      @screening.clickNotificationDeliveryCheckBox("On the date")

      @screening.clickSaveButton()
      !5.times{ break if (getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Appointment Reminders")
      !5.times{ break if (@screening.getTableViewHeader() == "Provider"); sleep 1 }
      expect(@screening.getTableViewHeader()).to eq("Provider")

      #Navigate to the Notification Setting screen to remove the email address
      @common.navigateToNotificationSettingAndSetOrRemoveEmail("")
      !5.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
      expect(@modal.getTopLayerModalConfirmationHeading()).to eq("Warning")
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[class='btn btn-primary ng-binding ng-scope']").click
      waitForPageToFinishLoading
      !5.times{ break if (@modal.isConfirmationPopUpNotPresent()); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      #Return to Reminder Detail
      waitForPageToFinishLoading
      @main.clickNavMenu
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='MyReminders']").click
      waitForPageToFinishLoading
      @screening.clickAppointments
      @appointments.clickAddEntryButton
      expect(@reminders.getPrimaryHeader()).to eq("Add Appointment Reminder")

      setDate(tomorrow, "date-control[label='Appointment Date'] input")
      setTime("01:00 PM", "time-control[label='Appointment Time'] input")
      @reminders.setClinicName("Sterling Hospital")

      #Verify that now the Notification Status is set to Off and email checkbox is unchecked
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Off", "notificationOption")).to eq(true)
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(false)
      #Turn the Status to On and check In-App checkbox
      @screening.selectNotificationStatus("On")
      @screening.clickNotificationDeliveryCheckBox("On the date")

      @screening.clickSaveButton()
      !5.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")

      #Navigate to Notification Settings and provide an email address
      @common.navigateToNotificationSettingAndSetOrRemoveEmail("adil.vohra@agilex.com")

      #Return to Reminder Detail
      waitForPageToFinishLoading
      @main.clickNavMenu
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='MyReminders']").click
      waitForPageToFinishLoading
      @screening.clickAppointments
      @appointments.clickAddEntryButton
      expect(@reminders.getPrimaryHeader()).to eq("Add Appointment Reminder")

      #Verify that email return to the edit box, but email checkbox is NOT checked automatically. User has to elect to check it
      expect(@screening.getEmailFromNotification()).to eq("adil.vohra@agilex.com")
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(false)
    end

  end

  context 'AC #JRNL-1802 |TC #JRNL-1956: Save and Cancel Options Available in Add Mode' do

    it "Save and Cancel Options" do
      waitForPageToFinishLoading
      expect(@reminders.isSaveButtonVisible()).to eq(true)
      expect(@reminders.isCancelButtonVisible()).to eq(true)
    end

  end

  context 'AC #JRNL-1801 |TC #JRNL-1956: Edit and Entry for Appointment Reminder' do

    it "Editing a reminder", :broken => true do
      @reminders.clickCancelButton()
      !5.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")

#      clickNthRow(2)
      @driver.find_element(:xpath ,".//*[@id='main-content-div']/div[2]/div[2]/list-table/div/div/ul/li[2]/span[5]").click
      waitForPageToFinishLoading
      !5.times{ break if (getPrimaryHeader() == "Edit Appointment Reminder"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Reminder")

      #Changing Clinic Name and Saving and Verifying
      @reminders.setClinicName("Fairfax Hospital")
      waitForPageToFinishLoading
      @reminders.clickConfirmSaveButton
      !5.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")
      !5.times{ break if (@screening.getTableViewHeader() == "Provider"); sleep 1 }
      expect(@screening.getTableViewHeader()).to eq("Provider")

      expect(getTextForRowColumn(2,1)).to eq("Fairfax Hospital")
    end

  end

  context 'AC #JRNL-1800 |TC #JRNL-1956: Cancel and Delete Appointment Reminder' do

    it "Cancelling an Appointment Reminder", :broken => true do
      #Selecting a Record from the table
        waitForPageToFinishLoading
        @driver.find_element(:xpath ,".//*[@id='main-content-div']/div[2]/div[2]/list-table/div/div/ul/li[2]/span[5]").click
        waitForPageToFinishLoading
      !5.times{ break if (getPrimaryHeader() == "Edit Appointment Reminder"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Reminder")

      @reminders.setClinicName("New Hospital")
      waitForPageToFinishLoading
      @reminders.clickCancelButton()
      !5.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")
      !5.times{ break if (@screening.getTableViewHeader() == "Provider"); sleep 1 }
      expect(@screening.getTableViewHeader()).to eq("Provider")

      #Verifying Nothing Changed
      expect(getCount()).to eq(3)
      expect(getTextForRowColumn(2,1)).to eq("Fairfax Hospital")
    end

    it "Deleting an Appointment Reminder", :broken => true do
      waitForPageToFinishLoading
      @driver.find_element(:xpath ,".//*[@id='main-content-div']/div[2]/div[2]/list-table/div/div/ul/li[2]/span[5]").click
      waitForPageToFinishLoading
      !5.times{ break if (getPrimaryHeader() == "Edit Appointment Reminder"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Reminder")
      !5.times{ break if(isElementPresentAndVisible(:css, "form[name='entryForm']")); sleep 1 }
      expect(isElementPresentAndVisible(:css, "form[name='entryForm']")).to eq(true)

      expect(@reminders.isDeleteButtonVisible()).to eq(true)
      waitForPageToFinishLoading
      @reminders.clickDeleteButton()
      !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")

      @modal.clickNoButton()
      !5.times{ break if (getPrimaryHeader() == "Edit Appointment Reminder"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Reminder")
      waitForPageToFinishLoading
      @reminders.clickDeleteButton()
      !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")

      @modal.clickYesButton()
      !5.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")
      !5.times{ break if (@screening.getTableViewHeader() == "Provider"); sleep 1 }
      expect(@screening.getTableViewHeader()).to eq("Provider")

      expect(getCount()).to eq(2)
    end

  end

  #######################
  ### Local Functions ###
  #######################
  def checkingInlineError(errMsg, seqNum)
    # Verify error message header
    if seqNum == 0 then
      !5.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    end
    # Verify the error message
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

  def verifyThisCheckboxPresentAndVisible(value, trueOrFalse)
    expect(isElementPresentAndVisible(:css, "input[type='checkbox'][value='" + value + "']")).to eq(trueOrFalse)
  end

  def verifyThisCheckboxIsDisabled(value, trueOrFalse)
    expect(isThisElementDisabled(:css, "input[type='checkbox'][value='" + value + "']")).to eq(trueOrFalse)
  end

end






















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "Story# JRNL-2500: [Add_Appointment_Reminder_JRNL_2500_spec.rb]", :acceptance => true do
  list_view_header = "Appointment Reminders"
  first_name = "provider-Fname"
  last_name = "provider-Lname"
  clinic = "clinic"
  facility = "location"
  reason = "reason"

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("notificationPreferences", "notificationsdb")
    removeCollection("preferences", "notificationsdb")
    removeCollection("appointments", "medicalhistorydb")
    removeCollection("reminders", "remindersdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")


    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }
    expect(@reminders.getTitle()).to eq("My Reminders")

    @reminders.clickSubGroup("appointments")
    !45.times{ break if (@reminders.getPrimaryHeader() == list_view_header); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(list_view_header)
  end

  after(:all) do
    quitDriver()
  end


  context'AC #JRNL-1805 |TC #JRNL-1956: Appointments Reminder Detail' do

    it "Appointment Header and Required field indicator" do
      @reminders.clickAddEntryButton()
      !45.times{ break if(@reminders.getPrimaryHeader() == "Add Appointment Reminder"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Add Appointment Reminder")
      expect(@reminders.getrequiredFieldIndicator()).to eq("* required field")
    end

    it "Appointment Date and Time" do
      waitForPageToFinishLoading
      expect(@reminders.getDateGuidanceText()).to eq("MM/DD/YYYY")
      expect(@reminders.isDateRequired()).to eq(true)
      expect(@reminders.getTimeGuidanceText()).to eq("HH:MM AM/PM")
      expect(@reminders.isTimeRequired()).to eq(true)
    end

    it "Provider Label and First Name, Last Name Fields" do
      expect(@reminders.getProviderLabelText()).to eq("Provider")
      expect(@reminders.verifyMaxCharactersForField(first_name, 30)).to eq(true)
      expect(@reminders.verifyMaxCharactersForField(last_name, 40)).to eq(true)
    end

    it "Clinic/Organization name" do
      expect(@reminders.getClinicLabelText()).to eq("* Clinic/Organization Name:")
      expect(@reminders.isClinicRequired()).to eq(true)
      expect(@reminders.verifyMaxCharactersForField(clinic, 50))
    end

    it "Facility/Location" do
      expect(@reminders.getFacilityLabelText()).to eq("Facility/Location:")
      expect(@reminders.verifyMaxCharactersForField(facility, 150)).to eq(true)
    end

    it "Reason" do
      expect(@reminders.getReasonLabelText()).to eq("Reason:")
      expect(@reminders.verifyMaxCharactersForField(reason, 50)).to eq(true)
    end

    it "Phone", :broken => true do
      expect(@reminders.getPhoneLabelText()).to eq("Phone:")
      expect(@reminders.getPhoneGuidanceText()).to eq("(###) ###-####")
    end

    it "Note" do
      expect(@reminders.getNoteLabelText()).to eq("Note:")
      expect(verifyTotalCharacterInNarrative()).to eq(true)
    end

  end

  context 'AC #JRNL-1804 |TC #JRNL-1956: Notification Details for Appointment Reminder' do
    it "Notification Lable and Radio Buttons" do
      expect(@reminders.getNotificationLabelText()).to eq("Notification:")
      expect(@reminders.isOnRadioVisible()).to eq(true)
      expect(@reminders.isOffRadioVisible()).to eq(true)
    end

    it "Notify me label and Checkbox verification" do
      @screening.selectNotificationStatus("On")
      #Verify the Notify Label
      expect(@screening.getNotifyMeLabel()).to eq("* Notify Me About This Appointment:")
      #Verify that four checkboxes are present
      verifyThisCheckboxPresentAndVisible("On the date", true)
      verifyThisCheckboxPresentAndVisible("1 day before", true)
      verifyThisCheckboxPresentAndVisible("2 weeks before", true)
      verifyThisCheckboxPresentAndVisible("4 weeks before", true)

      #VErify that four checkboxes are disabled when Next Due Date = null
      verifyThisCheckboxIsDisabled("On the date", true)
      verifyThisCheckboxIsDisabled("1 day before", true)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)
    end

    it "When notification status is on, notify me checkboxes are enabled/disabled based on Next Due Date; Also verify error handling upon save" do
      today = getDateNthDaysFromNow(0, "%m/%d/%Y")
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      the3rdDay = getDateNthDaysFromNow(2, "%m/%d/%Y")
      the15thDay = getDateNthDaysFromNow(14, "%m/%d/%Y")
      the16thDay = getDateNthDaysFromNow(15, "%m/%d/%Y")
      the29thDay = getDateNthDaysFromNow(28, "%m/%d/%Y")
      the30theDay = getDateNthDaysFromNow(29, "%m/%d/%Y")

      #When NDD = today, all checkboxes are disabled
      setDate(today, "date-control[label='Appointment Date'] input")
      setTime("11:45 AM", "time-control[label='Appointment Time'] input")
      verifyThisCheckboxIsDisabled("On the date", true)
      verifyThisCheckboxIsDisabled("1 day before", true)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      @screening.clickConfirmSaveButton
      #Verify error messages are displayed at the top of the screen
      checkingInlineError("Notifications cannot be provided for the Appointment Date you entered. Turn the Notification off to save the reminder.", 0)

      #Set Status to Off then Save
      @screening.selectNotificationStatus("Off")
      @reminders.setClinicName("Abc Hospital")

      @screening.clickConfirmSaveButton
      !45.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")

      @reminders.clickAddEntryButton()
      !45.times{ break if(@reminders.getPrimaryHeader() == "Add Appointment Reminder"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Add Appointment Reminder")

      @screening.selectNotificationStatus("On")

      #When NDD = tomorrow, 3 checkboxes are disabled, one is enabled
      setDate(tomorrow, "date-control[label='Appointment Date'] input")
      setTime("11:45 AM", "time-control[label='Appointment Time'] input")
      @reminders.setClinicName("Inova Hospital")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", true)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      #When NDD = the3rdDay, 2w, 4w disabled; On the date, 1 day before enabled
      setDate(the3rdDay, "date-control[label='Appointment Date'] input")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", false)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      #When NDD = the15thDay, 2w, 4w disabled; On the date, 1 day before enabled
      setDate(the15thDay, "date-control[label='Appointment Date'] input")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", false)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      #When NDD = the16thDay, 4w disabled; On the date, 1 day before, 2w enabled
      setDate(the16thDay, "date-control[label='Appointment Date'] input")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", false)
      verifyThisCheckboxIsDisabled("2 weeks before", false)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      #When NDD = the29thDay, 2w, 4w disabled; On the date, 1 day before enabled
      setDate(the29thDay, "date-control[label='Appointment Date'] input")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", false)
      verifyThisCheckboxIsDisabled("2 weeks before", false)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      #When NDD = the30theDay, all enabled
      setDate(the30theDay, "date-control[label='Appointment Date'] input")
      verifyThisCheckboxIsDisabled("On the date", false)
      verifyThisCheckboxIsDisabled("1 day before", false)
      verifyThisCheckboxIsDisabled("2 weeks before", false)
      verifyThisCheckboxIsDisabled("4 weeks before", false)

      #Check all four checkboxes
      @screening.clickNotificationDeliveryCheckBox("On the date")
      @screening.clickNotificationDeliveryCheckBox("1 day before")
      @screening.clickNotificationDeliveryCheckBox("2 weeks before")
      @screening.clickNotificationDeliveryCheckBox("4 weeks before")

      @screening.selectNotificationStatus("Off")
      #Verify that all four checkboxes unchecked
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate")).to eq(false)
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "1 day before", "notificationTriggerDate")).to eq(false)
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "2 weeks before", "notificationTriggerDate")).to eq(false)
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "4 weeks before", "notificationTriggerDate")).to eq(false)
      #And they are all disabled too
      verifyThisCheckboxIsDisabled("On the date", true)
      verifyThisCheckboxIsDisabled("1 day before", true)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)

      #Set NDD = today, then select status = On
      setDate(today, "date-control[label='Appointment Date'] input")
      @screening.selectNotificationStatus("On")
      #Verify that all four checkboxes are still unchecked
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "On the date", "notificationTriggerDate")).to eq(false)
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "1 day before", "notificationTriggerDate")).to eq(false)
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "2 weeks before", "notificationTriggerDate")).to eq(false)
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "4 weeks before", "notificationTriggerDate")).to eq(false)
      #And they are all disabled too
      verifyThisCheckboxIsDisabled("On the date", true)
      verifyThisCheckboxIsDisabled("1 day before", true)
      verifyThisCheckboxIsDisabled("2 weeks before", true)
      verifyThisCheckboxIsDisabled("4 weeks before", true)
    end

    it "Verify that when user does not have an email in the system the Notification fields - Notification Method are displayed according to acceptance criteria" do
      #Verify the Notification Method
      #In app is checked as default
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)
      #Email is disabled since this user does not have email provided
      expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(true)
      #Verify that the text is displayed when email is not available
      expect(@screening.getEmailFromNotification()).to eq("Email address has not been saved")
      #Verify the instructional text is displayed
      expect(@screening.getInstructionalTextWhenEmailIsNotAvailable()).to eq("You may update your Preferred Email address in the Notification feature by selecting the notification settings icon")
    end

    it "Verify that when user has an email in the system the Notification fields - Notification Method are displayed according to acceptance criteria", :broken => true do
      @screening.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")

      #Set the email to the user
      @common.navigateToNotificationSettingAndSetOrRemoveEmail("adil.vohra@agilex.com")

      #Returning to Reminder Detail
      waitForPageToFinishLoading
      @main.clickNavMenu
      @navMenu.clickReminders
      @screening.clickAppointments
      @appointments.clickAddEntryButton
      expect(@reminders.getPrimaryHeader()).to eq("Add Appointment Reminder")

      @screening.selectNotificationStatus("On")
      #In app is checked as default
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")).to eq(true)
      #Email is enabled since this user has an email provided
      expect(isThisElementDisabled(:css, "input[name='notificationDelivery'][value='Email']")).to eq(false)
      #Verify that the email address is displayed in the edit box
      expect(@screening.getEmailFromNotification()).to eq("adil.vohra@agilex.com")

      # unCheck the In-App option
      @screening.clickNotificationDeliveryCheckBox("In-App")
      # Check the Email option
      @screening.clickNotificationDeliveryCheckBox("Email")
      #Provide values to Next Due Date
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      setDate(tomorrow, "date-control[label='Appointment Date'] input")
      setTime("11:45 AM", "time-control[label='Appointment Time'] input")
      @reminders.setClinicName("Inova Hospital")

      #Check On the date checkbox from Notify Me
      @screening.clickNotificationDeliveryCheckBox("On the date")

      @screening.clickSaveButton()
      !45.times{ break if (getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Appointment Reminders")
      !45.times{ break if (@screening.getTableViewHeader() == "Provider"); sleep 1 }
      expect(@screening.getTableViewHeader()).to eq("Provider")

      #Navigate to the Notification Setting screen to remove the email address
      @common.navigateToNotificationSettingAndSetOrRemoveEmail("")
      !45.times{ break if (@modal.getTopLayerModalConfirmationHeading() == "Warning"); sleep 1 }
      expect(@modal.getTopLayerModalConfirmationHeading()).to eq("Warning")

      @modal.clickSaveButton()  #this is equivalent to click Save
      !45.times{ break if (@modal.isConfirmationPopUpNotPresent()); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      #Return to Reminder Detail
      waitForPageToFinishLoading
      @main.clickNavMenu
      @navMenu.clickReminders
      @screening.clickAppointments
      @appointments.clickAddEntryButton
      expect(@reminders.getPrimaryHeader()).to eq("Add Appointment Reminder")

      setDate(tomorrow, "date-control[label='Appointment Date'] input")
      setTime("01:00 PM", "time-control[label='Appointment Time'] input")
      @reminders.setClinicName("Sterling Hospital")

      #Verify that now the Notification Status is set to Off and email checkbox is unchecked
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Off", "notificationOption")).to eq(true)
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(false)
      #Turn the Status to On and check In-App checkbox
      @screening.selectNotificationStatus("On")
      @screening.clickNotificationDeliveryCheckBox("On the date")

      @screening.clickSaveButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")

      #Navigate to Notification Settings and provide an email address
      @common.navigateToNotificationSettingAndSetOrRemoveEmail("adil.vohra@agilex.com")

      #Return to Reminder Detail
      waitForPageToFinishLoading
      @main.clickNavMenu
      @navMenu.clickReminders
      @screening.clickAppointments
      @appointments.clickAddEntryButton
      expect(@reminders.getPrimaryHeader()).to eq("Add Appointment Reminder")

      #Verify that email return to the edit box, but email checkbox is NOT checked automatically. User has to elect to check it
      expect(@screening.getEmailFromNotification()).to eq("adil.vohra@agilex.com")
      expect(isThisRadioButtonOrCheckBoxSelected("checkbox", "Email", "notificationDelivery")).to eq(false)
    end

  end

  context 'AC #JRNL-1802 |TC #JRNL-1956: Save and Cancel Options Available in Add Mode' do

    it "Save and Cancel Options" do
      waitForPageToFinishLoading
      expect(@reminders.isSaveButtonVisible()).to eq(true)
      expect(@reminders.isCancelButtonVisible()).to eq(true)
    end

  end

  context 'AC #JRNL-1801 |TC #JRNL-1956: Edit and Entry for Appointment Reminder' do

    it "Editing a reminder", :broken => true do
      @reminders.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")

      clickNthRow(2)
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Reminder"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Reminder")

      #Changing Clinic Name and Saving and Verifying
      @reminders.setClinicName("Fairfax Hospital")
      waitForPageToFinishLoading
      @reminders.clickConfirmSaveButton
      !45.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")
      !45.times{ break if (@screening.getTableViewHeader() == "Provider"); sleep 1 }
      expect(@screening.getTableViewHeader()).to eq("Provider")

      expect(getTextForRowColumn(2,1)).to eq("Fairfax Hospital")
    end

  end

  context 'AC #JRNL-1800 |TC #JRNL-1956: Cancel and Delete Appointment Reminder' do

    it "Cancelling an Appointment Reminder", :broken => true do
      #Selecting a Record from the table
      clickNthRow(2)
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Reminder"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Reminder")

      @reminders.setClinicName("New Hospital")
      waitForPageToFinishLoading
      @reminders.clickCancelButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")
      !45.times{ break if (@screening.getTableViewHeader() == "Provider"); sleep 1 }
      expect(@screening.getTableViewHeader()).to eq("Provider")

      #Verifying Nothing Changed
      expect(getCount()).to eq(3)
      expect(getTextForRowColumn(2,1)).to eq("Fairfax Hospital")
    end

    it "Deleting an Appointment Reminder", :broken => true do
      clickNthRow(2)
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Reminder"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Reminder")
      !30.times{ break if(isElementPresentAndVisible(:css, "form[name='entryForm']")); sleep 1 }
      expect(isElementPresentAndVisible(:css, "form[name='entryForm']")).to eq(true)

      expect(@reminders.isDeleteButtonVisible()).to eq(true)
      waitForPageToFinishLoading
      @reminders.clickDeleteButton()
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")

      @modal.clickNoButton()
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Reminder"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Reminder")
      waitForPageToFinishLoading
      @reminders.clickDeleteButton()
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")

      @modal.clickYesButton()
      !45.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
      expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")
      !45.times{ break if (@screening.getTableViewHeader() == "Provider"); sleep 1 }
      expect(@screening.getTableViewHeader()).to eq("Provider")

      expect(getCount()).to eq(2)
    end

  end

  #######################
  ### Local Functions ###
  #######################
  def checkingInlineError(errMsg, seqNum)
    # Verify error message header
    if seqNum == 0 then
      !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("entryForm")).to eq("The following errors were found:")
    end
    # Verify the error message
    expect(@error.isErrorMessageDisplayed("entryForm", errMsg)).to eq(true)
  end

  def verifyThisCheckboxPresentAndVisible(value, trueOrFalse)
    expect(isElementPresentAndVisible(:css, "input[type='checkbox'][value='" + value + "']")).to eq(trueOrFalse)
  end

  def verifyThisCheckboxIsDisabled(value, trueOrFalse)
    expect(isThisElementDisabled(:css, "input[type='checkbox'][value='" + value + "']")).to eq(trueOrFalse)
  end

end
=end