require_relative '../../globalized'
include Globalized

describe "Story# JRNL-2525: [Reminders_Group_Navigation_JRNL_2525_spec.rb]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    quitDriver()
  end

  it "AC#JRNL-3139,3141|TC#JRNL-2009: Medication Reminders group navigation; Medication Reminders default display", :broken => true do

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getTitle() == "My Reminders"); sleep 1 }

    #Verify the group navigation header
    expect(@reminders.getSecondaryHeader()).to eq("My Reminders")
    #Verify the Table View header
    expect(@reminders.getPrimaryHeader()).to eq("My Reminders")

    #Verify that when there are records in the list, the default message displayed as follow

    !45.times{ break if (@reminders.getDefaultMsg() == "Select an item from the Reminders list to view details or add a new Reminder entry."); sleep 1 }
    expect(@reminders.getDefaultMsg()).to eq("Select an item from the Reminders list to view details or add a new Reminder entry.")

    #Verify Reminder group navigation options are available
    expect(@reminders.isThisReminderGroupAvailableAndDisplayedInRightOrder(1, "Appointments")).to eq(true)
    expect(@reminders.isThisReminderGroupAvailableAndDisplayedInRightOrder(2, "Medications")).to eq(true)
    expect(@reminders.isThisReminderGroupAvailableAndDisplayedInRightOrder(3, "Preventive Services")).to eq(true)
    expect(@reminders.isThisReminderGroupAvailableAndDisplayedInRightOrder(4, "Other")).to eq(true)

    #Click on each group
    @reminders.clickSubGroup("appointments")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Appointment Reminders"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Appointment Reminders")

    @reminders.clickSubGroup("medications")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Medication Reminders"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Medication Reminders")

    puts "Story JRNL-1303|AC JRNL-1228|TC JRNL-1212: Update Preventive Services Headers"
    @reminders.clickSubGroup("preventive-services")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Preventive Services")

    @reminders.clickSubGroup("other")
    !45.times{ break if (@reminders.getPrimaryHeader() == "Other Reminders"); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq("Other Reminders")

  end


end