require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1773: Occupational History List View and Filter]", :regression => true  do

  before(:all) do
    @FILTER_EXPANDED = [
        "* required field",
        "Event Title",
        "50 character maximum",
        "Event Date:",
        "* Start Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* End Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Filter Reset"
    ]

    @FILTER_COLLAPSED = []

    initializeConfigurations(BASE_URL)
    resetCollection("occupationhistory", "personalhistorydb", "occupationalHistory")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyProfile()
    !45.times{ break if (getSecondaryHeader() == "My Profile"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Profile")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1771|TC JRNL-1673: Sub Feature Selection" do

    it "Visible" do
      expect(@nav_menu.isNavVisible("OccupationalHistory")).to eq(true)
    end

    it "Label" do
      expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["OccupationalHistory"]["navButton"])).to eq("Military/Occupational History")
    end

    it "Location" do
      expect(@nav_menu.getNthSubFeatureName(2)).to eq("Military/Occupational History")
      expect(@nav_menu.getNthSubFeatureName(1)).to eq("My Contact Information")
    end
    
  end

  describe "AC JRNL-1770|TC JRNL-1673: Sub Feature Default View (Filter and Table List)" do

    it "Header" do
      @nav_menu.click(:css, Nav_menu::NAV["OccupationalHistory"]["navButton"])
      !45.times{ break if (getPrimaryHeader() == "Military/Occupational History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Military/Occupational History")
    end

    it "Focus" do
      expect(getFocusedElementText()).to eq("Military/Occupational History")
    end

    it "Content - Filter expanded", :broken => true do
      occupationalHistoryFilterScreen = @occupational_history_filter.getScreenContent().split("\n")
      @FILTER_EXPANDED.each_with_index do | expectedScreenRow, i |
        expect(occupationalHistoryFilterScreen[i]).to eq(expectedScreenRow)
      end
    end
    
    it "Filter defaults", :broken => true do
      expect(@occupational_history_filter.isFilterAccordionExpanded()).to be(true)
      expect(@occupational_history_filter.getFilterAccordionTitle()).to eq("Collapse filter options")

      @occupational_history_filter.clickFilterAccordion()
      sleep 1
      expect(@occupational_history_filter.isFilterAccordionExpanded()).to be(false)
      expect(@occupational_history_filter.getFilterAccordionTitle()).to eq("Expand filter options")

      @occupational_history_filter.clickFilterAccordion()
      sleep 1
      expect(getLongFieldLabel("startDate")).to eq("* Start Date:")
      expect(getLongFieldLabel("endDate")).to eq("* End Date:")

      expect(getPlaceHolderByCSS(:css, Occupational_History_Filter::START_DATE)).to eq("MM/DD/YYYY")
      expect(getPlaceHolderByCSS(:css, Occupational_History_Filter::END_DATE)).to eq("MM/DD/YYYY")
    end

    it "Content (Filter Collapsed)", :broken => true do
      @occupational_history_filter.clickFilterAccordion()

      occupationalHistoryFilterScreen = @occupational_history_filter.getScreenContent().split("\n")
      @FILTER_COLLAPSED.each_with_index do | expectedScreenRow, i |
        expect(occupationalHistoryFilterScreen[i]).to eq(expectedScreenRow)
      end
    end

    it "Filter Button", :broken => true do
      @occupational_history_filter.clickFilterAccordion()
      sleep 1
      expect(@occupational_history_filter.getFilterButtonLabel()).to eq("Filter")
    end

    describe "Filter Options" do

      it "Event Title" do
        expect(@occupational_history_filter.getTextFromInput(:css, Occupational_History_Filter::EVENT_TITLE)).to eq("")
        expect(@occupational_history_filter.isFieldRequired(:css, Occupational_History_Filter::EVENT_TITLE)).to eq(false)
        @occupational_history_filter.setInput(Occupational_History_Filter::EVENT_TITLE, "Over50CharactersOver50CharactersOver50CharactersOver50Characters")
        expect(@occupational_history_filter.getTextFromInput(:css, Occupational_History_Filter::EVENT_TITLE)).to eq("Over50CharactersOver50CharactersOver50CharactersOv")
        expect(@occupational_history_filter.getTextFromInput(:css, Occupational_History_Filter::EVENT_TITLE).length()).to eq(50)
      end

      it "Start Date" do
        nowDate = Time.new()
        thenDate = Time.new(nowDate.year() - 5, nowDate.month(), nowDate.day())

        expect(@occupational_history_filter.getTextFromInput(:css, Occupational_History_Filter::START_DATE)).to eq(thenDate.strftime("%m/%d/%Y"))
        expect(@occupational_history_filter.isFieldRequired(:css, Occupational_History_Filter::START_DATE)).to eq(true)
      end

      it "End Date" do
        now = Time.new()

        expect(@occupational_history_filter.getTextFromInput(:css, Occupational_History_Filter::END_DATE)).to eq(now.strftime("%m/%d/%Y"))
        expect(@occupational_history_filter.isFieldRequired(:css, Occupational_History_Filter::END_DATE)).to eq(true)
      end

      it "Date Validation" do
        expectedValidationSummaryHeader = "The following errors were found:"

        @occupational_history_filter.setInput(Occupational_History_Filter::START_DATE, "")
        @occupational_history_filter.setInput(Occupational_History_Filter::END_DATE, "")

        @occupational_history_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(false)

        @occupational_history_filter.setInput(Occupational_History_Filter::START_DATE, "12")
        @occupational_history_filter.setInput(Occupational_History_Filter::END_DATE, "12")

        @occupational_history_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(false)

        @occupational_history_filter.setInput(Occupational_History_Filter::START_DATE, "12/12/2013")
        @occupational_history_filter.setInput(Occupational_History_Filter::END_DATE, "12/12/2012")

        @occupational_history_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "End Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(true)
      end

    end

  end

  describe "AC JRNL-1769|TC JRNL-1673: Filter Action and Results Display" do

    it "Table headers", :broken => true do
      expect(getTableHeaders()).to eq(["Event Title", "Event Date"])
    end

    describe "If records are found entries are displayed in a table format" do

      it "sorted reverse chronological, then by title alphabetically", :broken => true do
        @occupational_history_filter.setInput(Occupational_History_Filter::EVENT_TITLE, "")
        @occupational_history_filter.setDateRangeAndFilter("01/01/2000", "10/30/2014")

        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("Event Title")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq(getTextForRow(1) + " ")
        expect(getCount()).to eq(9)

        verifyList(getList(), getFilteredList("2000-01-01", "2014-10-30", ""))
      end

      it "initial character title match", :broken => true do
        @occupational_history_filter.setInput(Occupational_History_Filter::EVENT_TITLE, "F")

        @occupational_history_filter.clickFilterBtn()
        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("Event Title")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq(getTextForRow(1) + " ")
        expect(getCount()).to eq(3)

        verifyList(getList(), getFilteredList("2000-01-01", "2014-10-30", "F"))
      end

      it "initial partial title match", :broken => true do
        @occupational_history_filter.setInput(Occupational_History_Filter::EVENT_TITLE, "Fir")

        @occupational_history_filter.clickFilterBtn()
        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("Event Title")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq(getTextForRow(1) + " ")
        expect(getCount()).to eq(2)

        verifyList(getList(), getFilteredList("2000-01-01", "2014-10-30", "Fir"))
      end

      it "internal title match", :broken => true do
        @occupational_history_filter.setInput(Occupational_History_Filter::EVENT_TITLE, "l")

        @occupational_history_filter.clickFilterBtn()
        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("Event Title")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq(getTextForRow(1) + " ")
        expect(getCount()).to eq(2)

        verifyList(getList(), getFilteredList("2000-01-01", "2014-10-30", "l"))
      end

      it "end character title match", :broken => true do
        @occupational_history_filter.setInput(Occupational_History_Filter::EVENT_TITLE, "nt")

        @occupational_history_filter.clickFilterBtn()
        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("Event Title")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq(getTextForRow(1) + " ")
        expect(getCount()).to eq(3)

        verifyList(getList(), getFilteredList("2000-01-01", "2014-10-30", "nt"))
      end

      it "special character match", :broken => true do
        @occupational_history_filter.setInput(Occupational_History_Filter::EVENT_TITLE, "A%")
        @occupational_history_filter.setFromDate("01/01/1990")

        @occupational_history_filter.clickFilterBtn()
        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("Event Title")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq(getTextForRow(1) + " ")
        expect(getCount()).to eq(1)

        verifyList(getList(), getFilteredList("1990-01-01", "2014-10-30", "A%"))
      end

      it "case insensitive", :broken => true do
        @occupational_history_filter.setInput(Occupational_History_Filter::EVENT_TITLE, "helping")

        @occupational_history_filter.clickFilterBtn()
        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("Event Title")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq(getTextForRow(1) + " ")
        expect(getCount()).to eq(1)

        verifyList(getList(), getFilteredList("1990-01-01", "2014-10-30", "helping"))
      end

      it "exact match", :broken => true do
        @occupational_history_filter.setInput(Occupational_History_Filter::EVENT_TITLE, "Submarine Experience")

        @occupational_history_filter.clickFilterBtn()
        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("Event Title")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq(getTextForRow(1) + " ")
        expect(getCount()).to eq(2)

        verifyList(getList(), getFilteredList("1990-01-01", "2014-10-30", "Submarine Experience"))
      end

      it "event date within filter range", :broken => true do
        @occupational_history_filter.setInput(Occupational_History_Filter::EVENT_TITLE, "")
        @occupational_history_filter.setFromDate("01/01/2013")

        @occupational_history_filter.clickFilterBtn()
        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("Event Title")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq(getTextForRow(1) + " ")
        expect(getCount()).to eq(3)

        verifyList(getList(), getFilteredList("2013-01-01", "2014-10-30", ""))
      end

      it "event date equal to start date filter", :broken => true do
        @occupational_history_filter.setFromDate("10/30/2013")

        @occupational_history_filter.clickFilterBtn()
        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("Event Title")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq(getTextForRow(1) + " ")
        expect(getCount()).to eq(3)

        verifyList(getList(), getFilteredList("2013-10-30", "2014-10-30", ""))
      end

      it "event date equal to end date filter", :broken => true do
        @occupational_history_filter.setEndDate("01/01/2014")

        @occupational_history_filter.clickFilterBtn()
        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("Event Title")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq(getTextForRow(1) + " ")
        expect(getCount()).to eq(3)

        verifyList(getList(), getFilteredList("2013-10-30", "2014-01-01", ""))
      end

      it "no results found", :broken => true do
        @occupational_history_filter.setInput(Occupational_History_Filter::EVENT_TITLE, "xyz")

        @occupational_history_filter.clickFilterBtn()
        !10.times{ break if (@occupational_history_filter.getFocusedElementText().include?("No results")); sleep 1 }
        expect(@occupational_history_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        expect(getCount()).to eq(0)

        verifyList(getList(), getFilteredList("2013-10-30", "2014-01-01", "xyz"))
      end

    end

    describe "Story JRNL-1696|AC JRNL-1583: Reset Button" do

      it "Present" do
        expect(@occupational_history_filter.isResetButtonPresent()).to eq(true)
      end

      it "Label" do
        expect(@occupational_history_filter.getResetButtonLabel()).to eq("Reset")
      end

      it "Result" do
        nowDate = Time.new()
        thenDate = Time.new(nowDate.year() - 5, nowDate.month(), nowDate.day())

        @occupational_history_filter.clickResetBtn()
        !10.times {
          break if (@occupational_history_filter.getFocusedElementText().include?("Event Title"));
          break if (@occupational_history_filter.getFocusedElementText().include?("No results"));
          sleep 1
        }
        verifyList(getList(), getFilteredList(thenDate.strftime("%Y-%m-%d"), nowDate.strftime("%Y-%m-%d"), ""))

        # DEFAULTS
        expect(@occupational_history_filter.getTextFromInput(:css, Occupational_History_Filter::START_DATE)).to eq(thenDate.strftime("%m/%d/%Y"))
        expect(@occupational_history_filter.getTextFromInput(:css, Occupational_History_Filter::END_DATE)).to eq(nowDate.strftime("%m/%d/%Y"))
        expect(@occupational_history_filter.getTextFromInput(:css, Occupational_History_Filter::EVENT_TITLE)).to eq("")
      end

    end

  end

  #######################
  ### Local Functions ###
  #######################

  def getAllRecordsInDBSorted
    def sortByKeys(x,y)
      if x["startDate"].strftime('%Y%m%d') == y["startDate"].strftime('%Y%m%d')
        return x["eventTitle"].upcase() <=> y["eventTitle"].upcase()
      end
      return y["startDate"].strftime('%Y%m%d') <=> x["startDate"].strftime('%Y%m%d')
    end

    return retreiveAllDocumentsInCollection("occupationhistory", "personalhistorydb").sort { |x, y| sortByKeys(x,y) }
  end

  def getFilteredList(startDate, endDate, title)
    dateMatch = []
    titleMatch = []
    getAllRecordsInDBSorted.each_with_index do |event, i|
      if event["startDate"].strftime('%Y%m%d') >= Date.parse(startDate).strftime('%Y%m%d') && event["startDate"].strftime('%Y%m%d') <= Date.parse(endDate).strftime('%Y%m%d')
        dateMatch << event
      end

      if title != "" && event["eventTitle"].upcase().include?(title.upcase())
        titleMatch << event
      end
    end

    return (dateMatch & titleMatch)
  end

  def verifyList(screenList, dbList)
    dbList.each_with_index do |dbrow, i|
      screenRow = screenList[i].text.split("\n")
      expect(screenRow[1].strip).to eq(dbrow["eventTitle"])
      expect(screenRow[3].strip).to eq(dbrow["startDate"].strftime('%m/%d/%Y'))
    end
  end

end
