require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1772: Occupational History - Edit/Delete/Nav]", :broken => true, :regression => true do

  before(:all) do

    @ENTRY_FORM_1 = [
        "* required field",
        "",
        "* Event Title:",
        "50 character maximum",
        "* Event Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Branch of Service:",
        "Location of Service:",
        "Assignment (unit, location, activity):",
        "150 character maximum",
        "Event Details: Injury, Exposure and Military Service",
        "Please select one or more of the options below to enter details about your event.",
        "",
        "Injury/Illness:",
        "Yes",
        "No",
        "* Record details about your injury/illness:",
        "1000 character maximum",
        "991 characters left",
        "Exposure:",
        "Yes",
        "No",
        "* Record details about your exposure:",
        "1000 character maximum",
        "989 characters left",
        "Military Service:",
        "Yes",
        "No",
        "* Describe your military service related to this event:",
        "1000 character maximum",
        "981 characters left",
        "Save Delete Cancel"
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("occupationhistory", "personalhistorydb", "occupationalHistory")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickMyProfile()
    !45.times{ break if (getPrimaryHeader() == "My Profile"); sleep 1 }
    expect(getPrimaryHeader()).to eq("My Profile")

    @navMenu.click(:css, Nav_menu::NAV["OccupationalHistory"]["navButton"])
    !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
    expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

    @numberOfRecords = 9

    expect(getCount()).to eq(@numberOfRecords)

    @occupationalHistoryFirstCount = retreiveAllDocumentsInCollection("occupationhistory", "personalhistorydb").length
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1687|TC JRNL-1652: When the user selects a Military/Occupational History entry from the table view" do

    it "The system displays the Military/Occupational History record in the Detail screen in Edit mode" do
      clickNthRow(1)
      !45.times{ break if( @occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1}
      expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)
    end

    it "All values previously field values saved are visible" do
      expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::INJURY)).to eq("My Injury")
      expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_DATE)).to eq("01/01/2014")
      expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_BRANCH)).to eq("Select")
      expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_LOCATION)).to eq("Overseas")
      expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::ASSIGNMENT)).to eq ("Classified")
      expect(@occupationalHistory.isInputChecked(OccupationalHistory::INJURY_FLAG_YES)).to eq(true)
      expect(@occupationalHistory.isInputChecked(OccupationalHistory::INJURY_FLAG_NO)).to eq(false)
      expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::INJURY)).to eq("My Injury")
      expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::INJURY_CHARACTER_COUNTER)).to eq("991 characters left")
      expect(@occupationalHistory.isInputChecked(OccupationalHistory::EXPOSURE_FLAG_YES)).to eq(true)
      expect(@occupationalHistory.isInputChecked(OccupationalHistory::EXPOSURE_FLAG_NO)).to eq(false)
      expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EXPOSURE)).to eq("My Exposure")
      expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::EXPOSURE_CHARACTER_COUNTER)).to eq("989 characters left")
      expect(@occupationalHistory.isInputChecked(OccupationalHistory::MILITARY_FLAG_YES)).to eq(true)
      expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::MILITARY_SERVICE)).to eq("My Military Service")
      expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::MILITARY_SERVICE_CHARACTER_COUNTER)).to eq("981 characters left")
    end

    describe "All fields displayed in the Add mode are available in the Edit mode" do

      it "Detail screen" do
        expect(@occupationalHistory.isElementVisible(:css, OccupationalHistory::INJURY_FLAG_YES)).to eq(true)
        expect(@occupationalHistory.isElementVisible(:css, OccupationalHistory::INJURY)).to eq(true)
        expect(@occupationalHistory.isElementVisible(:css, OccupationalHistory::EXPOSURE_FLAG_YES)).to eq(true)
        expect(@occupationalHistory.isElementVisible(:css, OccupationalHistory::EXPOSURE)).to eq(true)

        @form = @occupationalHistory.stripSelectTextFromScreen(
            @occupationalHistory.getScreenContent().split("\n"),
            ['serviceBranch', 'serviceLocation']
        )

        @ENTRY_FORM_1.each_with_index do | expectedScreenRow, i |
          expect(@form[i]).to eq(expectedScreenRow)
        end

        serviceBranches = ["Select", "Air Force", "Army", "Coast Guard", "Marine", "Navy", "Public Health", "Other"]

        @occupationalHistory.getElements(:css, OccupationalHistory::SERVICE_BRANCH + " option").each_with_index do | content, i |
          expect(content.text()).to eq(serviceBranches[i])
        end

        serviceLocations = ["Select", "CONUS", "Overseas", "Shipboard"]

        @occupationalHistory.getElements(:css, OccupationalHistory::SERVICE_LOCATION + " option").each_with_index do | content, i |
          expect(content.text()).to eq(serviceLocations[i])
        end
      end

      it "Required" do
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::EVENT_TITLE)).to eq(true)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::EVENT_DATE)).to eq(true)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::SERVICE_BRANCH)).to eq(false)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::SERVICE_LOCATION)).to eq(false)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::ASSIGNMENT)).to eq(false)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::INJURY_FLAG_YES)).to eq(false)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::INJURY_FLAG_NO)).to eq(false)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::INJURY)).to eq(true)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::EXPOSURE_FLAG_YES)).to eq(false)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::EXPOSURE_FLAG_NO)).to eq(false)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::EXPOSURE)).to eq(true)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::MILITARY_FLAG_YES)).to eq(false)
        expect(@occupationalHistory.isFieldRequired(:css, OccupationalHistory::MILITARY_FLAG_NO)).to eq(false)
      end

      it "Error Messages" do
        expectedValidationSummaryHeader = "The following errors were found:"

        @occupationalHistory.setInput(OccupationalHistory::EVENT_TITLE, "")
        @occupationalHistory.setInput(OccupationalHistory::EVENT_DATE, "")
        @occupationalHistory.click(:css, OccupationalHistory::MILITARY_FLAG_YES)
        @occupationalHistory.setInput(OccupationalHistory::INJURY, "")
        @occupationalHistory.setInput(OccupationalHistory::EXPOSURE,"")
        @occupationalHistory.setInput(OccupationalHistory::MILITARY_SERVICE,"")

        @occupationalHistory.clickSaveButton()
        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Event Title field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Event Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Event Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Record details about your injury/illness field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Record details about your exposure field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Describe your military service related to this event field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "You must answer 'yes' to at least one of the Event Detail questions and provide the related event information in order to save your entry.")).to eq(false)

        @occupationalHistory.setInput(OccupationalHistory::EVENT_TITLE, "Big Event")
        @occupationalHistory.setInput(OccupationalHistory::EVENT_DATE, "11/01")
        @occupationalHistory.click(:css, OccupationalHistory::INJURY_FLAG_NO)
        @occupationalHistory.click(:css, OccupationalHistory::EXPOSURE_FLAG_NO)
        @occupationalHistory.click(:css, OccupationalHistory::MILITARY_FLAG_NO)

        @occupationalHistory.clickSaveButton()
        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Event Title field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Event Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Event Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Record details about your injury/illness field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Record details about your exposure field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Describe your military service related to this event field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "You must answer 'yes' to at least one of the Event Detail questions and provide the related event information in order to save your entry.")).to eq(true)
      end

    end

    describe "AC JRNL-1686|TC JRNL-1652: Standard Edit functions are available" do

      it "Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        expect(@occupationalHistory.isCancelButtonVisible()).to eq(true)

        @occupationalHistory.clickCancelButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)

        expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_TITLE)).to eq("Fight")
        expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_DATE)).to eq("01/01/2014")
        expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_BRANCH)).to eq("Select")
        expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_LOCATION)).to eq("Overseas")
        expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::ASSIGNMENT)).to eq ("Classified")
        expect(@occupationalHistory.isInputChecked(OccupationalHistory::INJURY_FLAG_YES)).to eq(true)
        expect(@occupationalHistory.isInputChecked(OccupationalHistory::INJURY_FLAG_NO)).to eq(false)
        expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::INJURY)).to eq("My Injury")
        expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::INJURY_CHARACTER_COUNTER)).to eq("991 characters left")
        expect(@occupationalHistory.isInputChecked(OccupationalHistory::EXPOSURE_FLAG_YES)).to eq(true)
        expect(@occupationalHistory.isInputChecked(OccupationalHistory::EXPOSURE_FLAG_NO)).to eq(false)
        expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EXPOSURE)).to eq("My Exposure")
        expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::EXPOSURE_CHARACTER_COUNTER)).to eq("989 characters left")
        expect(@occupationalHistory.isInputChecked(OccupationalHistory::MILITARY_FLAG_YES)).to eq(true)
        expect(@occupationalHistory.isInputChecked(OccupationalHistory::MILITARY_FLAG_NO)).to eq(false)
        expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::MILITARY_SERVICE_CHARACTER_COUNTER)).to eq("981 characters left")

        expect(@occupationalHistory.isCancelButtonVisible()).to eq(true)

        @occupationalHistory.clickCancelButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

        expect(getCount()).to eq(@numberOfRecords)
      end


      it "Cancel after one field update" do

        clickNthRow(1)
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)
        expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_BRANCH)).to eq("Select")

        @occupationalHistory.setSelectBoxValue(OccupationalHistory::SERVICE_BRANCH, "Air Force")

        @occupationalHistory.clickCancelButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)
        expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_BRANCH)).to eq("Select")

      end

      it "Update" do

        @occupationalHistory.setSelectBoxValue(OccupationalHistory::SERVICE_BRANCH, "Air Force")

        @occupationalHistory.clickSaveButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)
        expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_BRANCH)).to eq("Air Force")

        @occupationalHistory.clickCancelButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)
        expect(getCount()).to eq(@numberOfRecords)

      end

      it "Verify when trying to add, Branch of Service is carried over" do
        @common.clickAddButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::ADD_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::ADD_HEADER)
        expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_BRANCH)).to eq("Air Force")

        @occupationalHistory.clickCancelButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)
        expect(getCount()).to eq(@numberOfRecords)

      end

      it "Delete" do
        clickNthRow(1)
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)
        expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_BRANCH)).to eq("Air Force")

        expect(@occupationalHistory.isDeleteButtonVisible()).to eq(true)

        @occupationalHistory.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickNoButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)
        !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
        expect(@occupationalHistory.getFocusedElementText()).to eq("Delete")

        @occupationalHistory.clickCancelButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)

        @occupationalHistory.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickYesButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

        expect(getCount()).to eq(@numberOfRecords - 1)

        expect(retreiveAllDocumentsInCollection("occupationhistory", "personalhistorydb").length()).to eq(@occupationalHistoryFirstCount)
      end

      it "Check a new record displays the previous record Branch of Service" do
        @common.clickAddButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::ADD_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::ADD_HEADER)
        expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_BRANCH)).to eq("Army")

        @occupationalHistory.clickCancelButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)
        expect(getCount()).to eq(@numberOfRecords - 1)
      end


      describe "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view" do

        it "max" do
          clickNthRow(1)
          !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
          expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)

          expect(@occupationalHistory.isSaveButtonVisible()).to eq(true)

          @occupationalHistory.setInput(OccupationalHistory::EVENT_TITLE, "()*&^%$@!?><.,:;{}[]ABCDEFGHIJKLMNopqrstuvwxyz1234 test should cut this out")
          @occupationalHistory.setInput(OccupationalHistory::EVENT_DATE, "01/01/2014")
          @occupationalHistory.setSelectBoxValue(OccupationalHistory::SERVICE_BRANCH, "Air Force")
          @occupationalHistory.setSelectBoxValue(OccupationalHistory::SERVICE_LOCATION, "CONUS")
          @occupationalHistory.setInput(OccupationalHistory::ASSIGNMENT, "This occupational history's assignment field string is deliberately set to be longer than length of one hundred and fifty characters. The field should truncate the string after the maximum number of characters is reached and display the first substring of this entire string.")
          @occupationalHistory.click(:css, OccupationalHistory::INJURY_FLAG_YES)
          @occupationalHistory.setInput(OccupationalHistory::INJURY,"And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's injury text area a string that is deliberately set to be way longer than the length of a good one thousand characters. This my va health application's my profile module's occupational history's injury text area is then expected to truncate the string after the maximum number of one thousand characters is reached and display a substring that is only the first one thousand characters of this entire string in the my va health application's my profile module's occupational history's injury text area field. I repeat, And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's injury text area a string that is deliberately set to be way longer than the length of a good one thousand characters. This my va health application's my profile module's occupational history's injury text area is then expected to truncate the string after the maximum number of one thousand characters is reached and display a substring that is only the first one thousand characters of this entire string in the my va health application's my profile module's occupational history's injury text area field.")
          expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::INJURY_CHARACTER_COUNTER)).to eq("0 characters left")
          @occupationalHistory.click(:css, OccupationalHistory::EXPOSURE_FLAG_YES)
          @occupationalHistory.setInput(OccupationalHistory::EXPOSURE,"And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's exposure text area a string that is deliberately set to be way longer than the length of a good one thousand characters. This my va health application's my profile module's occupational history's exposure text area is then expected to truncate the string after the maximum number of one thousand characters is reached and display a substring that is only the first one thousand characters of this entire string in the my va health application's my profile module's occupational history's exposure text area field. I repeat, And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's exposure text area a string that is deliberately set to be way longer than the length of a good one thousand characters. This my va health application's my profile module's occupational history's injury text area is then expected to truncate the string after the maximum number of one thousand characters is reached and display a substring that is only the first one thousand characters of this entire string in the my va health application's my profile module's occupational history's exposure text area field.")
          expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::EXPOSURE_CHARACTER_COUNTER)).to eq("0 characters left")
          @occupationalHistory.click(:css, OccupationalHistory::MILITARY_FLAG_YES)
          @occupationalHistory.setInput(OccupationalHistory::MILITARY_SERVICE,"And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's military service text area a string that is deliberately set to be way longer than the length of a good one thousand characters. This my va health application's my profile module's occupational history's military service text area is then expected to truncate the string after the maximum number of one thousand characters is reached and display a substring that is only the first one thousand characters of this entire string in the my va health application's my profile module's occupational history's military service text area field. I repeat, And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's military service text area a string that is deliberately set to be way longer than the length of a good one thousand characters. This my va health application's my profile module's occupational history's military service text area is then expected to truncate the string after the maximum number of one thousand characters is reached and display a substring that is only the first one thousand characters of this entire string in the my va health application's my profile module's occupational history's military service text area field.")
          expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::EXPOSURE_CHARACTER_COUNTER)).to eq("0 characters left")

          @occupationalHistory.clickSaveButton()
          !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
          expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

          expect(getCount()).to eq(@numberOfRecords -1)

          clickNthRow(1)
          !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
          expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)

          expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_TITLE)).to eq("()*&^%$@!?><.,:;{}[]ABCDEFGHIJKLMNopqrstuvwxyz1234")
          expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_DATE)).to eq("01/01/2014")
          expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_BRANCH)).to eq("Air Force")
          expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_LOCATION)).to eq("CONUS")
          expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::ASSIGNMENT)).to eq("This occupational history's assignment field string is deliberately set to be longer than length of one hundred and fifty characters. The field should")
          expect(@occupationalHistory.isInputChecked(OccupationalHistory::INJURY_FLAG_YES)).to eq(true)
          expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::INJURY)).to eq("And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's injury text area a string that is deliberately set to be way longer than the length of a good one thousand characters. This my va health application's my profile module's occupational history's injury text area is then expected to truncate the string after the maximum number of one thousand characters is reached and display a substring that is only the first one thousand characters of this entire string in the my va health application's my profile module's occupational history's injury text area field. I repeat, And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's injury text area a string that is deliberately set to be way longer than the length of a good one thousand characters. This my va health application's my prof")
          expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::INJURY_CHARACTER_COUNTER)).to eq("0 characters left")
          expect(@occupationalHistory.isInputChecked(OccupationalHistory::EXPOSURE_FLAG_YES)).to eq(true)
          expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EXPOSURE)).to eq("And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's exposure text area a string that is deliberately set to be way longer than the length of a good one thousand characters. This my va health application's my profile module's occupational history's exposure text area is then expected to truncate the string after the maximum number of one thousand characters is reached and display a substring that is only the first one thousand characters of this entire string in the my va health application's my profile module's occupational history's exposure text area field. I repeat, And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's exposure text area a string that is deliberately set to be way longer than the length of a good one thousand characters. This my va health application's")
          expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::EXPOSURE_CHARACTER_COUNTER)).to eq("0 characters left")
          expect(@occupationalHistory.isInputChecked(OccupationalHistory::MILITARY_FLAG_YES)).to eq(true)
          expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::MILITARY_SERVICE)).to eq("And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's military service text area a string that is deliberately set to be way longer than the length of a good one thousand characters. This my va health application's my profile module's occupational history's military service text area is then expected to truncate the string after the maximum number of one thousand characters is reached and display a substring that is only the first one thousand characters of this entire string in the my va health application's my profile module's occupational history's military service text area field. I repeat, And now we are intentionally going to try as hard as is humanly possible to enter into this my va health application's my profile module's occupational history's military service text area a string that is deliberately set to be way longer than the length of a good one thousand characters.")
          expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::MILITARY_SERVICE_CHARACTER_COUNTER)).to eq("0 characters left")
        end

        it "min" do
          @occupationalHistory.setInput(OccupationalHistory::EVENT_TITLE, "A")
          @occupationalHistory.setInput(OccupationalHistory::EVENT_DATE, "01/01/2014")
          @occupationalHistory.setSelectBoxValue(OccupationalHistory::SERVICE_BRANCH, "Select")
          @occupationalHistory.setSelectBoxValue(OccupationalHistory::SERVICE_LOCATION, "Select")
          @occupationalHistory.setInput(OccupationalHistory::ASSIGNMENT, "")
          @occupationalHistory.click(:css, OccupationalHistory::INJURY_FLAG_YES)
          @occupationalHistory.setInput(OccupationalHistory::INJURY, "b")
          @occupationalHistory.click(:css, OccupationalHistory::EXPOSURE_FLAG_NO)
          @occupationalHistory.click(:css, OccupationalHistory::MILITARY_FLAG_NO)

          @occupationalHistory.clickSaveButton()
          !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
          expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)

          clickNthRow(1)
          !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
          expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)

          expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_TITLE)).to eq("A")
          expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_DATE)).to eq("01/01/2014")
          expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_BRANCH)).to eq("Select")
          expect(@occupationalHistory.getSelectBoxText(OccupationalHistory::SERVICE_LOCATION)).to eq("Select")
          expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::ASSIGNMENT)).to eq("")
          expect(@occupationalHistory.isInputChecked(OccupationalHistory::INJURY_FLAG_YES)).to eq(true)
          expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::INJURY)).to eq("b")
          expect(@occupationalHistory.getTextForElement(:css, OccupationalHistory::INJURY_CHARACTER_COUNTER)).to eq("999 characters left")
          expect(@occupationalHistory.isInputChecked(OccupationalHistory::EXPOSURE_FLAG_YES)).to eq(false)
          expect(@occupationalHistory.isInputChecked(OccupationalHistory::EXPOSURE_FLAG_NO)).to eq(true)
          expect(@occupationalHistory.isInputChecked(OccupationalHistory::MILITARY_FLAG_YES)).to eq(false)
          expect(@occupationalHistory.isInputChecked(OccupationalHistory::MILITARY_FLAG_NO)).to eq(true)

          @occupationalHistory.clickCancelButton()
          !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
          expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)
        end

      end

    end

    describe "AC MVAH-2772|TC JRNL-1652: Navigation Without Saving" do

      it "If the user tries to navigate away from a detail record where a field has been updated without saving, the user is prompted to confirm that they want to leave the record without saving via a modal" do
        clickNthRow(1)
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)

        expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_TITLE)).to eq("A")
        @occupationalHistory.setInput(OccupationalHistory::EVENT_TITLE, "XYZ")

        @navMenu.click(:css, Nav_menu::NAV["OccupationalHistory"]["navButton"])
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickReturnButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)

        @navMenu.click(:css, Nav_menu::NAV["OccupationalHistory"]["navButton"])
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickContinueButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

        expect(getCount()).to eq(@numberOfRecords - 1)

        clickNthRow(1)
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)

        expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_TITLE)).to eq("A")
      end

      it "Back button" do
        @occupationalHistory.setInput(OccupationalHistory::EVENT_TITLE, "XYZ")

        @occupationalHistory.clickBackButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickReturnButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)

        @occupationalHistory.clickBackButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickContinueButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)

        expect(getCount()).to eq(@numberOfRecords - 1)

        clickNthRow(1)
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::EDIT_HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::EDIT_HEADER)

        expect(@occupationalHistory.getTextFromInput(:css, OccupationalHistory::EVENT_TITLE)).to eq("A")

        @occupationalHistory.clickCancelButton()
        !45.times{ break if (@occupationalHistory.getPrimaryHeader() == OccupationalHistory::HEADER); sleep 1 }
        expect(@occupationalHistory.getPrimaryHeader()).to eq(OccupationalHistory::HEADER)
      end

    end

  end

end
