require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1724: Add 'My Profile' to Left Navigation]", :regression => true do


  before(:all) do
    initializeConfigurations(BASE_URL)

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")
  end

  # after(:all) do
  #   quitDriver()
  # end

  describe "AC JRNL-1718|TC JRNL-1669: When a user opens the Left Panel navigation, the system displays a navigation option for the My Profile feature" do

    it "Visible" do
      @main.clickNavMenu()
      !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      expect(@nav_menu.isElementVisible(:css, Nav_menu::NAV["MyProfile"]["navButton"])).to eq(true)
    end

    it "Label" do
      expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["MyProfile"]["navButton"])).to eq("My Profile")
    end

    it "Location" do
      ## JRNL-1718 AC states the "My Profile" should now be the first nav item. It is now the 2nd as altered by JRNL-3138.
      expect(@nav_menu.getNthOptionName(2)).to eq("My Profile")
    end

    it "Secondary Header" do
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='MyProfile']").click
      waitForPageToFinishLoading
      !5.times{ break if (getSecondaryHeader() == "My Profile"); sleep 1 }
      expect(getSecondaryHeader()).to eq("My Profile")
    end

    it "Primary Header" do
      expect(getPrimaryHeader()).to eq("My Profile")
    end

    it "Default Message" do
      expect(@common.getDefaultMsg()).to eq("Select an item from the My Profile list to view details or add a new entry.")
    end

  end

end
















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1724: Add 'My Profile' to Left Navigation]", :regression => true do


  before(:all) do
    initializeConfigurations(BASE_URL)

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1718|TC JRNL-1669: When a user opens the Left Panel navigation, the system displays a navigation option for the My Profile feature" do

    it "Visible" do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      expect(@nav_menu.isElementVisible(:css, Nav_menu::NAV["MyProfile"]["navButton"])).to eq(true)
    end

    it "Label" do
      expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["MyProfile"]["navButton"])).to eq("My Profile")
    end

    it "Location" do
      ## JRNL-1718 AC states the "My Profile" should now be the first nav item. It is now the 2nd as altered by JRNL-3138.
      expect(@nav_menu.getNthOptionName(2)).to eq("My Profile")
    end

    it "Secondary Header" do
      @nav_menu.clickMyProfile()

      !45.times{ break if (getSecondaryHeader() == "My Profile"); sleep 1 }
      expect(getSecondaryHeader()).to eq("My Profile")
    end

    it "Primary Header" do
      expect(getPrimaryHeader()).to eq("My Profile")
    end

    it "Default Message" do
      expect(@common.getDefaultMsg()).to eq("Select an item from the My Profile list to view details or add a new entry.")
    end

  end

end
=end