require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1753: My Contact Information - Edit/Nav]", :regression => true do

  before(:all) do
    @ENTRY_FORM_1 = [
        "Primary Phone:",
        "Enter 10 digits",
        "Primary Phone Type:",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Add Phone",
        "Email:",
        "100 character maximum",
        "Current Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State:",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Save"
    ]

    @ENTRY_FORM_2 = [
        "Primary Phone:",
        "Enter 10 digits",
        "Primary Phone Type:",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Email:",
        "100 character maximum",
        "Current Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State/Province:",
        "50 character maximum",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Save"
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("demographics", "personalprofiledb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05","patient05, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest");

    @main.clickNavMenu()
    !5.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyProfile']").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader() == "My Profile"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Profile")
  end

  # after(:all) do
  #   quitDriver()
  # end

  describe "AC JRNL-1741|TC JRNL-1655: My Contact Information - Menu" do

    it "Label" do
      expect(@navMenu.getTextForElement(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])).to eq("My Contact Information")
    end

    it "Location" do
      expect(@navMenu.getNthSubFeatureName(1)).to eq("My Contact Information")
    end

    it "Clickable" do
      @navMenu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      !4.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)
    end

  end

  describe "AC JRNL-1697|TC JRNL-1655: My Contact Information - Screen" do

    it "Content (Country = US)" do
    end

    it "Defaults" do
        expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::PRIMARY_PHONE)).to eq("")
        expect(@myContactInformation.getSelectBoxText(MyContactInformation::PRIMARY_PHONE_TYPE)).to eq("Select")
        expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::EMAIL)).to eq("")
        expect(@myContactInformation.getSelectBoxText(MyContactInformation::COUNTRY)).to eq("Australia")
        expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_1)).to eq("")
        expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_2)).to eq("")
        expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::CITY)).to eq("")
        expect(@myContactInformation.getSelectBoxText(MyContactInformation::STATE)).to eq("")
        expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ZIP_POSTAL_CODE)).to eq("")
    end

    it "Primary Phone" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::PRIMARY_PHONE)).to eq(false)
    end

    it "Primary Phone Type" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::PRIMARY_PHONE_TYPE)).to eq(false)
    end

    it "Primary Phone Type Values" do
      phoneTypes = ["Select", "Mobile", "Home", "Work", "Fax"]

      @myContactInformation.getElements(:css, MyContactInformation::PRIMARY_PHONE_TYPE + " option").each_with_index do | content, i |
        expect(content.text()).to eq(phoneTypes[i])
      end
    end

    it "Other Phone 1" do
    end

    it "Other Phone Type 1" do
    end

    it "Other Phone Type 1 Values" do
      phoneTypes = ["Select", "Mobile", "Home", "Work", "Fax"]

      @myContactInformation.getElements(:css, MyContactInformation::OTHER_PHONE_TYPE_1 + " option").each_with_index do | content, i |
        expect(content.text()).to eq(phoneTypes[i])
      end
    end

    it "Other Phone 1 Delete Button" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_1)).to eq(false)
    end

    it "Other Phone 2" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_2)).to eq(false)
    end

    it "Other Phone Type 2" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_2)).to eq(false)
    end

    it "Other Phone 2 Delete Button" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_2)).to eq(false)
    end

    it "Other Phone 3" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_3)).to eq(false)
    end

    it "Other Phone Type 3" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_3)).to eq(false)
    end

    it "Other Phone 3 Delete Button" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_3)).to eq(false)
    end

    it "Other Phone 4" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_4)).to eq(false)
    end

    it "Other Phone Type 4" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_4)).to eq(false)
    end

    it "Other Phone 4 Delete Button" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_4)).to eq(false)
    end

    it "Add Other Phone 2" do
      @myContactInformation.click(:css, MyContactInformation::ADD_PHONE_BUTTON)

      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_1)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_2)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_TYPE_2)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_2)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_3)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_3)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_3)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_4)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_4)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_4)).to eq(false)
    end

    it "Other Phone Type 2 Values" do
      phoneTypes = ["Select", "Mobile", "Home", "Work", "Fax"]

      @myContactInformation.getElements(:css, MyContactInformation::OTHER_PHONE_TYPE_2 + " option").each_with_index do | content, i |
        expect(content.text()).to eq(phoneTypes[i])
      end
    end

    it "Add Other Phone 3" do
      @myContactInformation.click(:css, MyContactInformation::ADD_PHONE_BUTTON)

      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_1)).to eq(true)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_2)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_3)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_TYPE_3)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_3)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_4)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_4)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_4)).to eq(false)
    end

    it "Other Phone Type 3 Values" do
      phoneTypes = ["Select", "Mobile", "Home", "Work", "Fax"]

      @myContactInformation.getElements(:css, MyContactInformation::OTHER_PHONE_TYPE_3 + " option").each_with_index do | content, i |
        expect(content.text()).to eq(phoneTypes[i])
      end
    end

    it "Add Other Phone 4" do
      @myContactInformation.click(:css, MyContactInformation::ADD_PHONE_BUTTON)

      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_1)).to eq(true)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_2)).to eq(true)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_3)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_4)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_TYPE_4)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_4)).to eq(false)
    end

    it "Other Phone Type 4 Values" do
      phoneTypes = ["Select", "Mobile", "Home", "Work", "Fax"]

      @myContactInformation.getElements(:css, MyContactInformation::OTHER_PHONE_TYPE_4 + " option").each_with_index do | content, i |
        expect(content.text()).to eq(phoneTypes[i])
      end
    end

    it "Email" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::EMAIL)).to eq(false)
    end

    it "Country" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::COUNTRY)).to eq(false)
    end

    it "Address Line One" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::ADDRESS_LINE_1)).to eq(false)
    end

    it "Address Line Two" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::ADDRESS_LINE_2)).to eq(false)
    end

    it "City" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::CITY)).to eq(false)
    end

    it "State" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::STATE)).to eq(false)
    end

    it "Zip/Postal Code" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::ZIP_POSTAL_CODE)).to eq(false)
    end

    it "State/Province", :broken => true do
      @myContactInformation.setSelectBoxValue(MyContactInformation::COUNTRY, "Australia")

      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::STATE)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::STATE_PROVINCE)).to eq(true)
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::STATE_PROVINCE)).to eq(false)
    end

    it "Content (Country != US)", :broken => true do

    end

    it "Error Messages", :broken => true do
        expectedValidationSummaryHeader = "The following errors were found:"

        @myContactInformation.setPhoneInput(MyContactInformation::PRIMARY_PHONE, "10")
        @myContactInformation.setPhoneInput(MyContactInformation::OTHER_PHONE_1, "10")
        @myContactInformation.setPhoneInput(MyContactInformation::OTHER_PHONE_2, "10")

        @myContactInformation.clickSaveButton()

        !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.isErrorMessageDisplayed("form", "Primary Phone must be formatted (###) ###-####.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Other Phone must be formatted (###) ###-####.")).to eq(false)
    end

    it "Save Available", :broken => true do
        waitForPageToFinishLoading
        @driver.find_element(:css, "button[class='btn btn-default my-contact-information']").click
        waitForPageToFinishLoading
        expect(@myContactInformation.isSaveButtonVisible()).to eq(true)
    end

    it "Delete Unavailable" do
        expect(@myContactInformation.isDeleteButtonVisible()).to eq(false)
    end

    it "Cancel Unavailable" do
        expect(@myContactInformation.isCancelButtonVisible()).to eq(false)
    end

  end

  describe "AC JRNL-1739|TC JRNL-1655: My Contact Information - Save" do

    it "Max", :broken => true do
      @myContactInformation.setInput(MyContactInformation::PRIMARY_PHONE, "abc11111111111111")
      @myContactInformation.setSelectBoxValue(MyContactInformation::PRIMARY_PHONE_TYPE, "Mobile")
      @myContactInformation.setInput(MyContactInformation::OTHER_PHONE_1, "!@$22222222222222222")
      @myContactInformation.setSelectBoxValue(MyContactInformation::OTHER_PHONE_TYPE_1, "Home")
      @myContactInformation.setInput(MyContactInformation::OTHER_PHONE_2, "DEF333333333333333")
      @myContactInformation.setSelectBoxValue(MyContactInformation::OTHER_PHONE_TYPE_2, "Work")
      @driver.find_element(:css, "button[class='btn btn-default']").click
      waitForPageToFinishLoading
      @myContactInformation.setInput(MyContactInformation::OTHER_PHONE_3, "(444)444444444444")
      @myContactInformation.setSelectBoxValue(MyContactInformation::OTHER_PHONE_TYPE_3, "Fax")
      @myContactInformation.setInput(MyContactInformation::EMAIL, "user@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agilex.com")
      @myContactInformation.setSelectBoxValue(MyContactInformation::COUNTRY, "United States")
      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_1, "5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr.")
      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_2, "Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2")
      @myContactInformation.setInput(MyContactInformation::CITY, "Chantilly Chantilly Chantilly Chantilly Chantilly Chantilly Chantilly")
      @myContactInformation.setSelectBoxValue(MyContactInformation::STATE, "Virginia")
      @myContactInformation.setInput(MyContactInformation::ZIP_POSTAL_CODE, "201512015120151")

      @myContactInformation.clickSaveButton()
      !5.times{ break if (@myContactInformation.getPrimaryHeader() == "My Profile"); sleep 1 }
    end

    it "Returned To Main Screen", :broken => true do
      expect(@myContactInformation.getPrimaryHeader()).to eq("My Profile")
    end

    it "Focus", :broken => true do
      expect(@myContactInformation.getFocusedElementText()).to eq("My Profile")
    end

    it "AC JRNL-1740|TC JRNL-1655: My Contact Information - Previously Saved Values Are Visible", :broken => true do
      @navMenu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      !5.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::PRIMARY_PHONE)).to eq("(111) 111-1111")
      #expect(@myContactInformation.getSelectBoxText(MyContactInformation::PRIMARY_PHONE_TYPE)).to eq("Mobile")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::OTHER_PHONE_1)).to eq("(222) 222-2222")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::OTHER_PHONE_TYPE_1)).to eq("Home")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::OTHER_PHONE_2)).to eq("(333) 333-3333")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::OTHER_PHONE_TYPE_2)).to eq("Work")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::OTHER_PHONE_3)).to eq("(444) 444-4444")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::OTHER_PHONE_TYPE_3)).to eq("Fax")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::EMAIL)).to eq("user@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agile")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::COUNTRY)).to eq("United States")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_1)).to eq("5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 ")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_2)).to eq("Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floo")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::CITY)).to eq("Chantilly Chantilly Chantilly Chantilly Chantilly ")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::STATE)).to eq("Virginia")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ZIP_POSTAL_CODE)).to eq("2015120151")
    end

    it "Min" do
      @myContactInformation.setInput(MyContactInformation::PRIMARY_PHONE, "")
      @myContactInformation.setSelectBoxValue(MyContactInformation::PRIMARY_PHONE_TYPE, "Select")
      @myContactInformation.setInput(MyContactInformation::OTHER_PHONE_1, "")
      @myContactInformation.setSelectBoxValue(MyContactInformation::OTHER_PHONE_TYPE_1, "Select")
      @myContactInformation.click(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_3)
      @myContactInformation.click(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_2)
      @myContactInformation.setInput(MyContactInformation::EMAIL, "")
      @myContactInformation.setSelectBoxValue(MyContactInformation::COUNTRY, "Select")
      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_1, "")
      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_2, "")
      @myContactInformation.setInput(MyContactInformation::CITY, "")
      @myContactInformation.setInput(MyContactInformation::ZIP_POSTAL_CODE, "")
      @driver.find_element(:css, "button[name='deletePhone0']").click
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[name='deletePhone0']").click
      waitForPageToFinishLoading
      @myContactInformation.setSelectBoxValue(MyContactInformation::COUNTRY, "Australia")
      waitForPageToFinishLoading
      @driver.find_element(:css, "input[name='addressStateProvince']").clear
      waitForPageToFinishLoading
      @myContactInformation.clickSaveButton()
      !5.times{ break if (@myContactInformation.getPrimaryHeader() == "My Profile"); sleep 1 }
    end

    it "Returned To Main Screen" do
      expect(@myContactInformation.getPrimaryHeader()).to eq("My Profile")
    end

    it "Focus" do
      expect(@myContactInformation.getFocusedElementText()).to eq("My Profile")
    end

    it "AC JRNL-1740|TC JRNL-1655: My Contact Information - Previously Saved Values Are Visible" do
      @navMenu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      !5.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::PRIMARY_PHONE)).to eq("")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::PRIMARY_PHONE_TYPE)).to eq("Select")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::EMAIL)).to eq("")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::COUNTRY)).to eq("Australia")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_1)).to eq("")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_2)).to eq("")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::CITY)).to eq("")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::STATE_PROVINCE)).to eq("")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ZIP_POSTAL_CODE)).to eq("")
    end

  end

  describe "AC JRNL-1738|TC JRNL-1655: My Contact Information - Navigation" do

    it "Back Button Visible" do
      expect(@myContactInformation.isBackButtonVisible()).to eq(true)
    end

    it "Back Button Alt Text" do
      expect(@myContactInformation.getBackButtonAltText()).to eq("Return to Previous Screen")
    end

    it "Returned To Main Screen - No Changes" do
      @myContactInformation.clickBackButton()
      !5.times{ break if (getPrimaryHeader() == "My Profile"); sleep 1 }
      expect(getPrimaryHeader()).to eq("My Profile")
    end

    it "Returned To Main Screen - Changes", :broken => true do
      @navMenu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      !5.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_1, "xyz")

      @myContactInformation.clickBackButton()
      @modal.clickReturnButton()
      !5.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      @myContactInformation.clickBackButton()
      !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
      expect(@modal.getConfirmButtonText()).to eq("Continue without Saving")
      expect(@modal.getCancelButtonText()).to eq("Return to Form")

      @modal.clickContinueButton()
      !5.times{ break if (getPrimaryHeader() == "My Profile"); sleep 1 }
      expect(getPrimaryHeader()).to eq("My Profile")
    end

    it "Click Menu Item - No Changes", :broken => true do
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[class='btn btn-default my-contact-information']").click
      waitForPageToFinishLoading
      !5.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)
      sleep 2.0
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_1)).to eq("xyz")

      @navMenu.click(:css, Nav_menu::NAV["OccupationalHistory"]["navButton"])
      !5.times{ break if (getPrimaryHeader() == "Military/Occupational History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Military/Occupational History")
    end

    it "Click Menu Item - Changes", :broken => true do
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[class='btn btn-default my-contact-information']").click
      waitForPageToFinishLoading
      !5.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_1, "")

      waitForPageToFinishLoading
      @driver.find_element(:css, "button[class='btn btn-default military-occupational-history']").click
      waitForPageToFinishLoading
      !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
      expect(@modal.getConfirmButtonText()).to eq("Continue without Saving")
      expect(@modal.getCancelButtonText()).to eq("Return to Form")

      @modal.clickReturnButton()
      !5.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[class='btn btn-default military-occupational-history']").click
      waitForPageToFinishLoading
      !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
      expect(@modal.getConfirmButtonText()).to eq("Continue without Saving")
      expect(@modal.getCancelButtonText()).to eq("Return to Form")

      @modal.clickContinueButton()
      !5.times{ break if (getPrimaryHeader() == "Military/Occupational History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Military/Occupational History")
    end

    it "Verify No Changes", :broken => true do
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[class='btn btn-default my-contact-information']").click
      waitForPageToFinishLoading
      !5.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_1)).to eq("")
    end

  end

end
































































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1753: My Contact Information - Edit/Nav]", :regression => true do

  before(:all) do
    @ENTRY_FORM_1 = [
        "Primary Phone:",
        "Enter 10 digits",
        "Primary Phone Type:",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Add Phone",
        "Email:",
        "100 character maximum",
        "Current Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State:",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Save"
    ]

    @ENTRY_FORM_2 = [
        "Primary Phone:",
        "Enter 10 digits",
        "Primary Phone Type:",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Email:",
        "100 character maximum",
        "Current Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State/Province:",
        "50 character maximum",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Save"
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("demographics", "personalprofiledb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }

    @navMenu.clickMyProfile()
    !45.times{ break if (getSecondaryHeader() == "My Profile"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Profile")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1741|TC JRNL-1655: My Contact Information - Menu" do

    it "Label" do
      expect(@navMenu.getTextForElement(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])).to eq("My Contact Information")
    end

    it "Location" do
      expect(@navMenu.getNthSubFeatureName(1)).to eq("My Contact Information")
    end

    it "Clickable" do
      @navMenu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      !45.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)
    end

  end

  describe "AC JRNL-1697|TC JRNL-1655: My Contact Information - Screen" do

    it "Content (Country = US)" do
      sleep 4.0

      @form = @myContactInformation.stripSelectTextFromScreen(
          @myContactInformation.getScreenContent().split("\n"),
          ['primaryPhoneType', 'otherPhoneType1', 'addressCountry', 'addressStateAbbreviation']
      )

      @ENTRY_FORM_1.each_with_index do | expectedScreenRow, i |
        expect(@form[i]).to eq(expectedScreenRow)
      end
    end

    it "Defaults" do
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::PRIMARY_PHONE)).to eq("")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::PRIMARY_PHONE_TYPE)).to eq("Select")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::OTHER_PHONE_1)).to eq("")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::OTHER_PHONE_TYPE_1)).to eq("Select")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::EMAIL)).to eq("")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::COUNTRY)).to eq("United States")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_1)).to eq("")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_2)).to eq("")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::CITY)).to eq("")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::STATE)).to eq("Select")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ZIP_POSTAL_CODE)).to eq("")
    end

    it "Primary Phone" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::PRIMARY_PHONE)).to eq(false)
    end

    it "Primary Phone Type" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::PRIMARY_PHONE_TYPE)).to eq(false)
    end

    it "Primary Phone Type Values" do
      phoneTypes = ["Select", "Mobile", "Home", "Work", "Fax"]

      @myContactInformation.getElements(:css, MyContactInformation::PRIMARY_PHONE_TYPE + " option").each_with_index do | content, i |
        expect(content.text()).to eq(phoneTypes[i])
      end
    end

    it "Other Phone 1" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::OTHER_PHONE_1)).to eq(false)
    end

    it "Other Phone Type 1" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::OTHER_PHONE_TYPE_1)).to eq(false)
    end

    it "Other Phone Type 1 Values" do
      phoneTypes = ["Select", "Mobile", "Home", "Work", "Fax"]

      @myContactInformation.getElements(:css, MyContactInformation::OTHER_PHONE_TYPE_1 + " option").each_with_index do | content, i |
        expect(content.text()).to eq(phoneTypes[i])
      end
    end

    it "Other Phone 1 Delete Button" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_1)).to eq(false)
    end

    it "Other Phone 2" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_2)).to eq(false)
    end

    it "Other Phone Type 2" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_2)).to eq(false)
    end

    it "Other Phone 2 Delete Button" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_2)).to eq(false)
    end

    it "Other Phone 3" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_3)).to eq(false)
    end

    it "Other Phone Type 3" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_3)).to eq(false)
    end

    it "Other Phone 3 Delete Button" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_3)).to eq(false)
    end

    it "Other Phone 4" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_4)).to eq(false)
    end

    it "Other Phone Type 4" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_4)).to eq(false)
    end

    it "Other Phone 4 Delete Button" do
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_4)).to eq(false)
    end

    it "Add Other Phone 2" do
      @myContactInformation.click(:css, MyContactInformation::ADD_PHONE_BUTTON)

      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_1)).to eq(true)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_2)).to eq(true)
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::OTHER_PHONE_2)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_TYPE_2)).to eq(true)
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::OTHER_PHONE_TYPE_2)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_2)).to eq(true)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_3)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_3)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_3)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_4)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_4)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_4)).to eq(false)
    end

    it "Other Phone Type 2 Values" do
      phoneTypes = ["Select", "Mobile", "Home", "Work", "Fax"]

      @myContactInformation.getElements(:css, MyContactInformation::OTHER_PHONE_TYPE_2 + " option").each_with_index do | content, i |
        expect(content.text()).to eq(phoneTypes[i])
      end
    end

    it "Add Other Phone 3" do
      @myContactInformation.click(:css, MyContactInformation::ADD_PHONE_BUTTON)

      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_1)).to eq(true)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_2)).to eq(true)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_3)).to eq(true)
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::OTHER_PHONE_3)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_TYPE_3)).to eq(true)
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::OTHER_PHONE_TYPE_3)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_3)).to eq(true)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_4)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_TYPE_4)).to eq(false)
      expect(@myContactInformation.is_element_present(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_4)).to eq(false)
    end

    it "Other Phone Type 3 Values" do
      phoneTypes = ["Select", "Mobile", "Home", "Work", "Fax"]

      @myContactInformation.getElements(:css, MyContactInformation::OTHER_PHONE_TYPE_3 + " option").each_with_index do | content, i |
        expect(content.text()).to eq(phoneTypes[i])
      end
    end

    it "Add Other Phone 4" do
      @myContactInformation.click(:css, MyContactInformation::ADD_PHONE_BUTTON)

      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_1)).to eq(true)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_2)).to eq(true)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_3)).to eq(true)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_4)).to eq(true)
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::OTHER_PHONE_4)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_TYPE_4)).to eq(true)
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::OTHER_PHONE_TYPE_4)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_4)).to eq(true)
    end

    it "Other Phone Type 4 Values" do
      phoneTypes = ["Select", "Mobile", "Home", "Work", "Fax"]

      @myContactInformation.getElements(:css, MyContactInformation::OTHER_PHONE_TYPE_4 + " option").each_with_index do | content, i |
        expect(content.text()).to eq(phoneTypes[i])
      end
    end

    it "Email" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::EMAIL)).to eq(false)
    end

    it "Country" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::COUNTRY)).to eq(false)
    end

    it "Address Line One" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::ADDRESS_LINE_1)).to eq(false)
    end

    it "Address Line Two" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::ADDRESS_LINE_2)).to eq(false)
    end

    it "City" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::CITY)).to eq(false)
    end

    it "State" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::STATE)).to eq(false)
    end

    it "Zip/Postal Code" do
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::ZIP_POSTAL_CODE)).to eq(false)
    end

    it "State/Province", :broken => true do
      @myContactInformation.setSelectBoxValue(MyContactInformation::COUNTRY, "Australia")

      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::STATE)).to eq(false)
      expect(@myContactInformation.isElementVisible(:css, MyContactInformation::STATE_PROVINCE)).to eq(true)
      expect(@myContactInformation.isFieldRequired(:css, MyContactInformation::STATE_PROVINCE)).to eq(false)
    end

    it "Content (Country != US)", :broken => true do
      @form = @myContactInformation.stripSelectTextFromScreen(
          @myContactInformation.getScreenContent().split("\n"),
          ['primaryPhoneType', 'otherPhoneType1', 'otherPhoneType2', 'otherPhoneType3', 'otherPhoneType4', 'addressCountry']
      )

      @ENTRY_FORM_2.each_with_index do | expectedScreenRow, i |
        expect(@form[i]).to eq(expectedScreenRow)
      end
    end

    it "Error Messages", :broken => true do
      expectedValidationSummaryHeader = "The following errors were found:"

      @myContactInformation.setPhoneInput(MyContactInformation::PRIMARY_PHONE, "10")
      @myContactInformation.setPhoneInput(MyContactInformation::OTHER_PHONE_1, "10")
      @myContactInformation.setPhoneInput(MyContactInformation::OTHER_PHONE_2, "10")
      @myContactInformation.setPhoneInput(MyContactInformation::OTHER_PHONE_3, "10")
      @myContactInformation.setPhoneInput(MyContactInformation::OTHER_PHONE_4, "10")

      @myContactInformation.clickSaveButton()

      !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Primary Phone must be formatted (###) ###-####.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Other Phone must be formatted (###) ###-####.")).to eq(true)
    end

    it "Save Available", :broken => true do
      expect(@myContactInformation.isSaveButtonVisible()).to eq(true)
    end

    it "Delete Unavailable" do
      expect(@myContactInformation.isDeleteButtonVisible()).to eq(false)
    end

    it "Cancel Unavailable" do
      expect(@myContactInformation.isCancelButtonVisible()).to eq(false)
    end

  end

  describe "AC JRNL-1739|TC JRNL-1655: My Contact Information - Save" do

    it "Max", :broken => true do
      @myContactInformation.setInput(MyContactInformation::PRIMARY_PHONE, "abc11111111111111")
      @myContactInformation.setSelectBoxValue(MyContactInformation::PRIMARY_PHONE_TYPE, "Mobile")
      @myContactInformation.setInput(MyContactInformation::OTHER_PHONE_1, "!@$22222222222222222")
      @myContactInformation.setSelectBoxValue(MyContactInformation::OTHER_PHONE_TYPE_1, "Home")
      @myContactInformation.setInput(MyContactInformation::OTHER_PHONE_2, "DEF333333333333333")
      @myContactInformation.setSelectBoxValue(MyContactInformation::OTHER_PHONE_TYPE_2, "Work")
      @myContactInformation.setInput(MyContactInformation::OTHER_PHONE_3, "(444)444444444444")
      @myContactInformation.setSelectBoxValue(MyContactInformation::OTHER_PHONE_TYPE_3, "Fax")
      @myContactInformation.setInput(MyContactInformation::OTHER_PHONE_4, "555-555555555555")
      @myContactInformation.setSelectBoxValue(MyContactInformation::OTHER_PHONE_TYPE_4, "Mobile")
      @myContactInformation.setInput(MyContactInformation::EMAIL, "user@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agilex.com")
      @myContactInformation.setSelectBoxValue(MyContactInformation::COUNTRY, "United States")
      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_1, "5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr.")
      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_2, "Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2")
      @myContactInformation.setInput(MyContactInformation::CITY, "Chantilly Chantilly Chantilly Chantilly Chantilly Chantilly Chantilly")
      @myContactInformation.setSelectBoxValue(MyContactInformation::STATE, "Virginia")
      @myContactInformation.setInput(MyContactInformation::ZIP_POSTAL_CODE, "201512015120151")

      @myContactInformation.clickSaveButton()
      !45.times{ break if (@myContactInformation.getPrimaryHeader() == "My Profile"); sleep 1 }
    end

    it "Returned To Main Screen", :broken => true do
      expect(@myContactInformation.getPrimaryHeader()).to eq("My Profile")
    end

    it "Focus", :broken => true do
      expect(@myContactInformation.getFocusedElementText()).to eq("My Profile")
    end

    it "AC JRNL-1740|TC JRNL-1655: My Contact Information - Previously Saved Values Are Visible", :broken => true do
      @navMenu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      !45.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::PRIMARY_PHONE)).to eq("(111) 111-1111")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::PRIMARY_PHONE_TYPE)).to eq("Mobile")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::OTHER_PHONE_1)).to eq("(222) 222-2222")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::OTHER_PHONE_TYPE_1)).to eq("Home")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::OTHER_PHONE_2)).to eq("(333) 333-3333")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::OTHER_PHONE_TYPE_2)).to eq("Work")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::OTHER_PHONE_3)).to eq("(444) 444-4444")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::OTHER_PHONE_TYPE_3)).to eq("Fax")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::OTHER_PHONE_4)).to eq("(555) 555-5555")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::OTHER_PHONE_TYPE_4)).to eq("Mobile")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::EMAIL)).to eq("user@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agilex.comuser@agile")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::COUNTRY)).to eq("United States")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_1)).to eq("5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 Parkstone Dr. 5155 ")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_2)).to eq("Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floor 2 Floo")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::CITY)).to eq("Chantilly Chantilly Chantilly Chantilly Chantilly ")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::STATE)).to eq("Virginia")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ZIP_POSTAL_CODE)).to eq("2015120151")
    end

    it "Min" do
      @myContactInformation.setInput(MyContactInformation::PRIMARY_PHONE, "")
      @myContactInformation.setSelectBoxValue(MyContactInformation::PRIMARY_PHONE_TYPE, "Select")
      @myContactInformation.setInput(MyContactInformation::OTHER_PHONE_1, "")
      @myContactInformation.setSelectBoxValue(MyContactInformation::OTHER_PHONE_TYPE_1, "Select")

      @myContactInformation.click(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_4)
      @myContactInformation.click(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_3)
      @myContactInformation.click(:css, MyContactInformation::OTHER_PHONE_DELETE_BUTTON_2)

      @myContactInformation.setInput(MyContactInformation::EMAIL, "")
      @myContactInformation.setSelectBoxValue(MyContactInformation::COUNTRY, "Select")
      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_1, "")
      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_2, "")
      @myContactInformation.setInput(MyContactInformation::CITY, "")
      @myContactInformation.setInput(MyContactInformation::ZIP_POSTAL_CODE, "")

      @myContactInformation.clickSaveButton()
      !45.times{ break if (@myContactInformation.getPrimaryHeader() == "My Profile"); sleep 1 }
    end

    it "Returned To Main Screen" do
      expect(@myContactInformation.getPrimaryHeader()).to eq("My Profile")
    end

    it "Focus" do
      expect(@myContactInformation.getFocusedElementText()).to eq("My Profile")
    end

    it "AC JRNL-1740|TC JRNL-1655: My Contact Information - Previously Saved Values Are Visible" do
      @navMenu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      !45.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::PRIMARY_PHONE)).to eq("")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::PRIMARY_PHONE_TYPE)).to eq("Select")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::OTHER_PHONE_1)).to eq("")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::OTHER_PHONE_TYPE_1)).to eq("Select")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::EMAIL)).to eq("")
      expect(@myContactInformation.getSelectBoxText(MyContactInformation::COUNTRY)).to eq("Select")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_1)).to eq("")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_2)).to eq("")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::CITY)).to eq("")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::STATE_PROVINCE)).to eq("")
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ZIP_POSTAL_CODE)).to eq("")
    end

  end

  describe "AC JRNL-1738|TC JRNL-1655: My Contact Information - Navigation" do

    it "Back Button Visible" do
      expect(@myContactInformation.isBackButtonVisible()).to eq(true)
    end

    it "Back Button Alt Text" do
      # Story JRNL-1580 changes back button text on entry pages to 'Return to Previous Screen'
      # expect(@myContactInformation.getBackButtonAltText()).to eq("Return to My Profile Options")
      expect(@myContactInformation.getBackButtonAltText()).to eq("Return to Previous Screen")
    end

    it "Returned To Main Screen - No Changes" do
      @myContactInformation.clickBackButton()
      !45.times{ break if (getPrimaryHeader() == "My Profile"); sleep 1 }
      expect(getPrimaryHeader()).to eq("My Profile")
    end

    it "Returned To Main Screen - Changes", :broken => true do
      @navMenu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      !45.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_1, "xyz")

      @myContactInformation.clickBackButton()
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
      expect(@modal.getConfirmButtonText()).to eq("Continue")
      expect(@modal.getCancelButtonText()).to eq("Return")

      @modal.clickReturnButton()
      !45.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      @myContactInformation.clickBackButton()
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
      expect(@modal.getConfirmButtonText()).to eq("Continue")
      expect(@modal.getCancelButtonText()).to eq("Return")

      @modal.clickContinueButton()
      !45.times{ break if (getPrimaryHeader() == "My Profile"); sleep 1 }
      expect(getPrimaryHeader()).to eq("My Profile")
    end

    it "Click Menu Item - No Changes", :broken => true do
      @navMenu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      !45.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)
      sleep 2.0
      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_1)).to eq("")

      @navMenu.click(:css, Nav_menu::NAV["OccupationalHistory"]["navButton"])
      !45.times{ break if (getPrimaryHeader() == "Military/Occupational History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Military/Occupational History")
    end

    it "Click Menu Item - Changes", :broken => true do
      @navMenu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      !45.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      @myContactInformation.setInput(MyContactInformation::ADDRESS_LINE_1, "xyz")

      @navMenu.click(:css, Nav_menu::NAV["OccupationalHistory"]["navButton"])
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
      expect(@modal.getConfirmButtonText()).to eq("Continue")
      expect(@modal.getCancelButtonText()).to eq("Return")

      @modal.clickReturnButton()
      !45.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      @navMenu.click(:css, Nav_menu::NAV["OccupationalHistory"]["navButton"])
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
      expect(@modal.getConfirmButtonText()).to eq("Continue")
      expect(@modal.getCancelButtonText()).to eq("Return")

      @modal.clickContinueButton()
      !45.times{ break if (getPrimaryHeader() == "Military/Occupational History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Military/Occupational History")
    end

    it "Verify No Changes", :broken => true do
      @navMenu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      sleep 2.0
      !45.times{ break if (@myContactInformation.getPrimaryHeader() == MyContactInformation::HEADER); sleep 1 }
      expect(@myContactInformation.getPrimaryHeader()).to eq(MyContactInformation::HEADER)

      expect(@myContactInformation.getTextFromInput(:css, MyContactInformation::ADDRESS_LINE_1)).to eq("")
    end

  end

end
=end