# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe '[Story #JRNL-1195: My Medical - Symptoms Select From List]', :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("symptoms", 'medicalhistorydb')
    initializeAllObjects

    #@char50 = "abcdefghij1234567890KLMNOPQRSTUVWXY!$%&().,?<>[]:;"
    @char50 = "abcdefghij1234567890ABCDEFGHIJ1234567890abcdefghij"

    @common.loginEndsOnLandingPage('zztest.patient01', 'patient01, zztest')
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == 'App Options'); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq('App Options')

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == 'My Medical'); sleep 1 }
    expect(getSecondaryHeader()).to eq('My Medical')

    @mymedical.clickSymptom()
    waitForPageToFinishLoading()

    @common.clickAddButton()
    waitForPageToFinishLoading()
  end

  after(:all) do
    quitDriver()
  end

  describe 'AC JRNL-1166|TC JRNL-1147: Control Display' do

    it "50 Character Max" do
      setTypeaheadField(@char50 + @char50)
      expect(@symptoms.getSymptomName()).to eq(@char50)
    end

    it "Label" do
      expect(getElement(:css,"span[name='nameLabel']").text).to eq("Symptom Name:")
    end

    it "Guidance text" do
       expect(@symptoms.getSymptomNameElement().attribute("placeholder")).to eq("Enter a Symptom Name")
    end

    it "Screen reader" do
       expect(@symptoms.getSymptomNameElement().attribute("title")).to \
            eq("Type to enter a symptom name or select a name from the list provided. "+
               "List suggestions are provided after 3 characters are typed.")
    end

  end

  describe 'AC JRNL-1165|TC JRNL-1147: Type, Search and Sort Action' do

    it "After 3 chars list displays", :broken => true do
      setTypeaheadField("d")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }
      expect(isElementVisible(:css, getSelectListCSS())).to eq(false)

      setTypeaheadField("dr")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }
      expect(isElementVisible(:css, getSelectListCSS())).to eq(false)

      setTypeaheadField("dre")
      !3.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }
      expect(isElementVisible(:css, getSelectListCSS())).to eq(true)
      expect(getSelectListCount()).to be > 0
    end

    it "List sort", :broken => true do
      setTypeaheadField("dre")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }
      expect(isElementVisible(:css, getSelectListCSS())).to eq(true)

      expect(getSelectListCount()).to be > 0

      startInternalMatch = 0

      #Find the point where beginning match changes to internal match
      selectionList = getSelectListText()
      for i in 0...getSelectListCount()
        if selectionList[i][0..2].upcase != "DRE"
          startInternalMatch = i
          break
        end
      end

      expect(startInternalMatch).to be > 0
      expect(startInternalMatch).to be <= getSelectListCount()-1

      #Verify no Beginning matches are in the bottom of list
      for i in startInternalMatch...getSelectListCount()
        expect(selectionList[i][0..2].upcase).to_not eq("DRE")
      end
    end

    it "Refine match with more chars", :broken => true do
      setTypeaheadField("hea")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }
      expect(isElementVisible(:css, getSelectListCSS())).to eq(true)

      threeCharMatchCount = getSelectListCount()

      setTypeaheadField("hear")
      !5.times{ break if (getSelectListCount() < threeCharMatchCount); sleep 1 }

      expect(getSelectListCount()).to be > 0
      expect(getSelectListCount()).to be < threeCharMatchCount
    end

    it "Focus on input field" do
      expect(getActiveElement().attribute("name")).to eq("name")
    end

  end

  describe 'AC JRNL-1164|TC JRNL-1147: Selecting a List Value' do

    it "Focus on first item and can navigate through list", :broken => true do
      setTypeaheadField("hea")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }

      selectionList = getSelectList()
      selectListCount = getSelectListCount()
      for i in 0...selectListCount
        for j in 0...selectListCount
          if i == j
            expect(selectionList[j].attribute("class")).to eq("ng-scope active")
          else
            expect(selectionList[j].attribute("class")).to eq("ng-scope")
          end
        end
        typeaheadField.send_keys(:arrow_down)
        sleep 0.5
      end
    end

    it "Select term", :broken => true do
      #Wraparound to last selection
      typeaheadField().send_keys(:arrow_up)
      sleep 0.5

      currentlyHighlighted = getSelectListText[getSelectListCount()-1].strip

      typeaheadField.send_keys(:return)
      sleep 0.5

      expect(@symptoms.getSymptomName().strip).to eq(currentlyHighlighted)
    end

    it "Move to next field of focus", :broken => true do
      expect(getActiveElement().attribute("name")).to eq("name")

      typeaheadField.send_keys(:tab)
      sleep 0.5

      #Check focus is on next field
      expect(getActiveElement().attribute("name")).to eq("hours")
    end

    it "SNOMED info stored", :broken => true do
      name = @symptoms.getSymptomName().strip

      @symptoms.clickSaveButton()
      waitForPageToFinishLoading()

      coding = getSNOMEDInfo("symptoms", "medicalhistorydb", "", name)
      expect(coding[0]["system"]).to eq("http://snomed.info/sct")
      expect(coding[0]["code"]).to eq("267060006")
      expect(coding[0]["display"]).to eq("Diarrhea")
      expect(coding[0]["version"]).to eq("20140931-US")
    end

  end

  context 'AC JRNL-1163|TC JRNL-1147: Entering a Verbatim Term' do

    it "No match", :broken => true do
      @common.clickAddButton()
      waitForPageToFinishLoading()

      setTypeaheadField("asparx")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }
      expect(isElementVisible(:css, getSelectListCSS())).to eq(false)
    end

    it "Shift focus", :broken => true do
      setTypeaheadField(@char50)
      expect(getActiveElement().attribute("name")).to eq("name")

      typeaheadField.send_keys(:tab)
      sleep 0.5

      #Check focus is on next field
      expect(getActiveElement().attribute("name")).to eq("hours")
    end

    it "Value Retained" do
      expect(@symptoms.getSymptomName()).to eq(@char50)
    end

    it "Save - Verbatim term - SNOMED info not stored" do
      @symptoms.clickSaveButton()
      waitForPageToFinishLoading()

      coding = getSNOMEDInfo('symptoms', "medicalhistorydb", "", @char50)

      expect(coding).to eq([])
    end

  end

end