require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1743: Symptom List View and Filter]", :regression => true  do

  before(:all) do
    @FILTER_EXPANDED = [
        "* required field",
        "Symptom Date Range:",
        "* From Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* To Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Symptom:",
        "50 character maximum",
        "Filter Reset"
    ]

    @FILTER_COLLAPSED = []

    initializeConfigurations(BASE_URL)
    resetCollection("symptoms", "medicalhistorydb", "symptom")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1737|TC JRNL-1649: Sub Feature Selection" do

    it "Visible" do
      expect(@nav_menu.isNavVisible("SymptomDiary")).to eq(true)
    end

    it "Label" do
      expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["SymptomDiary"]["navButton"])).to eq("Symptom Diary")
    end

    it "Location" do
      menuLocation = -1
      menu = getElements(:css, "div.secondary-content li")

      menu.each_with_index do | menuItem, i |
        if menuItem.text() == "Symptom Diary"
          menuLocation = i + 1
          break
        end
      end

      #With Stories 4748 and 4750, location of Symptom Diary changed from
      #being above Diagnosis to above Medications
      expect(@nav_menu.getNthSubFeatureName(menuLocation)).to eq("Symptom Diary")
      expect(@nav_menu.getNthSubFeatureName(menuLocation + 1)).to eq("Medications")
    end
    
  end

  describe "AC JRNL-1736|TC JRNL-1649: Filter and Table" do

    it "Screen Header" do
      @nav_menu.click(:css, Nav_menu::NAV["SymptomDiary"]["navButton"])
      !45.times{ break if (getPrimaryHeader() == Symptom_Filter::HEADER); sleep 1 }
      expect(getPrimaryHeader()).to eq(Symptom_Filter::HEADER)
    end

    it "Focus" do
      expect(getFocusedElementText()).to eq(Symptom_Filter::HEADER)
    end

    it "Content (Filter Expanded)", :broken => true do
      filterScreen = @symptom_filter.getScreenContent().split("\n")
      @FILTER_EXPANDED.each_with_index do | expectedScreenRow, i |
        expect(filterScreen[i]).to eq(expectedScreenRow)
      end
    end

    it "Filter Default", :broken => true do
      expect(@symptom_filter.isFilterAccordionExpanded()).to be(true)
      expect(@symptom_filter.getFilterAccordionTitle()).to eq("Collapse filter options")

      @symptom_filter.clickFilterAccordion()
      sleep 1
      expect(@symptom_filter.isFilterAccordionExpanded()).to be(false)
      expect(@symptom_filter.getFilterAccordionTitle()).to eq("Expand filter options")

      @symptom_filter.clickFilterAccordion()
      sleep 1
      expect(getLongFieldLabel("startDate")).to eq("* From Date:")
      expect(getLongFieldLabel("endDate")).to eq("* To Date:")

      expect(getPlaceHolderByCSS(:css, Symptom_Filter::FROM_DATE)).to eq("MM/DD/YYYY")
      expect(getPlaceHolderByCSS(:css, Symptom_Filter::TO_DATE)).to eq("MM/DD/YYYY")
    end

    it "Content (Filter Collapsed)", :broken => true do
      @symptom_filter.clickFilterAccordion()

      filterScreen = @symptom_filter.getScreenContent().split("\n")
      @FILTER_COLLAPSED.each_with_index do | expectedScreenRow, i |
        expect(filterScreen[i]).to eq(expectedScreenRow)
      end
    end

    it "Filter Button", :broken => true do
      @symptom_filter.clickFilterAccordion()
      sleep 1
      expect(@symptom_filter.getFilterButtonLabel()).to eq("Filter")
    end

    describe "Filter Options" do

      it "From Date" do
        nowDate = Time.new()
        thenDate = Time.new(nowDate.year() - 1, nowDate.month(), nowDate.day())

        expect(@symptom_filter.getTextFromInput(:css, Symptom_Filter::FROM_DATE)).to eq(thenDate.strftime("%m/%d/%Y"))
        expect(@symptom_filter.isFieldRequired(:css, Symptom_Filter::FROM_DATE)).to eq(true)
      end

      it "To Date" do
        now = Time.new()

        expect(@symptom_filter.getTextFromInput(:css, Symptom_Filter::TO_DATE)).to eq(now.strftime("%m/%d/%Y"))
        expect(@symptom_filter.isFieldRequired(:css, Symptom_Filter::TO_DATE)).to eq(true)
      end

      it "Symptom" do
        expect(@symptom_filter.getTextFromInput(:css, Symptom_Filter::SYMPTOM)).to eq("")
        expect(@symptom_filter.isFieldRequired(:css, Symptom_Filter::SYMPTOM)).to eq(false)
        @symptom_filter.setInput(Symptom_Filter::SYMPTOM, "Over50CharactersOver50CharactersOver50CharactersOver50Characters")
        expect(@symptom_filter.getTextFromInput(:css, Symptom_Filter::SYMPTOM)).to eq("Over50CharactersOver50CharactersOver50CharactersOv")
        expect(@symptom_filter.getTextFromInput(:css, Symptom_Filter::SYMPTOM).length()).to eq(50)
      end

      it "Date Validation", :broken => true do
        expectedValidationSummaryHeader = "The following errors were found:"

        @symptom_filter.setInput(Symptom_Filter::FROM_DATE, "")
        @symptom_filter.setInput(Symptom_Filter::TO_DATE, "")

        @symptom_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "From Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "To Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "From Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "To Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "From Date must occur before To Date.")).to eq(false)

        @symptom_filter.setInput(Symptom_Filter::FROM_DATE, "12")
        @symptom_filter.setInput(Symptom_Filter::TO_DATE, "12")

        @symptom_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "From Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "To Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "From Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "To Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("filterForm", "From Date must occur before To Date.")).to eq(false)

        # @date_picker.clickStartDateCalendarBtn()
        @symptom_filter.click(:css, Symptom_Filter::FROM_DATE_BUTTON)
        !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(12, 12, 2013)

        # @date_picker.clickEndDateCalendarBtn()
        @symptom_filter.click(:css, Symptom_Filter::TO_DATE_BUTTON)
        !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(12, 12, 2012)

        @symptom_filter.clickFilterBtn()
        !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("filterForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("filterForm", "From Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "To Date field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "From Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "To Date must be formatted MM/DD/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("filterForm", "From Date must occur before To Date.")).to eq(true)
      end

    end

  end

  describe "AC JRNL-1735|TC JRNL-1649: Filter Action and Results Display" do

    it "Text", :broken => true do
      @symptom_filter.clickResetBtn()
      !30.times{ break if(@symptom_filter.getFocusedElementText().include?("No results") || @symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
      expect(@symptom_filter.getFocusedElementText().include?("No results") || @symptom_filter.getFocusedElementText().include?("Symptom")).to eq(true)

      @symptom_filter.setFromDate("01/01/1900")
      @symptom_filter.clickFilterBtn()
      !30.times{ break if(@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
      expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")

      expect(getTextForElement(:id, Symptom_Filter::TEXT)).to eq("All symptoms are self-reported.")
    end

    it "Table Headers", :broken => true do
      expect(getTableHeaders()).to eq(["Symptom", %(Date/Time), "Intensity"])
    end

    describe "When Records Are Found" do

      it "Sorted Reverse Chronologically, Then By Symptom Alphabetically", :broken => true do
        @symptom_filter.setInput(Symptom_Filter::SYMPTOM, "")
        @symptom_filter.setDateRangeAndFilter("11/11/2011", "11/11/2014")

        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(7)

        verifyList(getList(), getFilteredList("2011-11-11", "2014-11-11", ""))
      end

      it "Initial Character Match", :broken => true do
        @symptom_filter.setInput(Symptom_Filter::SYMPTOM, "C")

        @symptom_filter.clickFilterBtn()
        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(4)

        verifyList(getList(), getFilteredList("2011-11-11", "2014-11-11", "C"))
      end

      it "Initial Partial Character Match", :broken => true do
        @symptom_filter.setInput(Symptom_Filter::SYMPTOM, "Cry")

        @symptom_filter.clickFilterBtn()
        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(1)

        verifyList(getList(), getFilteredList("2011-11-11", "2014-11-11", "Cry"))
      end

      it "Internal Character Match", :broken => true do
        @symptom_filter.setInput(Symptom_Filter::SYMPTOM, "h")

        @symptom_filter.clickFilterBtn()
        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(5)

        verifyList(getList(), getFilteredList("2011-11-11", "2014-11-11", "h"))
      end

      it "End Character Match", :broken => true do
        @symptom_filter.setInput(Symptom_Filter::SYMPTOM, "ing")

        @symptom_filter.clickFilterBtn()
        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(5)

        verifyList(getList(), getFilteredList("2011-11-11", "2014-11-11", "ing"))
      end

      it "Special Character Match", :broken => true do
        @symptom_filter.setInput(Symptom_Filter::SYMPTOM, "A%")

        @symptom_filter.clickFilterBtn()
        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(1)

        verifyList(getList(), getFilteredList("2011-11-11", "2014-11-11", "A%"))
      end

      it "Case Insensitive", :broken => true do
        @symptom_filter.setInput(Symptom_Filter::SYMPTOM, "wheezing")

        @symptom_filter.clickFilterBtn()
        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(2)

        verifyList(getList(), getFilteredList("2011-11-11", "2014-11-11", "wheezing"))
      end

      it "Exact Match", :broken => true do
        @symptom_filter.setInput(Symptom_Filter::SYMPTOM, "Migraine")

        @symptom_filter.clickFilterBtn()
        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(1)

        verifyList(getList(), getFilteredList("2011-11-11", "2014-11-11", "Migraine"))
      end

      it "Date Within Filter Range", :broken => true do
        @symptom_filter.setInput(Symptom_Filter::SYMPTOM, "")
        @symptom_filter.setFromDate("01/01/2013")

        @symptom_filter.clickFilterBtn()
        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(3)

        verifyList(getList(), getFilteredList("2013-01-01", "2014-11-11", ""))
      end

      it "Date Equal To Start Date Filter", :broken => true do
        @symptom_filter.setFromDate("10/30/2013")

        @symptom_filter.clickFilterBtn()
        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(3)

        verifyList(getList(), getFilteredList("2013-10-30", "2014-10-30", ""))
      end

      it "Date Equal To End Date Filter", :broken => true do
        @symptom_filter.setEndDate("01/01/2014")

        @symptom_filter.clickFilterBtn()
        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(3)

        verifyList(getList(), getFilteredList("2013-10-30", "2014-01-01", ""))
      end

    end

    describe "When No Records Found" do

      it "Message" do
        @symptom_filter.setInput(Symptom_Filter::SYMPTOM, "xyz")

        @symptom_filter.clickFilterBtn()
        !10.times{ break if (@symptom_filter.getFocusedElementText().include?("No results")); sleep 1 }
        expect(@symptom_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        expect(getCount()).to eq(0)

        verifyList(getList(), getFilteredList("2013-10-30", "2014-01-01", "xyz"))
      end

    end

  end

  describe "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible" do
      expect(@symptom_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label" do
      expect(@symptom_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result" do
      nowDate = Time.new()
      thenDate = Time.new(nowDate.year() - 1, nowDate.month(), nowDate.day())

      @symptom_filter.clickResetBtn()
      !30.times{ break if(@symptom_filter.getFocusedElementText().include?("No results") || @symptom_filter.getFocusedElementText().include?("Symptom")); sleep 1 }
      expect(@symptom_filter.getFocusedElementText().include?("No results") || @symptom_filter.getFocusedElementText().include?("Symptom")).to eq(true)
      verifyList(getList(), getFilteredList(thenDate.strftime("%Y-%m-%d"), nowDate.strftime("%Y-%m-%d"), ""))

      # DEFAULTS
      expect(@symptom_filter.getTextFromInput(:css, Symptom_Filter::FROM_DATE)).to eq(thenDate.strftime("%m/%d/%Y"))
      expect(@symptom_filter.getTextFromInput(:css, Symptom_Filter::TO_DATE)).to eq(nowDate.strftime("%m/%d/%Y"))
      expect(@symptom_filter.getTextFromInput(:css, Symptom_Filter::SYMPTOM)).to eq("")
    end
  end

  #######################
  ### Local Functions ###
  #######################

  def getAllRecordsInDBSorted
    def sortByKeys(x,y)
      if x["onsetDate"].strftime('%Y%m%d') == y["onsetDate"].strftime('%Y%m%d')
        return x["description"].upcase() <=> y["description"].upcase()
      end
      return y["onsetDate"].strftime('%Y%m%d') <=> x["onsetDate"].strftime('%Y%m%d')
    end

    return retreiveAllDocumentsInCollection("symptoms", "medicalhistorydb").sort { |x, y| sortByKeys(x,y) }
  end

  def getFilteredList(startDate, endDate, symptom)
    dateMatch = []
    stringMatch = []
    getAllRecordsInDBSorted.each_with_index do |event, i|
      if event["onsetDate"].strftime('%Y%m%d') >= Date.parse(startDate).strftime('%Y%m%d') && event["onsetDate"].strftime('%Y%m%d') <= Date.parse(endDate).strftime('%Y%m%d')
        dateMatch << event
      end

      if symptom != "" && event["description"].upcase().include?(symptom.upcase())
        stringMatch << event
      end
    end

    return (dateMatch & stringMatch)
  end

  def verifyList(screenList, dbList)
    dbList.each_with_index do |dbrow, i|
      screenRow = screenList[i].text.split("\n")
      expect(screenRow[1].strip).to eq(dbrow["description"])
      expect(screenRow[3].strip).to eq(dbrow["onsetDate"].strftime('%m/%d/%Y 12:00 AM'))
    end
  end

end
