require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1742: Symptom - Edit/Delete/Nav]", :broken => true, :regression => true do

  before(:all) do

    initializeConfigurations(BASE_URL)
    resetCollection("symptoms", "medicalhistorydb", "symptom")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05","patient05, zztest")

    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickSymptom()
    !45.times{ break if (getPrimaryHeader() == Symptom::HEADER); sleep 1 }
    expect(getPrimaryHeader()).to eq(Symptom::HEADER)

    @symptomFilter.setInput(Symptom_Filter::FROM_DATE, "01/01/1990")
    @symptomFilter.setInput(Symptom_Filter::TO_DATE, "11/10/2014")

    @symptomFilter.clickFilterBtn()
    !10.times{ break if (@symptomFilter.getFocusedElementText().include?(Symptom::HEADER)); sleep 1 }
    expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

    @numberOfRecords = 8

    expect(getCount()).to eq(@numberOfRecords)

    @SymptomFirstCount = retreiveAllDocumentsInCollection("symptoms", "medicalhistorydb").length
  end

  # after(:all) do
  #   quitDriver()
  # end

  describe "AC JRNL-1732|TC JRNL-1578: When the user selects a Symptom entry from the table view" do

    it "The system displays the Symptom record in the Detail screen in Edit mode" do
      clickNthRow(1)
      !45.times{ break if( @symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1}
      expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
    end

    it "All values previously field values saved are visible" do
      expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("Coughing")
      expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("01/01/2014")
      expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to eq("12:00 AM")
      expect(@symptom.getSelectBoxText(Symptom::DURATION_HOURS)).to eq("12")
      expect(@symptom.getSelectBoxText(Symptom::DURATION_MINUTES)).to eq("5")
      expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("Test Trigger")
      expect(@symptom.getTextForElement(:css, Symptom::TRIGGER_CHARACTER_COUNTER)).to eq("238 characters left")
      expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("Test Treatment")
      expect(@symptom.getTextForElement(:css, Symptom::TREATMENT_CHARACTER_COUNTER)).to eq("236 characters left")
      expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("Test Response")
      expect(@symptom.getTextForElement(:css, Symptom::RESPONSE_CHARACTER_COUNTER)).to eq("237 characters left")
      expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("Test Note")
      expect(@symptom.getTextForElement(:css, Symptom::NOTES_CHARACTER_COUNTER)).to eq("241 characters left")
    end

    describe "All fields displayed in the Add mode are available in the Edit mode" do

      it "Required" do
        expect(@symptom.isFieldRequired(:css, Symptom::DESCRIPTION)).to eq(true)
        expect(@symptom.isFieldRequired(:css, Symptom::SYMPTOM_DATE)).to eq(true)
        expect(@symptom.isFieldRequired(:css, Symptom::SYMPTOM_TIME)).to eq(true)
        expect(@symptom.isFieldRequired(:css, Symptom::TRIGGER)).to eq(false)
        expect(@symptom.isFieldRequired(:css, Symptom::TREATMENT)).to eq(false)
        expect(@symptom.isFieldRequired(:css, Symptom::RESPONSE)).to eq(false)
        expect(@symptom.isFieldRequired(:css, Symptom::NOTES)).to eq(false)
      end

      it "Disabled" do
        expect(@symptom.isThisElementDisabled(:css, Symptom::DESCRIPTION)).to eq(true)
      end

      it "Error Messages" do
        expectedValidationSummaryHeader = "The following errors were found:"

        @symptom.setInput(Symptom::SYMPTOM_DATE, "")
        @symptom.setInput(Symptom::SYMPTOM_TIME, "")

        @symptom.clickSaveButton()
        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(true)

        @symptom.setInput(Symptom::SYMPTOM_DATE, "11/01")
        @time_picker.clickTimePickerButton()
        !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
        expect(@time_picker.areMinutesIn5MinIntervals()).to eq(false)
        @time_picker.setTimeFromGUI(8, "05", "AM")
        !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }

        @symptom.clickSaveButton()
        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
      end

    end

    describe "AC JRNL-1731|TC JRNL-1571:: Standard Edit functions are available" do

      it "Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        expect(@symptom.isCancelButtonVisible()).to eq(true)

        @symptom.clickCancelButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)

        expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("Coughing")
        expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("01/01/2014")
        expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to eq("12:00 AM")
        expect(@symptom.getSelectBoxText(Symptom::DURATION_HOURS)).to eq("12")
        expect(@symptom.getSelectBoxText(Symptom::DURATION_MINUTES)).to eq("5")
        expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("Test Trigger")
        expect(@symptom.getTextForElement(:css, Symptom::TRIGGER_CHARACTER_COUNTER)).to eq("238 characters left")
        expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("Test Treatment")
        expect(@symptom.getTextForElement(:css, Symptom::TREATMENT_CHARACTER_COUNTER)).to eq("236 characters left")
        expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("Test Response")
        expect(@symptom.getTextForElement(:css, Symptom::RESPONSE_CHARACTER_COUNTER)).to eq("237 characters left")
        expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("Test Note")
        expect(@symptom.getTextForElement(:css, Symptom::NOTES_CHARACTER_COUNTER)).to eq("241 characters left")

        expect(@symptom.isCancelButtonVisible()).to eq(true)

        @symptom.clickCancelButton()
        !60.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)
      end

      it "Cancel after one field update" do
        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
        expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("Coughing")

        @symptom.setInput(Symptom::NOTES, "Wheezing")

        @symptom.clickCancelButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
        expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("Test Note")
      end

      it "Update" do
        @symptom.setInput(Symptom::NOTES, "Wheezing")

        @symptom.clickSaveButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
        expect(@symptom.getTextFromInput(:css,Symptom::NOTES)).to eq("Wheezing")

        @symptom.clickCancelButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)
      end

      it "Delete" do
        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
        expect(@symptom.getTextFromInput(:css,Symptom::NOTES)).to eq("Wheezing")

        expect(@symptom.isDeleteButtonVisible()).to eq(true)

        @symptom.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickNoButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
        !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
        expect(@symptom.getFocusedElementText()).to eq("Delete")

        @symptom.clickCancelButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)

        @symptom.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickYesButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords - 1)

        expect(retreiveAllDocumentsInCollection("symptoms", "medicalhistorydb").length()).to eq(@SymptomFirstCount)
      end

      describe "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header.
                Updates made to the record are visible in the table, if included in that view" do

        it "max" do
          clickNthRow(1)
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)

          expect(@symptom.isSaveButtonVisible()).to eq(true)

          @symptom.setInput(Symptom::SYMPTOM_DATE, "01/01/2014")
          @time_picker.clickTimePickerButton()
          !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
          @time_picker.setTimeFromGUI(9, "01", "AM")
          !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }

          @symptom.setInput(Symptom::TRIGGER, "This  field value is deliberately set to be longer than length of two hundred and fifty characters. The field should truncate the string after the maximum number of characters is reached and display the first substring of this entire string.         ")
          expect(@symptom.getTextForElement(:css, Symptom::TRIGGER_CHARACTER_COUNTER)).to eq("0 characters left")
          @symptom.setInput(Symptom::TREATMENT, "This  field value is deliberately set to be longer than length of two hundred and fifty characters. The field should truncate the string after the maximum number of characters is reached and display the first substring of this entire string.          ")
          expect(@symptom.getTextForElement(:css, Symptom::TREATMENT_CHARACTER_COUNTER)).to eq("0 characters left")
          @symptom.setInput(Symptom::RESPONSE, "This  field value is deliberately set to be longer than length of two hundred and fifty characters. The field should truncate the string after the maximum number of characters is reached and display the first substring of this entire string.          ")
          expect(@symptom.getTextForElement(:css, Symptom::RESPONSE_CHARACTER_COUNTER)).to eq("0 characters left")
          @symptom.setInput(Symptom::NOTES, "This  field value is deliberately set to be longer than length of two hundred and fifty characters. The field should truncate the string after the maximum number of characters is reached and display the first substring of this entire string.          ")
          expect(@symptom.getTextForElement(:css, Symptom::NOTES_CHARACTER_COUNTER)).to eq("0 characters left")

          @symptom.clickSaveButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          expect(getCount()).to eq(@numberOfRecords -1)
        end

        it "min" do
          clickNthRow(1)
          @symptom.setInput(Symptom::SYMPTOM_DATE, "01/01/2014")
          @time_picker.clickTimePickerButton()
          !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
          @time_picker.setTimeFromGUI(9, "01", "AM")
          !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }
          @symptom.setSelectBoxValue(Symptom::DURATION_HOURS, "Select")
          @symptom.setSelectBoxValue(Symptom::DURATION_MINUTES, "Select")
          @symptom.setInput(Symptom::TRIGGER, "")
          @symptom.setInput(Symptom::TREATMENT, "")
          @symptom.setInput(Symptom::RESPONSE, "")
          @symptom.setInput(Symptom::NOTES, "")

          @symptom.clickSaveButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)

          clickNthRow(1)
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)

          expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("Crying")
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("01/01/2014")
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to eq("09:01 AM")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_MINUTES)).to eq("0")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_HOURS)).to eq("Select")
          expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("")

          @symptom.clickCancelButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)
        end

      end

    end

  end

end





























































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1742: Symptom - Edit/Delete/Nav]", :broken => true, :regression => true do

  before(:all) do

    initializeConfigurations(BASE_URL)
    resetCollection("symptoms", "medicalhistorydb", "symptom")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest")

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@navMenu.getNavMenuHeading()).to eq("App Options")

    @navMenu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickSymptom()
    !45.times{ break if (getPrimaryHeader() == Symptom::HEADER); sleep 1 }
    expect(getPrimaryHeader()).to eq(Symptom::HEADER)

    @symptomFilter.setInput(Symptom_Filter::FROM_DATE, "01/01/1990")
    @symptomFilter.setInput(Symptom_Filter::TO_DATE, "11/10/2014")

    @symptomFilter.clickFilterBtn()
    !10.times{ break if (@symptomFilter.getFocusedElementText().include?(Symptom::HEADER)); sleep 1 }
    expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

    @numberOfRecords = 8

    expect(getCount()).to eq(@numberOfRecords)

    @SymptomFirstCount = retreiveAllDocumentsInCollection("symptoms", "medicalhistorydb").length
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1732|TC JRNL-1578: When the user selects a Symptom entry from the table view" do

    it "The system displays the Symptom record in the Detail screen in Edit mode" do
      clickNthRow(1)
      !45.times{ break if( @symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1}
      expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
    end

    it "All values previously field values saved are visible" do
      expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("Coughing")
      expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("01/01/2014")
      expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to eq("12:00 AM")
      expect(@symptom.getSelectBoxText(Symptom::DURATION_HOURS)).to eq("12")
      expect(@symptom.getSelectBoxText(Symptom::DURATION_MINUTES)).to eq("5")
      expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("Test Trigger")
      expect(@symptom.getTextForElement(:css, Symptom::TRIGGER_CHARACTER_COUNTER)).to eq("238 characters left")
      expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("Test Treatment")
      expect(@symptom.getTextForElement(:css, Symptom::TREATMENT_CHARACTER_COUNTER)).to eq("236 characters left")
      expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("Test Response")
      expect(@symptom.getTextForElement(:css, Symptom::RESPONSE_CHARACTER_COUNTER)).to eq("237 characters left")
      expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("Test Note")
      expect(@symptom.getTextForElement(:css, Symptom::NOTES_CHARACTER_COUNTER)).to eq("241 characters left")
    end

    describe "All fields displayed in the Add mode are available in the Edit mode" do

      it "Required" do
        expect(@symptom.isFieldRequired(:css, Symptom::DESCRIPTION)).to eq(true)
        expect(@symptom.isFieldRequired(:css, Symptom::SYMPTOM_DATE)).to eq(true)
        expect(@symptom.isFieldRequired(:css, Symptom::SYMPTOM_TIME)).to eq(true)
        expect(@symptom.isFieldRequired(:css, Symptom::TRIGGER)).to eq(false)
        expect(@symptom.isFieldRequired(:css, Symptom::TREATMENT)).to eq(false)
        expect(@symptom.isFieldRequired(:css, Symptom::RESPONSE)).to eq(false)
        expect(@symptom.isFieldRequired(:css, Symptom::NOTES)).to eq(false)
      end

      it "Disabled" do
        expect(@symptom.isThisElementDisabled(:css, Symptom::DESCRIPTION)).to eq(true)
      end

      it "Error Messages" do
        expectedValidationSummaryHeader = "The following errors were found:"

        @symptom.setInput(Symptom::SYMPTOM_DATE, "")
        @symptom.setInput(Symptom::SYMPTOM_TIME, "")

        @symptom.clickSaveButton()
        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(true)

        @symptom.setInput(Symptom::SYMPTOM_DATE, "11/01")
        @time_picker.clickTimePickerButton()
        !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
        expect(@time_picker.areMinutesIn5MinIntervals()).to eq(false)
        @time_picker.setTimeFromGUI(8, "05", "AM")
        !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }

        @symptom.clickSaveButton()
        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
      end

    end

    describe "AC JRNL-1731|TC JRNL-1571:: Standard Edit functions are available" do

      it "Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        expect(@symptom.isCancelButtonVisible()).to eq(true)

        @symptom.clickCancelButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)

        expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("Coughing")
        expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("01/01/2014")
        expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to eq("12:00 AM")
        expect(@symptom.getSelectBoxText(Symptom::DURATION_HOURS)).to eq("12")
        expect(@symptom.getSelectBoxText(Symptom::DURATION_MINUTES)).to eq("5")
        expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("Test Trigger")
        expect(@symptom.getTextForElement(:css, Symptom::TRIGGER_CHARACTER_COUNTER)).to eq("238 characters left")
        expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("Test Treatment")
        expect(@symptom.getTextForElement(:css, Symptom::TREATMENT_CHARACTER_COUNTER)).to eq("236 characters left")
        expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("Test Response")
        expect(@symptom.getTextForElement(:css, Symptom::RESPONSE_CHARACTER_COUNTER)).to eq("237 characters left")
        expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("Test Note")
        expect(@symptom.getTextForElement(:css, Symptom::NOTES_CHARACTER_COUNTER)).to eq("241 characters left")

        expect(@symptom.isCancelButtonVisible()).to eq(true)

        @symptom.clickCancelButton()
        !60.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)
      end

      it "Cancel after one field update" do
        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
        expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("Coughing")

        @symptom.setInput(Symptom::NOTES, "Wheezing")

        @symptom.clickCancelButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
        expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("Test Note")
      end

      it "Update" do
        @symptom.setInput(Symptom::NOTES, "Wheezing")

        @symptom.clickSaveButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
        expect(@symptom.getTextFromInput(:css,Symptom::NOTES)).to eq("Wheezing")

        @symptom.clickCancelButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)
      end

      it "Delete" do
        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
        expect(@symptom.getTextFromInput(:css,Symptom::NOTES)).to eq("Wheezing")

        expect(@symptom.isDeleteButtonVisible()).to eq(true)

        @symptom.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickNoButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
        !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
        expect(@symptom.getFocusedElementText()).to eq("Delete")

        @symptom.clickCancelButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords)

        clickNthRow(1)
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)

        @symptom.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickYesButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(@numberOfRecords - 1)

        expect(retreiveAllDocumentsInCollection("symptoms", "medicalhistorydb").length()).to eq(@SymptomFirstCount)
      end

      describe "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header.
                Updates made to the record are visible in the table, if included in that view" do

        it "max" do
          clickNthRow(1)
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)

          expect(@symptom.isSaveButtonVisible()).to eq(true)

          @symptom.setInput(Symptom::SYMPTOM_DATE, "01/01/2014")
          @time_picker.clickTimePickerButton()
          !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
          @time_picker.setTimeFromGUI(9, "01", "AM")
          !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }

          @symptom.setInput(Symptom::TRIGGER, "This  field value is deliberately set to be longer than length of two hundred and fifty characters. The field should truncate the string after the maximum number of characters is reached and display the first substring of this entire string.         ")
          expect(@symptom.getTextForElement(:css, Symptom::TRIGGER_CHARACTER_COUNTER)).to eq("0 characters left")
          @symptom.setInput(Symptom::TREATMENT, "This  field value is deliberately set to be longer than length of two hundred and fifty characters. The field should truncate the string after the maximum number of characters is reached and display the first substring of this entire string.          ")
          expect(@symptom.getTextForElement(:css, Symptom::TREATMENT_CHARACTER_COUNTER)).to eq("0 characters left")
          @symptom.setInput(Symptom::RESPONSE, "This  field value is deliberately set to be longer than length of two hundred and fifty characters. The field should truncate the string after the maximum number of characters is reached and display the first substring of this entire string.          ")
          expect(@symptom.getTextForElement(:css, Symptom::RESPONSE_CHARACTER_COUNTER)).to eq("0 characters left")
          @symptom.setInput(Symptom::NOTES, "This  field value is deliberately set to be longer than length of two hundred and fifty characters. The field should truncate the string after the maximum number of characters is reached and display the first substring of this entire string.          ")
          expect(@symptom.getTextForElement(:css, Symptom::NOTES_CHARACTER_COUNTER)).to eq("0 characters left")

          @symptom.clickSaveButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          expect(getCount()).to eq(@numberOfRecords -1)
        end

        it "min" do
          clickNthRow(1)
          @symptom.setInput(Symptom::SYMPTOM_DATE, "01/01/2014")
          @time_picker.clickTimePickerButton()
          !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
          @time_picker.setTimeFromGUI(9, "01", "AM")
          !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }
          @symptom.setSelectBoxValue(Symptom::DURATION_HOURS, "Select")
          @symptom.setSelectBoxValue(Symptom::DURATION_MINUTES, "Select")
          @symptom.setInput(Symptom::TRIGGER, "")
          @symptom.setInput(Symptom::TREATMENT, "")
          @symptom.setInput(Symptom::RESPONSE, "")
          @symptom.setInput(Symptom::NOTES, "")

          @symptom.clickSaveButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)

          clickNthRow(1)
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)

          expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("Crying")
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("01/01/2014")
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to eq("09:01 AM")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_MINUTES)).to eq("0")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_HOURS)).to eq("Select")
          expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("")

          @symptom.clickCancelButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          expect(getCount()).to eq(@numberOfRecords - 1)
        end

      end

    end

  end

end
=end